/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data lineage event summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineageEventSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LineageEventSummary.Builder, LineageEventSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(LineageEventSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(LineageEventSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(LineageEventSummary::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<EventSummary> EVENT_SUMMARY_FIELD = SdkField.<EventSummary> builder(MarshallingType.SDK_POJO)
            .memberName("eventSummary").getter(getter(LineageEventSummary::eventSummary)).setter(setter(Builder::eventSummary))
            .constructor(EventSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSummary").build()).build();

    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventTime").getter(getter(LineageEventSummary::eventTime)).setter(setter(Builder::eventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTime").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(LineageEventSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> PROCESSING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("processingStatus").getter(getter(LineageEventSummary::processingStatusAsString))
            .setter(setter(Builder::processingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DOMAIN_ID_FIELD, EVENT_SUMMARY_FIELD, EVENT_TIME_FIELD, ID_FIELD, PROCESSING_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("createdAt", CREATED_AT_FIELD);
                    put("createdBy", CREATED_BY_FIELD);
                    put("domainId", DOMAIN_ID_FIELD);
                    put("eventSummary", EVENT_SUMMARY_FIELD);
                    put("eventTime", EVENT_TIME_FIELD);
                    put("id", ID_FIELD);
                    put("processingStatus", PROCESSING_STATUS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String createdBy;

    private final String domainId;

    private final EventSummary eventSummary;

    private final Instant eventTime;

    private final String id;

    private final String processingStatus;

    private LineageEventSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.eventSummary = builder.eventSummary;
        this.eventTime = builder.eventTime;
        this.id = builder.id;
        this.processingStatus = builder.processingStatus;
    }

    /**
     * <p>
     * The timestamp at which data lineage event was created.
     * </p>
     * 
     * @return The timestamp at which data lineage event was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the data lineage event.
     * </p>
     * 
     * @return The user who created the data lineage event.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The domain ID of the lineage event.
     * </p>
     * 
     * @return The domain ID of the lineage event.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The summary of the data lineate event.
     * </p>
     * 
     * @return The summary of the data lineate event.
     */
    public final EventSummary eventSummary() {
        return eventSummary;
    }

    /**
     * <p>
     * The time of the data lineage event.
     * </p>
     * 
     * @return The time of the data lineage event.
     */
    public final Instant eventTime() {
        return eventTime;
    }

    /**
     * <p>
     * The ID of the data lineage event.
     * </p>
     * 
     * @return The ID of the data lineage event.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The processing status of the data lineage event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processingStatus}
     * will return {@link LineageEventProcessingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #processingStatusAsString}.
     * </p>
     * 
     * @return The processing status of the data lineage event.
     * @see LineageEventProcessingStatus
     */
    public final LineageEventProcessingStatus processingStatus() {
        return LineageEventProcessingStatus.fromValue(processingStatus);
    }

    /**
     * <p>
     * The processing status of the data lineage event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processingStatus}
     * will return {@link LineageEventProcessingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #processingStatusAsString}.
     * </p>
     * 
     * @return The processing status of the data lineage event.
     * @see LineageEventProcessingStatus
     */
    public final String processingStatusAsString() {
        return processingStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(eventSummary());
        hashCode = 31 * hashCode + Objects.hashCode(eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(processingStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageEventSummary)) {
            return false;
        }
        LineageEventSummary other = (LineageEventSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(domainId(), other.domainId()) && Objects.equals(eventSummary(), other.eventSummary())
                && Objects.equals(eventTime(), other.eventTime()) && Objects.equals(id(), other.id())
                && Objects.equals(processingStatusAsString(), other.processingStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineageEventSummary").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("DomainId", domainId()).add("EventSummary", eventSummary()).add("EventTime", eventTime()).add("Id", id())
                .add("ProcessingStatus", processingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "eventSummary":
            return Optional.ofNullable(clazz.cast(eventSummary()));
        case "eventTime":
            return Optional.ofNullable(clazz.cast(eventTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "processingStatus":
            return Optional.ofNullable(clazz.cast(processingStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LineageEventSummary, T> g) {
        return obj -> g.apply((LineageEventSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineageEventSummary> {
        /**
         * <p>
         * The timestamp at which data lineage event was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp at which data lineage event was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the data lineage event.
         * </p>
         * 
         * @param createdBy
         *        The user who created the data lineage event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The domain ID of the lineage event.
         * </p>
         * 
         * @param domainId
         *        The domain ID of the lineage event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The summary of the data lineate event.
         * </p>
         * 
         * @param eventSummary
         *        The summary of the data lineate event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSummary(EventSummary eventSummary);

        /**
         * <p>
         * The summary of the data lineate event.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventSummary.Builder} avoiding the need
         * to create one manually via {@link EventSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #eventSummary(EventSummary)}.
         * 
         * @param eventSummary
         *        a consumer that will call methods on {@link EventSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSummary(EventSummary)
         */
        default Builder eventSummary(Consumer<EventSummary.Builder> eventSummary) {
            return eventSummary(EventSummary.builder().applyMutation(eventSummary).build());
        }

        /**
         * <p>
         * The time of the data lineage event.
         * </p>
         * 
         * @param eventTime
         *        The time of the data lineage event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTime(Instant eventTime);

        /**
         * <p>
         * The ID of the data lineage event.
         * </p>
         * 
         * @param id
         *        The ID of the data lineage event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The processing status of the data lineage event.
         * </p>
         * 
         * @param processingStatus
         *        The processing status of the data lineage event.
         * @see LineageEventProcessingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineageEventProcessingStatus
         */
        Builder processingStatus(String processingStatus);

        /**
         * <p>
         * The processing status of the data lineage event.
         * </p>
         * 
         * @param processingStatus
         *        The processing status of the data lineage event.
         * @see LineageEventProcessingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineageEventProcessingStatus
         */
        Builder processingStatus(LineageEventProcessingStatus processingStatus);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String domainId;

        private EventSummary eventSummary;

        private Instant eventTime;

        private String id;

        private String processingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LineageEventSummary model) {
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            domainId(model.domainId);
            eventSummary(model.eventSummary);
            eventTime(model.eventTime);
            id(model.id);
            processingStatus(model.processingStatus);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final EventSummary.Builder getEventSummary() {
            return eventSummary != null ? eventSummary.toBuilder() : null;
        }

        public final void setEventSummary(EventSummary.BuilderImpl eventSummary) {
            this.eventSummary = eventSummary != null ? eventSummary.build() : null;
        }

        @Override
        public final Builder eventSummary(EventSummary eventSummary) {
            this.eventSummary = eventSummary;
            return this;
        }

        public final Instant getEventTime() {
            return eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getProcessingStatus() {
            return processingStatus;
        }

        public final void setProcessingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
        }

        @Override
        public final Builder processingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
            return this;
        }

        @Override
        public final Builder processingStatus(LineageEventProcessingStatus processingStatus) {
            this.processingStatus(processingStatus == null ? null : processingStatus.toString());
            return this;
        }

        @Override
        public LineageEventSummary build() {
            return new LineageEventSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
