/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the data lineage node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineageNodeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LineageNodeSummary.Builder, LineageNodeSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(LineageNodeSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(LineageNodeSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(LineageNodeSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(LineageNodeSummary::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<Instant> EVENT_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventTimestamp").getter(getter(LineageNodeSummary::eventTimestamp))
            .setter(setter(Builder::eventTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(LineageNodeSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LineageNodeSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceIdentifier").getter(getter(LineageNodeSummary::sourceIdentifier))
            .setter(setter(Builder::sourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIdentifier").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeName").getter(getter(LineageNodeSummary::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()).build();

    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeRevision").getter(getter(LineageNodeSummary::typeRevision)).setter(setter(Builder::typeRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(LineageNodeSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(LineageNodeSummary::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, EVENT_TIMESTAMP_FIELD, ID_FIELD, NAME_FIELD,
            SOURCE_IDENTIFIER_FIELD, TYPE_NAME_FIELD, TYPE_REVISION_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("createdAt", CREATED_AT_FIELD);
                    put("createdBy", CREATED_BY_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("domainId", DOMAIN_ID_FIELD);
                    put("eventTimestamp", EVENT_TIMESTAMP_FIELD);
                    put("id", ID_FIELD);
                    put("name", NAME_FIELD);
                    put("sourceIdentifier", SOURCE_IDENTIFIER_FIELD);
                    put("typeName", TYPE_NAME_FIELD);
                    put("typeRevision", TYPE_REVISION_FIELD);
                    put("updatedAt", UPDATED_AT_FIELD);
                    put("updatedBy", UPDATED_BY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final String domainId;

    private final Instant eventTimestamp;

    private final String id;

    private final String name;

    private final String sourceIdentifier;

    private final String typeName;

    private final String typeRevision;

    private final Instant updatedAt;

    private final String updatedBy;

    private LineageNodeSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.eventTimestamp = builder.eventTimestamp;
        this.id = builder.id;
        this.name = builder.name;
        this.sourceIdentifier = builder.sourceIdentifier;
        this.typeName = builder.typeName;
        this.typeRevision = builder.typeRevision;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The timestamp at which the data lineage node was created.
     * </p>
     * 
     * @return The timestamp at which the data lineage node was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the data lineage node.
     * </p>
     * 
     * @return The user who created the data lineage node.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of the data lineage node.
     * </p>
     * 
     * @return The description of the data lineage node.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the domain of the data lineage node.
     * </p>
     * 
     * @return The ID of the domain of the data lineage node.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The event timestamp of the data lineage node.
     * </p>
     * 
     * @return The event timestamp of the data lineage node.
     */
    public final Instant eventTimestamp() {
        return eventTimestamp;
    }

    /**
     * <p>
     * The ID of the data lineage node.
     * </p>
     * 
     * @return The ID of the data lineage node.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the data lineage node.
     * </p>
     * 
     * @return The name of the data lineage node.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The alternate ID of the data lineage node.
     * </p>
     * 
     * @return The alternate ID of the data lineage node.
     */
    public final String sourceIdentifier() {
        return sourceIdentifier;
    }

    /**
     * <p>
     * The name of the type of the data lineage node.
     * </p>
     * 
     * @return The name of the type of the data lineage node.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The type of the revision of the data lineage node.
     * </p>
     * 
     * @return The type of the revision of the data lineage node.
     */
    public final String typeRevision() {
        return typeRevision;
    }

    /**
     * <p>
     * The timestamp at which the data lineage node was updated.
     * </p>
     * 
     * @return The timestamp at which the data lineage node was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user who updated the data lineage node.
     * </p>
     * 
     * @return The user who updated the data lineage node.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(typeRevision());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageNodeSummary)) {
            return false;
        }
        LineageNodeSummary other = (LineageNodeSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(eventTimestamp(), other.eventTimestamp()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(sourceIdentifier(), other.sourceIdentifier())
                && Objects.equals(typeName(), other.typeName()) && Objects.equals(typeRevision(), other.typeRevision())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineageNodeSummary").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Description", description()).add("DomainId", domainId()).add("EventTimestamp", eventTimestamp())
                .add("Id", id()).add("Name", name()).add("SourceIdentifier", sourceIdentifier()).add("TypeName", typeName())
                .add("TypeRevision", typeRevision()).add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "eventTimestamp":
            return Optional.ofNullable(clazz.cast(eventTimestamp()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sourceIdentifier":
            return Optional.ofNullable(clazz.cast(sourceIdentifier()));
        case "typeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "typeRevision":
            return Optional.ofNullable(clazz.cast(typeRevision()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LineageNodeSummary, T> g) {
        return obj -> g.apply((LineageNodeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineageNodeSummary> {
        /**
         * <p>
         * The timestamp at which the data lineage node was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp at which the data lineage node was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the data lineage node.
         * </p>
         * 
         * @param createdBy
         *        The user who created the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of the data lineage node.
         * </p>
         * 
         * @param description
         *        The description of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the domain of the data lineage node.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The event timestamp of the data lineage node.
         * </p>
         * 
         * @param eventTimestamp
         *        The event timestamp of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestamp(Instant eventTimestamp);

        /**
         * <p>
         * The ID of the data lineage node.
         * </p>
         * 
         * @param id
         *        The ID of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the data lineage node.
         * </p>
         * 
         * @param name
         *        The name of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The alternate ID of the data lineage node.
         * </p>
         * 
         * @param sourceIdentifier
         *        The alternate ID of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIdentifier(String sourceIdentifier);

        /**
         * <p>
         * The name of the type of the data lineage node.
         * </p>
         * 
         * @param typeName
         *        The name of the type of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The type of the revision of the data lineage node.
         * </p>
         * 
         * @param typeRevision
         *        The type of the revision of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeRevision(String typeRevision);

        /**
         * <p>
         * The timestamp at which the data lineage node was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp at which the data lineage node was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user who updated the data lineage node.
         * </p>
         * 
         * @param updatedBy
         *        The user who updated the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String description;

        private String domainId;

        private Instant eventTimestamp;

        private String id;

        private String name;

        private String sourceIdentifier;

        private String typeName;

        private String typeRevision;

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(LineageNodeSummary model) {
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            domainId(model.domainId);
            eventTimestamp(model.eventTimestamp);
            id(model.id);
            name(model.name);
            sourceIdentifier(model.sourceIdentifier);
            typeName(model.typeName);
            typeRevision(model.typeRevision);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Instant getEventTimestamp() {
            return eventTimestamp;
        }

        public final void setEventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSourceIdentifier() {
            return sourceIdentifier;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeRevision() {
            return typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public LineageNodeSummary build() {
            return new LineageNodeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
