/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a data lineage node type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineageNodeTypeItem implements SdkPojo, Serializable,
        ToCopyableBuilder<LineageNodeTypeItem.Builder, LineageNodeTypeItem> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(LineageNodeTypeItem::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(LineageNodeTypeItem::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(LineageNodeTypeItem::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(LineageNodeTypeItem::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<Map<String, FormEntryOutput>> FORMS_OUTPUT_FIELD = SdkField
            .<Map<String, FormEntryOutput>> builder(MarshallingType.MAP)
            .memberName("formsOutput")
            .getter(getter(LineageNodeTypeItem::formsOutput))
            .setter(setter(Builder::formsOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsOutput").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FormEntryOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormEntryOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LineageNodeTypeItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(LineageNodeTypeItem::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(LineageNodeTypeItem::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(LineageNodeTypeItem::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, FORMS_OUTPUT_FIELD, NAME_FIELD, REVISION_FIELD,
            UPDATED_AT_FIELD, UPDATED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("createdAt", CREATED_AT_FIELD);
                    put("createdBy", CREATED_BY_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("domainId", DOMAIN_ID_FIELD);
                    put("formsOutput", FORMS_OUTPUT_FIELD);
                    put("name", NAME_FIELD);
                    put("revision", REVISION_FIELD);
                    put("updatedAt", UPDATED_AT_FIELD);
                    put("updatedBy", UPDATED_BY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final String domainId;

    private final Map<String, FormEntryOutput> formsOutput;

    private final String name;

    private final String revision;

    private final Instant updatedAt;

    private final String updatedBy;

    private LineageNodeTypeItem(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.formsOutput = builder.formsOutput;
        this.name = builder.name;
        this.revision = builder.revision;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The timestamp at which the data lineage node type was created.
     * </p>
     * 
     * @return The timestamp at which the data lineage node type was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the data lineage node type.
     * </p>
     * 
     * @return The user who created the data lineage node type.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of the data lineage node type.
     * </p>
     * 
     * @return The description of the data lineage node type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the domain where the data lineage node type lives.
     * </p>
     * 
     * @return The ID of the domain where the data lineage node type lives.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FormsOutput property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFormsOutput() {
        return formsOutput != null && !(formsOutput instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The forms output of the data lineage node type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormsOutput} method.
     * </p>
     * 
     * @return The forms output of the data lineage node type.
     */
    public final Map<String, FormEntryOutput> formsOutput() {
        return formsOutput;
    }

    /**
     * <p>
     * The name of the data lineage node type.
     * </p>
     * 
     * @return The name of the data lineage node type.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The revision of the data lineage node type.
     * </p>
     * 
     * @return The revision of the data lineage node type.
     */
    public final String revision() {
        return revision;
    }

    /**
     * <p>
     * The timestamp at which the data lineage node type was updated.
     * </p>
     * 
     * @return The timestamp at which the data lineage node type was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user who updated the data lineage node type.
     * </p>
     * 
     * @return The user who updated the data lineage node type.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFormsOutput() ? formsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageNodeTypeItem)) {
            return false;
        }
        LineageNodeTypeItem other = (LineageNodeTypeItem) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && hasFormsOutput() == other.hasFormsOutput() && Objects.equals(formsOutput(), other.formsOutput())
                && Objects.equals(name(), other.name()) && Objects.equals(revision(), other.revision())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineageNodeTypeItem").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Description", description()).add("DomainId", domainId())
                .add("FormsOutput", hasFormsOutput() ? formsOutput() : null).add("Name", name()).add("Revision", revision())
                .add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "formsOutput":
            return Optional.ofNullable(clazz.cast(formsOutput()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LineageNodeTypeItem, T> g) {
        return obj -> g.apply((LineageNodeTypeItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineageNodeTypeItem> {
        /**
         * <p>
         * The timestamp at which the data lineage node type was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp at which the data lineage node type was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the data lineage node type.
         * </p>
         * 
         * @param createdBy
         *        The user who created the data lineage node type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of the data lineage node type.
         * </p>
         * 
         * @param description
         *        The description of the data lineage node type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the domain where the data lineage node type lives.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain where the data lineage node type lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The forms output of the data lineage node type.
         * </p>
         * 
         * @param formsOutput
         *        The forms output of the data lineage node type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formsOutput(Map<String, FormEntryOutput> formsOutput);

        /**
         * <p>
         * The name of the data lineage node type.
         * </p>
         * 
         * @param name
         *        The name of the data lineage node type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The revision of the data lineage node type.
         * </p>
         * 
         * @param revision
         *        The revision of the data lineage node type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        /**
         * <p>
         * The timestamp at which the data lineage node type was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp at which the data lineage node type was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user who updated the data lineage node type.
         * </p>
         * 
         * @param updatedBy
         *        The user who updated the data lineage node type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String description;

        private String domainId;

        private Map<String, FormEntryOutput> formsOutput = DefaultSdkAutoConstructMap.getInstance();

        private String name;

        private String revision;

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(LineageNodeTypeItem model) {
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            domainId(model.domainId);
            formsOutput(model.formsOutput);
            name(model.name);
            revision(model.revision);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Map<String, FormEntryOutput.Builder> getFormsOutput() {
            Map<String, FormEntryOutput.Builder> result = FormsOutputMapCopier.copyToBuilder(this.formsOutput);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFormsOutput(Map<String, FormEntryOutput.BuilderImpl> formsOutput) {
            this.formsOutput = FormsOutputMapCopier.copyFromBuilder(formsOutput);
        }

        @Override
        public final Builder formsOutput(Map<String, FormEntryOutput> formsOutput) {
            this.formsOutput = FormsOutputMapCopier.copy(formsOutput);
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public LineageNodeTypeItem build() {
            return new LineageNodeTypeItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
