/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataSourceRunsRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListDataSourceRunsRequest.Builder, ListDataSourceRunsRequest> {
    private static final SdkField<String> DATA_SOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceIdentifier").getter(getter(ListDataSourceRunsRequest::dataSourceIdentifier))
            .setter(setter(Builder::dataSourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceIdentifier").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListDataSourceRunsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListDataSourceRunsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDataSourceRunsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListDataSourceRunsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_IDENTIFIER_FIELD,
            DOMAIN_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("dataSourceIdentifier", DATA_SOURCE_IDENTIFIER_FIELD);
                    put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
                    put("maxResults", MAX_RESULTS_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                    put("status", STATUS_FIELD);
                }
            });

    private final String dataSourceIdentifier;

    private final String domainIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final String status;

    private ListDataSourceRunsRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceIdentifier = builder.dataSourceIdentifier;
        this.domainIdentifier = builder.domainIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
    }

    /**
     * <p>
     * The identifier of the data source.
     * </p>
     * 
     * @return The identifier of the data source.
     */
    public final String dataSourceIdentifier() {
        return dataSourceIdentifier;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which to invoke the <code>ListDataSourceRuns</code> action.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which to invoke the <code>ListDataSourceRuns</code>
     *         action.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The maximum number of runs to return in a single call to <code>ListDataSourceRuns</code>. When the number of runs
     * to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code>
     * value that you can use in a subsequent call to <code>ListDataSourceRuns</code> to list the next set of runs.
     * </p>
     * 
     * @return The maximum number of runs to return in a single call to <code>ListDataSourceRuns</code>. When the number
     *         of runs to be listed is greater than the value of <code>MaxResults</code>, the response contains a
     *         <code>NextToken</code> value that you can use in a subsequent call to <code>ListDataSourceRuns</code> to
     *         list the next set of runs.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of runs is greater than the default value for the <code>MaxResults</code> parameter, or if you
     * explicitly specify a value for <code>MaxResults</code> that is less than the number of runs, the response
     * includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
     * subsequent call to <code>ListDataSourceRuns</code> to list the next set of runs.
     * </p>
     * 
     * @return When the number of runs is greater than the default value for the <code>MaxResults</code> parameter, or
     *         if you explicitly specify a value for <code>MaxResults</code> that is less than the number of runs, the
     *         response includes a pagination token named <code>NextToken</code>. You can specify this
     *         <code>NextToken</code> value in a subsequent call to <code>ListDataSourceRuns</code> to list the next set
     *         of runs.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The status of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data source.
     * @see DataSourceRunStatus
     */
    public final DataSourceRunStatus status() {
        return DataSourceRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data source.
     * @see DataSourceRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourceRunsRequest)) {
            return false;
        }
        ListDataSourceRunsRequest other = (ListDataSourceRunsRequest) obj;
        return Objects.equals(dataSourceIdentifier(), other.dataSourceIdentifier())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataSourceRunsRequest").add("DataSourceIdentifier", dataSourceIdentifier())
                .add("DomainIdentifier", domainIdentifier()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSourceIdentifier":
            return Optional.ofNullable(clazz.cast(dataSourceIdentifier()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSourceRunsRequest, T> g) {
        return obj -> g.apply((ListDataSourceRunsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDataSourceRunsRequest> {
        /**
         * <p>
         * The identifier of the data source.
         * </p>
         * 
         * @param dataSourceIdentifier
         *        The identifier of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceIdentifier(String dataSourceIdentifier);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which to invoke the <code>ListDataSourceRuns</code> action.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain in which to invoke the <code>ListDataSourceRuns</code>
         *        action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The maximum number of runs to return in a single call to <code>ListDataSourceRuns</code>. When the number of
         * runs to be listed is greater than the value of <code>MaxResults</code>, the response contains a
         * <code>NextToken</code> value that you can use in a subsequent call to <code>ListDataSourceRuns</code> to list
         * the next set of runs.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of runs to return in a single call to <code>ListDataSourceRuns</code>. When the
         *        number of runs to be listed is greater than the value of <code>MaxResults</code>, the response
         *        contains a <code>NextToken</code> value that you can use in a subsequent call to
         *        <code>ListDataSourceRuns</code> to list the next set of runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of runs is greater than the default value for the <code>MaxResults</code> parameter, or if
         * you explicitly specify a value for <code>MaxResults</code> that is less than the number of runs, the response
         * includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value
         * in a subsequent call to <code>ListDataSourceRuns</code> to list the next set of runs.
         * </p>
         * 
         * @param nextToken
         *        When the number of runs is greater than the default value for the <code>MaxResults</code> parameter,
         *        or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of runs,
         *        the response includes a pagination token named <code>NextToken</code>. You can specify this
         *        <code>NextToken</code> value in a subsequent call to <code>ListDataSourceRuns</code> to list the next
         *        set of runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The status of the data source.
         * </p>
         * 
         * @param status
         *        The status of the data source.
         * @see DataSourceRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the data source.
         * </p>
         * 
         * @param status
         *        The status of the data source.
         * @see DataSourceRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceRunStatus
         */
        Builder status(DataSourceRunStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String dataSourceIdentifier;

        private String domainIdentifier;

        private Integer maxResults;

        private String nextToken;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSourceRunsRequest model) {
            super(model);
            dataSourceIdentifier(model.dataSourceIdentifier);
            domainIdentifier(model.domainIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            status(model.status);
        }

        public final String getDataSourceIdentifier() {
            return dataSourceIdentifier;
        }

        public final void setDataSourceIdentifier(String dataSourceIdentifier) {
            this.dataSourceIdentifier = dataSourceIdentifier;
        }

        @Override
        public final Builder dataSourceIdentifier(String dataSourceIdentifier) {
            this.dataSourceIdentifier = dataSourceIdentifier;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDataSourceRunsRequest build() {
            return new ListDataSourceRunsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
