/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSubscriptionTargetsRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListSubscriptionTargetsRequest.Builder, ListSubscriptionTargetsRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListSubscriptionTargetsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentIdentifier").getter(getter(ListSubscriptionTargetsRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentIdentifier").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSubscriptionTargetsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSubscriptionTargetsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListSubscriptionTargetsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListSubscriptionTargetsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            ENVIRONMENT_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
                    put("environmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
                    put("maxResults", MAX_RESULTS_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                    put("sortBy", SORT_BY_FIELD);
                    put("sortOrder", SORT_ORDER_FIELD);
                }
            });

    private final String domainIdentifier;

    private final String environmentIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final String sortBy;

    private final String sortOrder;

    private ListSubscriptionTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain where you want to list subscription targets.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain where you want to list subscription targets.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The identifier of the environment where you want to list subscription targets.
     * </p>
     * 
     * @return The identifier of the environment where you want to list subscription targets.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * The maximum number of subscription targets to return in a single call to <code>ListSubscriptionTargets</code>.
     * When the number of subscription targets to be listed is greater than the value of <code>MaxResults</code>, the
     * response contains a <code>NextToken</code> value that you can use in a subsequent call to
     * <code>ListSubscriptionTargets</code> to list the next set of subscription targets.
     * </p>
     * 
     * @return The maximum number of subscription targets to return in a single call to
     *         <code>ListSubscriptionTargets</code>. When the number of subscription targets to be listed is greater
     *         than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you
     *         can use in a subsequent call to <code>ListSubscriptionTargets</code> to list the next set of subscription
     *         targets.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of subscription targets is greater than the default value for the <code>MaxResults</code>
     * parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
     * subscription targets, the response includes a pagination token named <code>NextToken</code>. You can specify this
     * <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionTargets</code> to list the next set of
     * subscription targets.
     * </p>
     * 
     * @return When the number of subscription targets is greater than the default value for the <code>MaxResults</code>
     *         parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number
     *         of subscription targets, the response includes a pagination token named <code>NextToken</code>. You can
     *         specify this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionTargets</code> to
     *         list the next set of subscription targets.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the way in which the results of this action are to be sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Specifies the way in which the results of this action are to be sorted.
     * @see SortKey
     */
    public final SortKey sortBy() {
        return SortKey.fromValue(sortBy);
    }

    /**
     * <p>
     * Specifies the way in which the results of this action are to be sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Specifies the way in which the results of this action are to be sorted.
     * @see SortKey
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Specifies the sort order for the results of this action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies the sort order for the results of this action.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Specifies the sort order for the results of this action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies the sort order for the results of this action.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionTargetsRequest)) {
            return false;
        }
        ListSubscriptionTargetsRequest other = (ListSubscriptionTargetsRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSubscriptionTargetsRequest").add("DomainIdentifier", domainIdentifier())
                .add("EnvironmentIdentifier", environmentIdentifier()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSubscriptionTargetsRequest, T> g) {
        return obj -> g.apply((ListSubscriptionTargetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSubscriptionTargetsRequest> {
        /**
         * <p>
         * The identifier of the Amazon DataZone domain where you want to list subscription targets.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain where you want to list subscription targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The identifier of the environment where you want to list subscription targets.
         * </p>
         * 
         * @param environmentIdentifier
         *        The identifier of the environment where you want to list subscription targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * The maximum number of subscription targets to return in a single call to <code>ListSubscriptionTargets</code>
         * . When the number of subscription targets to be listed is greater than the value of <code>MaxResults</code>,
         * the response contains a <code>NextToken</code> value that you can use in a subsequent call to
         * <code>ListSubscriptionTargets</code> to list the next set of subscription targets.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of subscription targets to return in a single call to
         *        <code>ListSubscriptionTargets</code>. When the number of subscription targets to be listed is greater
         *        than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that
         *        you can use in a subsequent call to <code>ListSubscriptionTargets</code> to list the next set of
         *        subscription targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of subscription targets is greater than the default value for the <code>MaxResults</code>
         * parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
         * subscription targets, the response includes a pagination token named <code>NextToken</code>. You can specify
         * this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionTargets</code> to list the
         * next set of subscription targets.
         * </p>
         * 
         * @param nextToken
         *        When the number of subscription targets is greater than the default value for the
         *        <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code>
         *        that is less than the number of subscription targets, the response includes a pagination token named
         *        <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
         *        <code>ListSubscriptionTargets</code> to list the next set of subscription targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the way in which the results of this action are to be sorted.
         * </p>
         * 
         * @param sortBy
         *        Specifies the way in which the results of this action are to be sorted.
         * @see SortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortKey
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Specifies the way in which the results of this action are to be sorted.
         * </p>
         * 
         * @param sortBy
         *        Specifies the way in which the results of this action are to be sorted.
         * @see SortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortKey
         */
        Builder sortBy(SortKey sortBy);

        /**
         * <p>
         * Specifies the sort order for the results of this action.
         * </p>
         * 
         * @param sortOrder
         *        Specifies the sort order for the results of this action.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Specifies the sort order for the results of this action.
         * </p>
         * 
         * @param sortOrder
         *        Specifies the sort order for the results of this action.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private String environmentIdentifier;

        private Integer maxResults;

        private String nextToken;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscriptionTargetsRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            environmentIdentifier(model.environmentIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSubscriptionTargetsRequest build() {
            return new ListSubscriptionTargetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
