/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The model of the API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Model implements SdkPojo, Serializable, ToCopyableBuilder<Model.Builder, Model> {
    private static final SdkField<String> SMITHY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("smithy")
            .getter(getter(Model::smithy)).setter(setter(Builder::smithy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smithy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMITHY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("smithy", SMITHY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String smithy;

    private final Type type;

    private Model(BuilderImpl builder) {
        this.smithy = builder.smithy;
        this.type = builder.type;
    }

    /**
     * <p>
     * Indicates the smithy model of the API.
     * </p>
     * 
     * @return Indicates the smithy model of the API.
     */
    public final String smithy() {
        return smithy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(smithy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Model)) {
            return false;
        }
        Model other = (Model) obj;
        return Objects.equals(smithy(), other.smithy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Model").add("Smithy", smithy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "smithy":
            return Optional.ofNullable(clazz.cast(smithy()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #smithy()} initialized to the given value.
     *
     * <p>
     * Indicates the smithy model of the API.
     * </p>
     * 
     * @param smithy
     *        Indicates the smithy model of the API.
     */
    public static Model fromSmithy(String smithy) {
        return builder().smithy(smithy).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Model, T> g) {
        return obj -> g.apply((Model) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Model> {
        /**
         * <p>
         * Indicates the smithy model of the API.
         * </p>
         * 
         * @param smithy
         *        Indicates the smithy model of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smithy(String smithy);
    }

    static final class BuilderImpl implements Builder {
        private String smithy;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Model model) {
            smithy(model.smithy);
        }

        public final String getSmithy() {
            return smithy;
        }

        public final void setSmithy(String smithy) {
            Object oldValue = this.smithy;
            this.smithy = smithy;
            handleUnionValueChange(Type.SMITHY, oldValue, this.smithy);
        }

        @Override
        public final Builder smithy(String smithy) {
            Object oldValue = this.smithy;
            this.smithy = smithy;
            handleUnionValueChange(Type.SMITHY, oldValue, this.smithy);
            return this;
        }

        @Override
        public Model build() {
            return new Model(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Model#type()
     */
    public enum Type {
        SMITHY,

        UNKNOWN_TO_SDK_VERSION
    }
}
