/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a notification generated in Amazon DataZone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationOutput.Builder, NotificationOutput> {
    private static final SdkField<String> ACTION_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionLink").getter(getter(NotificationOutput::actionLink)).setter(setter(Builder::actionLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionLink").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTimestamp").getter(getter(NotificationOutput::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(NotificationOutput::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(NotificationOutput::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTimestamp").getter(getter(NotificationOutput::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(NotificationOutput::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("metadata")
            .getter(getter(NotificationOutput::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(NotificationOutput::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(NotificationOutput::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<Topic> TOPIC_FIELD = SdkField.<Topic> builder(MarshallingType.SDK_POJO).memberName("topic")
            .getter(getter(NotificationOutput::topic)).setter(setter(Builder::topic)).constructor(Topic::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topic").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(NotificationOutput::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_LINK_FIELD,
            CREATION_TIMESTAMP_FIELD, DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, MESSAGE_FIELD,
            METADATA_FIELD, STATUS_FIELD, TITLE_FIELD, TOPIC_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("actionLink", ACTION_LINK_FIELD);
                    put("creationTimestamp", CREATION_TIMESTAMP_FIELD);
                    put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
                    put("identifier", IDENTIFIER_FIELD);
                    put("lastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
                    put("message", MESSAGE_FIELD);
                    put("metadata", METADATA_FIELD);
                    put("status", STATUS_FIELD);
                    put("title", TITLE_FIELD);
                    put("topic", TOPIC_FIELD);
                    put("type", TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String actionLink;

    private final Instant creationTimestamp;

    private final String domainIdentifier;

    private final String identifier;

    private final Instant lastUpdatedTimestamp;

    private final String message;

    private final Map<String, String> metadata;

    private final String status;

    private final String title;

    private final Topic topic;

    private final String type;

    private NotificationOutput(BuilderImpl builder) {
        this.actionLink = builder.actionLink;
        this.creationTimestamp = builder.creationTimestamp;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.message = builder.message;
        this.metadata = builder.metadata;
        this.status = builder.status;
        this.title = builder.title;
        this.topic = builder.topic;
        this.type = builder.type;
    }

    /**
     * <p>
     * The action link included in the notification.
     * </p>
     * 
     * @return The action link included in the notification.
     */
    public final String actionLink() {
        return actionLink;
    }

    /**
     * <p>
     * The timestamp of when a notification was created.
     * </p>
     * 
     * @return The timestamp of when a notification was created.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The identifier of a Amazon DataZone domain in which the notification exists.
     * </p>
     * 
     * @return The identifier of a Amazon DataZone domain in which the notification exists.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The identifier of the notification.
     * </p>
     * 
     * @return The identifier of the notification.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The timestamp of when the notification was last updated.
     * </p>
     * 
     * @return The timestamp of when the notification was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The message included in the notification.
     * </p>
     * 
     * @return The message included in the notification.
     */
    public final String message() {
        return message;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata included in the notification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return The metadata included in the notification.
     */
    public final Map<String, String> metadata() {
        return metadata;
    }

    /**
     * <p>
     * The status included in the notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status included in the notification.
     * @see TaskStatus
     */
    public final TaskStatus status() {
        return TaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The status included in the notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status included in the notification.
     * @see TaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The title of the notification.
     * </p>
     * 
     * @return The title of the notification.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The topic of the notification.
     * </p>
     * 
     * @return The topic of the notification.
     */
    public final Topic topic() {
        return topic;
    }

    /**
     * <p>
     * The type of the notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the notification.
     * @see NotificationType
     */
    public final NotificationType type() {
        return NotificationType.fromValue(type);
    }

    /**
     * <p>
     * The type of the notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the notification.
     * @see NotificationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionLink());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(topic());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationOutput)) {
            return false;
        }
        NotificationOutput other = (NotificationOutput) obj;
        return Objects.equals(actionLink(), other.actionLink()) && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(identifier(), other.identifier())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(message(), other.message()) && hasMetadata() == other.hasMetadata()
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(title(), other.title()) && Objects.equals(topic(), other.topic())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationOutput")
                .add("ActionLink", actionLink() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreationTimestamp", creationTimestamp()).add("DomainIdentifier", domainIdentifier())
                .add("Identifier", identifier()).add("LastUpdatedTimestamp", lastUpdatedTimestamp())
                .add("Message", message() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Metadata", hasMetadata() ? metadata() : null).add("Status", statusAsString())
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***").add("Topic", topic())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionLink":
            return Optional.ofNullable(clazz.cast(actionLink()));
        case "creationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "lastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "topic":
            return Optional.ofNullable(clazz.cast(topic()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NotificationOutput, T> g) {
        return obj -> g.apply((NotificationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationOutput> {
        /**
         * <p>
         * The action link included in the notification.
         * </p>
         * 
         * @param actionLink
         *        The action link included in the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionLink(String actionLink);

        /**
         * <p>
         * The timestamp of when a notification was created.
         * </p>
         * 
         * @param creationTimestamp
         *        The timestamp of when a notification was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The identifier of a Amazon DataZone domain in which the notification exists.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of a Amazon DataZone domain in which the notification exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The identifier of the notification.
         * </p>
         * 
         * @param identifier
         *        The identifier of the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The timestamp of when the notification was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The timestamp of when the notification was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * The message included in the notification.
         * </p>
         * 
         * @param message
         *        The message included in the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The metadata included in the notification.
         * </p>
         * 
         * @param metadata
         *        The metadata included in the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);

        /**
         * <p>
         * The status included in the notification.
         * </p>
         * 
         * @param status
         *        The status included in the notification.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status included in the notification.
         * </p>
         * 
         * @param status
         *        The status included in the notification.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder status(TaskStatus status);

        /**
         * <p>
         * The title of the notification.
         * </p>
         * 
         * @param title
         *        The title of the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The topic of the notification.
         * </p>
         * 
         * @param topic
         *        The topic of the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(Topic topic);

        /**
         * <p>
         * The topic of the notification.
         * </p>
         * This is a convenience method that creates an instance of the {@link Topic.Builder} avoiding the need to
         * create one manually via {@link Topic#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Topic.Builder#build()} is called immediately and its result is
         * passed to {@link #topic(Topic)}.
         * 
         * @param topic
         *        a consumer that will call methods on {@link Topic.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topic(Topic)
         */
        default Builder topic(Consumer<Topic.Builder> topic) {
            return topic(Topic.builder().applyMutation(topic).build());
        }

        /**
         * <p>
         * The type of the notification.
         * </p>
         * 
         * @param type
         *        The type of the notification.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the notification.
         * </p>
         * 
         * @param type
         *        The type of the notification.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder type(NotificationType type);
    }

    static final class BuilderImpl implements Builder {
        private String actionLink;

        private Instant creationTimestamp;

        private String domainIdentifier;

        private String identifier;

        private Instant lastUpdatedTimestamp;

        private String message;

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private String title;

        private Topic topic;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationOutput model) {
            actionLink(model.actionLink);
            creationTimestamp(model.creationTimestamp);
            domainIdentifier(model.domainIdentifier);
            identifier(model.identifier);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            message(model.message);
            metadata(model.metadata);
            status(model.status);
            title(model.title);
            topic(model.topic);
            type(model.type);
        }

        public final String getActionLink() {
            return actionLink;
        }

        public final void setActionLink(String actionLink) {
            this.actionLink = actionLink;
        }

        @Override
        public final Builder actionLink(String actionLink) {
            this.actionLink = actionLink;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataMapCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataMapCopier.copy(metadata);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Topic.Builder getTopic() {
            return topic != null ? topic.toBuilder() : null;
        }

        public final void setTopic(Topic.BuilderImpl topic) {
            this.topic = topic != null ? topic.build() : null;
        }

        @Override
        public final Builder topic(Topic topic) {
            this.topic = topic;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NotificationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public NotificationOutput build() {
            return new NotificationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
