/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a project member.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectMember implements SdkPojo, Serializable, ToCopyableBuilder<ProjectMember.Builder, ProjectMember> {
    private static final SdkField<String> DESIGNATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("designation").getter(getter(ProjectMember::designationAsString)).setter(setter(Builder::designation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("designation").build()).build();

    private static final SdkField<MemberDetails> MEMBER_DETAILS_FIELD = SdkField
            .<MemberDetails> builder(MarshallingType.SDK_POJO).memberName("memberDetails")
            .getter(getter(ProjectMember::memberDetails)).setter(setter(Builder::memberDetails))
            .constructor(MemberDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIGNATION_FIELD,
            MEMBER_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("designation", DESIGNATION_FIELD);
                    put("memberDetails", MEMBER_DETAILS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String designation;

    private final MemberDetails memberDetails;

    private ProjectMember(BuilderImpl builder) {
        this.designation = builder.designation;
        this.memberDetails = builder.memberDetails;
    }

    /**
     * <p>
     * The designated role of a project member.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #designation} will
     * return {@link UserDesignation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #designationAsString}.
     * </p>
     * 
     * @return The designated role of a project member.
     * @see UserDesignation
     */
    public final UserDesignation designation() {
        return UserDesignation.fromValue(designation);
    }

    /**
     * <p>
     * The designated role of a project member.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #designation} will
     * return {@link UserDesignation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #designationAsString}.
     * </p>
     * 
     * @return The designated role of a project member.
     * @see UserDesignation
     */
    public final String designationAsString() {
        return designation;
    }

    /**
     * <p>
     * The membership details of a project member.
     * </p>
     * 
     * @return The membership details of a project member.
     */
    public final MemberDetails memberDetails() {
        return memberDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(designationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(memberDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectMember)) {
            return false;
        }
        ProjectMember other = (ProjectMember) obj;
        return Objects.equals(designationAsString(), other.designationAsString())
                && Objects.equals(memberDetails(), other.memberDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectMember").add("Designation", designationAsString()).add("MemberDetails", memberDetails())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "designation":
            return Optional.ofNullable(clazz.cast(designationAsString()));
        case "memberDetails":
            return Optional.ofNullable(clazz.cast(memberDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProjectMember, T> g) {
        return obj -> g.apply((ProjectMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectMember> {
        /**
         * <p>
         * The designated role of a project member.
         * </p>
         * 
         * @param designation
         *        The designated role of a project member.
         * @see UserDesignation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserDesignation
         */
        Builder designation(String designation);

        /**
         * <p>
         * The designated role of a project member.
         * </p>
         * 
         * @param designation
         *        The designated role of a project member.
         * @see UserDesignation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserDesignation
         */
        Builder designation(UserDesignation designation);

        /**
         * <p>
         * The membership details of a project member.
         * </p>
         * 
         * @param memberDetails
         *        The membership details of a project member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDetails(MemberDetails memberDetails);

        /**
         * <p>
         * The membership details of a project member.
         * </p>
         * This is a convenience method that creates an instance of the {@link MemberDetails.Builder} avoiding the need
         * to create one manually via {@link MemberDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MemberDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #memberDetails(MemberDetails)}.
         * 
         * @param memberDetails
         *        a consumer that will call methods on {@link MemberDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberDetails(MemberDetails)
         */
        default Builder memberDetails(Consumer<MemberDetails.Builder> memberDetails) {
            return memberDetails(MemberDetails.builder().applyMutation(memberDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String designation;

        private MemberDetails memberDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectMember model) {
            designation(model.designation);
            memberDetails(model.memberDetails);
        }

        public final String getDesignation() {
            return designation;
        }

        public final void setDesignation(String designation) {
            this.designation = designation;
        }

        @Override
        public final Builder designation(String designation) {
            this.designation = designation;
            return this;
        }

        @Override
        public final Builder designation(UserDesignation designation) {
            this.designation(designation == null ? null : designation.toString());
            return this;
        }

        public final MemberDetails.Builder getMemberDetails() {
            return memberDetails != null ? memberDetails.toBuilder() : null;
        }

        public final void setMemberDetails(MemberDetails.BuilderImpl memberDetails) {
            this.memberDetails = memberDetails != null ? memberDetails.build() : null;
        }

        @Override
        public final Builder memberDetails(MemberDetails memberDetails) {
            this.memberDetails = memberDetails;
            return this;
        }

        @Override
        public ProjectMember build() {
            return new ProjectMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
