/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon Redshift credentials of a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftCredentials.Builder, RedshiftCredentials> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretArn").getter(getter(RedshiftCredentials::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();

    private static final SdkField<UsernamePassword> USERNAME_PASSWORD_FIELD = SdkField
            .<UsernamePassword> builder(MarshallingType.SDK_POJO).memberName("usernamePassword")
            .getter(getter(RedshiftCredentials::usernamePassword)).setter(setter(Builder::usernamePassword))
            .constructor(UsernamePassword::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usernamePassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD,
            USERNAME_PASSWORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("secretArn", SECRET_ARN_FIELD);
                    put("usernamePassword", USERNAME_PASSWORD_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String secretArn;

    private final UsernamePassword usernamePassword;

    private final Type type;

    private RedshiftCredentials(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.usernamePassword = builder.usernamePassword;
        this.type = builder.type;
    }

    /**
     * <p>
     * The secret ARN of the Amazon Redshift credentials of a connection.
     * </p>
     * 
     * @return The secret ARN of the Amazon Redshift credentials of a connection.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The username and password of the Amazon Redshift credentials of a connection.
     * </p>
     * 
     * @return The username and password of the Amazon Redshift credentials of a connection.
     */
    public final UsernamePassword usernamePassword() {
        return usernamePassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(usernamePassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftCredentials)) {
            return false;
        }
        RedshiftCredentials other = (RedshiftCredentials) obj;
        return Objects.equals(secretArn(), other.secretArn()) && Objects.equals(usernamePassword(), other.usernamePassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftCredentials").add("SecretArn", secretArn())
                .add("UsernamePassword", usernamePassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "secretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "usernamePassword":
            return Optional.ofNullable(clazz.cast(usernamePassword()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #secretArn()} initialized to the given value.
     *
     * <p>
     * The secret ARN of the Amazon Redshift credentials of a connection.
     * </p>
     * 
     * @param secretArn
     *        The secret ARN of the Amazon Redshift credentials of a connection.
     */
    public static RedshiftCredentials fromSecretArn(String secretArn) {
        return builder().secretArn(secretArn).build();
    }

    /**
     * Create an instance of this class with {@link #usernamePassword()} initialized to the given value.
     *
     * <p>
     * The username and password of the Amazon Redshift credentials of a connection.
     * </p>
     * 
     * @param usernamePassword
     *        The username and password of the Amazon Redshift credentials of a connection.
     */
    public static RedshiftCredentials fromUsernamePassword(UsernamePassword usernamePassword) {
        return builder().usernamePassword(usernamePassword).build();
    }

    /**
     * Create an instance of this class with {@link #usernamePassword()} initialized to the given value.
     *
     * <p>
     * The username and password of the Amazon Redshift credentials of a connection.
     * </p>
     * 
     * @param usernamePassword
     *        The username and password of the Amazon Redshift credentials of a connection.
     */
    public static RedshiftCredentials fromUsernamePassword(Consumer<UsernamePassword.Builder> usernamePassword) {
        UsernamePassword.Builder builder = UsernamePassword.builder();
        usernamePassword.accept(builder);
        return fromUsernamePassword(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftCredentials, T> g) {
        return obj -> g.apply((RedshiftCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftCredentials> {
        /**
         * <p>
         * The secret ARN of the Amazon Redshift credentials of a connection.
         * </p>
         * 
         * @param secretArn
         *        The secret ARN of the Amazon Redshift credentials of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The username and password of the Amazon Redshift credentials of a connection.
         * </p>
         * 
         * @param usernamePassword
         *        The username and password of the Amazon Redshift credentials of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernamePassword(UsernamePassword usernamePassword);

        /**
         * <p>
         * The username and password of the Amazon Redshift credentials of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsernamePassword.Builder} avoiding the
         * need to create one manually via {@link UsernamePassword#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsernamePassword.Builder#build()} is called immediately and its
         * result is passed to {@link #usernamePassword(UsernamePassword)}.
         * 
         * @param usernamePassword
         *        a consumer that will call methods on {@link UsernamePassword.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usernamePassword(UsernamePassword)
         */
        default Builder usernamePassword(Consumer<UsernamePassword.Builder> usernamePassword) {
            return usernamePassword(UsernamePassword.builder().applyMutation(usernamePassword).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String secretArn;

        private UsernamePassword usernamePassword;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftCredentials model) {
            secretArn(model.secretArn);
            usernamePassword(model.usernamePassword);
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            Object oldValue = this.secretArn;
            this.secretArn = secretArn;
            handleUnionValueChange(Type.SECRET_ARN, oldValue, this.secretArn);
        }

        @Override
        public final Builder secretArn(String secretArn) {
            Object oldValue = this.secretArn;
            this.secretArn = secretArn;
            handleUnionValueChange(Type.SECRET_ARN, oldValue, this.secretArn);
            return this;
        }

        public final UsernamePassword.Builder getUsernamePassword() {
            return usernamePassword != null ? usernamePassword.toBuilder() : null;
        }

        public final void setUsernamePassword(UsernamePassword.BuilderImpl usernamePassword) {
            Object oldValue = this.usernamePassword;
            this.usernamePassword = usernamePassword != null ? usernamePassword.build() : null;
            handleUnionValueChange(Type.USERNAME_PASSWORD, oldValue, this.usernamePassword);
        }

        @Override
        public final Builder usernamePassword(UsernamePassword usernamePassword) {
            Object oldValue = this.usernamePassword;
            this.usernamePassword = usernamePassword;
            handleUnionValueChange(Type.USERNAME_PASSWORD, oldValue, this.usernamePassword);
            return this;
        }

        @Override
        public RedshiftCredentials build() {
            return new RedshiftCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RedshiftCredentials#type()
     */
    public enum Type {
        SECRET_ARN,

        USERNAME_PASSWORD,

        UNKNOWN_TO_SDK_VERSION
    }
}
