/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amaon Redshift lineage sync configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftLineageSyncConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftLineageSyncConfigurationInput.Builder, RedshiftLineageSyncConfigurationInput> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(RedshiftLineageSyncConfigurationInput::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<LineageSyncSchedule> SCHEDULE_FIELD = SdkField
            .<LineageSyncSchedule> builder(MarshallingType.SDK_POJO).memberName("schedule")
            .getter(getter(RedshiftLineageSyncConfigurationInput::schedule)).setter(setter(Builder::schedule))
            .constructor(LineageSyncSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ENABLED_FIELD, SCHEDULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("enabled", ENABLED_FIELD);
                    put("schedule", SCHEDULE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final LineageSyncSchedule schedule;

    private RedshiftLineageSyncConfigurationInput(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.schedule = builder.schedule;
    }

    /**
     * <p>
     * Specifies whether the Amaon Redshift lineage sync configuration is enabled.
     * </p>
     * 
     * @return Specifies whether the Amaon Redshift lineage sync configuration is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The schedule of the Amaon Redshift lineage sync configuration.
     * </p>
     * 
     * @return The schedule of the Amaon Redshift lineage sync configuration.
     */
    public final LineageSyncSchedule schedule() {
        return schedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftLineageSyncConfigurationInput)) {
            return false;
        }
        RedshiftLineageSyncConfigurationInput other = (RedshiftLineageSyncConfigurationInput) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(schedule(), other.schedule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftLineageSyncConfigurationInput").add("Enabled", enabled()).add("Schedule", schedule())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftLineageSyncConfigurationInput, T> g) {
        return obj -> g.apply((RedshiftLineageSyncConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftLineageSyncConfigurationInput> {
        /**
         * <p>
         * Specifies whether the Amaon Redshift lineage sync configuration is enabled.
         * </p>
         * 
         * @param enabled
         *        Specifies whether the Amaon Redshift lineage sync configuration is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The schedule of the Amaon Redshift lineage sync configuration.
         * </p>
         * 
         * @param schedule
         *        The schedule of the Amaon Redshift lineage sync configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(LineageSyncSchedule schedule);

        /**
         * <p>
         * The schedule of the Amaon Redshift lineage sync configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineageSyncSchedule.Builder} avoiding the
         * need to create one manually via {@link LineageSyncSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineageSyncSchedule.Builder#build()} is called immediately and
         * its result is passed to {@link #schedule(LineageSyncSchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link LineageSyncSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(LineageSyncSchedule)
         */
        default Builder schedule(Consumer<LineageSyncSchedule.Builder> schedule) {
            return schedule(LineageSyncSchedule.builder().applyMutation(schedule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private LineageSyncSchedule schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftLineageSyncConfigurationInput model) {
            enabled(model.enabled);
            schedule(model.schedule);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final LineageSyncSchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(LineageSyncSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(LineageSyncSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        public RedshiftLineageSyncConfigurationInput build() {
            return new RedshiftLineageSyncConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
