/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Redshift properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftPropertiesOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftPropertiesOutput.Builder, RedshiftPropertiesOutput> {
    private static final SdkField<RedshiftCredentials> CREDENTIALS_FIELD = SdkField
            .<RedshiftCredentials> builder(MarshallingType.SDK_POJO).memberName("credentials")
            .getter(getter(RedshiftPropertiesOutput::credentials)).setter(setter(Builder::credentials))
            .constructor(RedshiftCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(RedshiftPropertiesOutput::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<Boolean> IS_PROVISIONED_SECRET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isProvisionedSecret").getter(getter(RedshiftPropertiesOutput::isProvisionedSecret))
            .setter(setter(Builder::isProvisionedSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isProvisionedSecret").build())
            .build();

    private static final SdkField<String> JDBC_IAM_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jdbcIamUrl").getter(getter(RedshiftPropertiesOutput::jdbcIamUrl)).setter(setter(Builder::jdbcIamUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jdbcIamUrl").build()).build();

    private static final SdkField<String> JDBC_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jdbcUrl").getter(getter(RedshiftPropertiesOutput::jdbcUrl)).setter(setter(Builder::jdbcUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jdbcUrl").build()).build();

    private static final SdkField<RedshiftLineageSyncConfigurationOutput> LINEAGE_SYNC_FIELD = SdkField
            .<RedshiftLineageSyncConfigurationOutput> builder(MarshallingType.SDK_POJO).memberName("lineageSync")
            .getter(getter(RedshiftPropertiesOutput::lineageSync)).setter(setter(Builder::lineageSync))
            .constructor(RedshiftLineageSyncConfigurationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineageSync").build()).build();

    private static final SdkField<String> REDSHIFT_TEMP_DIR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("redshiftTempDir").getter(getter(RedshiftPropertiesOutput::redshiftTempDir))
            .setter(setter(Builder::redshiftTempDir))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftTempDir").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RedshiftPropertiesOutput::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<RedshiftStorageProperties> STORAGE_FIELD = SdkField
            .<RedshiftStorageProperties> builder(MarshallingType.SDK_POJO).memberName("storage")
            .getter(getter(RedshiftPropertiesOutput::storage)).setter(setter(Builder::storage))
            .constructor(RedshiftStorageProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD,
            DATABASE_NAME_FIELD, IS_PROVISIONED_SECRET_FIELD, JDBC_IAM_URL_FIELD, JDBC_URL_FIELD, LINEAGE_SYNC_FIELD,
            REDSHIFT_TEMP_DIR_FIELD, STATUS_FIELD, STORAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("credentials", CREDENTIALS_FIELD);
                    put("databaseName", DATABASE_NAME_FIELD);
                    put("isProvisionedSecret", IS_PROVISIONED_SECRET_FIELD);
                    put("jdbcIamUrl", JDBC_IAM_URL_FIELD);
                    put("jdbcUrl", JDBC_URL_FIELD);
                    put("lineageSync", LINEAGE_SYNC_FIELD);
                    put("redshiftTempDir", REDSHIFT_TEMP_DIR_FIELD);
                    put("status", STATUS_FIELD);
                    put("storage", STORAGE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final RedshiftCredentials credentials;

    private final String databaseName;

    private final Boolean isProvisionedSecret;

    private final String jdbcIamUrl;

    private final String jdbcUrl;

    private final RedshiftLineageSyncConfigurationOutput lineageSync;

    private final String redshiftTempDir;

    private final String status;

    private final RedshiftStorageProperties storage;

    private RedshiftPropertiesOutput(BuilderImpl builder) {
        this.credentials = builder.credentials;
        this.databaseName = builder.databaseName;
        this.isProvisionedSecret = builder.isProvisionedSecret;
        this.jdbcIamUrl = builder.jdbcIamUrl;
        this.jdbcUrl = builder.jdbcUrl;
        this.lineageSync = builder.lineageSync;
        this.redshiftTempDir = builder.redshiftTempDir;
        this.status = builder.status;
        this.storage = builder.storage;
    }

    /**
     * <p>
     * The Amazon Redshift credentials.
     * </p>
     * 
     * @return The Amazon Redshift credentials.
     */
    public final RedshiftCredentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The Amazon Redshift database name.
     * </p>
     * 
     * @return The Amazon Redshift database name.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Specifies whether Amaon Redshift properties has a provisioned secret.
     * </p>
     * 
     * @return Specifies whether Amaon Redshift properties has a provisioned secret.
     */
    public final Boolean isProvisionedSecret() {
        return isProvisionedSecret;
    }

    /**
     * <p>
     * The jdbcIam URL of the Amazon Redshift properties.
     * </p>
     * 
     * @return The jdbcIam URL of the Amazon Redshift properties.
     */
    public final String jdbcIamUrl() {
        return jdbcIamUrl;
    }

    /**
     * <p>
     * The jdbcURL of the Amazon Redshift properties.
     * </p>
     * 
     * @return The jdbcURL of the Amazon Redshift properties.
     */
    public final String jdbcUrl() {
        return jdbcUrl;
    }

    /**
     * <p>
     * The lineage syn of the Amazon Redshift properties.
     * </p>
     * 
     * @return The lineage syn of the Amazon Redshift properties.
     */
    public final RedshiftLineageSyncConfigurationOutput lineageSync() {
        return lineageSync;
    }

    /**
     * <p>
     * The redshiftTempDir of the Amazon Redshift properties.
     * </p>
     * 
     * @return The redshiftTempDir of the Amazon Redshift properties.
     */
    public final String redshiftTempDir() {
        return redshiftTempDir;
    }

    /**
     * <p>
     * The status in the Amazon Redshift properties.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status in the Amazon Redshift properties.
     * @see ConnectionStatus
     */
    public final ConnectionStatus status() {
        return ConnectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status in the Amazon Redshift properties.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status in the Amazon Redshift properties.
     * @see ConnectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The storage in the Amazon Redshift properties.
     * </p>
     * 
     * @return The storage in the Amazon Redshift properties.
     */
    public final RedshiftStorageProperties storage() {
        return storage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(isProvisionedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(jdbcIamUrl());
        hashCode = 31 * hashCode + Objects.hashCode(jdbcUrl());
        hashCode = 31 * hashCode + Objects.hashCode(lineageSync());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftTempDir());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftPropertiesOutput)) {
            return false;
        }
        RedshiftPropertiesOutput other = (RedshiftPropertiesOutput) obj;
        return Objects.equals(credentials(), other.credentials()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(isProvisionedSecret(), other.isProvisionedSecret())
                && Objects.equals(jdbcIamUrl(), other.jdbcIamUrl()) && Objects.equals(jdbcUrl(), other.jdbcUrl())
                && Objects.equals(lineageSync(), other.lineageSync())
                && Objects.equals(redshiftTempDir(), other.redshiftTempDir())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(storage(), other.storage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftPropertiesOutput")
                .add("Credentials", credentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DatabaseName", databaseName()).add("IsProvisionedSecret", isProvisionedSecret())
                .add("JdbcIamUrl", jdbcIamUrl()).add("JdbcUrl", jdbcUrl()).add("LineageSync", lineageSync())
                .add("RedshiftTempDir", redshiftTempDir()).add("Status", statusAsString()).add("Storage", storage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "isProvisionedSecret":
            return Optional.ofNullable(clazz.cast(isProvisionedSecret()));
        case "jdbcIamUrl":
            return Optional.ofNullable(clazz.cast(jdbcIamUrl()));
        case "jdbcUrl":
            return Optional.ofNullable(clazz.cast(jdbcUrl()));
        case "lineageSync":
            return Optional.ofNullable(clazz.cast(lineageSync()));
        case "redshiftTempDir":
            return Optional.ofNullable(clazz.cast(redshiftTempDir()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "storage":
            return Optional.ofNullable(clazz.cast(storage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftPropertiesOutput, T> g) {
        return obj -> g.apply((RedshiftPropertiesOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftPropertiesOutput> {
        /**
         * <p>
         * The Amazon Redshift credentials.
         * </p>
         * 
         * @param credentials
         *        The Amazon Redshift credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(RedshiftCredentials credentials);

        /**
         * <p>
         * The Amazon Redshift credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftCredentials.Builder} avoiding the
         * need to create one manually via {@link RedshiftCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftCredentials.Builder#build()} is called immediately and
         * its result is passed to {@link #credentials(RedshiftCredentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link RedshiftCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(RedshiftCredentials)
         */
        default Builder credentials(Consumer<RedshiftCredentials.Builder> credentials) {
            return credentials(RedshiftCredentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The Amazon Redshift database name.
         * </p>
         * 
         * @param databaseName
         *        The Amazon Redshift database name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Specifies whether Amaon Redshift properties has a provisioned secret.
         * </p>
         * 
         * @param isProvisionedSecret
         *        Specifies whether Amaon Redshift properties has a provisioned secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isProvisionedSecret(Boolean isProvisionedSecret);

        /**
         * <p>
         * The jdbcIam URL of the Amazon Redshift properties.
         * </p>
         * 
         * @param jdbcIamUrl
         *        The jdbcIam URL of the Amazon Redshift properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jdbcIamUrl(String jdbcIamUrl);

        /**
         * <p>
         * The jdbcURL of the Amazon Redshift properties.
         * </p>
         * 
         * @param jdbcUrl
         *        The jdbcURL of the Amazon Redshift properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jdbcUrl(String jdbcUrl);

        /**
         * <p>
         * The lineage syn of the Amazon Redshift properties.
         * </p>
         * 
         * @param lineageSync
         *        The lineage syn of the Amazon Redshift properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageSync(RedshiftLineageSyncConfigurationOutput lineageSync);

        /**
         * <p>
         * The lineage syn of the Amazon Redshift properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RedshiftLineageSyncConfigurationOutput.Builder} avoiding the need to create one manually via
         * {@link RedshiftLineageSyncConfigurationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftLineageSyncConfigurationOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #lineageSync(RedshiftLineageSyncConfigurationOutput)}.
         * 
         * @param lineageSync
         *        a consumer that will call methods on {@link RedshiftLineageSyncConfigurationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineageSync(RedshiftLineageSyncConfigurationOutput)
         */
        default Builder lineageSync(Consumer<RedshiftLineageSyncConfigurationOutput.Builder> lineageSync) {
            return lineageSync(RedshiftLineageSyncConfigurationOutput.builder().applyMutation(lineageSync).build());
        }

        /**
         * <p>
         * The redshiftTempDir of the Amazon Redshift properties.
         * </p>
         * 
         * @param redshiftTempDir
         *        The redshiftTempDir of the Amazon Redshift properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftTempDir(String redshiftTempDir);

        /**
         * <p>
         * The status in the Amazon Redshift properties.
         * </p>
         * 
         * @param status
         *        The status in the Amazon Redshift properties.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status in the Amazon Redshift properties.
         * </p>
         * 
         * @param status
         *        The status in the Amazon Redshift properties.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(ConnectionStatus status);

        /**
         * <p>
         * The storage in the Amazon Redshift properties.
         * </p>
         * 
         * @param storage
         *        The storage in the Amazon Redshift properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(RedshiftStorageProperties storage);

        /**
         * <p>
         * The storage in the Amazon Redshift properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftStorageProperties.Builder}
         * avoiding the need to create one manually via {@link RedshiftStorageProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftStorageProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #storage(RedshiftStorageProperties)}.
         * 
         * @param storage
         *        a consumer that will call methods on {@link RedshiftStorageProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storage(RedshiftStorageProperties)
         */
        default Builder storage(Consumer<RedshiftStorageProperties.Builder> storage) {
            return storage(RedshiftStorageProperties.builder().applyMutation(storage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RedshiftCredentials credentials;

        private String databaseName;

        private Boolean isProvisionedSecret;

        private String jdbcIamUrl;

        private String jdbcUrl;

        private RedshiftLineageSyncConfigurationOutput lineageSync;

        private String redshiftTempDir;

        private String status;

        private RedshiftStorageProperties storage;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftPropertiesOutput model) {
            credentials(model.credentials);
            databaseName(model.databaseName);
            isProvisionedSecret(model.isProvisionedSecret);
            jdbcIamUrl(model.jdbcIamUrl);
            jdbcUrl(model.jdbcUrl);
            lineageSync(model.lineageSync);
            redshiftTempDir(model.redshiftTempDir);
            status(model.status);
            storage(model.storage);
        }

        public final RedshiftCredentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(RedshiftCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(RedshiftCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final Boolean getIsProvisionedSecret() {
            return isProvisionedSecret;
        }

        public final void setIsProvisionedSecret(Boolean isProvisionedSecret) {
            this.isProvisionedSecret = isProvisionedSecret;
        }

        @Override
        public final Builder isProvisionedSecret(Boolean isProvisionedSecret) {
            this.isProvisionedSecret = isProvisionedSecret;
            return this;
        }

        public final String getJdbcIamUrl() {
            return jdbcIamUrl;
        }

        public final void setJdbcIamUrl(String jdbcIamUrl) {
            this.jdbcIamUrl = jdbcIamUrl;
        }

        @Override
        public final Builder jdbcIamUrl(String jdbcIamUrl) {
            this.jdbcIamUrl = jdbcIamUrl;
            return this;
        }

        public final String getJdbcUrl() {
            return jdbcUrl;
        }

        public final void setJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
        }

        @Override
        public final Builder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public final RedshiftLineageSyncConfigurationOutput.Builder getLineageSync() {
            return lineageSync != null ? lineageSync.toBuilder() : null;
        }

        public final void setLineageSync(RedshiftLineageSyncConfigurationOutput.BuilderImpl lineageSync) {
            this.lineageSync = lineageSync != null ? lineageSync.build() : null;
        }

        @Override
        public final Builder lineageSync(RedshiftLineageSyncConfigurationOutput lineageSync) {
            this.lineageSync = lineageSync;
            return this;
        }

        public final String getRedshiftTempDir() {
            return redshiftTempDir;
        }

        public final void setRedshiftTempDir(String redshiftTempDir) {
            this.redshiftTempDir = redshiftTempDir;
        }

        @Override
        public final Builder redshiftTempDir(String redshiftTempDir) {
            this.redshiftTempDir = redshiftTempDir;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final RedshiftStorageProperties.Builder getStorage() {
            return storage != null ? storage.toBuilder() : null;
        }

        public final void setStorage(RedshiftStorageProperties.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        @Override
        public final Builder storage(RedshiftStorageProperties storage) {
            this.storage = storage;
            return this;
        }

        @Override
        public RedshiftPropertiesOutput build() {
            return new RedshiftPropertiesOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
