/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The relational filter configuration for the data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelationalFilterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RelationalFilterConfiguration.Builder, RelationalFilterConfiguration> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(RelationalFilterConfiguration::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<List<FilterExpression>> FILTER_EXPRESSIONS_FIELD = SdkField
            .<List<FilterExpression>> builder(MarshallingType.LIST)
            .memberName("filterExpressions")
            .getter(getter(RelationalFilterConfiguration::filterExpressions))
            .setter(setter(Builder::filterExpressions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterExpressions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterExpression> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterExpression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaName").getter(getter(RelationalFilterConfiguration::schemaName))
            .setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            FILTER_EXPRESSIONS_FIELD, SCHEMA_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("databaseName", DATABASE_NAME_FIELD);
                    put("filterExpressions", FILTER_EXPRESSIONS_FIELD);
                    put("schemaName", SCHEMA_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String databaseName;

    private final List<FilterExpression> filterExpressions;

    private final String schemaName;

    private RelationalFilterConfiguration(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.filterExpressions = builder.filterExpressions;
        this.schemaName = builder.schemaName;
    }

    /**
     * <p>
     * The database name specified in the relational filter configuration for the data source.
     * </p>
     * 
     * @return The database name specified in the relational filter configuration for the data source.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterExpressions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterExpressions() {
        return filterExpressions != null && !(filterExpressions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter expressions specified in the relational filter configuration for the data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterExpressions} method.
     * </p>
     * 
     * @return The filter expressions specified in the relational filter configuration for the data source.
     */
    public final List<FilterExpression> filterExpressions() {
        return filterExpressions;
    }

    /**
     * <p>
     * The schema name specified in the relational filter configuration for the data source.
     * </p>
     * 
     * @return The schema name specified in the relational filter configuration for the data source.
     */
    public final String schemaName() {
        return schemaName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterExpressions() ? filterExpressions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalFilterConfiguration)) {
            return false;
        }
        RelationalFilterConfiguration other = (RelationalFilterConfiguration) obj;
        return Objects.equals(databaseName(), other.databaseName()) && hasFilterExpressions() == other.hasFilterExpressions()
                && Objects.equals(filterExpressions(), other.filterExpressions())
                && Objects.equals(schemaName(), other.schemaName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelationalFilterConfiguration").add("DatabaseName", databaseName())
                .add("FilterExpressions", hasFilterExpressions() ? filterExpressions() : null).add("SchemaName", schemaName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "filterExpressions":
            return Optional.ofNullable(clazz.cast(filterExpressions()));
        case "schemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RelationalFilterConfiguration, T> g) {
        return obj -> g.apply((RelationalFilterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelationalFilterConfiguration> {
        /**
         * <p>
         * The database name specified in the relational filter configuration for the data source.
         * </p>
         * 
         * @param databaseName
         *        The database name specified in the relational filter configuration for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The filter expressions specified in the relational filter configuration for the data source.
         * </p>
         * 
         * @param filterExpressions
         *        The filter expressions specified in the relational filter configuration for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpressions(Collection<FilterExpression> filterExpressions);

        /**
         * <p>
         * The filter expressions specified in the relational filter configuration for the data source.
         * </p>
         * 
         * @param filterExpressions
         *        The filter expressions specified in the relational filter configuration for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpressions(FilterExpression... filterExpressions);

        /**
         * <p>
         * The filter expressions specified in the relational filter configuration for the data source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FilterExpression.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.FilterExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FilterExpression.Builder#build()} is called immediately
         * and its result is passed to {@link #filterExpressions(List<FilterExpression>)}.
         * 
         * @param filterExpressions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FilterExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterExpressions(java.util.Collection<FilterExpression>)
         */
        Builder filterExpressions(Consumer<FilterExpression.Builder>... filterExpressions);

        /**
         * <p>
         * The schema name specified in the relational filter configuration for the data source.
         * </p>
         * 
         * @param schemaName
         *        The schema name specified in the relational filter configuration for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);
    }

    static final class BuilderImpl implements Builder {
        private String databaseName;

        private List<FilterExpression> filterExpressions = DefaultSdkAutoConstructList.getInstance();

        private String schemaName;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalFilterConfiguration model) {
            databaseName(model.databaseName);
            filterExpressions(model.filterExpressions);
            schemaName(model.schemaName);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final List<FilterExpression.Builder> getFilterExpressions() {
            List<FilterExpression.Builder> result = FilterExpressionsCopier.copyToBuilder(this.filterExpressions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterExpressions(Collection<FilterExpression.BuilderImpl> filterExpressions) {
            this.filterExpressions = FilterExpressionsCopier.copyFromBuilder(filterExpressions);
        }

        @Override
        public final Builder filterExpressions(Collection<FilterExpression> filterExpressions) {
            this.filterExpressions = FilterExpressionsCopier.copy(filterExpressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterExpressions(FilterExpression... filterExpressions) {
            filterExpressions(Arrays.asList(filterExpressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterExpressions(Consumer<FilterExpression.Builder>... filterExpressions) {
            filterExpressions(Stream.of(filterExpressions).map(c -> FilterExpression.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public RelationalFilterConfiguration build() {
            return new RelationalFilterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
