/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemovePolicyGrantRequest extends DataZoneRequest implements
        ToCopyableBuilder<RemovePolicyGrantRequest.Builder, RemovePolicyGrantRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(RemovePolicyGrantRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(RemovePolicyGrantRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityIdentifier").getter(getter(RemovePolicyGrantRequest::entityIdentifier))
            .setter(setter(Builder::entityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(RemovePolicyGrantRequest::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyType").getter(getter(RemovePolicyGrantRequest::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()).build();

    private static final SdkField<PolicyGrantPrincipal> PRINCIPAL_FIELD = SdkField
            .<PolicyGrantPrincipal> builder(MarshallingType.SDK_POJO).memberName("principal")
            .getter(getter(RemovePolicyGrantRequest::principal)).setter(setter(Builder::principal))
            .constructor(PolicyGrantPrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DOMAIN_IDENTIFIER_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_TYPE_FIELD, POLICY_TYPE_FIELD, PRINCIPAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("clientToken", CLIENT_TOKEN_FIELD);
                    put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
                    put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
                    put("entityType", ENTITY_TYPE_FIELD);
                    put("policyType", POLICY_TYPE_FIELD);
                    put("principal", PRINCIPAL_FIELD);
                }
            });

    private final String clientToken;

    private final String domainIdentifier;

    private final String entityIdentifier;

    private final String entityType;

    private final String policyType;

    private final PolicyGrantPrincipal principal;

    private RemovePolicyGrantRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityType = builder.entityType;
        this.policyType = builder.policyType;
        this.principal = builder.principal;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the domain where you want to remove a policy grant.
     * </p>
     * 
     * @return The ID of the domain where you want to remove a policy grant.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the entity from which you want to remove a policy grant.
     * </p>
     * 
     * @return The ID of the entity from which you want to remove a policy grant.
     */
    public final String entityIdentifier() {
        return entityIdentifier;
    }

    /**
     * <p>
     * The type of the entity from which you want to remove a policy grant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TargetEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the entity from which you want to remove a policy grant.
     * @see TargetEntityType
     */
    public final TargetEntityType entityType() {
        return TargetEntityType.fromValue(entityType);
    }

    /**
     * <p>
     * The type of the entity from which you want to remove a policy grant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TargetEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the entity from which you want to remove a policy grant.
     * @see TargetEntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    /**
     * <p>
     * The type of the policy that you want to remove.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link ManagedPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of the policy that you want to remove.
     * @see ManagedPolicyType
     */
    public final ManagedPolicyType policyType() {
        return ManagedPolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The type of the policy that you want to remove.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link ManagedPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of the policy that you want to remove.
     * @see ManagedPolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * The principal from which you want to remove a policy grant.
     * </p>
     * 
     * @return The principal from which you want to remove a policy grant.
     */
    public final PolicyGrantPrincipal principal() {
        return principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemovePolicyGrantRequest)) {
            return false;
        }
        RemovePolicyGrantRequest other = (RemovePolicyGrantRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(entityIdentifier(), other.entityIdentifier())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(principal(), other.principal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemovePolicyGrantRequest").add("ClientToken", clientToken())
                .add("DomainIdentifier", domainIdentifier()).add("EntityIdentifier", entityIdentifier())
                .add("EntityType", entityTypeAsString()).add("PolicyType", policyTypeAsString()).add("Principal", principal())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "entityIdentifier":
            return Optional.ofNullable(clazz.cast(entityIdentifier()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        case "policyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RemovePolicyGrantRequest, T> g) {
        return obj -> g.apply((RemovePolicyGrantRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemovePolicyGrantRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the domain where you want to remove a policy grant.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain where you want to remove a policy grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the entity from which you want to remove a policy grant.
         * </p>
         * 
         * @param entityIdentifier
         *        The ID of the entity from which you want to remove a policy grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdentifier(String entityIdentifier);

        /**
         * <p>
         * The type of the entity from which you want to remove a policy grant.
         * </p>
         * 
         * @param entityType
         *        The type of the entity from which you want to remove a policy grant.
         * @see TargetEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetEntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The type of the entity from which you want to remove a policy grant.
         * </p>
         * 
         * @param entityType
         *        The type of the entity from which you want to remove a policy grant.
         * @see TargetEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetEntityType
         */
        Builder entityType(TargetEntityType entityType);

        /**
         * <p>
         * The type of the policy that you want to remove.
         * </p>
         * 
         * @param policyType
         *        The type of the policy that you want to remove.
         * @see ManagedPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedPolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of the policy that you want to remove.
         * </p>
         * 
         * @param policyType
         *        The type of the policy that you want to remove.
         * @see ManagedPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedPolicyType
         */
        Builder policyType(ManagedPolicyType policyType);

        /**
         * <p>
         * The principal from which you want to remove a policy grant.
         * </p>
         * 
         * @param principal
         *        The principal from which you want to remove a policy grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(PolicyGrantPrincipal principal);

        /**
         * <p>
         * The principal from which you want to remove a policy grant.
         * </p>
         * This is a convenience method that creates an instance of the {@link PolicyGrantPrincipal.Builder} avoiding
         * the need to create one manually via {@link PolicyGrantPrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PolicyGrantPrincipal.Builder#build()} is called immediately and
         * its result is passed to {@link #principal(PolicyGrantPrincipal)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link PolicyGrantPrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(PolicyGrantPrincipal)
         */
        default Builder principal(Consumer<PolicyGrantPrincipal.Builder> principal) {
            return principal(PolicyGrantPrincipal.builder().applyMutation(principal).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String domainIdentifier;

        private String entityIdentifier;

        private String entityType;

        private String policyType;

        private PolicyGrantPrincipal principal;

        private BuilderImpl() {
        }

        private BuilderImpl(RemovePolicyGrantRequest model) {
            super(model);
            clientToken(model.clientToken);
            domainIdentifier(model.domainIdentifier);
            entityIdentifier(model.entityIdentifier);
            entityType(model.entityType);
            policyType(model.policyType);
            principal(model.principal);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(TargetEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(ManagedPolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final PolicyGrantPrincipal.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        public final void setPrincipal(PolicyGrantPrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(PolicyGrantPrincipal principal) {
            this.principal = principal;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemovePolicyGrantRequest build() {
            return new RemovePolicyGrantRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
