/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The row filter configuration details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RowFilterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RowFilterConfiguration.Builder, RowFilterConfiguration> {
    private static final SdkField<RowFilter> ROW_FILTER_FIELD = SdkField.<RowFilter> builder(MarshallingType.SDK_POJO)
            .memberName("rowFilter").getter(getter(RowFilterConfiguration::rowFilter)).setter(setter(Builder::rowFilter))
            .constructor(RowFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowFilter").build()).build();

    private static final SdkField<Boolean> SENSITIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("sensitive").getter(getter(RowFilterConfiguration::sensitive)).setter(setter(Builder::sensitive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_FILTER_FIELD,
            SENSITIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("rowFilter", ROW_FILTER_FIELD);
                    put("sensitive", SENSITIVE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final RowFilter rowFilter;

    private final Boolean sensitive;

    private RowFilterConfiguration(BuilderImpl builder) {
        this.rowFilter = builder.rowFilter;
        this.sensitive = builder.sensitive;
    }

    /**
     * <p>
     * The row filter.
     * </p>
     * 
     * @return The row filter.
     */
    public final RowFilter rowFilter() {
        return rowFilter;
    }

    /**
     * <p>
     * Specifies whether the row filter is sensitive.
     * </p>
     * 
     * @return Specifies whether the row filter is sensitive.
     */
    public final Boolean sensitive() {
        return sensitive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rowFilter());
        hashCode = 31 * hashCode + Objects.hashCode(sensitive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowFilterConfiguration)) {
            return false;
        }
        RowFilterConfiguration other = (RowFilterConfiguration) obj;
        return Objects.equals(rowFilter(), other.rowFilter()) && Objects.equals(sensitive(), other.sensitive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RowFilterConfiguration").add("RowFilter", rowFilter()).add("Sensitive", sensitive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rowFilter":
            return Optional.ofNullable(clazz.cast(rowFilter()));
        case "sensitive":
            return Optional.ofNullable(clazz.cast(sensitive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RowFilterConfiguration, T> g) {
        return obj -> g.apply((RowFilterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RowFilterConfiguration> {
        /**
         * <p>
         * The row filter.
         * </p>
         * 
         * @param rowFilter
         *        The row filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowFilter(RowFilter rowFilter);

        /**
         * <p>
         * The row filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link RowFilter.Builder} avoiding the need to
         * create one manually via {@link RowFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RowFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #rowFilter(RowFilter)}.
         * 
         * @param rowFilter
         *        a consumer that will call methods on {@link RowFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowFilter(RowFilter)
         */
        default Builder rowFilter(Consumer<RowFilter.Builder> rowFilter) {
            return rowFilter(RowFilter.builder().applyMutation(rowFilter).build());
        }

        /**
         * <p>
         * Specifies whether the row filter is sensitive.
         * </p>
         * 
         * @param sensitive
         *        Specifies whether the row filter is sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitive(Boolean sensitive);
    }

    static final class BuilderImpl implements Builder {
        private RowFilter rowFilter;

        private Boolean sensitive;

        private BuilderImpl() {
        }

        private BuilderImpl(RowFilterConfiguration model) {
            rowFilter(model.rowFilter);
            sensitive(model.sensitive);
        }

        public final RowFilter.Builder getRowFilter() {
            return rowFilter != null ? rowFilter.toBuilder() : null;
        }

        public final void setRowFilter(RowFilter.BuilderImpl rowFilter) {
            this.rowFilter = rowFilter != null ? rowFilter.build() : null;
        }

        @Override
        public final Builder rowFilter(RowFilter rowFilter) {
            this.rowFilter = rowFilter;
            return this;
        }

        public final Boolean getSensitive() {
            return sensitive;
        }

        public final void setSensitive(Boolean sensitive) {
            this.sensitive = sensitive;
        }

        @Override
        public final Builder sensitive(Boolean sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        @Override
        public RowFilterConfiguration build() {
            return new RowFilterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
