/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target of the rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleTarget implements SdkPojo, Serializable, ToCopyableBuilder<RuleTarget.Builder, RuleTarget> {
    private static final SdkField<DomainUnitTarget> DOMAIN_UNIT_TARGET_FIELD = SdkField
            .<DomainUnitTarget> builder(MarshallingType.SDK_POJO).memberName("domainUnitTarget")
            .getter(getter(RuleTarget::domainUnitTarget)).setter(setter(Builder::domainUnitTarget))
            .constructor(DomainUnitTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_UNIT_TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("domainUnitTarget", DOMAIN_UNIT_TARGET_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final DomainUnitTarget domainUnitTarget;

    private final Type type;

    private RuleTarget(BuilderImpl builder) {
        this.domainUnitTarget = builder.domainUnitTarget;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID of the domain unit.
     * </p>
     * 
     * @return The ID of the domain unit.
     */
    public final DomainUnitTarget domainUnitTarget() {
        return domainUnitTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainUnitTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleTarget)) {
            return false;
        }
        RuleTarget other = (RuleTarget) obj;
        return Objects.equals(domainUnitTarget(), other.domainUnitTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleTarget").add("DomainUnitTarget", domainUnitTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainUnitTarget":
            return Optional.ofNullable(clazz.cast(domainUnitTarget()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #domainUnitTarget()} initialized to the given value.
     *
     * <p>
     * The ID of the domain unit.
     * </p>
     * 
     * @param domainUnitTarget
     *        The ID of the domain unit.
     */
    public static RuleTarget fromDomainUnitTarget(DomainUnitTarget domainUnitTarget) {
        return builder().domainUnitTarget(domainUnitTarget).build();
    }

    /**
     * Create an instance of this class with {@link #domainUnitTarget()} initialized to the given value.
     *
     * <p>
     * The ID of the domain unit.
     * </p>
     * 
     * @param domainUnitTarget
     *        The ID of the domain unit.
     */
    public static RuleTarget fromDomainUnitTarget(Consumer<DomainUnitTarget.Builder> domainUnitTarget) {
        DomainUnitTarget.Builder builder = DomainUnitTarget.builder();
        domainUnitTarget.accept(builder);
        return fromDomainUnitTarget(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RuleTarget, T> g) {
        return obj -> g.apply((RuleTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleTarget> {
        /**
         * <p>
         * The ID of the domain unit.
         * </p>
         * 
         * @param domainUnitTarget
         *        The ID of the domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainUnitTarget(DomainUnitTarget domainUnitTarget);

        /**
         * <p>
         * The ID of the domain unit.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainUnitTarget.Builder} avoiding the
         * need to create one manually via {@link DomainUnitTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainUnitTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #domainUnitTarget(DomainUnitTarget)}.
         * 
         * @param domainUnitTarget
         *        a consumer that will call methods on {@link DomainUnitTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainUnitTarget(DomainUnitTarget)
         */
        default Builder domainUnitTarget(Consumer<DomainUnitTarget.Builder> domainUnitTarget) {
            return domainUnitTarget(DomainUnitTarget.builder().applyMutation(domainUnitTarget).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DomainUnitTarget domainUnitTarget;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleTarget model) {
            domainUnitTarget(model.domainUnitTarget);
        }

        public final DomainUnitTarget.Builder getDomainUnitTarget() {
            return domainUnitTarget != null ? domainUnitTarget.toBuilder() : null;
        }

        public final void setDomainUnitTarget(DomainUnitTarget.BuilderImpl domainUnitTarget) {
            Object oldValue = this.domainUnitTarget;
            this.domainUnitTarget = domainUnitTarget != null ? domainUnitTarget.build() : null;
            handleUnionValueChange(Type.DOMAIN_UNIT_TARGET, oldValue, this.domainUnitTarget);
        }

        @Override
        public final Builder domainUnitTarget(DomainUnitTarget domainUnitTarget) {
            Object oldValue = this.domainUnitTarget;
            this.domainUnitTarget = domainUnitTarget;
            handleUnionValueChange(Type.DOMAIN_UNIT_TARGET, oldValue, this.domainUnitTarget);
            return this;
        }

        @Override
        public RuleTarget build() {
            return new RuleTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RuleTarget#type()
     */
    public enum Type {
        DOMAIN_UNIT_TARGET,

        UNKNOWN_TO_SDK_VERSION
    }
}
