/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon SageMaker run configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SageMakerRunConfigurationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<SageMakerRunConfigurationOutput.Builder, SageMakerRunConfigurationOutput> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(SageMakerRunConfigurationOutput::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(SageMakerRunConfigurationOutput::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<Map<String, List<String>>> TRACKING_ASSETS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("trackingAssets")
            .getter(getter(SageMakerRunConfigurationOutput::trackingAssets))
            .setter(setter(Builder::trackingAssets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingAssets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            REGION_FIELD, TRACKING_ASSETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("accountId", ACCOUNT_ID_FIELD);
                    put("region", REGION_FIELD);
                    put("trackingAssets", TRACKING_ASSETS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String region;

    private final Map<String, List<String>> trackingAssets;

    private SageMakerRunConfigurationOutput(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.region = builder.region;
        this.trackingAssets = builder.trackingAssets;
    }

    /**
     * <p>
     * The Amazon SageMaker account ID.
     * </p>
     * 
     * @return The Amazon SageMaker account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Amazon SageMaker Region.
     * </p>
     * 
     * @return The Amazon SageMaker Region.
     */
    public final String region() {
        return region;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrackingAssets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrackingAssets() {
        return trackingAssets != null && !(trackingAssets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tracking assets of the Amazon SageMaker.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrackingAssets} method.
     * </p>
     * 
     * @return The tracking assets of the Amazon SageMaker.
     */
    public final Map<String, List<String>> trackingAssets() {
        return trackingAssets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrackingAssets() ? trackingAssets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SageMakerRunConfigurationOutput)) {
            return false;
        }
        SageMakerRunConfigurationOutput other = (SageMakerRunConfigurationOutput) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(region(), other.region())
                && hasTrackingAssets() == other.hasTrackingAssets() && Objects.equals(trackingAssets(), other.trackingAssets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SageMakerRunConfigurationOutput").add("AccountId", accountId()).add("Region", region())
                .add("TrackingAssets", hasTrackingAssets() ? trackingAssets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "trackingAssets":
            return Optional.ofNullable(clazz.cast(trackingAssets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SageMakerRunConfigurationOutput, T> g) {
        return obj -> g.apply((SageMakerRunConfigurationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SageMakerRunConfigurationOutput> {
        /**
         * <p>
         * The Amazon SageMaker account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon SageMaker account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Amazon SageMaker Region.
         * </p>
         * 
         * @param region
         *        The Amazon SageMaker Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The tracking assets of the Amazon SageMaker.
         * </p>
         * 
         * @param trackingAssets
         *        The tracking assets of the Amazon SageMaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingAssets(Map<String, ? extends Collection<String>> trackingAssets);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String region;

        private Map<String, List<String>> trackingAssets = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SageMakerRunConfigurationOutput model) {
            accountId(model.accountId);
            region(model.region);
            trackingAssets(model.trackingAssets);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getTrackingAssets() {
            if (trackingAssets instanceof SdkAutoConstructMap) {
                return null;
            }
            return trackingAssets;
        }

        public final void setTrackingAssets(Map<String, ? extends Collection<String>> trackingAssets) {
            this.trackingAssets = TrackingAssetsCopier.copy(trackingAssets);
        }

        @Override
        public final Builder trackingAssets(Map<String, ? extends Collection<String>> trackingAssets) {
            this.trackingAssets = TrackingAssetsCopier.copy(trackingAssets);
            return this;
        }

        @Override
        public SageMakerRunConfigurationOutput build() {
            return new SageMakerRunConfigurationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
