/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchTypesRequest extends DataZoneRequest implements
        ToCopyableBuilder<SearchTypesRequest.Builder, SearchTypesRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(SearchTypesRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<FilterClause> FILTERS_FIELD = SdkField.<FilterClause> builder(MarshallingType.SDK_POJO)
            .memberName("filters").getter(getter(SearchTypesRequest::filters)).setter(setter(Builder::filters))
            .constructor(FilterClause::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build()).build();

    private static final SdkField<Boolean> MANAGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("managed").getter(getter(SearchTypesRequest::managed)).setter(setter(Builder::managed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managed").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchTypesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchTypesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<SearchInItem>> SEARCH_IN_FIELD = SdkField
            .<List<SearchInItem>> builder(MarshallingType.LIST)
            .memberName("searchIn")
            .getter(getter(SearchTypesRequest::searchIn))
            .setter(setter(Builder::searchIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchIn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchInItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchInItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SEARCH_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("searchScope").getter(getter(SearchTypesRequest::searchScopeAsString))
            .setter(setter(Builder::searchScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchScope").build()).build();

    private static final SdkField<String> SEARCH_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("searchText").getter(getter(SearchTypesRequest::searchText)).setter(setter(Builder::searchText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchText").build()).build();

    private static final SdkField<SearchSort> SORT_FIELD = SdkField.<SearchSort> builder(MarshallingType.SDK_POJO)
            .memberName("sort").getter(getter(SearchTypesRequest::sort)).setter(setter(Builder::sort))
            .constructor(SearchSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            FILTERS_FIELD, MANAGED_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEARCH_IN_FIELD, SEARCH_SCOPE_FIELD,
            SEARCH_TEXT_FIELD, SORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
                    put("filters", FILTERS_FIELD);
                    put("managed", MANAGED_FIELD);
                    put("maxResults", MAX_RESULTS_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                    put("searchIn", SEARCH_IN_FIELD);
                    put("searchScope", SEARCH_SCOPE_FIELD);
                    put("searchText", SEARCH_TEXT_FIELD);
                    put("sort", SORT_FIELD);
                }
            });

    private final String domainIdentifier;

    private final FilterClause filters;

    private final Boolean managed;

    private final Integer maxResults;

    private final String nextToken;

    private final List<SearchInItem> searchIn;

    private final String searchScope;

    private final String searchText;

    private final SearchSort sort;

    private SearchTypesRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.filters = builder.filters;
        this.managed = builder.managed;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.searchIn = builder.searchIn;
        this.searchScope = builder.searchScope;
        this.searchText = builder.searchText;
        this.sort = builder.sort;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which to invoke the <code>SearchTypes</code> action.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which to invoke the <code>SearchTypes</code> action.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The filters for the <code>SearchTypes</code> action.
     * </p>
     * 
     * @return The filters for the <code>SearchTypes</code> action.
     */
    public final FilterClause filters() {
        return filters;
    }

    /**
     * <p>
     * Specifies whether the search is managed.
     * </p>
     * 
     * @return Specifies whether the search is managed.
     */
    public final Boolean managed() {
        return managed;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call to <code>SearchTypes</code>. When the number of results
     * to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code>
     * value that you can use in a subsequent call to <code>SearchTypes</code> to list the next set of results.
     * </p>
     * 
     * @return The maximum number of results to return in a single call to <code>SearchTypes</code>. When the number of
     *         results to be listed is greater than the value of <code>MaxResults</code>, the response contains a
     *         <code>NextToken</code> value that you can use in a subsequent call to <code>SearchTypes</code> to list
     *         the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you
     * explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response
     * includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
     * subsequent call to <code>SearchTypes</code> to list the next set of results.
     * </p>
     * 
     * @return When the number of results is greater than the default value for the <code>MaxResults</code> parameter,
     *         or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results,
     *         the response includes a pagination token named <code>NextToken</code>. You can specify this
     *         <code>NextToken</code> value in a subsequent call to <code>SearchTypes</code> to list the next set of
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SearchIn property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSearchIn() {
        return searchIn != null && !(searchIn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSearchIn} method.
     * </p>
     * 
     * @return The details of the search.
     */
    public final List<SearchInItem> searchIn() {
        return searchIn;
    }

    /**
     * <p>
     * Specifies the scope of the search for types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #searchScope} will
     * return {@link TypesSearchScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #searchScopeAsString}.
     * </p>
     * 
     * @return Specifies the scope of the search for types.
     * @see TypesSearchScope
     */
    public final TypesSearchScope searchScope() {
        return TypesSearchScope.fromValue(searchScope);
    }

    /**
     * <p>
     * Specifies the scope of the search for types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #searchScope} will
     * return {@link TypesSearchScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #searchScopeAsString}.
     * </p>
     * 
     * @return Specifies the scope of the search for types.
     * @see TypesSearchScope
     */
    public final String searchScopeAsString() {
        return searchScope;
    }

    /**
     * <p>
     * Specifies the text for which to search.
     * </p>
     * 
     * @return Specifies the text for which to search.
     */
    public final String searchText() {
        return searchText;
    }

    /**
     * <p>
     * The specifies the way to sort the <code>SearchTypes</code> results.
     * </p>
     * 
     * @return The specifies the way to sort the <code>SearchTypes</code> results.
     */
    public final SearchSort sort() {
        return sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(managed());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSearchIn() ? searchIn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(searchScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(searchText());
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTypesRequest)) {
            return false;
        }
        SearchTypesRequest other = (SearchTypesRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier()) && Objects.equals(filters(), other.filters())
                && Objects.equals(managed(), other.managed()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && hasSearchIn() == other.hasSearchIn()
                && Objects.equals(searchIn(), other.searchIn())
                && Objects.equals(searchScopeAsString(), other.searchScopeAsString())
                && Objects.equals(searchText(), other.searchText()) && Objects.equals(sort(), other.sort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchTypesRequest").add("DomainIdentifier", domainIdentifier()).add("Filters", filters())
                .add("Managed", managed()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("SearchIn", hasSearchIn() ? searchIn() : null).add("SearchScope", searchScopeAsString())
                .add("SearchText", searchText()).add("Sort", sort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "managed":
            return Optional.ofNullable(clazz.cast(managed()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "searchIn":
            return Optional.ofNullable(clazz.cast(searchIn()));
        case "searchScope":
            return Optional.ofNullable(clazz.cast(searchScopeAsString()));
        case "searchText":
            return Optional.ofNullable(clazz.cast(searchText()));
        case "sort":
            return Optional.ofNullable(clazz.cast(sort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchTypesRequest, T> g) {
        return obj -> g.apply((SearchTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchTypesRequest> {
        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which to invoke the <code>SearchTypes</code> action.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain in which to invoke the <code>SearchTypes</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The filters for the <code>SearchTypes</code> action.
         * </p>
         * 
         * @param filters
         *        The filters for the <code>SearchTypes</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(FilterClause filters);

        /**
         * <p>
         * The filters for the <code>SearchTypes</code> action.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterClause.Builder} avoiding the need
         * to create one manually via {@link FilterClause#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterClause.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(FilterClause)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link FilterClause.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(FilterClause)
         */
        default Builder filters(Consumer<FilterClause.Builder> filters) {
            return filters(FilterClause.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * Specifies whether the search is managed.
         * </p>
         * 
         * @param managed
         *        Specifies whether the search is managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managed(Boolean managed);

        /**
         * <p>
         * The maximum number of results to return in a single call to <code>SearchTypes</code>. When the number of
         * results to be listed is greater than the value of <code>MaxResults</code>, the response contains a
         * <code>NextToken</code> value that you can use in a subsequent call to <code>SearchTypes</code> to list the
         * next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call to <code>SearchTypes</code>. When the number
         *        of results to be listed is greater than the value of <code>MaxResults</code>, the response contains a
         *        <code>NextToken</code> value that you can use in a subsequent call to <code>SearchTypes</code> to list
         *        the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if
         * you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the
         * response includes a pagination token named <code>NextToken</code>. You can specify this
         * <code>NextToken</code> value in a subsequent call to <code>SearchTypes</code> to list the next set of
         * results.
         * </p>
         * 
         * @param nextToken
         *        When the number of results is greater than the default value for the <code>MaxResults</code>
         *        parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the
         *        number of results, the response includes a pagination token named <code>NextToken</code>. You can
         *        specify this <code>NextToken</code> value in a subsequent call to <code>SearchTypes</code> to list the
         *        next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The details of the search.
         * </p>
         * 
         * @param searchIn
         *        The details of the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchIn(Collection<SearchInItem> searchIn);

        /**
         * <p>
         * The details of the search.
         * </p>
         * 
         * @param searchIn
         *        The details of the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchIn(SearchInItem... searchIn);

        /**
         * <p>
         * The details of the search.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.SearchInItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.SearchInItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.SearchInItem.Builder#build()} is called immediately and
         * its result is passed to {@link #searchIn(List<SearchInItem>)}.
         * 
         * @param searchIn
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.SearchInItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchIn(java.util.Collection<SearchInItem>)
         */
        Builder searchIn(Consumer<SearchInItem.Builder>... searchIn);

        /**
         * <p>
         * Specifies the scope of the search for types.
         * </p>
         * 
         * @param searchScope
         *        Specifies the scope of the search for types.
         * @see TypesSearchScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TypesSearchScope
         */
        Builder searchScope(String searchScope);

        /**
         * <p>
         * Specifies the scope of the search for types.
         * </p>
         * 
         * @param searchScope
         *        Specifies the scope of the search for types.
         * @see TypesSearchScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TypesSearchScope
         */
        Builder searchScope(TypesSearchScope searchScope);

        /**
         * <p>
         * Specifies the text for which to search.
         * </p>
         * 
         * @param searchText
         *        Specifies the text for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchText(String searchText);

        /**
         * <p>
         * The specifies the way to sort the <code>SearchTypes</code> results.
         * </p>
         * 
         * @param sort
         *        The specifies the way to sort the <code>SearchTypes</code> results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(SearchSort sort);

        /**
         * <p>
         * The specifies the way to sort the <code>SearchTypes</code> results.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchSort.Builder} avoiding the need to
         * create one manually via {@link SearchSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchSort.Builder#build()} is called immediately and its result
         * is passed to {@link #sort(SearchSort)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link SearchSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(SearchSort)
         */
        default Builder sort(Consumer<SearchSort.Builder> sort) {
            return sort(SearchSort.builder().applyMutation(sort).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private FilterClause filters;

        private Boolean managed;

        private Integer maxResults;

        private String nextToken;

        private List<SearchInItem> searchIn = DefaultSdkAutoConstructList.getInstance();

        private String searchScope;

        private String searchText;

        private SearchSort sort;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTypesRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            filters(model.filters);
            managed(model.managed);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            searchIn(model.searchIn);
            searchScope(model.searchScope);
            searchText(model.searchText);
            sort(model.sort);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final FilterClause.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(FilterClause.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(FilterClause filters) {
            this.filters = filters;
            return this;
        }

        public final Boolean getManaged() {
            return managed;
        }

        public final void setManaged(Boolean managed) {
            this.managed = managed;
        }

        @Override
        public final Builder managed(Boolean managed) {
            this.managed = managed;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SearchInItem.Builder> getSearchIn() {
            List<SearchInItem.Builder> result = SearchInListCopier.copyToBuilder(this.searchIn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSearchIn(Collection<SearchInItem.BuilderImpl> searchIn) {
            this.searchIn = SearchInListCopier.copyFromBuilder(searchIn);
        }

        @Override
        public final Builder searchIn(Collection<SearchInItem> searchIn) {
            this.searchIn = SearchInListCopier.copy(searchIn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchIn(SearchInItem... searchIn) {
            searchIn(Arrays.asList(searchIn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchIn(Consumer<SearchInItem.Builder>... searchIn) {
            searchIn(Stream.of(searchIn).map(c -> SearchInItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSearchScope() {
            return searchScope;
        }

        public final void setSearchScope(String searchScope) {
            this.searchScope = searchScope;
        }

        @Override
        public final Builder searchScope(String searchScope) {
            this.searchScope = searchScope;
            return this;
        }

        @Override
        public final Builder searchScope(TypesSearchScope searchScope) {
            this.searchScope(searchScope == null ? null : searchScope.toString());
            return this;
        }

        public final String getSearchText() {
            return searchText;
        }

        public final void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        @Override
        public final Builder searchText(String searchText) {
            this.searchText = searchText;
            return this;
        }

        public final SearchSort.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(SearchSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(SearchSort sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchTypesRequest build() {
            return new SearchTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
