/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchUserProfilesRequest extends DataZoneRequest implements
        ToCopyableBuilder<SearchUserProfilesRequest.Builder, SearchUserProfilesRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(SearchUserProfilesRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchUserProfilesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchUserProfilesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SEARCH_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("searchText").getter(getter(SearchUserProfilesRequest::searchText)).setter(setter(Builder::searchText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchText").build()).build();

    private static final SdkField<String> USER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userType").getter(getter(SearchUserProfilesRequest::userTypeAsString)).setter(setter(Builder::userType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEARCH_TEXT_FIELD, USER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
                    put("maxResults", MAX_RESULTS_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                    put("searchText", SEARCH_TEXT_FIELD);
                    put("userType", USER_TYPE_FIELD);
                }
            });

    private final String domainIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final String searchText;

    private final String userType;

    private SearchUserProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.searchText = builder.searchText;
        this.userType = builder.userType;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which you want to search user profiles.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which you want to search user profiles.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call to <code>SearchUserProfiles</code>. When the number of
     * results to be listed is greater than the value of <code>MaxResults</code>, the response contains a
     * <code>NextToken</code> value that you can use in a subsequent call to <code>SearchUserProfiles</code> to list the
     * next set of results.
     * </p>
     * 
     * @return The maximum number of results to return in a single call to <code>SearchUserProfiles</code>. When the
     *         number of results to be listed is greater than the value of <code>MaxResults</code>, the response
     *         contains a <code>NextToken</code> value that you can use in a subsequent call to
     *         <code>SearchUserProfiles</code> to list the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you
     * explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response
     * includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
     * subsequent call to <code>SearchUserProfiles</code> to list the next set of results.
     * </p>
     * 
     * @return When the number of results is greater than the default value for the <code>MaxResults</code> parameter,
     *         or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results,
     *         the response includes a pagination token named <code>NextToken</code>. You can specify this
     *         <code>NextToken</code> value in a subsequent call to <code>SearchUserProfiles</code> to list the next set
     *         of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the text for which to search.
     * </p>
     * 
     * @return Specifies the text for which to search.
     */
    public final String searchText() {
        return searchText;
    }

    /**
     * <p>
     * Specifies the user type for the <code>SearchUserProfiles</code> action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userType} will
     * return {@link UserSearchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userTypeAsString}.
     * </p>
     * 
     * @return Specifies the user type for the <code>SearchUserProfiles</code> action.
     * @see UserSearchType
     */
    public final UserSearchType userType() {
        return UserSearchType.fromValue(userType);
    }

    /**
     * <p>
     * Specifies the user type for the <code>SearchUserProfiles</code> action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userType} will
     * return {@link UserSearchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userTypeAsString}.
     * </p>
     * 
     * @return Specifies the user type for the <code>SearchUserProfiles</code> action.
     * @see UserSearchType
     */
    public final String userTypeAsString() {
        return userType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(searchText());
        hashCode = 31 * hashCode + Objects.hashCode(userTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUserProfilesRequest)) {
            return false;
        }
        SearchUserProfilesRequest other = (SearchUserProfilesRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(searchText(), other.searchText())
                && Objects.equals(userTypeAsString(), other.userTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchUserProfilesRequest").add("DomainIdentifier", domainIdentifier())
                .add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("SearchText", searchText() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UserType", userTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "searchText":
            return Optional.ofNullable(clazz.cast(searchText()));
        case "userType":
            return Optional.ofNullable(clazz.cast(userTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchUserProfilesRequest, T> g) {
        return obj -> g.apply((SearchUserProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchUserProfilesRequest> {
        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which you want to search user profiles.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain in which you want to search user profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The maximum number of results to return in a single call to <code>SearchUserProfiles</code>. When the number
         * of results to be listed is greater than the value of <code>MaxResults</code>, the response contains a
         * <code>NextToken</code> value that you can use in a subsequent call to <code>SearchUserProfiles</code> to list
         * the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call to <code>SearchUserProfiles</code>. When the
         *        number of results to be listed is greater than the value of <code>MaxResults</code>, the response
         *        contains a <code>NextToken</code> value that you can use in a subsequent call to
         *        <code>SearchUserProfiles</code> to list the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if
         * you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the
         * response includes a pagination token named <code>NextToken</code>. You can specify this
         * <code>NextToken</code> value in a subsequent call to <code>SearchUserProfiles</code> to list the next set of
         * results.
         * </p>
         * 
         * @param nextToken
         *        When the number of results is greater than the default value for the <code>MaxResults</code>
         *        parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the
         *        number of results, the response includes a pagination token named <code>NextToken</code>. You can
         *        specify this <code>NextToken</code> value in a subsequent call to <code>SearchUserProfiles</code> to
         *        list the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the text for which to search.
         * </p>
         * 
         * @param searchText
         *        Specifies the text for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchText(String searchText);

        /**
         * <p>
         * Specifies the user type for the <code>SearchUserProfiles</code> action.
         * </p>
         * 
         * @param userType
         *        Specifies the user type for the <code>SearchUserProfiles</code> action.
         * @see UserSearchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserSearchType
         */
        Builder userType(String userType);

        /**
         * <p>
         * Specifies the user type for the <code>SearchUserProfiles</code> action.
         * </p>
         * 
         * @param userType
         *        Specifies the user type for the <code>SearchUserProfiles</code> action.
         * @see UserSearchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserSearchType
         */
        Builder userType(UserSearchType userType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private Integer maxResults;

        private String nextToken;

        private String searchText;

        private String userType;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUserProfilesRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            searchText(model.searchText);
            userType(model.userType);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSearchText() {
            return searchText;
        }

        public final void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        @Override
        public final Builder searchText(String searchText) {
            this.searchText = searchText;
            return this;
        }

        public final String getUserType() {
            return userType;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        @Override
        public final Builder userType(UserSearchType userType) {
            this.userType(userType == null ? null : userType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchUserProfilesRequest build() {
            return new SearchUserProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
