/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The single sign-on details in Amazon DataZone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SingleSignOn implements SdkPojo, Serializable, ToCopyableBuilder<SingleSignOn.Builder, SingleSignOn> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SingleSignOn::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> USER_ASSIGNMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userAssignment").getter(getter(SingleSignOn::userAssignmentAsString))
            .setter(setter(Builder::userAssignment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAssignment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            USER_ASSIGNMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("type", TYPE_FIELD);
                    put("userAssignment", USER_ASSIGNMENT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String userAssignment;

    private SingleSignOn(BuilderImpl builder) {
        this.type = builder.type;
        this.userAssignment = builder.userAssignment;
    }

    /**
     * <p>
     * The type of single sign-on in Amazon DataZone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of single sign-on in Amazon DataZone.
     * @see AuthType
     */
    public final AuthType type() {
        return AuthType.fromValue(type);
    }

    /**
     * <p>
     * The type of single sign-on in Amazon DataZone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of single sign-on in Amazon DataZone.
     * @see AuthType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The single sign-on user assignment in Amazon DataZone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userAssignment}
     * will return {@link UserAssignment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #userAssignmentAsString}.
     * </p>
     * 
     * @return The single sign-on user assignment in Amazon DataZone.
     * @see UserAssignment
     */
    public final UserAssignment userAssignment() {
        return UserAssignment.fromValue(userAssignment);
    }

    /**
     * <p>
     * The single sign-on user assignment in Amazon DataZone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userAssignment}
     * will return {@link UserAssignment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #userAssignmentAsString}.
     * </p>
     * 
     * @return The single sign-on user assignment in Amazon DataZone.
     * @see UserAssignment
     */
    public final String userAssignmentAsString() {
        return userAssignment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userAssignmentAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleSignOn)) {
            return false;
        }
        SingleSignOn other = (SingleSignOn) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(userAssignmentAsString(), other.userAssignmentAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SingleSignOn").add("Type", typeAsString()).add("UserAssignment", userAssignmentAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "userAssignment":
            return Optional.ofNullable(clazz.cast(userAssignmentAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SingleSignOn, T> g) {
        return obj -> g.apply((SingleSignOn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SingleSignOn> {
        /**
         * <p>
         * The type of single sign-on in Amazon DataZone.
         * </p>
         * 
         * @param type
         *        The type of single sign-on in Amazon DataZone.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of single sign-on in Amazon DataZone.
         * </p>
         * 
         * @param type
         *        The type of single sign-on in Amazon DataZone.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder type(AuthType type);

        /**
         * <p>
         * The single sign-on user assignment in Amazon DataZone.
         * </p>
         * 
         * @param userAssignment
         *        The single sign-on user assignment in Amazon DataZone.
         * @see UserAssignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserAssignment
         */
        Builder userAssignment(String userAssignment);

        /**
         * <p>
         * The single sign-on user assignment in Amazon DataZone.
         * </p>
         * 
         * @param userAssignment
         *        The single sign-on user assignment in Amazon DataZone.
         * @see UserAssignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserAssignment
         */
        Builder userAssignment(UserAssignment userAssignment);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String userAssignment;

        private BuilderImpl() {
        }

        private BuilderImpl(SingleSignOn model) {
            type(model.type);
            userAssignment(model.userAssignment);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AuthType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUserAssignment() {
            return userAssignment;
        }

        public final void setUserAssignment(String userAssignment) {
            this.userAssignment = userAssignment;
        }

        @Override
        public final Builder userAssignment(String userAssignment) {
            this.userAssignment = userAssignment;
            return this;
        }

        @Override
        public final Builder userAssignment(UserAssignment userAssignment) {
            this.userAssignment(userAssignment == null ? null : userAssignment.toString());
            return this;
        }

        @Override
        public SingleSignOn build() {
            return new SingleSignOn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
