/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the published asset for which the subscription grant is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscribedAssetListing implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscribedAssetListing.Builder, SubscribedAssetListing> {
    private static final SdkField<AssetScope> ASSET_SCOPE_FIELD = SdkField.<AssetScope> builder(MarshallingType.SDK_POJO)
            .memberName("assetScope").getter(getter(SubscribedAssetListing::assetScope)).setter(setter(Builder::assetScope))
            .constructor(AssetScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetScope").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(SubscribedAssetListing::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> ENTITY_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityRevision").getter(getter(SubscribedAssetListing::entityRevision))
            .setter(setter(Builder::entityRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityRevision").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(SubscribedAssetListing::entityType)).setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()).build();

    private static final SdkField<String> FORMS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("forms")
            .getter(getter(SubscribedAssetListing::forms)).setter(setter(Builder::forms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build()).build();

    private static final SdkField<List<DetailedGlossaryTerm>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<DetailedGlossaryTerm>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(SubscribedAssetListing::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetailedGlossaryTerm> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetailedGlossaryTerm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_SCOPE_FIELD,
            ENTITY_ID_FIELD, ENTITY_REVISION_FIELD, ENTITY_TYPE_FIELD, FORMS_FIELD, GLOSSARY_TERMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("assetScope", ASSET_SCOPE_FIELD);
                    put("entityId", ENTITY_ID_FIELD);
                    put("entityRevision", ENTITY_REVISION_FIELD);
                    put("entityType", ENTITY_TYPE_FIELD);
                    put("forms", FORMS_FIELD);
                    put("glossaryTerms", GLOSSARY_TERMS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final AssetScope assetScope;

    private final String entityId;

    private final String entityRevision;

    private final String entityType;

    private final String forms;

    private final List<DetailedGlossaryTerm> glossaryTerms;

    private SubscribedAssetListing(BuilderImpl builder) {
        this.assetScope = builder.assetScope;
        this.entityId = builder.entityId;
        this.entityRevision = builder.entityRevision;
        this.entityType = builder.entityType;
        this.forms = builder.forms;
        this.glossaryTerms = builder.glossaryTerms;
    }

    /**
     * <p>
     * The asset scope of the subscribed asset listing.
     * </p>
     * 
     * @return The asset scope of the subscribed asset listing.
     */
    public final AssetScope assetScope() {
        return assetScope;
    }

    /**
     * <p>
     * The identifier of the published asset for which the subscription grant is created.
     * </p>
     * 
     * @return The identifier of the published asset for which the subscription grant is created.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The revision of the published asset for which the subscription grant is created.
     * </p>
     * 
     * @return The revision of the published asset for which the subscription grant is created.
     */
    public final String entityRevision() {
        return entityRevision;
    }

    /**
     * <p>
     * The type of the published asset for which the subscription grant is created.
     * </p>
     * 
     * @return The type of the published asset for which the subscription grant is created.
     */
    public final String entityType() {
        return entityType;
    }

    /**
     * <p>
     * The forms attached to the published asset for which the subscription grant is created.
     * </p>
     * 
     * @return The forms attached to the published asset for which the subscription grant is created.
     */
    public final String forms() {
        return forms;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The glossary terms attached to the published asset for which the subscription grant is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The glossary terms attached to the published asset for which the subscription grant is created.
     */
    public final List<DetailedGlossaryTerm> glossaryTerms() {
        return glossaryTerms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetScope());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityRevision());
        hashCode = 31 * hashCode + Objects.hashCode(entityType());
        hashCode = 31 * hashCode + Objects.hashCode(forms());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedAssetListing)) {
            return false;
        }
        SubscribedAssetListing other = (SubscribedAssetListing) obj;
        return Objects.equals(assetScope(), other.assetScope()) && Objects.equals(entityId(), other.entityId())
                && Objects.equals(entityRevision(), other.entityRevision()) && Objects.equals(entityType(), other.entityType())
                && Objects.equals(forms(), other.forms()) && hasGlossaryTerms() == other.hasGlossaryTerms()
                && Objects.equals(glossaryTerms(), other.glossaryTerms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubscribedAssetListing").add("AssetScope", assetScope()).add("EntityId", entityId())
                .add("EntityRevision", entityRevision()).add("EntityType", entityType()).add("Forms", forms())
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetScope":
            return Optional.ofNullable(clazz.cast(assetScope()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "entityRevision":
            return Optional.ofNullable(clazz.cast(entityRevision()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityType()));
        case "forms":
            return Optional.ofNullable(clazz.cast(forms()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SubscribedAssetListing, T> g) {
        return obj -> g.apply((SubscribedAssetListing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscribedAssetListing> {
        /**
         * <p>
         * The asset scope of the subscribed asset listing.
         * </p>
         * 
         * @param assetScope
         *        The asset scope of the subscribed asset listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetScope(AssetScope assetScope);

        /**
         * <p>
         * The asset scope of the subscribed asset listing.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetScope.Builder} avoiding the need to
         * create one manually via {@link AssetScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetScope.Builder#build()} is called immediately and its result
         * is passed to {@link #assetScope(AssetScope)}.
         * 
         * @param assetScope
         *        a consumer that will call methods on {@link AssetScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetScope(AssetScope)
         */
        default Builder assetScope(Consumer<AssetScope.Builder> assetScope) {
            return assetScope(AssetScope.builder().applyMutation(assetScope).build());
        }

        /**
         * <p>
         * The identifier of the published asset for which the subscription grant is created.
         * </p>
         * 
         * @param entityId
         *        The identifier of the published asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The revision of the published asset for which the subscription grant is created.
         * </p>
         * 
         * @param entityRevision
         *        The revision of the published asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRevision(String entityRevision);

        /**
         * <p>
         * The type of the published asset for which the subscription grant is created.
         * </p>
         * 
         * @param entityType
         *        The type of the published asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The forms attached to the published asset for which the subscription grant is created.
         * </p>
         * 
         * @param forms
         *        The forms attached to the published asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forms(String forms);

        /**
         * <p>
         * The glossary terms attached to the published asset for which the subscription grant is created.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms attached to the published asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms);

        /**
         * <p>
         * The glossary terms attached to the published asset for which the subscription grant is created.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms attached to the published asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(DetailedGlossaryTerm... glossaryTerms);

        /**
         * <p>
         * The glossary terms attached to the published asset for which the subscription grant is created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder#build()} is called
         * immediately and its result is passed to {@link #glossaryTerms(List<DetailedGlossaryTerm>)}.
         * 
         * @param glossaryTerms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glossaryTerms(java.util.Collection<DetailedGlossaryTerm>)
         */
        Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder>... glossaryTerms);
    }

    static final class BuilderImpl implements Builder {
        private AssetScope assetScope;

        private String entityId;

        private String entityRevision;

        private String entityType;

        private String forms;

        private List<DetailedGlossaryTerm> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedAssetListing model) {
            assetScope(model.assetScope);
            entityId(model.entityId);
            entityRevision(model.entityRevision);
            entityType(model.entityType);
            forms(model.forms);
            glossaryTerms(model.glossaryTerms);
        }

        public final AssetScope.Builder getAssetScope() {
            return assetScope != null ? assetScope.toBuilder() : null;
        }

        public final void setAssetScope(AssetScope.BuilderImpl assetScope) {
            this.assetScope = assetScope != null ? assetScope.build() : null;
        }

        @Override
        public final Builder assetScope(AssetScope assetScope) {
            this.assetScope = assetScope;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityRevision() {
            return entityRevision;
        }

        public final void setEntityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
        }

        @Override
        public final Builder entityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getForms() {
            return forms;
        }

        public final void setForms(String forms) {
            this.forms = forms;
        }

        @Override
        public final Builder forms(String forms) {
            this.forms = forms;
            return this;
        }

        public final List<DetailedGlossaryTerm.Builder> getGlossaryTerms() {
            List<DetailedGlossaryTerm.Builder> result = DetailedGlossaryTermsCopier.copyToBuilder(this.glossaryTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlossaryTerms(Collection<DetailedGlossaryTerm.BuilderImpl> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copyFromBuilder(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(DetailedGlossaryTerm... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder>... glossaryTerms) {
            glossaryTerms(Stream.of(glossaryTerms).map(c -> DetailedGlossaryTerm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SubscribedAssetListing build() {
            return new SubscribedAssetListing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
