/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time series data points form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSeriesDataPointFormOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeSeriesDataPointFormOutput.Builder, TimeSeriesDataPointFormOutput> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("content")
            .getter(getter(TimeSeriesDataPointFormOutput::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> FORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("formName").getter(getter(TimeSeriesDataPointFormOutput::formName)).setter(setter(Builder::formName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(TimeSeriesDataPointFormOutput::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp").getter(getter(TimeSeriesDataPointFormOutput::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeIdentifier").getter(getter(TimeSeriesDataPointFormOutput::typeIdentifier))
            .setter(setter(Builder::typeIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeIdentifier").build()).build();

    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeRevision").getter(getter(TimeSeriesDataPointFormOutput::typeRevision))
            .setter(setter(Builder::typeRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            FORM_NAME_FIELD, ID_FIELD, TIMESTAMP_FIELD, TYPE_IDENTIFIER_FIELD, TYPE_REVISION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("content", CONTENT_FIELD);
                    put("formName", FORM_NAME_FIELD);
                    put("id", ID_FIELD);
                    put("timestamp", TIMESTAMP_FIELD);
                    put("typeIdentifier", TYPE_IDENTIFIER_FIELD);
                    put("typeRevision", TYPE_REVISION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String content;

    private final String formName;

    private final String id;

    private final Instant timestamp;

    private final String typeIdentifier;

    private final String typeRevision;

    private TimeSeriesDataPointFormOutput(BuilderImpl builder) {
        this.content = builder.content;
        this.formName = builder.formName;
        this.id = builder.id;
        this.timestamp = builder.timestamp;
        this.typeIdentifier = builder.typeIdentifier;
        this.typeRevision = builder.typeRevision;
    }

    /**
     * <p>
     * The content of the time series data points form.
     * </p>
     * 
     * @return The content of the time series data points form.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The name of the time series data points form.
     * </p>
     * 
     * @return The name of the time series data points form.
     */
    public final String formName() {
        return formName;
    }

    /**
     * <p>
     * The ID of the time series data points form.
     * </p>
     * 
     * @return The ID of the time series data points form.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The timestamp of the time series data points form.
     * </p>
     * 
     * @return The timestamp of the time series data points form.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The ID of the type of the time series data points form.
     * </p>
     * 
     * @return The ID of the type of the time series data points form.
     */
    public final String typeIdentifier() {
        return typeIdentifier;
    }

    /**
     * <p>
     * The revision type of the time series data points form.
     * </p>
     * 
     * @return The revision type of the time series data points form.
     */
    public final String typeRevision() {
        return typeRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(formName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(typeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(typeRevision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesDataPointFormOutput)) {
            return false;
        }
        TimeSeriesDataPointFormOutput other = (TimeSeriesDataPointFormOutput) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(formName(), other.formName())
                && Objects.equals(id(), other.id()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(typeIdentifier(), other.typeIdentifier())
                && Objects.equals(typeRevision(), other.typeRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSeriesDataPointFormOutput").add("Content", content()).add("FormName", formName())
                .add("Id", id()).add("Timestamp", timestamp()).add("TypeIdentifier", typeIdentifier())
                .add("TypeRevision", typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "formName":
            return Optional.ofNullable(clazz.cast(formName()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "typeIdentifier":
            return Optional.ofNullable(clazz.cast(typeIdentifier()));
        case "typeRevision":
            return Optional.ofNullable(clazz.cast(typeRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesDataPointFormOutput, T> g) {
        return obj -> g.apply((TimeSeriesDataPointFormOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSeriesDataPointFormOutput> {
        /**
         * <p>
         * The content of the time series data points form.
         * </p>
         * 
         * @param content
         *        The content of the time series data points form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The name of the time series data points form.
         * </p>
         * 
         * @param formName
         *        The name of the time series data points form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formName(String formName);

        /**
         * <p>
         * The ID of the time series data points form.
         * </p>
         * 
         * @param id
         *        The ID of the time series data points form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The timestamp of the time series data points form.
         * </p>
         * 
         * @param timestamp
         *        The timestamp of the time series data points form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The ID of the type of the time series data points form.
         * </p>
         * 
         * @param typeIdentifier
         *        The ID of the type of the time series data points form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeIdentifier(String typeIdentifier);

        /**
         * <p>
         * The revision type of the time series data points form.
         * </p>
         * 
         * @param typeRevision
         *        The revision type of the time series data points form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeRevision(String typeRevision);
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private String formName;

        private String id;

        private Instant timestamp;

        private String typeIdentifier;

        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesDataPointFormOutput model) {
            content(model.content);
            formName(model.formName);
            id(model.id);
            timestamp(model.timestamp);
            typeIdentifier(model.typeIdentifier);
            typeRevision(model.typeRevision);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getFormName() {
            return formName;
        }

        public final void setFormName(String formName) {
            this.formName = formName;
        }

        @Override
        public final Builder formName(String formName) {
            this.formName = formName;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getTypeIdentifier() {
            return typeIdentifier;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        public final String getTypeRevision() {
            return typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        @Override
        public TimeSeriesDataPointFormOutput build() {
            return new TimeSeriesDataPointFormOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
