/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainRequest extends DataZoneRequest implements
        ToCopyableBuilder<UpdateDomainRequest.Builder, UpdateDomainRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateDomainRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateDomainRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainExecutionRole").getter(getter(UpdateDomainRequest::domainExecutionRole))
            .setter(setter(Builder::domainExecutionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainExecutionRole").build())
            .build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateDomainRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateDomainRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRole").getter(getter(UpdateDomainRequest::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();

    private static final SdkField<SingleSignOn> SINGLE_SIGN_ON_FIELD = SdkField.<SingleSignOn> builder(MarshallingType.SDK_POJO)
            .memberName("singleSignOn").getter(getter(UpdateDomainRequest::singleSignOn)).setter(setter(Builder::singleSignOn))
            .constructor(SingleSignOn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("singleSignOn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, DOMAIN_EXECUTION_ROLE_FIELD, IDENTIFIER_FIELD, NAME_FIELD, SERVICE_ROLE_FIELD,
            SINGLE_SIGN_ON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("clientToken", CLIENT_TOKEN_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("domainExecutionRole", DOMAIN_EXECUTION_ROLE_FIELD);
                    put("identifier", IDENTIFIER_FIELD);
                    put("name", NAME_FIELD);
                    put("serviceRole", SERVICE_ROLE_FIELD);
                    put("singleSignOn", SINGLE_SIGN_ON_FIELD);
                }
            });

    private final String clientToken;

    private final String description;

    private final String domainExecutionRole;

    private final String identifier;

    private final String name;

    private final String serviceRole;

    private final SingleSignOn singleSignOn;

    private UpdateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.domainExecutionRole = builder.domainExecutionRole;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.serviceRole = builder.serviceRole;
        this.singleSignOn = builder.singleSignOn;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description to be updated as part of the <code>UpdateDomain</code> action.
     * </p>
     * 
     * @return The description to be updated as part of the <code>UpdateDomain</code> action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The domain execution role to be updated as part of the <code>UpdateDomain</code> action.
     * </p>
     * 
     * @return The domain execution role to be updated as part of the <code>UpdateDomain</code> action.
     */
    public final String domainExecutionRole() {
        return domainExecutionRole;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services domain that is to be updated.
     * </p>
     * 
     * @return The ID of the Amazon Web Services domain that is to be updated.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The name to be updated as part of the <code>UpdateDomain</code> action.
     * </p>
     * 
     * @return The name to be updated as part of the <code>UpdateDomain</code> action.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The service role of the domain.
     * </p>
     * 
     * @return The service role of the domain.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The single sign-on option to be updated as part of the <code>UpdateDomain</code> action.
     * </p>
     * 
     * @return The single sign-on option to be updated as part of the <code>UpdateDomain</code> action.
     */
    public final SingleSignOn singleSignOn() {
        return singleSignOn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainExecutionRole());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(singleSignOn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainRequest)) {
            return false;
        }
        UpdateDomainRequest other = (UpdateDomainRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(domainExecutionRole(), other.domainExecutionRole())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(name(), other.name())
                && Objects.equals(serviceRole(), other.serviceRole()) && Objects.equals(singleSignOn(), other.singleSignOn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainRequest").add("ClientToken", clientToken()).add("Description", description())
                .add("DomainExecutionRole", domainExecutionRole()).add("Identifier", identifier()).add("Name", name())
                .add("ServiceRole", serviceRole()).add("SingleSignOn", singleSignOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainExecutionRole":
            return Optional.ofNullable(clazz.cast(domainExecutionRole()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "serviceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "singleSignOn":
            return Optional.ofNullable(clazz.cast(singleSignOn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainRequest, T> g) {
        return obj -> g.apply((UpdateDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description to be updated as part of the <code>UpdateDomain</code> action.
         * </p>
         * 
         * @param description
         *        The description to be updated as part of the <code>UpdateDomain</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The domain execution role to be updated as part of the <code>UpdateDomain</code> action.
         * </p>
         * 
         * @param domainExecutionRole
         *        The domain execution role to be updated as part of the <code>UpdateDomain</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainExecutionRole(String domainExecutionRole);

        /**
         * <p>
         * The ID of the Amazon Web Services domain that is to be updated.
         * </p>
         * 
         * @param identifier
         *        The ID of the Amazon Web Services domain that is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The name to be updated as part of the <code>UpdateDomain</code> action.
         * </p>
         * 
         * @param name
         *        The name to be updated as part of the <code>UpdateDomain</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The service role of the domain.
         * </p>
         * 
         * @param serviceRole
         *        The service role of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The single sign-on option to be updated as part of the <code>UpdateDomain</code> action.
         * </p>
         * 
         * @param singleSignOn
         *        The single sign-on option to be updated as part of the <code>UpdateDomain</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSignOn(SingleSignOn singleSignOn);

        /**
         * <p>
         * The single sign-on option to be updated as part of the <code>UpdateDomain</code> action.
         * </p>
         * This is a convenience method that creates an instance of the {@link SingleSignOn.Builder} avoiding the need
         * to create one manually via {@link SingleSignOn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingleSignOn.Builder#build()} is called immediately and its
         * result is passed to {@link #singleSignOn(SingleSignOn)}.
         * 
         * @param singleSignOn
         *        a consumer that will call methods on {@link SingleSignOn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleSignOn(SingleSignOn)
         */
        default Builder singleSignOn(Consumer<SingleSignOn.Builder> singleSignOn) {
            return singleSignOn(SingleSignOn.builder().applyMutation(singleSignOn).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private String domainExecutionRole;

        private String identifier;

        private String name;

        private String serviceRole;

        private SingleSignOn singleSignOn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            domainExecutionRole(model.domainExecutionRole);
            identifier(model.identifier);
            name(model.name);
            serviceRole(model.serviceRole);
            singleSignOn(model.singleSignOn);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainExecutionRole() {
            return domainExecutionRole;
        }

        public final void setDomainExecutionRole(String domainExecutionRole) {
            this.domainExecutionRole = domainExecutionRole;
        }

        @Override
        public final Builder domainExecutionRole(String domainExecutionRole) {
            this.domainExecutionRole = domainExecutionRole;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final SingleSignOn.Builder getSingleSignOn() {
            return singleSignOn != null ? singleSignOn.toBuilder() : null;
        }

        public final void setSingleSignOn(SingleSignOn.BuilderImpl singleSignOn) {
            this.singleSignOn = singleSignOn != null ? singleSignOn.build() : null;
        }

        @Override
        public final Builder singleSignOn(SingleSignOn singleSignOn) {
            this.singleSignOn = singleSignOn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainRequest build() {
            return new UpdateDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
