/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRuleRequest extends DataZoneRequest implements
        ToCopyableBuilder<UpdateRuleRequest.Builder, UpdateRuleRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateRuleRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<RuleDetail> DETAIL_FIELD = SdkField.<RuleDetail> builder(MarshallingType.SDK_POJO)
            .memberName("detail").getter(getter(UpdateRuleRequest::detail)).setter(setter(Builder::detail))
            .constructor(RuleDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detail").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(UpdateRuleRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateRuleRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<Boolean> INCLUDE_CHILD_DOMAIN_UNITS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeChildDomainUnits").getter(getter(UpdateRuleRequest::includeChildDomainUnits))
            .setter(setter(Builder::includeChildDomainUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeChildDomainUnits").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<RuleScope> SCOPE_FIELD = SdkField.<RuleScope> builder(MarshallingType.SDK_POJO)
            .memberName("scope").getter(getter(UpdateRuleRequest::scope)).setter(setter(Builder::scope))
            .constructor(RuleScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DETAIL_FIELD, DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD, INCLUDE_CHILD_DOMAIN_UNITS_FIELD, NAME_FIELD, SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("description", DESCRIPTION_FIELD);
                    put("detail", DETAIL_FIELD);
                    put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
                    put("identifier", IDENTIFIER_FIELD);
                    put("includeChildDomainUnits", INCLUDE_CHILD_DOMAIN_UNITS_FIELD);
                    put("name", NAME_FIELD);
                    put("scope", SCOPE_FIELD);
                }
            });

    private final String description;

    private final RuleDetail detail;

    private final String domainIdentifier;

    private final String identifier;

    private final Boolean includeChildDomainUnits;

    private final String name;

    private final RuleScope scope;

    private UpdateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.detail = builder.detail;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.includeChildDomainUnits = builder.includeChildDomainUnits;
        this.name = builder.name;
        this.scope = builder.scope;
    }

    /**
     * <p>
     * The description of the rule.
     * </p>
     * 
     * @return The description of the rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The detail of the rule.
     * </p>
     * 
     * @return The detail of the rule.
     */
    public final RuleDetail detail() {
        return detail;
    }

    /**
     * <p>
     * The ID of the domain in which a rule is to be updated.
     * </p>
     * 
     * @return The ID of the domain in which a rule is to be updated.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the rule that is to be updated
     * </p>
     * 
     * @return The ID of the rule that is to be updated
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Specifies whether to update this rule in the child domain units.
     * </p>
     * 
     * @return Specifies whether to update this rule in the child domain units.
     */
    public final Boolean includeChildDomainUnits() {
        return includeChildDomainUnits;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The scrope of the rule.
     * </p>
     * 
     * @return The scrope of the rule.
     */
    public final RuleScope scope() {
        return scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(detail());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(includeChildDomainUnits());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleRequest)) {
            return false;
        }
        UpdateRuleRequest other = (UpdateRuleRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(detail(), other.detail())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(identifier(), other.identifier())
                && Objects.equals(includeChildDomainUnits(), other.includeChildDomainUnits())
                && Objects.equals(name(), other.name()) && Objects.equals(scope(), other.scope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRuleRequest")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Detail", detail())
                .add("DomainIdentifier", domainIdentifier()).add("Identifier", identifier())
                .add("IncludeChildDomainUnits", includeChildDomainUnits())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Scope", scope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "detail":
            return Optional.ofNullable(clazz.cast(detail()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "includeChildDomainUnits":
            return Optional.ofNullable(clazz.cast(includeChildDomainUnits()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRuleRequest, T> g) {
        return obj -> g.apply((UpdateRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRuleRequest> {
        /**
         * <p>
         * The description of the rule.
         * </p>
         * 
         * @param description
         *        The description of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The detail of the rule.
         * </p>
         * 
         * @param detail
         *        The detail of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detail(RuleDetail detail);

        /**
         * <p>
         * The detail of the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleDetail.Builder} avoiding the need to
         * create one manually via {@link RuleDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #detail(RuleDetail)}.
         * 
         * @param detail
         *        a consumer that will call methods on {@link RuleDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detail(RuleDetail)
         */
        default Builder detail(Consumer<RuleDetail.Builder> detail) {
            return detail(RuleDetail.builder().applyMutation(detail).build());
        }

        /**
         * <p>
         * The ID of the domain in which a rule is to be updated.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain in which a rule is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the rule that is to be updated
         * </p>
         * 
         * @param identifier
         *        The ID of the rule that is to be updated
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Specifies whether to update this rule in the child domain units.
         * </p>
         * 
         * @param includeChildDomainUnits
         *        Specifies whether to update this rule in the child domain units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeChildDomainUnits(Boolean includeChildDomainUnits);

        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param name
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The scrope of the rule.
         * </p>
         * 
         * @param scope
         *        The scrope of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(RuleScope scope);

        /**
         * <p>
         * The scrope of the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleScope.Builder} avoiding the need to
         * create one manually via {@link RuleScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleScope.Builder#build()} is called immediately and its result
         * is passed to {@link #scope(RuleScope)}.
         * 
         * @param scope
         *        a consumer that will call methods on {@link RuleScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scope(RuleScope)
         */
        default Builder scope(Consumer<RuleScope.Builder> scope) {
            return scope(RuleScope.builder().applyMutation(scope).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String description;

        private RuleDetail detail;

        private String domainIdentifier;

        private String identifier;

        private Boolean includeChildDomainUnits;

        private String name;

        private RuleScope scope;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuleRequest model) {
            super(model);
            description(model.description);
            detail(model.detail);
            domainIdentifier(model.domainIdentifier);
            identifier(model.identifier);
            includeChildDomainUnits(model.includeChildDomainUnits);
            name(model.name);
            scope(model.scope);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RuleDetail.Builder getDetail() {
            return detail != null ? detail.toBuilder() : null;
        }

        public final void setDetail(RuleDetail.BuilderImpl detail) {
            this.detail = detail != null ? detail.build() : null;
        }

        @Override
        public final Builder detail(RuleDetail detail) {
            this.detail = detail;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Boolean getIncludeChildDomainUnits() {
            return includeChildDomainUnits;
        }

        public final void setIncludeChildDomainUnits(Boolean includeChildDomainUnits) {
            this.includeChildDomainUnits = includeChildDomainUnits;
        }

        @Override
        public final Builder includeChildDomainUnits(Boolean includeChildDomainUnits) {
            this.includeChildDomainUnits = includeChildDomainUnits;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RuleScope.Builder getScope() {
            return scope != null ? scope.toBuilder() : null;
        }

        public final void setScope(RuleScope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(RuleScope scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRuleRequest build() {
            return new UpdateRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
