/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSubscriptionGrantStatusRequest extends DataZoneRequest implements
        ToCopyableBuilder<UpdateSubscriptionGrantStatusRequest.Builder, UpdateSubscriptionGrantStatusRequest> {
    private static final SdkField<String> ASSET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetIdentifier").getter(getter(UpdateSubscriptionGrantStatusRequest::assetIdentifier))
            .setter(setter(Builder::assetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetIdentifier").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(UpdateSubscriptionGrantStatusRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<FailureCause> FAILURE_CAUSE_FIELD = SdkField.<FailureCause> builder(MarshallingType.SDK_POJO)
            .memberName("failureCause").getter(getter(UpdateSubscriptionGrantStatusRequest::failureCause))
            .setter(setter(Builder::failureCause)).constructor(FailureCause::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCause").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateSubscriptionGrantStatusRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateSubscriptionGrantStatusRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetName").getter(getter(UpdateSubscriptionGrantStatusRequest::targetName))
            .setter(setter(Builder::targetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_IDENTIFIER_FIELD,
            DOMAIN_IDENTIFIER_FIELD, FAILURE_CAUSE_FIELD, IDENTIFIER_FIELD, STATUS_FIELD, TARGET_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("assetIdentifier", ASSET_IDENTIFIER_FIELD);
                    put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
                    put("failureCause", FAILURE_CAUSE_FIELD);
                    put("identifier", IDENTIFIER_FIELD);
                    put("status", STATUS_FIELD);
                    put("targetName", TARGET_NAME_FIELD);
                }
            });

    private final String assetIdentifier;

    private final String domainIdentifier;

    private final FailureCause failureCause;

    private final String identifier;

    private final String status;

    private final String targetName;

    private UpdateSubscriptionGrantStatusRequest(BuilderImpl builder) {
        super(builder);
        this.assetIdentifier = builder.assetIdentifier;
        this.domainIdentifier = builder.domainIdentifier;
        this.failureCause = builder.failureCause;
        this.identifier = builder.identifier;
        this.status = builder.status;
        this.targetName = builder.targetName;
    }

    /**
     * <p>
     * The identifier of the asset the subscription grant status of which is to be updated.
     * </p>
     * 
     * @return The identifier of the asset the subscription grant status of which is to be updated.
     */
    public final String assetIdentifier() {
        return assetIdentifier;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which a subscription grant status is to be updated.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which a subscription grant status is to be updated.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * Specifies the error message that is returned if the operation cannot be successfully completed.
     * </p>
     * 
     * @return Specifies the error message that is returned if the operation cannot be successfully completed.
     */
    public final FailureCause failureCause() {
        return failureCause;
    }

    /**
     * <p>
     * The identifier of the subscription grant the status of which is to be updated.
     * </p>
     * 
     * @return The identifier of the subscription grant the status of which is to be updated.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The status to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SubscriptionGrantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.
     * @see SubscriptionGrantStatus
     */
    public final SubscriptionGrantStatus status() {
        return SubscriptionGrantStatus.fromValue(status);
    }

    /**
     * <p>
     * The status to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SubscriptionGrantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.
     * @see SubscriptionGrantStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The target name to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.
     * </p>
     * 
     * @return The target name to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.
     */
    public final String targetName() {
        return targetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(failureCause());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubscriptionGrantStatusRequest)) {
            return false;
        }
        UpdateSubscriptionGrantStatusRequest other = (UpdateSubscriptionGrantStatusRequest) obj;
        return Objects.equals(assetIdentifier(), other.assetIdentifier())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(failureCause(), other.failureCause()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(targetName(), other.targetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSubscriptionGrantStatusRequest").add("AssetIdentifier", assetIdentifier())
                .add("DomainIdentifier", domainIdentifier()).add("FailureCause", failureCause()).add("Identifier", identifier())
                .add("Status", statusAsString()).add("TargetName", targetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetIdentifier":
            return Optional.ofNullable(clazz.cast(assetIdentifier()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "failureCause":
            return Optional.ofNullable(clazz.cast(failureCause()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "targetName":
            return Optional.ofNullable(clazz.cast(targetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSubscriptionGrantStatusRequest, T> g) {
        return obj -> g.apply((UpdateSubscriptionGrantStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSubscriptionGrantStatusRequest> {
        /**
         * <p>
         * The identifier of the asset the subscription grant status of which is to be updated.
         * </p>
         * 
         * @param assetIdentifier
         *        The identifier of the asset the subscription grant status of which is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetIdentifier(String assetIdentifier);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which a subscription grant status is to be updated.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain in which a subscription grant status is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * 
         * @param failureCause
         *        Specifies the error message that is returned if the operation cannot be successfully completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCause(FailureCause failureCause);

        /**
         * <p>
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * This is a convenience method that creates an instance of the {@link FailureCause.Builder} avoiding the need
         * to create one manually via {@link FailureCause#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailureCause.Builder#build()} is called immediately and its
         * result is passed to {@link #failureCause(FailureCause)}.
         * 
         * @param failureCause
         *        a consumer that will call methods on {@link FailureCause.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureCause(FailureCause)
         */
        default Builder failureCause(Consumer<FailureCause.Builder> failureCause) {
            return failureCause(FailureCause.builder().applyMutation(failureCause).build());
        }

        /**
         * <p>
         * The identifier of the subscription grant the status of which is to be updated.
         * </p>
         * 
         * @param identifier
         *        The identifier of the subscription grant the status of which is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The status to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.
         * </p>
         * 
         * @param status
         *        The status to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.
         * @see SubscriptionGrantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionGrantStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.
         * </p>
         * 
         * @param status
         *        The status to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.
         * @see SubscriptionGrantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionGrantStatus
         */
        Builder status(SubscriptionGrantStatus status);

        /**
         * <p>
         * The target name to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.
         * </p>
         * 
         * @param targetName
         *        The target name to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetName(String targetName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String assetIdentifier;

        private String domainIdentifier;

        private FailureCause failureCause;

        private String identifier;

        private String status;

        private String targetName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubscriptionGrantStatusRequest model) {
            super(model);
            assetIdentifier(model.assetIdentifier);
            domainIdentifier(model.domainIdentifier);
            failureCause(model.failureCause);
            identifier(model.identifier);
            status(model.status);
            targetName(model.targetName);
        }

        public final String getAssetIdentifier() {
            return assetIdentifier;
        }

        public final void setAssetIdentifier(String assetIdentifier) {
            this.assetIdentifier = assetIdentifier;
        }

        @Override
        public final Builder assetIdentifier(String assetIdentifier) {
            this.assetIdentifier = assetIdentifier;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final FailureCause.Builder getFailureCause() {
            return failureCause != null ? failureCause.toBuilder() : null;
        }

        public final void setFailureCause(FailureCause.BuilderImpl failureCause) {
            this.failureCause = failureCause != null ? failureCause.build() : null;
        }

        @Override
        public final Builder failureCause(FailureCause failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionGrantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetName() {
            return targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSubscriptionGrantStatusRequest build() {
            return new UpdateSubscriptionGrantStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
