/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserProfileRequest extends DataZoneRequest implements
        ToCopyableBuilder<UpdateUserProfileRequest.Builder, UpdateUserProfileRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(UpdateUserProfileRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateUserProfileRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(UpdateUserProfileRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> USER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userIdentifier").getter(getter(UpdateUserProfileRequest::userIdentifier))
            .setter(setter(Builder::userIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("userIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            STATUS_FIELD, TYPE_FIELD, USER_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
                    put("status", STATUS_FIELD);
                    put("type", TYPE_FIELD);
                    put("userIdentifier", USER_IDENTIFIER_FIELD);
                }
            });

    private final String domainIdentifier;

    private final String status;

    private final String type;

    private final String userIdentifier;

    private UpdateUserProfileRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.status = builder.status;
        this.type = builder.type;
        this.userIdentifier = builder.userIdentifier;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which a user profile is updated.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which a user profile is updated.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The status of the user profile that are to be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the user profile that are to be updated.
     * @see UserProfileStatus
     */
    public final UserProfileStatus status() {
        return UserProfileStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the user profile that are to be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the user profile that are to be updated.
     * @see UserProfileStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of the user profile that are to be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the user profile that are to be updated.
     * @see UserProfileType
     */
    public final UserProfileType type() {
        return UserProfileType.fromValue(type);
    }

    /**
     * <p>
     * The type of the user profile that are to be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the user profile that are to be updated.
     * @see UserProfileType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The identifier of the user whose user profile is to be updated.
     * </p>
     * 
     * @return The identifier of the user whose user profile is to be updated.
     */
    public final String userIdentifier() {
        return userIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserProfileRequest)) {
            return false;
        }
        UpdateUserProfileRequest other = (UpdateUserProfileRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(userIdentifier(), other.userIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserProfileRequest").add("DomainIdentifier", domainIdentifier())
                .add("Status", statusAsString()).add("Type", typeAsString()).add("UserIdentifier", userIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "userIdentifier":
            return Optional.ofNullable(clazz.cast(userIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserProfileRequest, T> g) {
        return obj -> g.apply((UpdateUserProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserProfileRequest> {
        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which a user profile is updated.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain in which a user profile is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The status of the user profile that are to be updated.
         * </p>
         * 
         * @param status
         *        The status of the user profile that are to be updated.
         * @see UserProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserProfileStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the user profile that are to be updated.
         * </p>
         * 
         * @param status
         *        The status of the user profile that are to be updated.
         * @see UserProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserProfileStatus
         */
        Builder status(UserProfileStatus status);

        /**
         * <p>
         * The type of the user profile that are to be updated.
         * </p>
         * 
         * @param type
         *        The type of the user profile that are to be updated.
         * @see UserProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserProfileType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the user profile that are to be updated.
         * </p>
         * 
         * @param type
         *        The type of the user profile that are to be updated.
         * @see UserProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserProfileType
         */
        Builder type(UserProfileType type);

        /**
         * <p>
         * The identifier of the user whose user profile is to be updated.
         * </p>
         * 
         * @param userIdentifier
         *        The identifier of the user whose user profile is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdentifier(String userIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private String status;

        private String type;

        private String userIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserProfileRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            status(model.status);
            type(model.type);
            userIdentifier(model.userIdentifier);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserProfileType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUserIdentifier() {
            return userIdentifier;
        }

        public final void setUserIdentifier(String userIdentifier) {
            this.userIdentifier = userIdentifier;
        }

        @Override
        public final Builder userIdentifier(String userIdentifier) {
            this.userIdentifier = userIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserProfileRequest build() {
            return new UpdateUserProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
