/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.datazone.model.AcceptPredictionsRequest;
import software.amazon.awssdk.services.datazone.model.AcceptPredictionsResponse;
import software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.AccessDeniedException;
import software.amazon.awssdk.services.datazone.model.AddEntityOwnerRequest;
import software.amazon.awssdk.services.datazone.model.AddEntityOwnerResponse;
import software.amazon.awssdk.services.datazone.model.AddPolicyGrantRequest;
import software.amazon.awssdk.services.datazone.model.AddPolicyGrantResponse;
import software.amazon.awssdk.services.datazone.model.AssociateEnvironmentRoleRequest;
import software.amazon.awssdk.services.datazone.model.AssociateEnvironmentRoleResponse;
import software.amazon.awssdk.services.datazone.model.CancelMetadataGenerationRunRequest;
import software.amazon.awssdk.services.datazone.model.CancelMetadataGenerationRunResponse;
import software.amazon.awssdk.services.datazone.model.CancelSubscriptionRequest;
import software.amazon.awssdk.services.datazone.model.CancelSubscriptionResponse;
import software.amazon.awssdk.services.datazone.model.ConflictException;
import software.amazon.awssdk.services.datazone.model.CreateAssetFilterRequest;
import software.amazon.awssdk.services.datazone.model.CreateAssetFilterResponse;
import software.amazon.awssdk.services.datazone.model.CreateAssetRequest;
import software.amazon.awssdk.services.datazone.model.CreateAssetResponse;
import software.amazon.awssdk.services.datazone.model.CreateAssetRevisionRequest;
import software.amazon.awssdk.services.datazone.model.CreateAssetRevisionResponse;
import software.amazon.awssdk.services.datazone.model.CreateAssetTypeRequest;
import software.amazon.awssdk.services.datazone.model.CreateAssetTypeResponse;
import software.amazon.awssdk.services.datazone.model.CreateConnectionRequest;
import software.amazon.awssdk.services.datazone.model.CreateConnectionResponse;
import software.amazon.awssdk.services.datazone.model.CreateDataProductRequest;
import software.amazon.awssdk.services.datazone.model.CreateDataProductResponse;
import software.amazon.awssdk.services.datazone.model.CreateDataProductRevisionRequest;
import software.amazon.awssdk.services.datazone.model.CreateDataProductRevisionResponse;
import software.amazon.awssdk.services.datazone.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.datazone.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.datazone.model.CreateDomainRequest;
import software.amazon.awssdk.services.datazone.model.CreateDomainResponse;
import software.amazon.awssdk.services.datazone.model.CreateDomainUnitRequest;
import software.amazon.awssdk.services.datazone.model.CreateDomainUnitResponse;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentActionRequest;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentActionResponse;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileRequest;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileResponse;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.datazone.model.CreateFormTypeRequest;
import software.amazon.awssdk.services.datazone.model.CreateFormTypeResponse;
import software.amazon.awssdk.services.datazone.model.CreateGlossaryRequest;
import software.amazon.awssdk.services.datazone.model.CreateGlossaryResponse;
import software.amazon.awssdk.services.datazone.model.CreateGlossaryTermRequest;
import software.amazon.awssdk.services.datazone.model.CreateGlossaryTermResponse;
import software.amazon.awssdk.services.datazone.model.CreateGroupProfileRequest;
import software.amazon.awssdk.services.datazone.model.CreateGroupProfileResponse;
import software.amazon.awssdk.services.datazone.model.CreateListingChangeSetRequest;
import software.amazon.awssdk.services.datazone.model.CreateListingChangeSetResponse;
import software.amazon.awssdk.services.datazone.model.CreateProjectMembershipRequest;
import software.amazon.awssdk.services.datazone.model.CreateProjectMembershipResponse;
import software.amazon.awssdk.services.datazone.model.CreateProjectProfileRequest;
import software.amazon.awssdk.services.datazone.model.CreateProjectProfileResponse;
import software.amazon.awssdk.services.datazone.model.CreateProjectRequest;
import software.amazon.awssdk.services.datazone.model.CreateProjectResponse;
import software.amazon.awssdk.services.datazone.model.CreateRuleRequest;
import software.amazon.awssdk.services.datazone.model.CreateRuleResponse;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantRequest;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantResponse;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetRequest;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetResponse;
import software.amazon.awssdk.services.datazone.model.CreateUserProfileRequest;
import software.amazon.awssdk.services.datazone.model.CreateUserProfileResponse;
import software.amazon.awssdk.services.datazone.model.DataZoneException;
import software.amazon.awssdk.services.datazone.model.DeleteAssetFilterRequest;
import software.amazon.awssdk.services.datazone.model.DeleteAssetFilterResponse;
import software.amazon.awssdk.services.datazone.model.DeleteAssetRequest;
import software.amazon.awssdk.services.datazone.model.DeleteAssetResponse;
import software.amazon.awssdk.services.datazone.model.DeleteAssetTypeRequest;
import software.amazon.awssdk.services.datazone.model.DeleteAssetTypeResponse;
import software.amazon.awssdk.services.datazone.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.datazone.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.datazone.model.DeleteDataProductRequest;
import software.amazon.awssdk.services.datazone.model.DeleteDataProductResponse;
import software.amazon.awssdk.services.datazone.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.datazone.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.datazone.model.DeleteDomainRequest;
import software.amazon.awssdk.services.datazone.model.DeleteDomainResponse;
import software.amazon.awssdk.services.datazone.model.DeleteDomainUnitRequest;
import software.amazon.awssdk.services.datazone.model.DeleteDomainUnitResponse;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentActionRequest;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentActionResponse;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationResponse;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentProfileRequest;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentProfileResponse;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentResponse;
import software.amazon.awssdk.services.datazone.model.DeleteFormTypeRequest;
import software.amazon.awssdk.services.datazone.model.DeleteFormTypeResponse;
import software.amazon.awssdk.services.datazone.model.DeleteGlossaryRequest;
import software.amazon.awssdk.services.datazone.model.DeleteGlossaryResponse;
import software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermRequest;
import software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermResponse;
import software.amazon.awssdk.services.datazone.model.DeleteListingRequest;
import software.amazon.awssdk.services.datazone.model.DeleteListingResponse;
import software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipRequest;
import software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipResponse;
import software.amazon.awssdk.services.datazone.model.DeleteProjectProfileRequest;
import software.amazon.awssdk.services.datazone.model.DeleteProjectProfileResponse;
import software.amazon.awssdk.services.datazone.model.DeleteProjectRequest;
import software.amazon.awssdk.services.datazone.model.DeleteProjectResponse;
import software.amazon.awssdk.services.datazone.model.DeleteRuleRequest;
import software.amazon.awssdk.services.datazone.model.DeleteRuleResponse;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionGrantRequest;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionGrantResponse;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionTargetRequest;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionTargetResponse;
import software.amazon.awssdk.services.datazone.model.DeleteTimeSeriesDataPointsRequest;
import software.amazon.awssdk.services.datazone.model.DeleteTimeSeriesDataPointsResponse;
import software.amazon.awssdk.services.datazone.model.DisassociateEnvironmentRoleRequest;
import software.amazon.awssdk.services.datazone.model.DisassociateEnvironmentRoleResponse;
import software.amazon.awssdk.services.datazone.model.GetAssetFilterRequest;
import software.amazon.awssdk.services.datazone.model.GetAssetFilterResponse;
import software.amazon.awssdk.services.datazone.model.GetAssetRequest;
import software.amazon.awssdk.services.datazone.model.GetAssetResponse;
import software.amazon.awssdk.services.datazone.model.GetAssetTypeRequest;
import software.amazon.awssdk.services.datazone.model.GetAssetTypeResponse;
import software.amazon.awssdk.services.datazone.model.GetConnectionRequest;
import software.amazon.awssdk.services.datazone.model.GetConnectionResponse;
import software.amazon.awssdk.services.datazone.model.GetDataProductRequest;
import software.amazon.awssdk.services.datazone.model.GetDataProductResponse;
import software.amazon.awssdk.services.datazone.model.GetDataSourceRequest;
import software.amazon.awssdk.services.datazone.model.GetDataSourceResponse;
import software.amazon.awssdk.services.datazone.model.GetDataSourceRunRequest;
import software.amazon.awssdk.services.datazone.model.GetDataSourceRunResponse;
import software.amazon.awssdk.services.datazone.model.GetDomainRequest;
import software.amazon.awssdk.services.datazone.model.GetDomainResponse;
import software.amazon.awssdk.services.datazone.model.GetDomainUnitRequest;
import software.amazon.awssdk.services.datazone.model.GetDomainUnitResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentActionRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentActionResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintConfigurationRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintConfigurationResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentCredentialsRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentCredentialsResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.datazone.model.GetFormTypeRequest;
import software.amazon.awssdk.services.datazone.model.GetFormTypeResponse;
import software.amazon.awssdk.services.datazone.model.GetGlossaryRequest;
import software.amazon.awssdk.services.datazone.model.GetGlossaryResponse;
import software.amazon.awssdk.services.datazone.model.GetGlossaryTermRequest;
import software.amazon.awssdk.services.datazone.model.GetGlossaryTermResponse;
import software.amazon.awssdk.services.datazone.model.GetGroupProfileRequest;
import software.amazon.awssdk.services.datazone.model.GetGroupProfileResponse;
import software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlRequest;
import software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlResponse;
import software.amazon.awssdk.services.datazone.model.GetJobRunRequest;
import software.amazon.awssdk.services.datazone.model.GetJobRunResponse;
import software.amazon.awssdk.services.datazone.model.GetLineageEventRequest;
import software.amazon.awssdk.services.datazone.model.GetLineageEventResponse;
import software.amazon.awssdk.services.datazone.model.GetLineageNodeRequest;
import software.amazon.awssdk.services.datazone.model.GetLineageNodeResponse;
import software.amazon.awssdk.services.datazone.model.GetListingRequest;
import software.amazon.awssdk.services.datazone.model.GetListingResponse;
import software.amazon.awssdk.services.datazone.model.GetMetadataGenerationRunRequest;
import software.amazon.awssdk.services.datazone.model.GetMetadataGenerationRunResponse;
import software.amazon.awssdk.services.datazone.model.GetProjectProfileRequest;
import software.amazon.awssdk.services.datazone.model.GetProjectProfileResponse;
import software.amazon.awssdk.services.datazone.model.GetProjectRequest;
import software.amazon.awssdk.services.datazone.model.GetProjectResponse;
import software.amazon.awssdk.services.datazone.model.GetRuleRequest;
import software.amazon.awssdk.services.datazone.model.GetRuleResponse;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantRequest;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantResponse;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionRequest;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsRequest;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsResponse;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionResponse;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetRequest;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetResponse;
import software.amazon.awssdk.services.datazone.model.GetTimeSeriesDataPointRequest;
import software.amazon.awssdk.services.datazone.model.GetTimeSeriesDataPointResponse;
import software.amazon.awssdk.services.datazone.model.GetUserProfileRequest;
import software.amazon.awssdk.services.datazone.model.GetUserProfileResponse;
import software.amazon.awssdk.services.datazone.model.InternalServerException;
import software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest;
import software.amazon.awssdk.services.datazone.model.ListAssetFiltersResponse;
import software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest;
import software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse;
import software.amazon.awssdk.services.datazone.model.ListConnectionsRequest;
import software.amazon.awssdk.services.datazone.model.ListConnectionsResponse;
import software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest;
import software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsResponse;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse;
import software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest;
import software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentResponse;
import software.amazon.awssdk.services.datazone.model.ListDomainsRequest;
import software.amazon.awssdk.services.datazone.model.ListDomainsResponse;
import software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest;
import software.amazon.awssdk.services.datazone.model.ListEntityOwnersResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse;
import software.amazon.awssdk.services.datazone.model.ListJobRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListJobRunsResponse;
import software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest;
import software.amazon.awssdk.services.datazone.model.ListLineageEventsResponse;
import software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest;
import software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryResponse;
import software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse;
import software.amazon.awssdk.services.datazone.model.ListNotificationsRequest;
import software.amazon.awssdk.services.datazone.model.ListNotificationsResponse;
import software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest;
import software.amazon.awssdk.services.datazone.model.ListPolicyGrantsResponse;
import software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest;
import software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse;
import software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest;
import software.amazon.awssdk.services.datazone.model.ListProjectProfilesResponse;
import software.amazon.awssdk.services.datazone.model.ListProjectsRequest;
import software.amazon.awssdk.services.datazone.model.ListProjectsResponse;
import software.amazon.awssdk.services.datazone.model.ListRulesRequest;
import software.amazon.awssdk.services.datazone.model.ListRulesResponse;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.datazone.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.datazone.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest;
import software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsResponse;
import software.amazon.awssdk.services.datazone.model.PostLineageEventRequest;
import software.amazon.awssdk.services.datazone.model.PostLineageEventResponse;
import software.amazon.awssdk.services.datazone.model.PostTimeSeriesDataPointsRequest;
import software.amazon.awssdk.services.datazone.model.PostTimeSeriesDataPointsResponse;
import software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationRequest;
import software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationResponse;
import software.amazon.awssdk.services.datazone.model.RejectPredictionsRequest;
import software.amazon.awssdk.services.datazone.model.RejectPredictionsResponse;
import software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.RemoveEntityOwnerRequest;
import software.amazon.awssdk.services.datazone.model.RemoveEntityOwnerResponse;
import software.amazon.awssdk.services.datazone.model.RemovePolicyGrantRequest;
import software.amazon.awssdk.services.datazone.model.RemovePolicyGrantResponse;
import software.amazon.awssdk.services.datazone.model.ResourceNotFoundException;
import software.amazon.awssdk.services.datazone.model.RevokeSubscriptionRequest;
import software.amazon.awssdk.services.datazone.model.RevokeSubscriptionResponse;
import software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest;
import software.amazon.awssdk.services.datazone.model.SearchGroupProfilesResponse;
import software.amazon.awssdk.services.datazone.model.SearchListingsRequest;
import software.amazon.awssdk.services.datazone.model.SearchListingsResponse;
import software.amazon.awssdk.services.datazone.model.SearchRequest;
import software.amazon.awssdk.services.datazone.model.SearchResponse;
import software.amazon.awssdk.services.datazone.model.SearchTypesRequest;
import software.amazon.awssdk.services.datazone.model.SearchTypesResponse;
import software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest;
import software.amazon.awssdk.services.datazone.model.SearchUserProfilesResponse;
import software.amazon.awssdk.services.datazone.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.datazone.model.StartDataSourceRunRequest;
import software.amazon.awssdk.services.datazone.model.StartDataSourceRunResponse;
import software.amazon.awssdk.services.datazone.model.StartMetadataGenerationRunRequest;
import software.amazon.awssdk.services.datazone.model.StartMetadataGenerationRunResponse;
import software.amazon.awssdk.services.datazone.model.TagResourceRequest;
import software.amazon.awssdk.services.datazone.model.TagResourceResponse;
import software.amazon.awssdk.services.datazone.model.ThrottlingException;
import software.amazon.awssdk.services.datazone.model.UnauthorizedException;
import software.amazon.awssdk.services.datazone.model.UntagResourceRequest;
import software.amazon.awssdk.services.datazone.model.UntagResourceResponse;
import software.amazon.awssdk.services.datazone.model.UpdateAssetFilterRequest;
import software.amazon.awssdk.services.datazone.model.UpdateAssetFilterResponse;
import software.amazon.awssdk.services.datazone.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.datazone.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.datazone.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.datazone.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.datazone.model.UpdateDomainRequest;
import software.amazon.awssdk.services.datazone.model.UpdateDomainResponse;
import software.amazon.awssdk.services.datazone.model.UpdateDomainUnitRequest;
import software.amazon.awssdk.services.datazone.model.UpdateDomainUnitResponse;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentActionRequest;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentActionResponse;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentProfileRequest;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentProfileResponse;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.datazone.model.UpdateGlossaryRequest;
import software.amazon.awssdk.services.datazone.model.UpdateGlossaryResponse;
import software.amazon.awssdk.services.datazone.model.UpdateGlossaryTermRequest;
import software.amazon.awssdk.services.datazone.model.UpdateGlossaryTermResponse;
import software.amazon.awssdk.services.datazone.model.UpdateGroupProfileRequest;
import software.amazon.awssdk.services.datazone.model.UpdateGroupProfileResponse;
import software.amazon.awssdk.services.datazone.model.UpdateProjectProfileRequest;
import software.amazon.awssdk.services.datazone.model.UpdateProjectProfileResponse;
import software.amazon.awssdk.services.datazone.model.UpdateProjectRequest;
import software.amazon.awssdk.services.datazone.model.UpdateProjectResponse;
import software.amazon.awssdk.services.datazone.model.UpdateRuleRequest;
import software.amazon.awssdk.services.datazone.model.UpdateRuleResponse;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionGrantStatusRequest;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionGrantStatusResponse;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionTargetRequest;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionTargetResponse;
import software.amazon.awssdk.services.datazone.model.UpdateUserProfileRequest;
import software.amazon.awssdk.services.datazone.model.UpdateUserProfileResponse;
import software.amazon.awssdk.services.datazone.model.ValidationException;
import software.amazon.awssdk.services.datazone.paginators.ListAssetFiltersIterable;
import software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListConnectionsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListDataProductRevisionsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesIterable;
import software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListDataSourcesIterable;
import software.amazon.awssdk.services.datazone.paginators.ListDomainUnitsForParentIterable;
import software.amazon.awssdk.services.datazone.paginators.ListDomainsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListEntityOwnersIterable;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentActionsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesIterable;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListJobRunsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListLineageEventsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListLineageNodeHistoryIterable;
import software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListNotificationsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListPolicyGrantsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListProjectProfilesIterable;
import software.amazon.awssdk.services.datazone.paginators.ListProjectsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListRulesIterable;
import software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListSubscriptionTargetsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListSubscriptionsIterable;
import software.amazon.awssdk.services.datazone.paginators.ListTimeSeriesDataPointsIterable;
import software.amazon.awssdk.services.datazone.paginators.SearchGroupProfilesIterable;
import software.amazon.awssdk.services.datazone.paginators.SearchIterable;
import software.amazon.awssdk.services.datazone.paginators.SearchListingsIterable;
import software.amazon.awssdk.services.datazone.paginators.SearchTypesIterable;
import software.amazon.awssdk.services.datazone.paginators.SearchUserProfilesIterable;

/**
 * Service client for accessing Amazon DataZone. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon DataZone is a data management service that enables you to catalog, discover, govern, share, and analyze your
 * data. With Amazon DataZone, you can share and access your data across accounts and supported regions. Amazon DataZone
 * simplifies your experience across Amazon Web Services services, including, but not limited to, Amazon Redshift,
 * Amazon Athena, Amazon Web Services Glue, and Amazon Web Services Lake Formation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DataZoneClient extends AwsClient {
    String SERVICE_NAME = "datazone";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "datazone";

    /**
     * <p>
     * Accepts automatically generated business-friendly metadata for your Amazon DataZone assets.
     * </p>
     *
     * @param acceptPredictionsRequest
     * @return Result of the AcceptPredictions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.AcceptPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptPredictions" target="_top">AWS
     *      API Documentation</a>
     */
    default AcceptPredictionsResponse acceptPredictions(AcceptPredictionsRequest acceptPredictionsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts automatically generated business-friendly metadata for your Amazon DataZone assets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptPredictionsRequest.Builder} avoiding the need
     * to create one manually via {@link AcceptPredictionsRequest#builder()}
     * </p>
     *
     * @param acceptPredictionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.AcceptPredictionsRequest.Builder} to create a
     *        request.
     * @return Result of the AcceptPredictions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.AcceptPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptPredictions" target="_top">AWS
     *      API Documentation</a>
     */
    default AcceptPredictionsResponse acceptPredictions(Consumer<AcceptPredictionsRequest.Builder> acceptPredictionsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return acceptPredictions(AcceptPredictionsRequest.builder().applyMutation(acceptPredictionsRequest).build());
    }

    /**
     * <p>
     * Accepts a subscription request to a specific asset.
     * </p>
     *
     * @param acceptSubscriptionRequestRequest
     * @return Result of the AcceptSubscriptionRequest operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.AcceptSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptSubscriptionRequestResponse acceptSubscriptionRequest(
            AcceptSubscriptionRequestRequest acceptSubscriptionRequestRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a subscription request to a specific asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptSubscriptionRequestRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptSubscriptionRequestRequest#builder()}
     * </p>
     *
     * @param acceptSubscriptionRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestRequest.Builder} to create
     *        a request.
     * @return Result of the AcceptSubscriptionRequest operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.AcceptSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptSubscriptionRequestResponse acceptSubscriptionRequest(
            Consumer<AcceptSubscriptionRequestRequest.Builder> acceptSubscriptionRequestRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return acceptSubscriptionRequest(AcceptSubscriptionRequestRequest.builder()
                .applyMutation(acceptSubscriptionRequestRequest).build());
    }

    /**
     * <p>
     * Adds the owner of an entity (a domain unit).
     * </p>
     *
     * @param addEntityOwnerRequest
     * @return Result of the AddEntityOwner operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.AddEntityOwner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AddEntityOwner" target="_top">AWS API
     *      Documentation</a>
     */
    default AddEntityOwnerResponse addEntityOwner(AddEntityOwnerRequest addEntityOwnerRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the owner of an entity (a domain unit).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddEntityOwnerRequest.Builder} avoiding the need to
     * create one manually via {@link AddEntityOwnerRequest#builder()}
     * </p>
     *
     * @param addEntityOwnerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.AddEntityOwnerRequest.Builder} to create a request.
     * @return Result of the AddEntityOwner operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.AddEntityOwner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AddEntityOwner" target="_top">AWS API
     *      Documentation</a>
     */
    default AddEntityOwnerResponse addEntityOwner(Consumer<AddEntityOwnerRequest.Builder> addEntityOwnerRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return addEntityOwner(AddEntityOwnerRequest.builder().applyMutation(addEntityOwnerRequest).build());
    }

    /**
     * <p>
     * Adds a policy grant (an authorization policy) to a specified entity, including domain units, environment
     * blueprint configurations, or environment profiles.
     * </p>
     *
     * @param addPolicyGrantRequest
     * @return Result of the AddPolicyGrant operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.AddPolicyGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AddPolicyGrant" target="_top">AWS API
     *      Documentation</a>
     */
    default AddPolicyGrantResponse addPolicyGrant(AddPolicyGrantRequest addPolicyGrantRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ServiceQuotaExceededException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a policy grant (an authorization policy) to a specified entity, including domain units, environment
     * blueprint configurations, or environment profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddPolicyGrantRequest.Builder} avoiding the need to
     * create one manually via {@link AddPolicyGrantRequest#builder()}
     * </p>
     *
     * @param addPolicyGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.AddPolicyGrantRequest.Builder} to create a request.
     * @return Result of the AddPolicyGrant operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.AddPolicyGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AddPolicyGrant" target="_top">AWS API
     *      Documentation</a>
     */
    default AddPolicyGrantResponse addPolicyGrant(Consumer<AddPolicyGrantRequest.Builder> addPolicyGrantRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return addPolicyGrant(AddPolicyGrantRequest.builder().applyMutation(addPolicyGrantRequest).build());
    }

    /**
     * <p>
     * Associates the environment role in Amazon DataZone.
     * </p>
     *
     * @param associateEnvironmentRoleRequest
     * @return Result of the AssociateEnvironmentRole operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.AssociateEnvironmentRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AssociateEnvironmentRole"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateEnvironmentRoleResponse associateEnvironmentRole(
            AssociateEnvironmentRoleRequest associateEnvironmentRoleRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the environment role in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateEnvironmentRoleRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateEnvironmentRoleRequest#builder()}
     * </p>
     *
     * @param associateEnvironmentRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.AssociateEnvironmentRoleRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateEnvironmentRole operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.AssociateEnvironmentRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AssociateEnvironmentRole"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateEnvironmentRoleResponse associateEnvironmentRole(
            Consumer<AssociateEnvironmentRoleRequest.Builder> associateEnvironmentRoleRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return associateEnvironmentRole(AssociateEnvironmentRoleRequest.builder().applyMutation(associateEnvironmentRoleRequest)
                .build());
    }

    /**
     * <p>
     * Cancels the metadata generation run.
     * </p>
     *
     * @param cancelMetadataGenerationRunRequest
     * @return Result of the CancelMetadataGenerationRun operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CancelMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMetadataGenerationRunResponse cancelMetadataGenerationRun(
            CancelMetadataGenerationRunRequest cancelMetadataGenerationRunRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the metadata generation run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMetadataGenerationRunRequest.Builder}
     * avoiding the need to create one manually via {@link CancelMetadataGenerationRunRequest#builder()}
     * </p>
     *
     * @param cancelMetadataGenerationRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CancelMetadataGenerationRunRequest.Builder} to
     *        create a request.
     * @return Result of the CancelMetadataGenerationRun operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CancelMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMetadataGenerationRunResponse cancelMetadataGenerationRun(
            Consumer<CancelMetadataGenerationRunRequest.Builder> cancelMetadataGenerationRunRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return cancelMetadataGenerationRun(CancelMetadataGenerationRunRequest.builder()
                .applyMutation(cancelMetadataGenerationRunRequest).build());
    }

    /**
     * <p>
     * Cancels the subscription to the specified asset.
     * </p>
     *
     * @param cancelSubscriptionRequest
     * @return Result of the CancelSubscription operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CancelSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelSubscriptionResponse cancelSubscription(CancelSubscriptionRequest cancelSubscriptionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the subscription to the specified asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link CancelSubscriptionRequest#builder()}
     * </p>
     *
     * @param cancelSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CancelSubscriptionRequest.Builder} to create a
     *        request.
     * @return Result of the CancelSubscription operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CancelSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelSubscriptionResponse cancelSubscription(Consumer<CancelSubscriptionRequest.Builder> cancelSubscriptionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return cancelSubscription(CancelSubscriptionRequest.builder().applyMutation(cancelSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates an asset in Amazon DataZone catalog.
     * </p>
     *
     * @param createAssetRequest
     * @return Result of the CreateAsset operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAssetResponse createAsset(CreateAssetRequest createAssetRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an asset in Amazon DataZone catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAssetRequest#builder()}
     * </p>
     *
     * @param createAssetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateAssetRequest.Builder} to create a request.
     * @return Result of the CreateAsset operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAssetResponse createAsset(Consumer<CreateAssetRequest.Builder> createAssetRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return createAsset(CreateAssetRequest.builder().applyMutation(createAssetRequest).build());
    }

    /**
     * <p>
     * Creates a data asset filter.
     * </p>
     *
     * @param createAssetFilterRequest
     * @return Result of the CreateAssetFilter operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateAssetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAssetFilterResponse createAssetFilter(CreateAssetFilterRequest createAssetFilterRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data asset filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetFilterRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssetFilterRequest#builder()}
     * </p>
     *
     * @param createAssetFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateAssetFilterRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAssetFilter operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateAssetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAssetFilterResponse createAssetFilter(Consumer<CreateAssetFilterRequest.Builder> createAssetFilterRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return createAssetFilter(CreateAssetFilterRequest.builder().applyMutation(createAssetFilterRequest).build());
    }

    /**
     * <p>
     * Creates a revision of the asset.
     * </p>
     *
     * @param createAssetRevisionRequest
     * @return Result of the CreateAssetRevision operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateAssetRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetRevision" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAssetRevisionResponse createAssetRevision(CreateAssetRevisionRequest createAssetRevisionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a revision of the asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetRevisionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAssetRevisionRequest#builder()}
     * </p>
     *
     * @param createAssetRevisionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateAssetRevisionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAssetRevision operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateAssetRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetRevision" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAssetRevisionResponse createAssetRevision(
            Consumer<CreateAssetRevisionRequest.Builder> createAssetRevisionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return createAssetRevision(CreateAssetRevisionRequest.builder().applyMutation(createAssetRevisionRequest).build());
    }

    /**
     * <p>
     * Creates a custom asset type.
     * </p>
     *
     * @param createAssetTypeRequest
     * @return Result of the CreateAssetType operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAssetTypeResponse createAssetType(CreateAssetTypeRequest createAssetTypeRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom asset type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetTypeRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssetTypeRequest#builder()}
     * </p>
     *
     * @param createAssetTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateAssetTypeRequest.Builder} to create a request.
     * @return Result of the CreateAssetType operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAssetTypeResponse createAssetType(Consumer<CreateAssetTypeRequest.Builder> createAssetTypeRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return createAssetType(CreateAssetTypeRequest.builder().applyMutation(createAssetTypeRequest).build());
    }

    /**
     * <p>
     * Creates a new connection. In Amazon DataZone, a connection enables you to connect your resources (domains,
     * projects, and environments) to external resources and services.
     * </p>
     *
     * @param createConnectionRequest
     * @return Result of the CreateConnection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateConnectionResponse createConnection(CreateConnectionRequest createConnectionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new connection. In Amazon DataZone, a connection enables you to connect your resources (domains,
     * projects, and environments) to external resources and services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectionRequest#builder()}
     * </p>
     *
     * @param createConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateConnection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateConnectionResponse createConnection(Consumer<CreateConnectionRequest.Builder> createConnectionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return createConnection(CreateConnectionRequest.builder().applyMutation(createConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a data product.
     * </p>
     *
     * @param createDataProductRequest
     * @return Result of the CreateDataProduct operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateDataProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDataProductResponse createDataProduct(CreateDataProductRequest createDataProductRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataProductRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataProductRequest#builder()}
     * </p>
     *
     * @param createDataProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateDataProductRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDataProduct operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateDataProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDataProductResponse createDataProduct(Consumer<CreateDataProductRequest.Builder> createDataProductRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return createDataProduct(CreateDataProductRequest.builder().applyMutation(createDataProductRequest).build());
    }

    /**
     * <p>
     * Creates a data product revision.
     * </p>
     *
     * @param createDataProductRevisionRequest
     * @return Result of the CreateDataProductRevision operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateDataProductRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataProductRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataProductRevisionResponse createDataProductRevision(
            CreateDataProductRevisionRequest createDataProductRevisionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data product revision.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataProductRevisionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDataProductRevisionRequest#builder()}
     * </p>
     *
     * @param createDataProductRevisionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateDataProductRevisionRequest.Builder} to create
     *        a request.
     * @return Result of the CreateDataProductRevision operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateDataProductRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataProductRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataProductRevisionResponse createDataProductRevision(
            Consumer<CreateDataProductRevisionRequest.Builder> createDataProductRevisionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return createDataProductRevision(CreateDataProductRevisionRequest.builder()
                .applyMutation(createDataProductRevisionRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone data source.
     * </p>
     *
     * @param createDataSourceRequest
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataSourceRequest#builder()}
     * </p>
     *
     * @param createDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateDataSourceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataSourceResponse createDataSource(Consumer<CreateDataSourceRequest.Builder> createDataSourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return createDataSource(CreateDataSourceRequest.builder().applyMutation(createDataSourceRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone domain.
     * </p>
     *
     * @param createDomainRequest
     * @return Result of the CreateDomain operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateDomainRequest.Builder} to create a request.
     * @return Result of the CreateDomain operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDomainResponse createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Creates a domain unit in Amazon DataZone.
     * </p>
     *
     * @param createDomainUnitRequest
     * @return Result of the CreateDomainUnit operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateDomainUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDomainUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDomainUnitResponse createDomainUnit(CreateDomainUnitRequest createDomainUnitRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain unit in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainUnitRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDomainUnitRequest#builder()}
     * </p>
     *
     * @param createDomainUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateDomainUnitRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDomainUnit operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateDomainUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDomainUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDomainUnitResponse createDomainUnit(Consumer<CreateDomainUnitRequest.Builder> createDomainUnitRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return createDomainUnit(CreateDomainUnitRequest.builder().applyMutation(createDomainUnitRequest).build());
    }

    /**
     * <p>
     * Create an Amazon DataZone environment.
     * </p>
     *
     * @param createEnvironmentRequest
     * @return Result of the CreateEnvironment operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEnvironmentResponse createEnvironment(CreateEnvironmentRequest createEnvironmentRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an Amazon DataZone environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEnvironmentRequest#builder()}
     * </p>
     *
     * @param createEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateEnvironmentRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEnvironment operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEnvironmentResponse createEnvironment(Consumer<CreateEnvironmentRequest.Builder> createEnvironmentRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return createEnvironment(CreateEnvironmentRequest.builder().applyMutation(createEnvironmentRequest).build());
    }

    /**
     * <p>
     * Creates an action for the environment, for example, creates a console link for an analytics tool that is
     * available in this environment.
     * </p>
     *
     * @param createEnvironmentActionRequest
     * @return Result of the CreateEnvironmentAction operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateEnvironmentAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEnvironmentActionResponse createEnvironmentAction(CreateEnvironmentActionRequest createEnvironmentActionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an action for the environment, for example, creates a console link for an analytics tool that is
     * available in this environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentActionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEnvironmentActionRequest#builder()}
     * </p>
     *
     * @param createEnvironmentActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateEnvironmentActionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEnvironmentAction operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateEnvironmentAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEnvironmentActionResponse createEnvironmentAction(
            Consumer<CreateEnvironmentActionRequest.Builder> createEnvironmentActionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return createEnvironmentAction(CreateEnvironmentActionRequest.builder().applyMutation(createEnvironmentActionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone environment profile.
     * </p>
     *
     * @param createEnvironmentProfileRequest
     * @return Result of the CreateEnvironmentProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEnvironmentProfileResponse createEnvironmentProfile(
            CreateEnvironmentProfileRequest createEnvironmentProfileRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone environment profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentProfileRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEnvironmentProfileRequest#builder()}
     * </p>
     *
     * @param createEnvironmentProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEnvironmentProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEnvironmentProfileResponse createEnvironmentProfile(
            Consumer<CreateEnvironmentProfileRequest.Builder> createEnvironmentProfileRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return createEnvironmentProfile(CreateEnvironmentProfileRequest.builder().applyMutation(createEnvironmentProfileRequest)
                .build());
    }

    /**
     * <p>
     * Creates a metadata form type.
     * </p>
     *
     * @param createFormTypeRequest
     * @return Result of the CreateFormType operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFormTypeResponse createFormType(CreateFormTypeRequest createFormTypeRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ServiceQuotaExceededException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a metadata form type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFormTypeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFormTypeRequest#builder()}
     * </p>
     *
     * @param createFormTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateFormTypeRequest.Builder} to create a request.
     * @return Result of the CreateFormType operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFormTypeResponse createFormType(Consumer<CreateFormTypeRequest.Builder> createFormTypeRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return createFormType(CreateFormTypeRequest.builder().applyMutation(createFormTypeRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone business glossary.
     * </p>
     *
     * @param createGlossaryRequest
     * @return Result of the CreateGlossary operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGlossaryResponse createGlossary(CreateGlossaryRequest createGlossaryRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ServiceQuotaExceededException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone business glossary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlossaryRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGlossaryRequest#builder()}
     * </p>
     *
     * @param createGlossaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateGlossaryRequest.Builder} to create a request.
     * @return Result of the CreateGlossary operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGlossaryResponse createGlossary(Consumer<CreateGlossaryRequest.Builder> createGlossaryRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return createGlossary(CreateGlossaryRequest.builder().applyMutation(createGlossaryRequest).build());
    }

    /**
     * <p>
     * Creates a business glossary term.
     * </p>
     *
     * @param createGlossaryTermRequest
     * @return Result of the CreateGlossaryTerm operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGlossaryTermResponse createGlossaryTerm(CreateGlossaryTermRequest createGlossaryTermRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a business glossary term.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlossaryTermRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGlossaryTermRequest#builder()}
     * </p>
     *
     * @param createGlossaryTermRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateGlossaryTermRequest.Builder} to create a
     *        request.
     * @return Result of the CreateGlossaryTerm operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGlossaryTermResponse createGlossaryTerm(Consumer<CreateGlossaryTermRequest.Builder> createGlossaryTermRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return createGlossaryTerm(CreateGlossaryTermRequest.builder().applyMutation(createGlossaryTermRequest).build());
    }

    /**
     * <p>
     * Creates a group profile in Amazon DataZone.
     * </p>
     *
     * @param createGroupProfileRequest
     * @return Result of the CreateGroupProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGroupProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGroupProfileResponse createGroupProfile(CreateGroupProfileRequest createGroupProfileRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a group profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGroupProfileRequest#builder()}
     * </p>
     *
     * @param createGroupProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateGroupProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateGroupProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGroupProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGroupProfileResponse createGroupProfile(Consumer<CreateGroupProfileRequest.Builder> createGroupProfileRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return createGroupProfile(CreateGroupProfileRequest.builder().applyMutation(createGroupProfileRequest).build());
    }

    /**
     * <p>
     * Publishes a listing (a record of an asset at a given time) or removes a listing from the catalog.
     * </p>
     *
     * @param createListingChangeSetRequest
     * @return Result of the CreateListingChangeSet operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateListingChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateListingChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateListingChangeSetResponse createListingChangeSet(CreateListingChangeSetRequest createListingChangeSetRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes a listing (a record of an asset at a given time) or removes a listing from the catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateListingChangeSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateListingChangeSetRequest#builder()}
     * </p>
     *
     * @param createListingChangeSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateListingChangeSetRequest.Builder} to create a
     *        request.
     * @return Result of the CreateListingChangeSet operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateListingChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateListingChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateListingChangeSetResponse createListingChangeSet(
            Consumer<CreateListingChangeSetRequest.Builder> createListingChangeSetRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return createListingChangeSet(CreateListingChangeSetRequest.builder().applyMutation(createListingChangeSetRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone project.
     * </p>
     *
     * @param createProjectRequest
     * @return Result of the CreateProject operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateProjectRequest.Builder} to create a request.
     * @return Result of the CreateProject operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Creates a project membership in Amazon DataZone.
     * </p>
     *
     * @param createProjectMembershipRequest
     * @return Result of the CreateProjectMembership operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateProjectMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProjectMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProjectMembershipResponse createProjectMembership(CreateProjectMembershipRequest createProjectMembershipRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a project membership in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectMembershipRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProjectMembershipRequest#builder()}
     * </p>
     *
     * @param createProjectMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateProjectMembershipRequest.Builder} to create a
     *        request.
     * @return Result of the CreateProjectMembership operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateProjectMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProjectMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProjectMembershipResponse createProjectMembership(
            Consumer<CreateProjectMembershipRequest.Builder> createProjectMembershipRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return createProjectMembership(CreateProjectMembershipRequest.builder().applyMutation(createProjectMembershipRequest)
                .build());
    }

    /**
     * <p>
     * Creates a project profile.
     * </p>
     *
     * @param createProjectProfileRequest
     * @return Result of the CreateProjectProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateProjectProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProjectProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProjectProfileResponse createProjectProfile(CreateProjectProfileRequest createProjectProfileRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a project profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateProjectProfileRequest#builder()}
     * </p>
     *
     * @param createProjectProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateProjectProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateProjectProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateProjectProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProjectProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProjectProfileResponse createProjectProfile(
            Consumer<CreateProjectProfileRequest.Builder> createProjectProfileRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return createProjectProfile(CreateProjectProfileRequest.builder().applyMutation(createProjectProfileRequest).build());
    }

    /**
     * <p>
     * Creates a rule in Amazon DataZone. A rule is a formal agreement that enforces specific requirements across user
     * workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects) within the Amazon
     * DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold governance standards
     * in data management processes. For instance, a metadata enforcement rule can specify the required information for
     * creating a subscription request or publishing a data asset to the catalog, ensuring alignment with organizational
     * standards.
     * </p>
     *
     * @param createRuleRequest
     * @return Result of the CreateRule operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRuleResponse createRule(CreateRuleRequest createRuleRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a rule in Amazon DataZone. A rule is a formal agreement that enforces specific requirements across user
     * workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects) within the Amazon
     * DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold governance standards
     * in data management processes. For instance, a metadata enforcement rule can specify the required information for
     * creating a subscription request or publishing a data asset to the catalog, ensuring alignment with organizational
     * standards.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRuleRequest#builder()}
     * </p>
     *
     * @param createRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateRuleRequest.Builder} to create a request.
     * @return Result of the CreateRule operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRuleResponse createRule(Consumer<CreateRuleRequest.Builder> createRuleRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return createRule(CreateRuleRequest.builder().applyMutation(createRuleRequest).build());
    }

    /**
     * <p>
     * Creates a subsscription grant in Amazon DataZone.
     * </p>
     *
     * @param createSubscriptionGrantRequest
     * @return Result of the CreateSubscriptionGrant operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubscriptionGrantResponse createSubscriptionGrant(CreateSubscriptionGrantRequest createSubscriptionGrantRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subsscription grant in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionGrantRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSubscriptionGrantRequest#builder()}
     * </p>
     *
     * @param createSubscriptionGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSubscriptionGrant operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubscriptionGrantResponse createSubscriptionGrant(
            Consumer<CreateSubscriptionGrantRequest.Builder> createSubscriptionGrantRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return createSubscriptionGrant(CreateSubscriptionGrantRequest.builder().applyMutation(createSubscriptionGrantRequest)
                .build());
    }

    /**
     * <p>
     * Creates a subscription request in Amazon DataZone.
     * </p>
     *
     * @param createSubscriptionRequestRequest
     * @return Result of the CreateSubscriptionRequest operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubscriptionRequestResponse createSubscriptionRequest(
            CreateSubscriptionRequestRequest createSubscriptionRequestRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subscription request in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionRequestRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSubscriptionRequestRequest#builder()}
     * </p>
     *
     * @param createSubscriptionRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestRequest.Builder} to create
     *        a request.
     * @return Result of the CreateSubscriptionRequest operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubscriptionRequestResponse createSubscriptionRequest(
            Consumer<CreateSubscriptionRequestRequest.Builder> createSubscriptionRequestRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return createSubscriptionRequest(CreateSubscriptionRequestRequest.builder()
                .applyMutation(createSubscriptionRequestRequest).build());
    }

    /**
     * <p>
     * Creates a subscription target in Amazon DataZone.
     * </p>
     *
     * @param createSubscriptionTargetRequest
     * @return Result of the CreateSubscriptionTarget operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubscriptionTargetResponse createSubscriptionTarget(
            CreateSubscriptionTargetRequest createSubscriptionTargetRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subscription target in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionTargetRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSubscriptionTargetRequest#builder()}
     * </p>
     *
     * @param createSubscriptionTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSubscriptionTarget operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubscriptionTargetResponse createSubscriptionTarget(
            Consumer<CreateSubscriptionTargetRequest.Builder> createSubscriptionTargetRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return createSubscriptionTarget(CreateSubscriptionTargetRequest.builder().applyMutation(createSubscriptionTargetRequest)
                .build());
    }

    /**
     * <p>
     * Creates a user profile in Amazon DataZone.
     * </p>
     *
     * @param createUserProfileRequest
     * @return Result of the CreateUserProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUserProfileResponse createUserProfile(CreateUserProfileRequest createUserProfileRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserProfileRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUserProfileRequest#builder()}
     * </p>
     *
     * @param createUserProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateUserProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateUserProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.CreateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUserProfileResponse createUserProfile(Consumer<CreateUserProfileRequest.Builder> createUserProfileRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return createUserProfile(CreateUserProfileRequest.builder().applyMutation(createUserProfileRequest).build());
    }

    /**
     * <p>
     * Deletes an asset in Amazon DataZone.
     * </p>
     *
     * @param deleteAssetRequest
     * @return Result of the DeleteAsset operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAssetResponse deleteAsset(DeleteAssetRequest deleteAssetRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an asset in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAssetRequest#builder()}
     * </p>
     *
     * @param deleteAssetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteAssetRequest.Builder} to create a request.
     * @return Result of the DeleteAsset operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAssetResponse deleteAsset(Consumer<DeleteAssetRequest.Builder> deleteAssetRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return deleteAsset(DeleteAssetRequest.builder().applyMutation(deleteAssetRequest).build());
    }

    /**
     * <p>
     * Deletes an asset filter.
     * </p>
     *
     * @param deleteAssetFilterRequest
     * @return Result of the DeleteAssetFilter operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteAssetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAssetFilterResponse deleteAssetFilter(DeleteAssetFilterRequest deleteAssetFilterRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an asset filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetFilterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssetFilterRequest#builder()}
     * </p>
     *
     * @param deleteAssetFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteAssetFilterRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAssetFilter operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteAssetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAssetFilterResponse deleteAssetFilter(Consumer<DeleteAssetFilterRequest.Builder> deleteAssetFilterRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return deleteAssetFilter(DeleteAssetFilterRequest.builder().applyMutation(deleteAssetFilterRequest).build());
    }

    /**
     * <p>
     * Deletes an asset type in Amazon DataZone.
     * </p>
     *
     * @param deleteAssetTypeRequest
     * @return Result of the DeleteAssetType operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAssetTypeResponse deleteAssetType(DeleteAssetTypeRequest deleteAssetTypeRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an asset type in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssetTypeRequest#builder()}
     * </p>
     *
     * @param deleteAssetTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteAssetTypeRequest.Builder} to create a request.
     * @return Result of the DeleteAssetType operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAssetTypeResponse deleteAssetType(Consumer<DeleteAssetTypeRequest.Builder> deleteAssetTypeRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return deleteAssetType(DeleteAssetTypeRequest.builder().applyMutation(deleteAssetTypeRequest).build());
    }

    /**
     * <p>
     * Deletes and connection. In Amazon DataZone, a connection enables you to connect your resources (domains,
     * projects, and environments) to external resources and services.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes and connection. In Amazon DataZone, a connection enables you to connect your resources (domains,
     * projects, and environments) to external resources and services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes a data product in Amazon DataZone.
     * </p>
     *
     * @param deleteDataProductRequest
     * @return Result of the DeleteDataProduct operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteDataProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDataProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDataProductResponse deleteDataProduct(DeleteDataProductRequest deleteDataProductRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a data product in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataProductRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataProductRequest#builder()}
     * </p>
     *
     * @param deleteDataProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteDataProductRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDataProduct operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteDataProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDataProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDataProductResponse deleteDataProduct(Consumer<DeleteDataProductRequest.Builder> deleteDataProductRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return deleteDataProduct(DeleteDataProductRequest.builder().applyMutation(deleteDataProductRequest).build());
    }

    /**
     * <p>
     * Deletes a data source in Amazon DataZone.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a data source in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteDataSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataSourceResponse deleteDataSource(Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Deletes a Amazon DataZone domain.
     * </p>
     *
     * @param deleteDomainRequest
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Amazon DataZone domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteDomainRequest.Builder} to create a request.
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Deletes a domain unit.
     * </p>
     *
     * @param deleteDomainUnitRequest
     * @return Result of the DeleteDomainUnit operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteDomainUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDomainUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDomainUnitResponse deleteDomainUnit(DeleteDomainUnitRequest deleteDomainUnitRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a domain unit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainUnitRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDomainUnitRequest#builder()}
     * </p>
     *
     * @param deleteDomainUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteDomainUnitRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDomainUnit operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteDomainUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDomainUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDomainUnitResponse deleteDomainUnit(Consumer<DeleteDomainUnitRequest.Builder> deleteDomainUnitRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return deleteDomainUnit(DeleteDomainUnitRequest.builder().applyMutation(deleteDomainUnitRequest).build());
    }

    /**
     * <p>
     * Deletes an environment in Amazon DataZone.
     * </p>
     *
     * @param deleteEnvironmentRequest
     * @return Result of the DeleteEnvironment operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEnvironmentResponse deleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an environment in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteEnvironmentRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEnvironment operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEnvironmentResponse deleteEnvironment(Consumer<DeleteEnvironmentRequest.Builder> deleteEnvironmentRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return deleteEnvironment(DeleteEnvironmentRequest.builder().applyMutation(deleteEnvironmentRequest).build());
    }

    /**
     * <p>
     * Deletes an action for the environment, for example, deletes a console link for an analytics tool that is
     * available in this environment.
     * </p>
     *
     * @param deleteEnvironmentActionRequest
     * @return Result of the DeleteEnvironmentAction operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteEnvironmentAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentAction"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEnvironmentActionResponse deleteEnvironmentAction(DeleteEnvironmentActionRequest deleteEnvironmentActionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an action for the environment, for example, deletes a console link for an analytics tool that is
     * available in this environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentActionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEnvironmentActionRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteEnvironmentActionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEnvironmentAction operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteEnvironmentAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentAction"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEnvironmentActionResponse deleteEnvironmentAction(
            Consumer<DeleteEnvironmentActionRequest.Builder> deleteEnvironmentActionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return deleteEnvironmentAction(DeleteEnvironmentActionRequest.builder().applyMutation(deleteEnvironmentActionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the blueprint configuration in Amazon DataZone.
     * </p>
     *
     * @param deleteEnvironmentBlueprintConfigurationRequest
     * @return Result of the DeleteEnvironmentBlueprintConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteEnvironmentBlueprintConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEnvironmentBlueprintConfigurationResponse deleteEnvironmentBlueprintConfiguration(
            DeleteEnvironmentBlueprintConfigurationRequest deleteEnvironmentBlueprintConfigurationRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the blueprint configuration in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteEnvironmentBlueprintConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteEnvironmentBlueprintConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentBlueprintConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteEnvironmentBlueprintConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteEnvironmentBlueprintConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEnvironmentBlueprintConfigurationResponse deleteEnvironmentBlueprintConfiguration(
            Consumer<DeleteEnvironmentBlueprintConfigurationRequest.Builder> deleteEnvironmentBlueprintConfigurationRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return deleteEnvironmentBlueprintConfiguration(DeleteEnvironmentBlueprintConfigurationRequest.builder()
                .applyMutation(deleteEnvironmentBlueprintConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an environment profile in Amazon DataZone.
     * </p>
     *
     * @param deleteEnvironmentProfileRequest
     * @return Result of the DeleteEnvironmentProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEnvironmentProfileResponse deleteEnvironmentProfile(
            DeleteEnvironmentProfileRequest deleteEnvironmentProfileRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an environment profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentProfileRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEnvironmentProfileRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteEnvironmentProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEnvironmentProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEnvironmentProfileResponse deleteEnvironmentProfile(
            Consumer<DeleteEnvironmentProfileRequest.Builder> deleteEnvironmentProfileRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return deleteEnvironmentProfile(DeleteEnvironmentProfileRequest.builder().applyMutation(deleteEnvironmentProfileRequest)
                .build());
    }

    /**
     * <p>
     * Delets and metadata form type in Amazon DataZone.
     * </p>
     *
     * @param deleteFormTypeRequest
     * @return Result of the DeleteFormType operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFormTypeResponse deleteFormType(DeleteFormTypeRequest deleteFormTypeRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delets and metadata form type in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFormTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFormTypeRequest#builder()}
     * </p>
     *
     * @param deleteFormTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteFormTypeRequest.Builder} to create a request.
     * @return Result of the DeleteFormType operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFormTypeResponse deleteFormType(Consumer<DeleteFormTypeRequest.Builder> deleteFormTypeRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return deleteFormType(DeleteFormTypeRequest.builder().applyMutation(deleteFormTypeRequest).build());
    }

    /**
     * <p>
     * Deletes a business glossary in Amazon DataZone.
     * </p>
     *
     * @param deleteGlossaryRequest
     * @return Result of the DeleteGlossary operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGlossaryResponse deleteGlossary(DeleteGlossaryRequest deleteGlossaryRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a business glossary in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlossaryRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGlossaryRequest#builder()}
     * </p>
     *
     * @param deleteGlossaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteGlossaryRequest.Builder} to create a request.
     * @return Result of the DeleteGlossary operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGlossaryResponse deleteGlossary(Consumer<DeleteGlossaryRequest.Builder> deleteGlossaryRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return deleteGlossary(DeleteGlossaryRequest.builder().applyMutation(deleteGlossaryRequest).build());
    }

    /**
     * <p>
     * Deletes a business glossary term in Amazon DataZone.
     * </p>
     *
     * @param deleteGlossaryTermRequest
     * @return Result of the DeleteGlossaryTerm operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteGlossaryTermResponse deleteGlossaryTerm(DeleteGlossaryTermRequest deleteGlossaryTermRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a business glossary term in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlossaryTermRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGlossaryTermRequest#builder()}
     * </p>
     *
     * @param deleteGlossaryTermRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteGlossaryTerm operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteGlossaryTermResponse deleteGlossaryTerm(Consumer<DeleteGlossaryTermRequest.Builder> deleteGlossaryTermRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return deleteGlossaryTerm(DeleteGlossaryTermRequest.builder().applyMutation(deleteGlossaryTermRequest).build());
    }

    /**
     * <p>
     * Deletes a listing (a record of an asset at a given time).
     * </p>
     *
     * @param deleteListingRequest
     * @return Result of the DeleteListing operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteListing" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteListingResponse deleteListing(DeleteListingRequest deleteListingRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a listing (a record of an asset at a given time).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteListingRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteListingRequest#builder()}
     * </p>
     *
     * @param deleteListingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteListingRequest.Builder} to create a request.
     * @return Result of the DeleteListing operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteListing" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteListingResponse deleteListing(Consumer<DeleteListingRequest.Builder> deleteListingRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return deleteListing(DeleteListingRequest.builder().applyMutation(deleteListingRequest).build());
    }

    /**
     * <p>
     * Deletes a project in Amazon DataZone.
     * </p>
     *
     * @param deleteProjectRequest
     * @return Result of the DeleteProject operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a project in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteProjectRequest.Builder} to create a request.
     * @return Result of the DeleteProject operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Deletes project membership in Amazon DataZone.
     * </p>
     *
     * @param deleteProjectMembershipRequest
     * @return Result of the DeleteProjectMembership operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteProjectMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProjectMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProjectMembershipResponse deleteProjectMembership(DeleteProjectMembershipRequest deleteProjectMembershipRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes project membership in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectMembershipRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProjectMembershipRequest#builder()}
     * </p>
     *
     * @param deleteProjectMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteProjectMembership operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteProjectMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProjectMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProjectMembershipResponse deleteProjectMembership(
            Consumer<DeleteProjectMembershipRequest.Builder> deleteProjectMembershipRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return deleteProjectMembership(DeleteProjectMembershipRequest.builder().applyMutation(deleteProjectMembershipRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a project profile.
     * </p>
     *
     * @param deleteProjectProfileRequest
     * @return Result of the DeleteProjectProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteProjectProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProjectProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProjectProfileResponse deleteProjectProfile(DeleteProjectProfileRequest deleteProjectProfileRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a project profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProjectProfileRequest#builder()}
     * </p>
     *
     * @param deleteProjectProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteProjectProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteProjectProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteProjectProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProjectProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProjectProfileResponse deleteProjectProfile(
            Consumer<DeleteProjectProfileRequest.Builder> deleteProjectProfileRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return deleteProjectProfile(DeleteProjectProfileRequest.builder().applyMutation(deleteProjectProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a rule in Amazon DataZone. A rule is a formal agreement that enforces specific requirements across user
     * workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects) within the Amazon
     * DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold governance standards
     * in data management processes. For instance, a metadata enforcement rule can specify the required information for
     * creating a subscription request or publishing a data asset to the catalog, ensuring alignment with organizational
     * standards.
     * </p>
     *
     * @param deleteRuleRequest
     * @return Result of the DeleteRule operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a rule in Amazon DataZone. A rule is a formal agreement that enforces specific requirements across user
     * workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects) within the Amazon
     * DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold governance standards
     * in data management processes. For instance, a metadata enforcement rule can specify the required information for
     * creating a subscription request or publishing a data asset to the catalog, ensuring alignment with organizational
     * standards.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleRequest#builder()}
     * </p>
     *
     * @param deleteRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteRuleRequest.Builder} to create a request.
     * @return Result of the DeleteRule operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleResponse deleteRule(Consumer<DeleteRuleRequest.Builder> deleteRuleRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return deleteRule(DeleteRuleRequest.builder().applyMutation(deleteRuleRequest).build());
    }

    /**
     * <p>
     * Deletes and subscription grant in Amazon DataZone.
     * </p>
     *
     * @param deleteSubscriptionGrantRequest
     * @return Result of the DeleteSubscriptionGrant operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSubscriptionGrantResponse deleteSubscriptionGrant(DeleteSubscriptionGrantRequest deleteSubscriptionGrantRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes and subscription grant in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriptionGrantRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSubscriptionGrantRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteSubscriptionGrantRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSubscriptionGrant operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSubscriptionGrantResponse deleteSubscriptionGrant(
            Consumer<DeleteSubscriptionGrantRequest.Builder> deleteSubscriptionGrantRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return deleteSubscriptionGrant(DeleteSubscriptionGrantRequest.builder().applyMutation(deleteSubscriptionGrantRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a subscription request in Amazon DataZone.
     * </p>
     *
     * @param deleteSubscriptionRequestRequest
     * @return Result of the DeleteSubscriptionRequest operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSubscriptionRequestResponse deleteSubscriptionRequest(
            DeleteSubscriptionRequestRequest deleteSubscriptionRequestRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subscription request in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriptionRequestRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSubscriptionRequestRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteSubscriptionRequest operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSubscriptionRequestResponse deleteSubscriptionRequest(
            Consumer<DeleteSubscriptionRequestRequest.Builder> deleteSubscriptionRequestRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return deleteSubscriptionRequest(DeleteSubscriptionRequestRequest.builder()
                .applyMutation(deleteSubscriptionRequestRequest).build());
    }

    /**
     * <p>
     * Deletes a subscription target in Amazon DataZone.
     * </p>
     *
     * @param deleteSubscriptionTargetRequest
     * @return Result of the DeleteSubscriptionTarget operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSubscriptionTargetResponse deleteSubscriptionTarget(
            DeleteSubscriptionTargetRequest deleteSubscriptionTargetRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subscription target in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriptionTargetRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSubscriptionTargetRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteSubscriptionTargetRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSubscriptionTarget operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSubscriptionTargetResponse deleteSubscriptionTarget(
            Consumer<DeleteSubscriptionTargetRequest.Builder> deleteSubscriptionTargetRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return deleteSubscriptionTarget(DeleteSubscriptionTargetRequest.builder().applyMutation(deleteSubscriptionTargetRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified time series form for the specified asset.
     * </p>
     *
     * @param deleteTimeSeriesDataPointsRequest
     * @return Result of the DeleteTimeSeriesDataPoints operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTimeSeriesDataPointsResponse deleteTimeSeriesDataPoints(
            DeleteTimeSeriesDataPointsRequest deleteTimeSeriesDataPointsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified time series form for the specified asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTimeSeriesDataPointsRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTimeSeriesDataPointsRequest#builder()}
     * </p>
     *
     * @param deleteTimeSeriesDataPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteTimeSeriesDataPointsRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteTimeSeriesDataPoints operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DeleteTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTimeSeriesDataPointsResponse deleteTimeSeriesDataPoints(
            Consumer<DeleteTimeSeriesDataPointsRequest.Builder> deleteTimeSeriesDataPointsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return deleteTimeSeriesDataPoints(DeleteTimeSeriesDataPointsRequest.builder()
                .applyMutation(deleteTimeSeriesDataPointsRequest).build());
    }

    /**
     * <p>
     * Disassociates the environment role in Amazon DataZone.
     * </p>
     *
     * @param disassociateEnvironmentRoleRequest
     * @return Result of the DisassociateEnvironmentRole operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DisassociateEnvironmentRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DisassociateEnvironmentRole"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateEnvironmentRoleResponse disassociateEnvironmentRole(
            DisassociateEnvironmentRoleRequest disassociateEnvironmentRoleRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the environment role in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateEnvironmentRoleRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateEnvironmentRoleRequest#builder()}
     * </p>
     *
     * @param disassociateEnvironmentRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DisassociateEnvironmentRoleRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateEnvironmentRole operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.DisassociateEnvironmentRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DisassociateEnvironmentRole"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateEnvironmentRoleResponse disassociateEnvironmentRole(
            Consumer<DisassociateEnvironmentRoleRequest.Builder> disassociateEnvironmentRoleRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return disassociateEnvironmentRole(DisassociateEnvironmentRoleRequest.builder()
                .applyMutation(disassociateEnvironmentRoleRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone asset.
     * </p>
     *
     * @param getAssetRequest
     * @return Result of the GetAsset operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAssetResponse getAsset(GetAssetRequest getAssetRequest) throws InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssetRequest#builder()}
     * </p>
     *
     * @param getAssetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetAssetRequest.Builder} to create a request.
     * @return Result of the GetAsset operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAssetResponse getAsset(Consumer<GetAssetRequest.Builder> getAssetRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return getAsset(GetAssetRequest.builder().applyMutation(getAssetRequest).build());
    }

    /**
     * <p>
     * Gets an asset filter.
     * </p>
     *
     * @param getAssetFilterRequest
     * @return Result of the GetAssetFilter operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetAssetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAssetFilterResponse getAssetFilter(GetAssetFilterRequest getAssetFilterRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an asset filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetFilterRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssetFilterRequest#builder()}
     * </p>
     *
     * @param getAssetFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetAssetFilterRequest.Builder} to create a request.
     * @return Result of the GetAssetFilter operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetAssetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAssetFilterResponse getAssetFilter(Consumer<GetAssetFilterRequest.Builder> getAssetFilterRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getAssetFilter(GetAssetFilterRequest.builder().applyMutation(getAssetFilterRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone asset type.
     * </p>
     *
     * @param getAssetTypeRequest
     * @return Result of the GetAssetType operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAssetTypeResponse getAssetType(GetAssetTypeRequest getAssetTypeRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone asset type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetTypeRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssetTypeRequest#builder()}
     * </p>
     *
     * @param getAssetTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetAssetTypeRequest.Builder} to create a request.
     * @return Result of the GetAssetType operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAssetTypeResponse getAssetType(Consumer<GetAssetTypeRequest.Builder> getAssetTypeRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getAssetType(GetAssetTypeRequest.builder().applyMutation(getAssetTypeRequest).build());
    }

    /**
     * <p>
     * Gets a connection. In Amazon DataZone, a connection enables you to connect your resources (domains, projects, and
     * environments) to external resources and services.
     * </p>
     *
     * @param getConnectionRequest
     * @return Result of the GetConnection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionResponse getConnection(GetConnectionRequest getConnectionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a connection. In Amazon DataZone, a connection enables you to connect your resources (domains, projects, and
     * environments) to external resources and services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionRequest#builder()}
     * </p>
     *
     * @param getConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetConnectionRequest.Builder} to create a request.
     * @return Result of the GetConnection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionResponse getConnection(Consumer<GetConnectionRequest.Builder> getConnectionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getConnection(GetConnectionRequest.builder().applyMutation(getConnectionRequest).build());
    }

    /**
     * <p>
     * Gets the data product.
     * </p>
     *
     * @param getDataProductRequest
     * @return Result of the GetDataProduct operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetDataProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataProduct" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataProductResponse getDataProduct(GetDataProductRequest getDataProductRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the data product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataProductRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataProductRequest#builder()}
     * </p>
     *
     * @param getDataProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetDataProductRequest.Builder} to create a request.
     * @return Result of the GetDataProduct operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetDataProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataProduct" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataProductResponse getDataProduct(Consumer<GetDataProductRequest.Builder> getDataProductRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getDataProduct(GetDataProductRequest.builder().applyMutation(getDataProductRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone data source.
     * </p>
     *
     * @param getDataSourceRequest
     * @return Result of the GetDataSource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataSourceResponse getDataSource(GetDataSourceRequest getDataSourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataSourceRequest#builder()}
     * </p>
     *
     * @param getDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetDataSourceRequest.Builder} to create a request.
     * @return Result of the GetDataSource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataSourceResponse getDataSource(Consumer<GetDataSourceRequest.Builder> getDataSourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return getDataSource(GetDataSourceRequest.builder().applyMutation(getDataSourceRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone data source run.
     * </p>
     *
     * @param getDataSourceRunRequest
     * @return Result of the GetDataSourceRun operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetDataSourceRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSourceRun" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataSourceRunResponse getDataSourceRun(GetDataSourceRunRequest getDataSourceRunRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone data source run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceRunRequest.Builder} avoiding the need
     * to create one manually via {@link GetDataSourceRunRequest#builder()}
     * </p>
     *
     * @param getDataSourceRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetDataSourceRunRequest.Builder} to create a
     *        request.
     * @return Result of the GetDataSourceRun operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetDataSourceRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSourceRun" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataSourceRunResponse getDataSourceRun(Consumer<GetDataSourceRunRequest.Builder> getDataSourceRunRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return getDataSourceRun(GetDataSourceRunRequest.builder().applyMutation(getDataSourceRunRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone domain.
     * </p>
     *
     * @param getDomainRequest
     * @return Result of the GetDomain operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDomainResponse getDomain(GetDomainRequest getDomainRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainRequest#builder()}
     * </p>
     *
     * @param getDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetDomainRequest.Builder} to create a request.
     * @return Result of the GetDomain operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDomainResponse getDomain(Consumer<GetDomainRequest.Builder> getDomainRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getDomain(GetDomainRequest.builder().applyMutation(getDomainRequest).build());
    }

    /**
     * <p>
     * Gets the details of the specified domain unit.
     * </p>
     *
     * @param getDomainUnitRequest
     * @return Result of the GetDomainUnit operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetDomainUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDomainUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDomainUnitResponse getDomainUnit(GetDomainUnitRequest getDomainUnitRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of the specified domain unit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainUnitRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainUnitRequest#builder()}
     * </p>
     *
     * @param getDomainUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetDomainUnitRequest.Builder} to create a request.
     * @return Result of the GetDomainUnit operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetDomainUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDomainUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDomainUnitResponse getDomainUnit(Consumer<GetDomainUnitRequest.Builder> getDomainUnitRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getDomainUnit(GetDomainUnitRequest.builder().applyMutation(getDomainUnitRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone environment.
     * </p>
     *
     * @param getEnvironmentRequest
     * @return Result of the GetEnvironment operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEnvironmentResponse getEnvironment(GetEnvironmentRequest getEnvironmentRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetEnvironmentRequest#builder()}
     * </p>
     *
     * @param getEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentRequest.Builder} to create a request.
     * @return Result of the GetEnvironment operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEnvironmentResponse getEnvironment(Consumer<GetEnvironmentRequest.Builder> getEnvironmentRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getEnvironment(GetEnvironmentRequest.builder().applyMutation(getEnvironmentRequest).build());
    }

    /**
     * <p>
     * Gets the specified environment action.
     * </p>
     *
     * @param getEnvironmentActionRequest
     * @return Result of the GetEnvironmentAction operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetEnvironmentAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentAction" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEnvironmentActionResponse getEnvironmentAction(GetEnvironmentActionRequest getEnvironmentActionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified environment action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentActionRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnvironmentActionRequest#builder()}
     * </p>
     *
     * @param getEnvironmentActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentActionRequest.Builder} to create a
     *        request.
     * @return Result of the GetEnvironmentAction operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetEnvironmentAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentAction" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEnvironmentActionResponse getEnvironmentAction(
            Consumer<GetEnvironmentActionRequest.Builder> getEnvironmentActionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return getEnvironmentAction(GetEnvironmentActionRequest.builder().applyMutation(getEnvironmentActionRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone blueprint.
     * </p>
     *
     * @param getEnvironmentBlueprintRequest
     * @return Result of the GetEnvironmentBlueprint operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetEnvironmentBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnvironmentBlueprintResponse getEnvironmentBlueprint(GetEnvironmentBlueprintRequest getEnvironmentBlueprintRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone blueprint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentBlueprintRequest.Builder} avoiding
     * the need to create one manually via {@link GetEnvironmentBlueprintRequest#builder()}
     * </p>
     *
     * @param getEnvironmentBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintRequest.Builder} to create a
     *        request.
     * @return Result of the GetEnvironmentBlueprint operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetEnvironmentBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnvironmentBlueprintResponse getEnvironmentBlueprint(
            Consumer<GetEnvironmentBlueprintRequest.Builder> getEnvironmentBlueprintRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return getEnvironmentBlueprint(GetEnvironmentBlueprintRequest.builder().applyMutation(getEnvironmentBlueprintRequest)
                .build());
    }

    /**
     * <p>
     * Gets the blueprint configuration in Amazon DataZone.
     * </p>
     *
     * @param getEnvironmentBlueprintConfigurationRequest
     * @return Result of the GetEnvironmentBlueprintConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetEnvironmentBlueprintConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnvironmentBlueprintConfigurationResponse getEnvironmentBlueprintConfiguration(
            GetEnvironmentBlueprintConfigurationRequest getEnvironmentBlueprintConfigurationRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the blueprint configuration in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEnvironmentBlueprintConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetEnvironmentBlueprintConfigurationRequest#builder()}
     * </p>
     *
     * @param getEnvironmentBlueprintConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the GetEnvironmentBlueprintConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetEnvironmentBlueprintConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnvironmentBlueprintConfigurationResponse getEnvironmentBlueprintConfiguration(
            Consumer<GetEnvironmentBlueprintConfigurationRequest.Builder> getEnvironmentBlueprintConfigurationRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getEnvironmentBlueprintConfiguration(GetEnvironmentBlueprintConfigurationRequest.builder()
                .applyMutation(getEnvironmentBlueprintConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets the credentials of an environment in Amazon DataZone.
     * </p>
     *
     * @param getEnvironmentCredentialsRequest
     * @return Result of the GetEnvironmentCredentials operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetEnvironmentCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnvironmentCredentialsResponse getEnvironmentCredentials(
            GetEnvironmentCredentialsRequest getEnvironmentCredentialsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the credentials of an environment in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentCredentialsRequest.Builder} avoiding
     * the need to create one manually via {@link GetEnvironmentCredentialsRequest#builder()}
     * </p>
     *
     * @param getEnvironmentCredentialsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentCredentialsRequest.Builder} to create
     *        a request.
     * @return Result of the GetEnvironmentCredentials operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetEnvironmentCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnvironmentCredentialsResponse getEnvironmentCredentials(
            Consumer<GetEnvironmentCredentialsRequest.Builder> getEnvironmentCredentialsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return getEnvironmentCredentials(GetEnvironmentCredentialsRequest.builder()
                .applyMutation(getEnvironmentCredentialsRequest).build());
    }

    /**
     * <p>
     * Gets an evinronment profile in Amazon DataZone.
     * </p>
     *
     * @param getEnvironmentProfileRequest
     * @return Result of the GetEnvironmentProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnvironmentProfileResponse getEnvironmentProfile(GetEnvironmentProfileRequest getEnvironmentProfileRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an evinronment profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentProfileRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnvironmentProfileRequest#builder()}
     * </p>
     *
     * @param getEnvironmentProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileRequest.Builder} to create a
     *        request.
     * @return Result of the GetEnvironmentProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnvironmentProfileResponse getEnvironmentProfile(
            Consumer<GetEnvironmentProfileRequest.Builder> getEnvironmentProfileRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return getEnvironmentProfile(GetEnvironmentProfileRequest.builder().applyMutation(getEnvironmentProfileRequest).build());
    }

    /**
     * <p>
     * Gets a metadata form type in Amazon DataZone.
     * </p>
     *
     * @param getFormTypeRequest
     * @return Result of the GetFormType operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFormTypeResponse getFormType(GetFormTypeRequest getFormTypeRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a metadata form type in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFormTypeRequest.Builder} avoiding the need to
     * create one manually via {@link GetFormTypeRequest#builder()}
     * </p>
     *
     * @param getFormTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetFormTypeRequest.Builder} to create a request.
     * @return Result of the GetFormType operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFormTypeResponse getFormType(Consumer<GetFormTypeRequest.Builder> getFormTypeRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getFormType(GetFormTypeRequest.builder().applyMutation(getFormTypeRequest).build());
    }

    /**
     * <p>
     * Gets a business glossary in Amazon DataZone.
     * </p>
     *
     * @param getGlossaryRequest
     * @return Result of the GetGlossary operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGlossaryResponse getGlossary(GetGlossaryRequest getGlossaryRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a business glossary in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGlossaryRequest.Builder} avoiding the need to
     * create one manually via {@link GetGlossaryRequest#builder()}
     * </p>
     *
     * @param getGlossaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetGlossaryRequest.Builder} to create a request.
     * @return Result of the GetGlossary operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGlossaryResponse getGlossary(Consumer<GetGlossaryRequest.Builder> getGlossaryRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getGlossary(GetGlossaryRequest.builder().applyMutation(getGlossaryRequest).build());
    }

    /**
     * <p>
     * Gets a business glossary term in Amazon DataZone.
     * </p>
     *
     * @param getGlossaryTermRequest
     * @return Result of the GetGlossaryTerm operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossaryTerm" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGlossaryTermResponse getGlossaryTerm(GetGlossaryTermRequest getGlossaryTermRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a business glossary term in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGlossaryTermRequest.Builder} avoiding the need
     * to create one manually via {@link GetGlossaryTermRequest#builder()}
     * </p>
     *
     * @param getGlossaryTermRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetGlossaryTermRequest.Builder} to create a request.
     * @return Result of the GetGlossaryTerm operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossaryTerm" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGlossaryTermResponse getGlossaryTerm(Consumer<GetGlossaryTermRequest.Builder> getGlossaryTermRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getGlossaryTerm(GetGlossaryTermRequest.builder().applyMutation(getGlossaryTermRequest).build());
    }

    /**
     * <p>
     * Gets a group profile in Amazon DataZone.
     * </p>
     *
     * @param getGroupProfileRequest
     * @return Result of the GetGroupProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGroupProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupProfileResponse getGroupProfile(GetGroupProfileRequest getGroupProfileRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a group profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetGroupProfileRequest#builder()}
     * </p>
     *
     * @param getGroupProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetGroupProfileRequest.Builder} to create a request.
     * @return Result of the GetGroupProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGroupProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupProfileResponse getGroupProfile(Consumer<GetGroupProfileRequest.Builder> getGroupProfileRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getGroupProfile(GetGroupProfileRequest.builder().applyMutation(getGroupProfileRequest).build());
    }

    /**
     * <p>
     * Gets the data portal URL for the specified Amazon DataZone domain.
     * </p>
     *
     * @param getIamPortalLoginUrlRequest
     * @return Result of the GetIamPortalLoginUrl operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetIamPortalLoginUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetIamPortalLoginUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default GetIamPortalLoginUrlResponse getIamPortalLoginUrl(GetIamPortalLoginUrlRequest getIamPortalLoginUrlRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the data portal URL for the specified Amazon DataZone domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIamPortalLoginUrlRequest.Builder} avoiding the
     * need to create one manually via {@link GetIamPortalLoginUrlRequest#builder()}
     * </p>
     *
     * @param getIamPortalLoginUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlRequest.Builder} to create a
     *        request.
     * @return Result of the GetIamPortalLoginUrl operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetIamPortalLoginUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetIamPortalLoginUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default GetIamPortalLoginUrlResponse getIamPortalLoginUrl(
            Consumer<GetIamPortalLoginUrlRequest.Builder> getIamPortalLoginUrlRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getIamPortalLoginUrl(GetIamPortalLoginUrlRequest.builder().applyMutation(getIamPortalLoginUrlRequest).build());
    }

    /**
     * <p>
     * The details of the job run.
     * </p>
     *
     * @param getJobRunRequest
     * @return Result of the GetJobRun operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobRunResponse getJobRun(GetJobRunRequest getJobRunRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The details of the job run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRunRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobRunRequest#builder()}
     * </p>
     *
     * @param getJobRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetJobRunRequest.Builder} to create a request.
     * @return Result of the GetJobRun operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobRunResponse getJobRun(Consumer<GetJobRunRequest.Builder> getJobRunRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return getJobRun(GetJobRunRequest.builder().applyMutation(getJobRunRequest).build());
    }

    /**
     * <p>
     * Describes the lineage event.
     * </p>
     *
     * @param getLineageEventRequest
     * @return Result of the GetLineageEvent operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetLineageEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetLineageEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLineageEventResponse getLineageEvent(GetLineageEventRequest getLineageEventRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the lineage event.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLineageEventRequest.Builder} avoiding the need
     * to create one manually via {@link GetLineageEventRequest#builder()}
     * </p>
     *
     * @param getLineageEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetLineageEventRequest.Builder} to create a request.
     * @return Result of the GetLineageEvent operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetLineageEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetLineageEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLineageEventResponse getLineageEvent(Consumer<GetLineageEventRequest.Builder> getLineageEventRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getLineageEvent(GetLineageEventRequest.builder().applyMutation(getLineageEventRequest).build());
    }

    /**
     * <p>
     * Gets the data lineage node.
     * </p>
     *
     * @param getLineageNodeRequest
     * @return Result of the GetLineageNode operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetLineageNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetLineageNode" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLineageNodeResponse getLineageNode(GetLineageNodeRequest getLineageNodeRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the data lineage node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLineageNodeRequest.Builder} avoiding the need to
     * create one manually via {@link GetLineageNodeRequest#builder()}
     * </p>
     *
     * @param getLineageNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetLineageNodeRequest.Builder} to create a request.
     * @return Result of the GetLineageNode operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetLineageNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetLineageNode" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLineageNodeResponse getLineageNode(Consumer<GetLineageNodeRequest.Builder> getLineageNodeRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getLineageNode(GetLineageNodeRequest.builder().applyMutation(getLineageNodeRequest).build());
    }

    /**
     * <p>
     * Gets a listing (a record of an asset at a given time). If you specify a listing version, only details that are
     * specific to that version are returned.
     * </p>
     *
     * @param getListingRequest
     * @return Result of the GetListing operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetListing" target="_top">AWS API
     *      Documentation</a>
     */
    default GetListingResponse getListing(GetListingRequest getListingRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a listing (a record of an asset at a given time). If you specify a listing version, only details that are
     * specific to that version are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetListingRequest.Builder} avoiding the need to
     * create one manually via {@link GetListingRequest#builder()}
     * </p>
     *
     * @param getListingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetListingRequest.Builder} to create a request.
     * @return Result of the GetListing operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetListing" target="_top">AWS API
     *      Documentation</a>
     */
    default GetListingResponse getListing(Consumer<GetListingRequest.Builder> getListingRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return getListing(GetListingRequest.builder().applyMutation(getListingRequest).build());
    }

    /**
     * <p>
     * Gets a metadata generation run in Amazon DataZone.
     * </p>
     *
     * @param getMetadataGenerationRunRequest
     * @return Result of the GetMetadataGenerationRun operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMetadataGenerationRunResponse getMetadataGenerationRun(
            GetMetadataGenerationRunRequest getMetadataGenerationRunRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a metadata generation run in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetadataGenerationRunRequest.Builder} avoiding
     * the need to create one manually via {@link GetMetadataGenerationRunRequest#builder()}
     * </p>
     *
     * @param getMetadataGenerationRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetMetadataGenerationRunRequest.Builder} to create a
     *        request.
     * @return Result of the GetMetadataGenerationRun operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMetadataGenerationRunResponse getMetadataGenerationRun(
            Consumer<GetMetadataGenerationRunRequest.Builder> getMetadataGenerationRunRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return getMetadataGenerationRun(GetMetadataGenerationRunRequest.builder().applyMutation(getMetadataGenerationRunRequest)
                .build());
    }

    /**
     * <p>
     * Gets a project in Amazon DataZone.
     * </p>
     *
     * @param getProjectRequest
     * @return Result of the GetProject operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProjectResponse getProject(GetProjectRequest getProjectRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a project in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProjectRequest.Builder} avoiding the need to
     * create one manually via {@link GetProjectRequest#builder()}
     * </p>
     *
     * @param getProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetProjectRequest.Builder} to create a request.
     * @return Result of the GetProject operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProjectResponse getProject(Consumer<GetProjectRequest.Builder> getProjectRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return getProject(GetProjectRequest.builder().applyMutation(getProjectRequest).build());
    }

    /**
     * <p>
     * The details of the project profile.
     * </p>
     *
     * @param getProjectProfileRequest
     * @return Result of the GetProjectProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetProjectProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetProjectProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProjectProfileResponse getProjectProfile(GetProjectProfileRequest getProjectProfileRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The details of the project profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProjectProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetProjectProfileRequest#builder()}
     * </p>
     *
     * @param getProjectProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetProjectProfileRequest.Builder} to create a
     *        request.
     * @return Result of the GetProjectProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetProjectProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetProjectProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProjectProfileResponse getProjectProfile(Consumer<GetProjectProfileRequest.Builder> getProjectProfileRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getProjectProfile(GetProjectProfileRequest.builder().applyMutation(getProjectProfileRequest).build());
    }

    /**
     * <p>
     * Gets the details of a rule in Amazon DataZone. A rule is a formal agreement that enforces specific requirements
     * across user workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects)
     * within the Amazon DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold
     * governance standards in data management processes. For instance, a metadata enforcement rule can specify the
     * required information for creating a subscription request or publishing a data asset to the catalog, ensuring
     * alignment with organizational standards.
     * </p>
     *
     * @param getRuleRequest
     * @return Result of the GetRule operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetRule" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRuleResponse getRule(GetRuleRequest getRuleRequest) throws InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a rule in Amazon DataZone. A rule is a formal agreement that enforces specific requirements
     * across user workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects)
     * within the Amazon DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold
     * governance standards in data management processes. For instance, a metadata enforcement rule can specify the
     * required information for creating a subscription request or publishing a data asset to the catalog, ensuring
     * alignment with organizational standards.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRuleRequest.Builder} avoiding the need to create
     * one manually via {@link GetRuleRequest#builder()}
     * </p>
     *
     * @param getRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetRuleRequest.Builder} to create a request.
     * @return Result of the GetRule operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetRule" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRuleResponse getRule(Consumer<GetRuleRequest.Builder> getRuleRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return getRule(GetRuleRequest.builder().applyMutation(getRuleRequest).build());
    }

    /**
     * <p>
     * Gets a subscription in Amazon DataZone.
     * </p>
     *
     * @param getSubscriptionRequest
     * @return Result of the GetSubscription operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSubscriptionResponse getSubscription(GetSubscriptionRequest getSubscriptionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a subscription in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionRequest.Builder} avoiding the need
     * to create one manually via {@link GetSubscriptionRequest#builder()}
     * </p>
     *
     * @param getSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetSubscriptionRequest.Builder} to create a request.
     * @return Result of the GetSubscription operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSubscriptionResponse getSubscription(Consumer<GetSubscriptionRequest.Builder> getSubscriptionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getSubscription(GetSubscriptionRequest.builder().applyMutation(getSubscriptionRequest).build());
    }

    /**
     * <p>
     * Gets the subscription grant in Amazon DataZone.
     * </p>
     *
     * @param getSubscriptionGrantRequest
     * @return Result of the GetSubscriptionGrant operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSubscriptionGrantResponse getSubscriptionGrant(GetSubscriptionGrantRequest getSubscriptionGrantRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the subscription grant in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionGrantRequest.Builder} avoiding the
     * need to create one manually via {@link GetSubscriptionGrantRequest#builder()}
     * </p>
     *
     * @param getSubscriptionGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantRequest.Builder} to create a
     *        request.
     * @return Result of the GetSubscriptionGrant operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSubscriptionGrantResponse getSubscriptionGrant(
            Consumer<GetSubscriptionGrantRequest.Builder> getSubscriptionGrantRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return getSubscriptionGrant(GetSubscriptionGrantRequest.builder().applyMutation(getSubscriptionGrantRequest).build());
    }

    /**
     * <p>
     * Gets the details of the specified subscription request.
     * </p>
     *
     * @param getSubscriptionRequestDetailsRequest
     * @return Result of the GetSubscriptionRequestDetails operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetSubscriptionRequestDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionRequestDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSubscriptionRequestDetailsResponse getSubscriptionRequestDetails(
            GetSubscriptionRequestDetailsRequest getSubscriptionRequestDetailsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of the specified subscription request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionRequestDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetSubscriptionRequestDetailsRequest#builder()}
     * </p>
     *
     * @param getSubscriptionRequestDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsRequest.Builder} to
     *        create a request.
     * @return Result of the GetSubscriptionRequestDetails operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetSubscriptionRequestDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionRequestDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSubscriptionRequestDetailsResponse getSubscriptionRequestDetails(
            Consumer<GetSubscriptionRequestDetailsRequest.Builder> getSubscriptionRequestDetailsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getSubscriptionRequestDetails(GetSubscriptionRequestDetailsRequest.builder()
                .applyMutation(getSubscriptionRequestDetailsRequest).build());
    }

    /**
     * <p>
     * Gets the subscription target in Amazon DataZone.
     * </p>
     *
     * @param getSubscriptionTargetRequest
     * @return Result of the GetSubscriptionTarget operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSubscriptionTargetResponse getSubscriptionTarget(GetSubscriptionTargetRequest getSubscriptionTargetRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the subscription target in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link GetSubscriptionTargetRequest#builder()}
     * </p>
     *
     * @param getSubscriptionTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetRequest.Builder} to create a
     *        request.
     * @return Result of the GetSubscriptionTarget operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSubscriptionTargetResponse getSubscriptionTarget(
            Consumer<GetSubscriptionTargetRequest.Builder> getSubscriptionTargetRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return getSubscriptionTarget(GetSubscriptionTargetRequest.builder().applyMutation(getSubscriptionTargetRequest).build());
    }

    /**
     * <p>
     * Gets the existing data point for the asset.
     * </p>
     *
     * @param getTimeSeriesDataPointRequest
     * @return Result of the GetTimeSeriesDataPoint operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetTimeSeriesDataPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetTimeSeriesDataPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTimeSeriesDataPointResponse getTimeSeriesDataPoint(GetTimeSeriesDataPointRequest getTimeSeriesDataPointRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the existing data point for the asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTimeSeriesDataPointRequest.Builder} avoiding the
     * need to create one manually via {@link GetTimeSeriesDataPointRequest#builder()}
     * </p>
     *
     * @param getTimeSeriesDataPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetTimeSeriesDataPointRequest.Builder} to create a
     *        request.
     * @return Result of the GetTimeSeriesDataPoint operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetTimeSeriesDataPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetTimeSeriesDataPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTimeSeriesDataPointResponse getTimeSeriesDataPoint(
            Consumer<GetTimeSeriesDataPointRequest.Builder> getTimeSeriesDataPointRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return getTimeSeriesDataPoint(GetTimeSeriesDataPointRequest.builder().applyMutation(getTimeSeriesDataPointRequest)
                .build());
    }

    /**
     * <p>
     * Gets a user profile in Amazon DataZone.
     * </p>
     *
     * @param getUserProfileRequest
     * @return Result of the GetUserProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetUserProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUserProfileResponse getUserProfile(GetUserProfileRequest getUserProfileRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a user profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserProfileRequest.Builder} avoiding the need to
     * create one manually via {@link GetUserProfileRequest#builder()}
     * </p>
     *
     * @param getUserProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetUserProfileRequest.Builder} to create a request.
     * @return Result of the GetUserProfile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.GetUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetUserProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUserProfileResponse getUserProfile(Consumer<GetUserProfileRequest.Builder> getUserProfileRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return getUserProfile(GetUserProfileRequest.builder().applyMutation(getUserProfileRequest).build());
    }

    /**
     * <p>
     * Lists asset filters.
     * </p>
     *
     * @param listAssetFiltersRequest
     * @return Result of the ListAssetFilters operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListAssetFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetFiltersResponse listAssetFilters(ListAssetFiltersRequest listAssetFiltersRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists asset filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetFiltersRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssetFiltersRequest#builder()}
     * </p>
     *
     * @param listAssetFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssetFilters operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListAssetFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetFiltersResponse listAssetFilters(Consumer<ListAssetFiltersRequest.Builder> listAssetFiltersRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listAssetFilters(ListAssetFiltersRequest.builder().applyMutation(listAssetFiltersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetFilters(software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetFiltersIterable responses = client.listAssetFiltersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListAssetFiltersIterable responses = client
     *             .listAssetFiltersPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListAssetFiltersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetFiltersIterable responses = client.listAssetFiltersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetFilters(software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest)} operation.</b>
     * </p>
     *
     * @param listAssetFiltersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListAssetFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetFiltersIterable listAssetFiltersPaginator(ListAssetFiltersRequest listAssetFiltersRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new ListAssetFiltersIterable(this, listAssetFiltersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetFilters(software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetFiltersIterable responses = client.listAssetFiltersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListAssetFiltersIterable responses = client
     *             .listAssetFiltersPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListAssetFiltersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetFiltersIterable responses = client.listAssetFiltersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetFilters(software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetFiltersRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssetFiltersRequest#builder()}
     * </p>
     *
     * @param listAssetFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListAssetFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetFiltersIterable listAssetFiltersPaginator(Consumer<ListAssetFiltersRequest.Builder> listAssetFiltersRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listAssetFiltersPaginator(ListAssetFiltersRequest.builder().applyMutation(listAssetFiltersRequest).build());
    }

    /**
     * <p>
     * Lists the revisions for the asset.
     * </p>
     *
     * @param listAssetRevisionsRequest
     * @return Result of the ListAssetRevisions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListAssetRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetRevisionsResponse listAssetRevisions(ListAssetRevisionsRequest listAssetRevisionsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the revisions for the asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetRevisionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetRevisionsRequest#builder()}
     * </p>
     *
     * @param listAssetRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssetRevisions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListAssetRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetRevisionsResponse listAssetRevisions(Consumer<ListAssetRevisionsRequest.Builder> listAssetRevisionsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listAssetRevisions(ListAssetRevisionsRequest.builder().applyMutation(listAssetRevisionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetRevisions(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsIterable responses = client.listAssetRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsIterable responses = client
     *             .listAssetRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsIterable responses = client.listAssetRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetRevisions(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssetRevisionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListAssetRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetRevisionsIterable listAssetRevisionsPaginator(ListAssetRevisionsRequest listAssetRevisionsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new ListAssetRevisionsIterable(this, listAssetRevisionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetRevisions(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsIterable responses = client.listAssetRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsIterable responses = client
     *             .listAssetRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsIterable responses = client.listAssetRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetRevisions(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetRevisionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetRevisionsRequest#builder()}
     * </p>
     *
     * @param listAssetRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListAssetRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetRevisionsIterable listAssetRevisionsPaginator(
            Consumer<ListAssetRevisionsRequest.Builder> listAssetRevisionsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listAssetRevisionsPaginator(ListAssetRevisionsRequest.builder().applyMutation(listAssetRevisionsRequest).build());
    }

    /**
     * <p>
     * Lists connections. In Amazon DataZone, a connection enables you to connect your resources (domains, projects, and
     * environments) to external resources and services.
     * </p>
     *
     * @param listConnectionsRequest
     * @return Result of the ListConnections operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectionsResponse listConnections(ListConnectionsRequest listConnectionsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists connections. In Amazon DataZone, a connection enables you to connect your resources (domains, projects, and
     * environments) to external resources and services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListConnectionsRequest#builder()}
     * </p>
     *
     * @param listConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListConnectionsRequest.Builder} to create a request.
     * @return Result of the ListConnections operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectionsResponse listConnections(Consumer<ListConnectionsRequest.Builder> listConnectionsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listConnections(ListConnectionsRequest.builder().applyMutation(listConnectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnections(software.amazon.awssdk.services.datazone.model.ListConnectionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListConnectionsIterable responses = client.listConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListConnectionsIterable responses = client
     *             .listConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListConnectionsIterable responses = client.listConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnections(software.amazon.awssdk.services.datazone.model.ListConnectionsRequest)} operation.</b>
     * </p>
     *
     * @param listConnectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectionsIterable listConnectionsPaginator(ListConnectionsRequest listConnectionsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new ListConnectionsIterable(this, listConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnections(software.amazon.awssdk.services.datazone.model.ListConnectionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListConnectionsIterable responses = client.listConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListConnectionsIterable responses = client
     *             .listConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListConnectionsIterable responses = client.listConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnections(software.amazon.awssdk.services.datazone.model.ListConnectionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListConnectionsRequest#builder()}
     * </p>
     *
     * @param listConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListConnectionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectionsIterable listConnectionsPaginator(Consumer<ListConnectionsRequest.Builder> listConnectionsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listConnectionsPaginator(ListConnectionsRequest.builder().applyMutation(listConnectionsRequest).build());
    }

    /**
     * <p>
     * Lists data product revisions.
     * </p>
     *
     * @param listDataProductRevisionsRequest
     * @return Result of the ListDataProductRevisions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataProductRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataProductRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataProductRevisionsResponse listDataProductRevisions(
            ListDataProductRevisionsRequest listDataProductRevisionsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data product revisions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataProductRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataProductRevisionsRequest#builder()}
     * </p>
     *
     * @param listDataProductRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDataProductRevisions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataProductRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataProductRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataProductRevisionsResponse listDataProductRevisions(
            Consumer<ListDataProductRevisionsRequest.Builder> listDataProductRevisionsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listDataProductRevisions(ListDataProductRevisionsRequest.builder().applyMutation(listDataProductRevisionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataProductRevisions(software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataProductRevisionsIterable responses = client.listDataProductRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListDataProductRevisionsIterable responses = client
     *             .listDataProductRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataProductRevisionsIterable responses = client.listDataProductRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataProductRevisions(software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataProductRevisionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataProductRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataProductRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataProductRevisionsIterable listDataProductRevisionsPaginator(
            ListDataProductRevisionsRequest listDataProductRevisionsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return new ListDataProductRevisionsIterable(this, listDataProductRevisionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataProductRevisions(software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataProductRevisionsIterable responses = client.listDataProductRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListDataProductRevisionsIterable responses = client
     *             .listDataProductRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataProductRevisionsIterable responses = client.listDataProductRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataProductRevisions(software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataProductRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataProductRevisionsRequest#builder()}
     * </p>
     *
     * @param listDataProductRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataProductRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataProductRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataProductRevisionsIterable listDataProductRevisionsPaginator(
            Consumer<ListDataProductRevisionsRequest.Builder> listDataProductRevisionsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listDataProductRevisionsPaginator(ListDataProductRevisionsRequest.builder()
                .applyMutation(listDataProductRevisionsRequest).build());
    }

    /**
     * <p>
     * Lists data source run activities.
     * </p>
     *
     * @param listDataSourceRunActivitiesRequest
     * @return Result of the ListDataSourceRunActivities operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataSourceRunActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceRunActivitiesResponse listDataSourceRunActivities(
            ListDataSourceRunActivitiesRequest listDataSourceRunActivitiesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data source run activities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceRunActivitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataSourceRunActivitiesRequest#builder()}
     * </p>
     *
     * @param listDataSourceRunActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest.Builder} to
     *        create a request.
     * @return Result of the ListDataSourceRunActivities operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataSourceRunActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceRunActivitiesResponse listDataSourceRunActivities(
            Consumer<ListDataSourceRunActivitiesRequest.Builder> listDataSourceRunActivitiesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listDataSourceRunActivities(ListDataSourceRunActivitiesRequest.builder()
                .applyMutation(listDataSourceRunActivitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceRunActivities(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesIterable responses = client.listDataSourceRunActivitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesIterable responses = client
     *             .listDataSourceRunActivitiesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesIterable responses = client.listDataSourceRunActivitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceRunActivities(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataSourceRunActivitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataSourceRunActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceRunActivitiesIterable listDataSourceRunActivitiesPaginator(
            ListDataSourceRunActivitiesRequest listDataSourceRunActivitiesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return new ListDataSourceRunActivitiesIterable(this, listDataSourceRunActivitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceRunActivities(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesIterable responses = client.listDataSourceRunActivitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesIterable responses = client
     *             .listDataSourceRunActivitiesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesIterable responses = client.listDataSourceRunActivitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceRunActivities(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceRunActivitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataSourceRunActivitiesRequest#builder()}
     * </p>
     *
     * @param listDataSourceRunActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataSourceRunActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceRunActivitiesIterable listDataSourceRunActivitiesPaginator(
            Consumer<ListDataSourceRunActivitiesRequest.Builder> listDataSourceRunActivitiesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listDataSourceRunActivitiesPaginator(ListDataSourceRunActivitiesRequest.builder()
                .applyMutation(listDataSourceRunActivitiesRequest).build());
    }

    /**
     * <p>
     * Lists data source runs in Amazon DataZone.
     * </p>
     *
     * @param listDataSourceRunsRequest
     * @return Result of the ListDataSourceRuns operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataSourceRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceRunsResponse listDataSourceRuns(ListDataSourceRunsRequest listDataSourceRunsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data source runs in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceRunsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceRunsRequest#builder()}
     * </p>
     *
     * @param listDataSourceRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDataSourceRuns operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataSourceRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceRunsResponse listDataSourceRuns(Consumer<ListDataSourceRunsRequest.Builder> listDataSourceRunsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listDataSourceRuns(ListDataSourceRunsRequest.builder().applyMutation(listDataSourceRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceRuns(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsIterable responses = client.listDataSourceRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsIterable responses = client
     *             .listDataSourceRunsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsIterable responses = client.listDataSourceRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceRuns(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataSourceRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataSourceRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceRunsIterable listDataSourceRunsPaginator(ListDataSourceRunsRequest listDataSourceRunsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return new ListDataSourceRunsIterable(this, listDataSourceRunsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceRuns(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsIterable responses = client.listDataSourceRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsIterable responses = client
     *             .listDataSourceRunsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsIterable responses = client.listDataSourceRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceRuns(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceRunsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceRunsRequest#builder()}
     * </p>
     *
     * @param listDataSourceRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataSourceRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceRunsIterable listDataSourceRunsPaginator(
            Consumer<ListDataSourceRunsRequest.Builder> listDataSourceRunsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return listDataSourceRunsPaginator(ListDataSourceRunsRequest.builder().applyMutation(listDataSourceRunsRequest).build());
    }

    /**
     * <p>
     * Lists data sources in Amazon DataZone.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return Result of the ListDataSources operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data sources in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest.Builder} to create a request.
     * @return Result of the ListDataSources operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesResponse listDataSources(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listDataSources(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListDataSourcesIterable responses = client
     *             .listDataSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesIterable listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return new ListDataSourcesIterable(this, listDataSourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListDataSourcesIterable responses = client
     *             .listDataSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesIterable listDataSourcesPaginator(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listDataSourcesPaginator(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * Lists child domain units for the specified parent domain unit.
     * </p>
     *
     * @param listDomainUnitsForParentRequest
     * @return Result of the ListDomainUnitsForParent operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDomainUnitsForParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomainUnitsForParent"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainUnitsForParentResponse listDomainUnitsForParent(
            ListDomainUnitsForParentRequest listDomainUnitsForParentRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists child domain units for the specified parent domain unit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainUnitsForParentRequest.Builder} avoiding
     * the need to create one manually via {@link ListDomainUnitsForParentRequest#builder()}
     * </p>
     *
     * @param listDomainUnitsForParentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest.Builder} to create a
     *        request.
     * @return Result of the ListDomainUnitsForParent operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDomainUnitsForParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomainUnitsForParent"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainUnitsForParentResponse listDomainUnitsForParent(
            Consumer<ListDomainUnitsForParentRequest.Builder> listDomainUnitsForParentRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listDomainUnitsForParent(ListDomainUnitsForParentRequest.builder().applyMutation(listDomainUnitsForParentRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainUnitsForParent(software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainUnitsForParentIterable responses = client.listDomainUnitsForParentPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListDomainUnitsForParentIterable responses = client
     *             .listDomainUnitsForParentPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainUnitsForParentIterable responses = client.listDomainUnitsForParentPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainUnitsForParent(software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDomainUnitsForParentRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDomainUnitsForParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomainUnitsForParent"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainUnitsForParentIterable listDomainUnitsForParentPaginator(
            ListDomainUnitsForParentRequest listDomainUnitsForParentRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return new ListDomainUnitsForParentIterable(this, listDomainUnitsForParentRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainUnitsForParent(software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainUnitsForParentIterable responses = client.listDomainUnitsForParentPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListDomainUnitsForParentIterable responses = client
     *             .listDomainUnitsForParentPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainUnitsForParentIterable responses = client.listDomainUnitsForParentPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainUnitsForParent(software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainUnitsForParentRequest.Builder} avoiding
     * the need to create one manually via {@link ListDomainUnitsForParentRequest#builder()}
     * </p>
     *
     * @param listDomainUnitsForParentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDomainUnitsForParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomainUnitsForParent"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainUnitsForParentIterable listDomainUnitsForParentPaginator(
            Consumer<ListDomainUnitsForParentRequest.Builder> listDomainUnitsForParentRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listDomainUnitsForParentPaginator(ListDomainUnitsForParentRequest.builder()
                .applyMutation(listDomainUnitsForParentRequest).build());
    }

    /**
     * <p>
     * Lists Amazon DataZone domains.
     * </p>
     *
     * @param listDomainsRequest
     * @return Result of the ListDomains operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDomainsRequest.Builder} to create a request.
     * @return Result of the ListDomains operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsResponse listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listDomains(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.datazone.model.ListDomainsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.datazone.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listDomainsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsIterable listDomainsPaginator(ListDomainsRequest listDomainsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return new ListDomainsIterable(this, listDomainsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.datazone.model.ListDomainsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.datazone.model.ListDomainsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDomainsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsIterable listDomainsPaginator(Consumer<ListDomainsRequest.Builder> listDomainsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listDomainsPaginator(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Lists the entity (domain units) owners.
     * </p>
     *
     * @param listEntityOwnersRequest
     * @return Result of the ListEntityOwners operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEntityOwners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEntityOwners" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntityOwnersResponse listEntityOwners(ListEntityOwnersRequest listEntityOwnersRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the entity (domain units) owners.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityOwnersRequest.Builder} avoiding the need
     * to create one manually via {@link ListEntityOwnersRequest#builder()}
     * </p>
     *
     * @param listEntityOwnersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest.Builder} to create a
     *        request.
     * @return Result of the ListEntityOwners operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEntityOwners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEntityOwners" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntityOwnersResponse listEntityOwners(Consumer<ListEntityOwnersRequest.Builder> listEntityOwnersRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listEntityOwners(ListEntityOwnersRequest.builder().applyMutation(listEntityOwnersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntityOwners(software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEntityOwnersIterable responses = client.listEntityOwnersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListEntityOwnersIterable responses = client
     *             .listEntityOwnersPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListEntityOwnersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEntityOwnersIterable responses = client.listEntityOwnersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityOwners(software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest)} operation.</b>
     * </p>
     *
     * @param listEntityOwnersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEntityOwners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEntityOwners" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntityOwnersIterable listEntityOwnersPaginator(ListEntityOwnersRequest listEntityOwnersRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new ListEntityOwnersIterable(this, listEntityOwnersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntityOwners(software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEntityOwnersIterable responses = client.listEntityOwnersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListEntityOwnersIterable responses = client
     *             .listEntityOwnersPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListEntityOwnersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEntityOwnersIterable responses = client.listEntityOwnersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityOwners(software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityOwnersRequest.Builder} avoiding the need
     * to create one manually via {@link ListEntityOwnersRequest#builder()}
     * </p>
     *
     * @param listEntityOwnersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEntityOwners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEntityOwners" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntityOwnersIterable listEntityOwnersPaginator(Consumer<ListEntityOwnersRequest.Builder> listEntityOwnersRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listEntityOwnersPaginator(ListEntityOwnersRequest.builder().applyMutation(listEntityOwnersRequest).build());
    }

    /**
     * <p>
     * Lists existing environment actions.
     * </p>
     *
     * @param listEnvironmentActionsRequest
     * @return Result of the ListEnvironmentActions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentActionsResponse listEnvironmentActions(ListEnvironmentActionsRequest listEnvironmentActionsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists existing environment actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnvironmentActionsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEnvironmentActions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentActionsResponse listEnvironmentActions(
            Consumer<ListEnvironmentActionsRequest.Builder> listEnvironmentActionsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listEnvironmentActions(ListEnvironmentActionsRequest.builder().applyMutation(listEnvironmentActionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentActions(software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentActionsIterable responses = client.listEnvironmentActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListEnvironmentActionsIterable responses = client
     *             .listEnvironmentActionsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentActionsIterable responses = client.listEnvironmentActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentActions(software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentActionsIterable listEnvironmentActionsPaginator(
            ListEnvironmentActionsRequest listEnvironmentActionsRequest) throws InternalServerException, AccessDeniedException,
            ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return new ListEnvironmentActionsIterable(this, listEnvironmentActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentActions(software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentActionsIterable responses = client.listEnvironmentActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListEnvironmentActionsIterable responses = client
     *             .listEnvironmentActionsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentActionsIterable responses = client.listEnvironmentActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentActions(software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnvironmentActionsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentActionsIterable listEnvironmentActionsPaginator(
            Consumer<ListEnvironmentActionsRequest.Builder> listEnvironmentActionsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listEnvironmentActionsPaginator(ListEnvironmentActionsRequest.builder()
                .applyMutation(listEnvironmentActionsRequest).build());
    }

    /**
     * <p>
     * Lists blueprint configurations for a Amazon DataZone environment.
     * </p>
     *
     * @param listEnvironmentBlueprintConfigurationsRequest
     * @return Result of the ListEnvironmentBlueprintConfigurations operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentBlueprintConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintConfigurationsResponse listEnvironmentBlueprintConfigurations(
            ListEnvironmentBlueprintConfigurationsRequest listEnvironmentBlueprintConfigurationsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists blueprint configurations for a Amazon DataZone environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListEnvironmentBlueprintConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListEnvironmentBlueprintConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentBlueprintConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListEnvironmentBlueprintConfigurations operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentBlueprintConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintConfigurationsResponse listEnvironmentBlueprintConfigurations(
            Consumer<ListEnvironmentBlueprintConfigurationsRequest.Builder> listEnvironmentBlueprintConfigurationsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listEnvironmentBlueprintConfigurations(ListEnvironmentBlueprintConfigurationsRequest.builder()
                .applyMutation(listEnvironmentBlueprintConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentBlueprintConfigurations(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsIterable responses = client.listEnvironmentBlueprintConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsIterable responses = client
     *             .listEnvironmentBlueprintConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsIterable responses = client.listEnvironmentBlueprintConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentBlueprintConfigurations(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentBlueprintConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentBlueprintConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintConfigurationsIterable listEnvironmentBlueprintConfigurationsPaginator(
            ListEnvironmentBlueprintConfigurationsRequest listEnvironmentBlueprintConfigurationsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new ListEnvironmentBlueprintConfigurationsIterable(this, listEnvironmentBlueprintConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentBlueprintConfigurations(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsIterable responses = client.listEnvironmentBlueprintConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsIterable responses = client
     *             .listEnvironmentBlueprintConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsIterable responses = client.listEnvironmentBlueprintConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentBlueprintConfigurations(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListEnvironmentBlueprintConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListEnvironmentBlueprintConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentBlueprintConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentBlueprintConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintConfigurationsIterable listEnvironmentBlueprintConfigurationsPaginator(
            Consumer<ListEnvironmentBlueprintConfigurationsRequest.Builder> listEnvironmentBlueprintConfigurationsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listEnvironmentBlueprintConfigurationsPaginator(ListEnvironmentBlueprintConfigurationsRequest.builder()
                .applyMutation(listEnvironmentBlueprintConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists blueprints in an Amazon DataZone environment.
     * </p>
     *
     * @param listEnvironmentBlueprintsRequest
     * @return Result of the ListEnvironmentBlueprints operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintsResponse listEnvironmentBlueprints(
            ListEnvironmentBlueprintsRequest listEnvironmentBlueprintsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists blueprints in an Amazon DataZone environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentBlueprintsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentBlueprintsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentBlueprintsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest.Builder} to create
     *        a request.
     * @return Result of the ListEnvironmentBlueprints operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintsResponse listEnvironmentBlueprints(
            Consumer<ListEnvironmentBlueprintsRequest.Builder> listEnvironmentBlueprintsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listEnvironmentBlueprints(ListEnvironmentBlueprintsRequest.builder()
                .applyMutation(listEnvironmentBlueprintsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentBlueprints(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsIterable responses = client.listEnvironmentBlueprintsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsIterable responses = client
     *             .listEnvironmentBlueprintsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsIterable responses = client.listEnvironmentBlueprintsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentBlueprints(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentBlueprintsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintsIterable listEnvironmentBlueprintsPaginator(
            ListEnvironmentBlueprintsRequest listEnvironmentBlueprintsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return new ListEnvironmentBlueprintsIterable(this, listEnvironmentBlueprintsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentBlueprints(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsIterable responses = client.listEnvironmentBlueprintsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsIterable responses = client
     *             .listEnvironmentBlueprintsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsIterable responses = client.listEnvironmentBlueprintsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentBlueprints(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentBlueprintsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentBlueprintsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentBlueprintsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintsIterable listEnvironmentBlueprintsPaginator(
            Consumer<ListEnvironmentBlueprintsRequest.Builder> listEnvironmentBlueprintsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listEnvironmentBlueprintsPaginator(ListEnvironmentBlueprintsRequest.builder()
                .applyMutation(listEnvironmentBlueprintsRequest).build());
    }

    /**
     * <p>
     * Lists Amazon DataZone environment profiles.
     * </p>
     *
     * @param listEnvironmentProfilesRequest
     * @return Result of the ListEnvironmentProfiles operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentProfilesResponse listEnvironmentProfiles(ListEnvironmentProfilesRequest listEnvironmentProfilesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone environment profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentProfilesRequest#builder()}
     * </p>
     *
     * @param listEnvironmentProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListEnvironmentProfiles operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentProfilesResponse listEnvironmentProfiles(
            Consumer<ListEnvironmentProfilesRequest.Builder> listEnvironmentProfilesRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listEnvironmentProfiles(ListEnvironmentProfilesRequest.builder().applyMutation(listEnvironmentProfilesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentProfiles(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesIterable responses = client.listEnvironmentProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesIterable responses = client
     *             .listEnvironmentProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesIterable responses = client.listEnvironmentProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentProfiles(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentProfilesIterable listEnvironmentProfilesPaginator(
            ListEnvironmentProfilesRequest listEnvironmentProfilesRequest) throws InternalServerException, AccessDeniedException,
            ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return new ListEnvironmentProfilesIterable(this, listEnvironmentProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentProfiles(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesIterable responses = client.listEnvironmentProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesIterable responses = client
     *             .listEnvironmentProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesIterable responses = client.listEnvironmentProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentProfiles(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentProfilesRequest#builder()}
     * </p>
     *
     * @param listEnvironmentProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironmentProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentProfilesIterable listEnvironmentProfilesPaginator(
            Consumer<ListEnvironmentProfilesRequest.Builder> listEnvironmentProfilesRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listEnvironmentProfilesPaginator(ListEnvironmentProfilesRequest.builder()
                .applyMutation(listEnvironmentProfilesRequest).build());
    }

    /**
     * <p>
     * Lists Amazon DataZone environments.
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return Result of the ListEnvironments operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsResponse listEnvironments(ListEnvironmentsRequest listEnvironmentsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone environments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEnvironments operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsResponse listEnvironments(Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listEnvironments(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironments(software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsIterable responses = client.listEnvironmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsIterable responses = client
     *             .listEnvironmentsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsIterable responses = client.listEnvironmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsIterable listEnvironmentsPaginator(ListEnvironmentsRequest listEnvironmentsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new ListEnvironmentsIterable(this, listEnvironmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironments(software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsIterable responses = client.listEnvironmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsIterable responses = client
     *             .listEnvironmentsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsIterable responses = client.listEnvironmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsIterable listEnvironmentsPaginator(Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listEnvironmentsPaginator(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Lists job runs.
     * </p>
     *
     * @param listJobRunsRequest
     * @return Result of the ListJobRuns operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobRunsResponse listJobRuns(ListJobRunsRequest listJobRunsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists job runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobRunsRequest#builder()}
     * </p>
     *
     * @param listJobRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListJobRunsRequest.Builder} to create a request.
     * @return Result of the ListJobRuns operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobRunsResponse listJobRuns(Consumer<ListJobRunsRequest.Builder> listJobRunsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listJobRuns(ListJobRunsRequest.builder().applyMutation(listJobRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listJobRuns(software.amazon.awssdk.services.datazone.model.ListJobRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListJobRunsIterable responses = client.listJobRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListJobRunsIterable responses = client.listJobRunsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListJobRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListJobRunsIterable responses = client.listJobRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobRuns(software.amazon.awssdk.services.datazone.model.ListJobRunsRequest)} operation.</b>
     * </p>
     *
     * @param listJobRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobRunsIterable listJobRunsPaginator(ListJobRunsRequest listJobRunsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return new ListJobRunsIterable(this, listJobRunsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listJobRuns(software.amazon.awssdk.services.datazone.model.ListJobRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListJobRunsIterable responses = client.listJobRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListJobRunsIterable responses = client.listJobRunsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListJobRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListJobRunsIterable responses = client.listJobRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobRuns(software.amazon.awssdk.services.datazone.model.ListJobRunsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobRunsRequest#builder()}
     * </p>
     *
     * @param listJobRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListJobRunsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobRunsIterable listJobRunsPaginator(Consumer<ListJobRunsRequest.Builder> listJobRunsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listJobRunsPaginator(ListJobRunsRequest.builder().applyMutation(listJobRunsRequest).build());
    }

    /**
     * <p>
     * Lists lineage events.
     * </p>
     *
     * @param listLineageEventsRequest
     * @return Result of the ListLineageEvents operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListLineageEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLineageEventsResponse listLineageEvents(ListLineageEventsRequest listLineageEventsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists lineage events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLineageEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLineageEventsRequest#builder()}
     * </p>
     *
     * @param listLineageEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest.Builder} to create a
     *        request.
     * @return Result of the ListLineageEvents operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListLineageEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLineageEventsResponse listLineageEvents(Consumer<ListLineageEventsRequest.Builder> listLineageEventsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listLineageEvents(ListLineageEventsRequest.builder().applyMutation(listLineageEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLineageEvents(software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageEventsIterable responses = client.listLineageEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListLineageEventsIterable responses = client
     *             .listLineageEventsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListLineageEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageEventsIterable responses = client.listLineageEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLineageEvents(software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLineageEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListLineageEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLineageEventsIterable listLineageEventsPaginator(ListLineageEventsRequest listLineageEventsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new ListLineageEventsIterable(this, listLineageEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLineageEvents(software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageEventsIterable responses = client.listLineageEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListLineageEventsIterable responses = client
     *             .listLineageEventsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListLineageEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageEventsIterable responses = client.listLineageEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLineageEvents(software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLineageEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLineageEventsRequest#builder()}
     * </p>
     *
     * @param listLineageEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListLineageEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLineageEventsIterable listLineageEventsPaginator(
            Consumer<ListLineageEventsRequest.Builder> listLineageEventsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listLineageEventsPaginator(ListLineageEventsRequest.builder().applyMutation(listLineageEventsRequest).build());
    }

    /**
     * <p>
     * Lists the history of the specified data lineage node.
     * </p>
     *
     * @param listLineageNodeHistoryRequest
     * @return Result of the ListLineageNodeHistory operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListLineageNodeHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageNodeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLineageNodeHistoryResponse listLineageNodeHistory(ListLineageNodeHistoryRequest listLineageNodeHistoryRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the history of the specified data lineage node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLineageNodeHistoryRequest.Builder} avoiding the
     * need to create one manually via {@link ListLineageNodeHistoryRequest#builder()}
     * </p>
     *
     * @param listLineageNodeHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest.Builder} to create a
     *        request.
     * @return Result of the ListLineageNodeHistory operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListLineageNodeHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageNodeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLineageNodeHistoryResponse listLineageNodeHistory(
            Consumer<ListLineageNodeHistoryRequest.Builder> listLineageNodeHistoryRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listLineageNodeHistory(ListLineageNodeHistoryRequest.builder().applyMutation(listLineageNodeHistoryRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLineageNodeHistory(software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageNodeHistoryIterable responses = client.listLineageNodeHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListLineageNodeHistoryIterable responses = client
     *             .listLineageNodeHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageNodeHistoryIterable responses = client.listLineageNodeHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLineageNodeHistory(software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLineageNodeHistoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListLineageNodeHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageNodeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLineageNodeHistoryIterable listLineageNodeHistoryPaginator(
            ListLineageNodeHistoryRequest listLineageNodeHistoryRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return new ListLineageNodeHistoryIterable(this, listLineageNodeHistoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLineageNodeHistory(software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageNodeHistoryIterable responses = client.listLineageNodeHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListLineageNodeHistoryIterable responses = client
     *             .listLineageNodeHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageNodeHistoryIterable responses = client.listLineageNodeHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLineageNodeHistory(software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLineageNodeHistoryRequest.Builder} avoiding the
     * need to create one manually via {@link ListLineageNodeHistoryRequest#builder()}
     * </p>
     *
     * @param listLineageNodeHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListLineageNodeHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageNodeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLineageNodeHistoryIterable listLineageNodeHistoryPaginator(
            Consumer<ListLineageNodeHistoryRequest.Builder> listLineageNodeHistoryRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listLineageNodeHistoryPaginator(ListLineageNodeHistoryRequest.builder()
                .applyMutation(listLineageNodeHistoryRequest).build());
    }

    /**
     * <p>
     * Lists all metadata generation runs.
     * </p>
     *
     * @param listMetadataGenerationRunsRequest
     * @return Result of the ListMetadataGenerationRuns operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListMetadataGenerationRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMetadataGenerationRunsResponse listMetadataGenerationRuns(
            ListMetadataGenerationRunsRequest listMetadataGenerationRunsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all metadata generation runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMetadataGenerationRunsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMetadataGenerationRunsRequest#builder()}
     * </p>
     *
     * @param listMetadataGenerationRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest.Builder} to create
     *        a request.
     * @return Result of the ListMetadataGenerationRuns operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListMetadataGenerationRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMetadataGenerationRunsResponse listMetadataGenerationRuns(
            Consumer<ListMetadataGenerationRunsRequest.Builder> listMetadataGenerationRunsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listMetadataGenerationRuns(ListMetadataGenerationRunsRequest.builder()
                .applyMutation(listMetadataGenerationRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMetadataGenerationRuns(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsIterable responses = client.listMetadataGenerationRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsIterable responses = client
     *             .listMetadataGenerationRunsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsIterable responses = client.listMetadataGenerationRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMetadataGenerationRuns(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMetadataGenerationRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListMetadataGenerationRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMetadataGenerationRunsIterable listMetadataGenerationRunsPaginator(
            ListMetadataGenerationRunsRequest listMetadataGenerationRunsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return new ListMetadataGenerationRunsIterable(this, listMetadataGenerationRunsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMetadataGenerationRuns(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsIterable responses = client.listMetadataGenerationRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsIterable responses = client
     *             .listMetadataGenerationRunsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsIterable responses = client.listMetadataGenerationRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMetadataGenerationRuns(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMetadataGenerationRunsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMetadataGenerationRunsRequest#builder()}
     * </p>
     *
     * @param listMetadataGenerationRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListMetadataGenerationRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMetadataGenerationRunsIterable listMetadataGenerationRunsPaginator(
            Consumer<ListMetadataGenerationRunsRequest.Builder> listMetadataGenerationRunsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listMetadataGenerationRunsPaginator(ListMetadataGenerationRunsRequest.builder()
                .applyMutation(listMetadataGenerationRunsRequest).build());
    }

    /**
     * <p>
     * Lists all Amazon DataZone notifications.
     * </p>
     *
     * @param listNotificationsRequest
     * @return Result of the ListNotifications operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNotificationsResponse listNotifications(ListNotificationsRequest listNotificationsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon DataZone notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListNotificationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListNotifications operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNotificationsResponse listNotifications(Consumer<ListNotificationsRequest.Builder> listNotificationsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listNotifications(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.datazone.model.ListNotificationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListNotificationsIterable responses = client.listNotificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListNotificationsIterable responses = client
     *             .listNotificationsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListNotificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListNotificationsIterable responses = client.listNotificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.datazone.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNotificationsIterable listNotificationsPaginator(ListNotificationsRequest listNotificationsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new ListNotificationsIterable(this, listNotificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.datazone.model.ListNotificationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListNotificationsIterable responses = client.listNotificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListNotificationsIterable responses = client
     *             .listNotificationsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListNotificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListNotificationsIterable responses = client.listNotificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.datazone.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListNotificationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNotificationsIterable listNotificationsPaginator(
            Consumer<ListNotificationsRequest.Builder> listNotificationsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listNotificationsPaginator(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * Lists policy grants.
     * </p>
     *
     * @param listPolicyGrantsRequest
     * @return Result of the ListPolicyGrants operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListPolicyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListPolicyGrants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyGrantsResponse listPolicyGrants(ListPolicyGrantsRequest listPolicyGrantsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists policy grants.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyGrantsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPolicyGrantsRequest#builder()}
     * </p>
     *
     * @param listPolicyGrantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPolicyGrants operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListPolicyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListPolicyGrants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyGrantsResponse listPolicyGrants(Consumer<ListPolicyGrantsRequest.Builder> listPolicyGrantsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listPolicyGrants(ListPolicyGrantsRequest.builder().applyMutation(listPolicyGrantsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPolicyGrants(software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListPolicyGrantsIterable responses = client.listPolicyGrantsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListPolicyGrantsIterable responses = client
     *             .listPolicyGrantsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListPolicyGrantsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListPolicyGrantsIterable responses = client.listPolicyGrantsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyGrants(software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest)} operation.</b>
     * </p>
     *
     * @param listPolicyGrantsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListPolicyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListPolicyGrants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyGrantsIterable listPolicyGrantsPaginator(ListPolicyGrantsRequest listPolicyGrantsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new ListPolicyGrantsIterable(this, listPolicyGrantsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPolicyGrants(software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListPolicyGrantsIterable responses = client.listPolicyGrantsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListPolicyGrantsIterable responses = client
     *             .listPolicyGrantsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListPolicyGrantsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListPolicyGrantsIterable responses = client.listPolicyGrantsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyGrants(software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyGrantsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPolicyGrantsRequest#builder()}
     * </p>
     *
     * @param listPolicyGrantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListPolicyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListPolicyGrants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyGrantsIterable listPolicyGrantsPaginator(Consumer<ListPolicyGrantsRequest.Builder> listPolicyGrantsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listPolicyGrantsPaginator(ListPolicyGrantsRequest.builder().applyMutation(listPolicyGrantsRequest).build());
    }

    /**
     * <p>
     * Lists all members of the specified project.
     * </p>
     *
     * @param listProjectMembershipsRequest
     * @return Result of the ListProjectMemberships operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListProjectMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectMembershipsResponse listProjectMemberships(ListProjectMembershipsRequest listProjectMembershipsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all members of the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProjectMembershipsRequest#builder()}
     * </p>
     *
     * @param listProjectMembershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest.Builder} to create a
     *        request.
     * @return Result of the ListProjectMemberships operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListProjectMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectMembershipsResponse listProjectMemberships(
            Consumer<ListProjectMembershipsRequest.Builder> listProjectMembershipsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listProjectMemberships(ListProjectMembershipsRequest.builder().applyMutation(listProjectMembershipsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProjectMemberships(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsIterable responses = client.listProjectMembershipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsIterable responses = client
     *             .listProjectMembershipsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsIterable responses = client.listProjectMembershipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectMemberships(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProjectMembershipsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListProjectMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectMembershipsIterable listProjectMembershipsPaginator(
            ListProjectMembershipsRequest listProjectMembershipsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return new ListProjectMembershipsIterable(this, listProjectMembershipsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProjectMemberships(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsIterable responses = client.listProjectMembershipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsIterable responses = client
     *             .listProjectMembershipsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsIterable responses = client.listProjectMembershipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectMemberships(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProjectMembershipsRequest#builder()}
     * </p>
     *
     * @param listProjectMembershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListProjectMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectMembershipsIterable listProjectMembershipsPaginator(
            Consumer<ListProjectMembershipsRequest.Builder> listProjectMembershipsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listProjectMembershipsPaginator(ListProjectMembershipsRequest.builder()
                .applyMutation(listProjectMembershipsRequest).build());
    }

    /**
     * <p>
     * Lists project profiles.
     * </p>
     *
     * @param listProjectProfilesRequest
     * @return Result of the ListProjectProfiles operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListProjectProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectProfilesResponse listProjectProfiles(ListProjectProfilesRequest listProjectProfilesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists project profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProjectProfilesRequest#builder()}
     * </p>
     *
     * @param listProjectProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListProjectProfiles operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListProjectProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectProfilesResponse listProjectProfiles(
            Consumer<ListProjectProfilesRequest.Builder> listProjectProfilesRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listProjectProfiles(ListProjectProfilesRequest.builder().applyMutation(listProjectProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProjectProfiles(software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectProfilesIterable responses = client.listProjectProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListProjectProfilesIterable responses = client
     *             .listProjectProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListProjectProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectProfilesIterable responses = client.listProjectProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectProfiles(software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProjectProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListProjectProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectProfilesIterable listProjectProfilesPaginator(ListProjectProfilesRequest listProjectProfilesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new ListProjectProfilesIterable(this, listProjectProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProjectProfiles(software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectProfilesIterable responses = client.listProjectProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListProjectProfilesIterable responses = client
     *             .listProjectProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListProjectProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectProfilesIterable responses = client.listProjectProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectProfiles(software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProjectProfilesRequest#builder()}
     * </p>
     *
     * @param listProjectProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListProjectProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectProfilesIterable listProjectProfilesPaginator(
            Consumer<ListProjectProfilesRequest.Builder> listProjectProfilesRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return listProjectProfilesPaginator(ListProjectProfilesRequest.builder().applyMutation(listProjectProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Lists Amazon DataZone projects.
     * </p>
     *
     * @param listProjectsRequest
     * @return Result of the ListProjects operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone projects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectsRequest.Builder} to create a request.
     * @return Result of the ListProjects operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.datazone.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.datazone.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return new ListProjectsIterable(this, listProjectsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.datazone.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.datazone.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Lists existing rules. In Amazon DataZone, a rule is a formal agreement that enforces specific requirements across
     * user workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects) within the
     * Amazon DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold governance
     * standards in data management processes. For instance, a metadata enforcement rule can specify the required
     * information for creating a subscription request or publishing a data asset to the catalog, ensuring alignment
     * with organizational standards.
     * </p>
     *
     * @param listRulesRequest
     * @return Result of the ListRules operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesResponse listRules(ListRulesRequest listRulesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists existing rules. In Amazon DataZone, a rule is a formal agreement that enforces specific requirements across
     * user workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects) within the
     * Amazon DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold governance
     * standards in data management processes. For instance, a metadata enforcement rule can specify the required
     * information for creating a subscription request or publishing a data asset to the catalog, ensuring alignment
     * with organizational standards.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesRequest#builder()}
     * </p>
     *
     * @param listRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListRulesRequest.Builder} to create a request.
     * @return Result of the ListRules operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesResponse listRules(Consumer<ListRulesRequest.Builder> listRulesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listRules(ListRulesRequest.builder().applyMutation(listRulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRules(software.amazon.awssdk.services.datazone.model.ListRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListRulesIterable responses = client.listRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListRulesIterable responses = client.listRulesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListRulesIterable responses = client.listRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRules(software.amazon.awssdk.services.datazone.model.ListRulesRequest)} operation.</b>
     * </p>
     *
     * @param listRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesIterable listRulesPaginator(ListRulesRequest listRulesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return new ListRulesIterable(this, listRulesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRules(software.amazon.awssdk.services.datazone.model.ListRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListRulesIterable responses = client.listRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListRulesIterable responses = client.listRulesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListRulesIterable responses = client.listRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRules(software.amazon.awssdk.services.datazone.model.ListRulesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesRequest#builder()}
     * </p>
     *
     * @param listRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListRulesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesIterable listRulesPaginator(Consumer<ListRulesRequest.Builder> listRulesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listRulesPaginator(ListRulesRequest.builder().applyMutation(listRulesRequest).build());
    }

    /**
     * <p>
     * Lists subscription grants.
     * </p>
     *
     * @param listSubscriptionGrantsRequest
     * @return Result of the ListSubscriptionGrants operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptionGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionGrantsResponse listSubscriptionGrants(ListSubscriptionGrantsRequest listSubscriptionGrantsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists subscription grants.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionGrantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSubscriptionGrantsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionGrantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSubscriptionGrants operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptionGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionGrantsResponse listSubscriptionGrants(
            Consumer<ListSubscriptionGrantsRequest.Builder> listSubscriptionGrantsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listSubscriptionGrants(ListSubscriptionGrantsRequest.builder().applyMutation(listSubscriptionGrantsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionGrants(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsIterable responses = client.listSubscriptionGrantsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsIterable responses = client
     *             .listSubscriptionGrantsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsIterable responses = client.listSubscriptionGrantsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionGrants(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscriptionGrantsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptionGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionGrantsIterable listSubscriptionGrantsPaginator(
            ListSubscriptionGrantsRequest listSubscriptionGrantsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return new ListSubscriptionGrantsIterable(this, listSubscriptionGrantsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionGrants(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsIterable responses = client.listSubscriptionGrantsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsIterable responses = client
     *             .listSubscriptionGrantsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsIterable responses = client.listSubscriptionGrantsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionGrants(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionGrantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSubscriptionGrantsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionGrantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptionGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionGrantsIterable listSubscriptionGrantsPaginator(
            Consumer<ListSubscriptionGrantsRequest.Builder> listSubscriptionGrantsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listSubscriptionGrantsPaginator(ListSubscriptionGrantsRequest.builder()
                .applyMutation(listSubscriptionGrantsRequest).build());
    }

    /**
     * <p>
     * Lists Amazon DataZone subscription requests.
     * </p>
     *
     * @param listSubscriptionRequestsRequest
     * @return Result of the ListSubscriptionRequests operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptionRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionRequestsResponse listSubscriptionRequests(
            ListSubscriptionRequestsRequest listSubscriptionRequestsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone subscription requests.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionRequestsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscriptionRequestsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSubscriptionRequests operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptionRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionRequestsResponse listSubscriptionRequests(
            Consumer<ListSubscriptionRequestsRequest.Builder> listSubscriptionRequestsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listSubscriptionRequests(ListSubscriptionRequestsRequest.builder().applyMutation(listSubscriptionRequestsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionRequests(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsIterable responses = client.listSubscriptionRequestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsIterable responses = client
     *             .listSubscriptionRequestsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsIterable responses = client.listSubscriptionRequestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionRequests(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscriptionRequestsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptionRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionRequestsIterable listSubscriptionRequestsPaginator(
            ListSubscriptionRequestsRequest listSubscriptionRequestsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return new ListSubscriptionRequestsIterable(this, listSubscriptionRequestsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionRequests(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsIterable responses = client.listSubscriptionRequestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsIterable responses = client
     *             .listSubscriptionRequestsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsIterable responses = client.listSubscriptionRequestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionRequests(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionRequestsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscriptionRequestsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptionRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionRequestsIterable listSubscriptionRequestsPaginator(
            Consumer<ListSubscriptionRequestsRequest.Builder> listSubscriptionRequestsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listSubscriptionRequestsPaginator(ListSubscriptionRequestsRequest.builder()
                .applyMutation(listSubscriptionRequestsRequest).build());
    }

    /**
     * <p>
     * Lists subscription targets in Amazon DataZone.
     * </p>
     *
     * @param listSubscriptionTargetsRequest
     * @return Result of the ListSubscriptionTargets operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionTargetsResponse listSubscriptionTargets(ListSubscriptionTargetsRequest listSubscriptionTargetsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists subscription targets in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionTargetsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscriptionTargetsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSubscriptionTargets operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionTargetsResponse listSubscriptionTargets(
            Consumer<ListSubscriptionTargetsRequest.Builder> listSubscriptionTargetsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listSubscriptionTargets(ListSubscriptionTargetsRequest.builder().applyMutation(listSubscriptionTargetsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionTargets(software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionTargetsIterable responses = client.listSubscriptionTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListSubscriptionTargetsIterable responses = client
     *             .listSubscriptionTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionTargetsIterable responses = client.listSubscriptionTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionTargets(software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscriptionTargetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionTargetsIterable listSubscriptionTargetsPaginator(
            ListSubscriptionTargetsRequest listSubscriptionTargetsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return new ListSubscriptionTargetsIterable(this, listSubscriptionTargetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionTargets(software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionTargetsIterable responses = client.listSubscriptionTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListSubscriptionTargetsIterable responses = client
     *             .listSubscriptionTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionTargetsIterable responses = client.listSubscriptionTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionTargets(software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionTargetsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscriptionTargetsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionTargetsIterable listSubscriptionTargetsPaginator(
            Consumer<ListSubscriptionTargetsRequest.Builder> listSubscriptionTargetsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listSubscriptionTargetsPaginator(ListSubscriptionTargetsRequest.builder()
                .applyMutation(listSubscriptionTargetsRequest).build());
    }

    /**
     * <p>
     * Lists subscriptions in Amazon DataZone.
     * </p>
     *
     * @param listSubscriptionsRequest
     * @return Result of the ListSubscriptions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscriptionsResponse listSubscriptions(ListSubscriptionsRequest listSubscriptionsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists subscriptions in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSubscriptions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscriptionsResponse listSubscriptions(Consumer<ListSubscriptionsRequest.Builder> listSubscriptionsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return listSubscriptions(ListSubscriptionsRequest.builder().applyMutation(listSubscriptionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptions(software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionsIterable responses = client.listSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListSubscriptionsIterable responses = client
     *             .listSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionsIterable responses = client.listSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptions(software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscriptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscriptionsIterable listSubscriptionsPaginator(ListSubscriptionsRequest listSubscriptionsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new ListSubscriptionsIterable(this, listSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptions(software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionsIterable responses = client.listSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListSubscriptionsIterable responses = client
     *             .listSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionsIterable responses = client.listSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptions(software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscriptionsIterable listSubscriptionsPaginator(
            Consumer<ListSubscriptionsRequest.Builder> listSubscriptionsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listSubscriptionsPaginator(ListSubscriptionsRequest.builder().applyMutation(listSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists tags for the specified resource in Amazon DataZone.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for the specified resource in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists time series data points.
     * </p>
     *
     * @param listTimeSeriesDataPointsRequest
     * @return Result of the ListTimeSeriesDataPoints operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTimeSeriesDataPointsResponse listTimeSeriesDataPoints(
            ListTimeSeriesDataPointsRequest listTimeSeriesDataPointsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists time series data points.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTimeSeriesDataPointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTimeSeriesDataPointsRequest#builder()}
     * </p>
     *
     * @param listTimeSeriesDataPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTimeSeriesDataPoints operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTimeSeriesDataPointsResponse listTimeSeriesDataPoints(
            Consumer<ListTimeSeriesDataPointsRequest.Builder> listTimeSeriesDataPointsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listTimeSeriesDataPoints(ListTimeSeriesDataPointsRequest.builder().applyMutation(listTimeSeriesDataPointsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTimeSeriesDataPoints(software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListTimeSeriesDataPointsIterable responses = client.listTimeSeriesDataPointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListTimeSeriesDataPointsIterable responses = client
     *             .listTimeSeriesDataPointsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListTimeSeriesDataPointsIterable responses = client.listTimeSeriesDataPointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTimeSeriesDataPoints(software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTimeSeriesDataPointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTimeSeriesDataPointsIterable listTimeSeriesDataPointsPaginator(
            ListTimeSeriesDataPointsRequest listTimeSeriesDataPointsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return new ListTimeSeriesDataPointsIterable(this, listTimeSeriesDataPointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTimeSeriesDataPoints(software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListTimeSeriesDataPointsIterable responses = client.listTimeSeriesDataPointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.ListTimeSeriesDataPointsIterable responses = client
     *             .listTimeSeriesDataPointsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListTimeSeriesDataPointsIterable responses = client.listTimeSeriesDataPointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTimeSeriesDataPoints(software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTimeSeriesDataPointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTimeSeriesDataPointsRequest#builder()}
     * </p>
     *
     * @param listTimeSeriesDataPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.ListTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTimeSeriesDataPointsIterable listTimeSeriesDataPointsPaginator(
            Consumer<ListTimeSeriesDataPointsRequest.Builder> listTimeSeriesDataPointsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return listTimeSeriesDataPointsPaginator(ListTimeSeriesDataPointsRequest.builder()
                .applyMutation(listTimeSeriesDataPointsRequest).build());
    }

    /**
     * <p>
     * Posts a data lineage event.
     * </p>
     *
     * @param postLineageEventRequest
     * @return Result of the PostLineageEvent operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.PostLineageEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PostLineageEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default PostLineageEventResponse postLineageEvent(PostLineageEventRequest postLineageEventRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Posts a data lineage event.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PostLineageEventRequest.Builder} avoiding the need
     * to create one manually via {@link PostLineageEventRequest#builder()}
     * </p>
     *
     * @param postLineageEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.PostLineageEventRequest.Builder} to create a
     *        request.
     * @return Result of the PostLineageEvent operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.PostLineageEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PostLineageEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default PostLineageEventResponse postLineageEvent(Consumer<PostLineageEventRequest.Builder> postLineageEventRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return postLineageEvent(PostLineageEventRequest.builder().applyMutation(postLineageEventRequest).build());
    }

    /**
     * <p>
     * Posts time series data points to Amazon DataZone for the specified asset.
     * </p>
     *
     * @param postTimeSeriesDataPointsRequest
     * @return Result of the PostTimeSeriesDataPoints operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.PostTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PostTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default PostTimeSeriesDataPointsResponse postTimeSeriesDataPoints(
            PostTimeSeriesDataPointsRequest postTimeSeriesDataPointsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Posts time series data points to Amazon DataZone for the specified asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PostTimeSeriesDataPointsRequest.Builder} avoiding
     * the need to create one manually via {@link PostTimeSeriesDataPointsRequest#builder()}
     * </p>
     *
     * @param postTimeSeriesDataPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.PostTimeSeriesDataPointsRequest.Builder} to create a
     *        request.
     * @return Result of the PostTimeSeriesDataPoints operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.PostTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PostTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default PostTimeSeriesDataPointsResponse postTimeSeriesDataPoints(
            Consumer<PostTimeSeriesDataPointsRequest.Builder> postTimeSeriesDataPointsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return postTimeSeriesDataPoints(PostTimeSeriesDataPointsRequest.builder().applyMutation(postTimeSeriesDataPointsRequest)
                .build());
    }

    /**
     * <p>
     * Writes the configuration for the specified environment blueprint in Amazon DataZone.
     * </p>
     *
     * @param putEnvironmentBlueprintConfigurationRequest
     * @return Result of the PutEnvironmentBlueprintConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.PutEnvironmentBlueprintConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PutEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEnvironmentBlueprintConfigurationResponse putEnvironmentBlueprintConfiguration(
            PutEnvironmentBlueprintConfigurationRequest putEnvironmentBlueprintConfigurationRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Writes the configuration for the specified environment blueprint in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutEnvironmentBlueprintConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutEnvironmentBlueprintConfigurationRequest#builder()}
     * </p>
     *
     * @param putEnvironmentBlueprintConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the PutEnvironmentBlueprintConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.PutEnvironmentBlueprintConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PutEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEnvironmentBlueprintConfigurationResponse putEnvironmentBlueprintConfiguration(
            Consumer<PutEnvironmentBlueprintConfigurationRequest.Builder> putEnvironmentBlueprintConfigurationRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return putEnvironmentBlueprintConfiguration(PutEnvironmentBlueprintConfigurationRequest.builder()
                .applyMutation(putEnvironmentBlueprintConfigurationRequest).build());
    }

    /**
     * <p>
     * Rejects automatically generated business-friendly metadata for your Amazon DataZone assets.
     * </p>
     *
     * @param rejectPredictionsRequest
     * @return Result of the RejectPredictions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.RejectPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RejectPredictions" target="_top">AWS
     *      API Documentation</a>
     */
    default RejectPredictionsResponse rejectPredictions(RejectPredictionsRequest rejectPredictionsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects automatically generated business-friendly metadata for your Amazon DataZone assets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectPredictionsRequest.Builder} avoiding the need
     * to create one manually via {@link RejectPredictionsRequest#builder()}
     * </p>
     *
     * @param rejectPredictionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.RejectPredictionsRequest.Builder} to create a
     *        request.
     * @return Result of the RejectPredictions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.RejectPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RejectPredictions" target="_top">AWS
     *      API Documentation</a>
     */
    default RejectPredictionsResponse rejectPredictions(Consumer<RejectPredictionsRequest.Builder> rejectPredictionsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return rejectPredictions(RejectPredictionsRequest.builder().applyMutation(rejectPredictionsRequest).build());
    }

    /**
     * <p>
     * Rejects the specified subscription request.
     * </p>
     *
     * @param rejectSubscriptionRequestRequest
     * @return Result of the RejectSubscriptionRequest operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.RejectSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RejectSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectSubscriptionRequestResponse rejectSubscriptionRequest(
            RejectSubscriptionRequestRequest rejectSubscriptionRequestRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects the specified subscription request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectSubscriptionRequestRequest.Builder} avoiding
     * the need to create one manually via {@link RejectSubscriptionRequestRequest#builder()}
     * </p>
     *
     * @param rejectSubscriptionRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestRequest.Builder} to create
     *        a request.
     * @return Result of the RejectSubscriptionRequest operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.RejectSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RejectSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectSubscriptionRequestResponse rejectSubscriptionRequest(
            Consumer<RejectSubscriptionRequestRequest.Builder> rejectSubscriptionRequestRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return rejectSubscriptionRequest(RejectSubscriptionRequestRequest.builder()
                .applyMutation(rejectSubscriptionRequestRequest).build());
    }

    /**
     * <p>
     * Removes an owner from an entity.
     * </p>
     *
     * @param removeEntityOwnerRequest
     * @return Result of the RemoveEntityOwner operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.RemoveEntityOwner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RemoveEntityOwner" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveEntityOwnerResponse removeEntityOwner(RemoveEntityOwnerRequest removeEntityOwnerRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an owner from an entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveEntityOwnerRequest.Builder} avoiding the need
     * to create one manually via {@link RemoveEntityOwnerRequest#builder()}
     * </p>
     *
     * @param removeEntityOwnerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.RemoveEntityOwnerRequest.Builder} to create a
     *        request.
     * @return Result of the RemoveEntityOwner operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.RemoveEntityOwner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RemoveEntityOwner" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveEntityOwnerResponse removeEntityOwner(Consumer<RemoveEntityOwnerRequest.Builder> removeEntityOwnerRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return removeEntityOwner(RemoveEntityOwnerRequest.builder().applyMutation(removeEntityOwnerRequest).build());
    }

    /**
     * <p>
     * Removes a policy grant.
     * </p>
     *
     * @param removePolicyGrantRequest
     * @return Result of the RemovePolicyGrant operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.RemovePolicyGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RemovePolicyGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default RemovePolicyGrantResponse removePolicyGrant(RemovePolicyGrantRequest removePolicyGrantRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a policy grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemovePolicyGrantRequest.Builder} avoiding the need
     * to create one manually via {@link RemovePolicyGrantRequest#builder()}
     * </p>
     *
     * @param removePolicyGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.RemovePolicyGrantRequest.Builder} to create a
     *        request.
     * @return Result of the RemovePolicyGrant operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.RemovePolicyGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RemovePolicyGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default RemovePolicyGrantResponse removePolicyGrant(Consumer<RemovePolicyGrantRequest.Builder> removePolicyGrantRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return removePolicyGrant(RemovePolicyGrantRequest.builder().applyMutation(removePolicyGrantRequest).build());
    }

    /**
     * <p>
     * Revokes a specified subscription in Amazon DataZone.
     * </p>
     *
     * @param revokeSubscriptionRequest
     * @return Result of the RevokeSubscription operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.RevokeSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RevokeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default RevokeSubscriptionResponse revokeSubscription(RevokeSubscriptionRequest revokeSubscriptionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes a specified subscription in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link RevokeSubscriptionRequest#builder()}
     * </p>
     *
     * @param revokeSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.RevokeSubscriptionRequest.Builder} to create a
     *        request.
     * @return Result of the RevokeSubscription operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.RevokeSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RevokeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default RevokeSubscriptionResponse revokeSubscription(Consumer<RevokeSubscriptionRequest.Builder> revokeSubscriptionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return revokeSubscription(RevokeSubscriptionRequest.builder().applyMutation(revokeSubscriptionRequest).build());
    }

    /**
     * <p>
     * Searches for assets in Amazon DataZone.
     * </p>
     *
     * @param searchRequest
     * @return Result of the Search operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/Search" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchResponse search(SearchRequest searchRequest) throws InternalServerException, AccessDeniedException,
            ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for assets in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRequest.Builder} avoiding the need to create
     * one manually via {@link SearchRequest#builder()}
     * </p>
     *
     * @param searchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchRequest.Builder} to create a request.
     * @return Result of the Search operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/Search" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchResponse search(Consumer<SearchRequest.Builder> searchRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return search(SearchRequest.builder().applyMutation(searchRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #search(software.amazon.awssdk.services.datazone.model.SearchRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.SearchIterable responses = client.searchPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.SearchResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #search(software.amazon.awssdk.services.datazone.model.SearchRequest)} operation.</b>
     * </p>
     *
     * @param searchRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/Search" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchIterable searchPaginator(SearchRequest searchRequest) throws InternalServerException, AccessDeniedException,
            ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        return new SearchIterable(this, searchRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #search(software.amazon.awssdk.services.datazone.model.SearchRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.SearchIterable responses = client.searchPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.SearchResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #search(software.amazon.awssdk.services.datazone.model.SearchRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRequest.Builder} avoiding the need to create
     * one manually via {@link SearchRequest#builder()}
     * </p>
     *
     * @param searchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/Search" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchIterable searchPaginator(Consumer<SearchRequest.Builder> searchRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return searchPaginator(SearchRequest.builder().applyMutation(searchRequest).build());
    }

    /**
     * <p>
     * Searches group profiles in Amazon DataZone.
     * </p>
     *
     * @param searchGroupProfilesRequest
     * @return Result of the SearchGroupProfiles operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchGroupProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchGroupProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchGroupProfilesResponse searchGroupProfiles(SearchGroupProfilesRequest searchGroupProfilesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches group profiles in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchGroupProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchGroupProfilesRequest#builder()}
     * </p>
     *
     * @param searchGroupProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the SearchGroupProfiles operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchGroupProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchGroupProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchGroupProfilesResponse searchGroupProfiles(
            Consumer<SearchGroupProfilesRequest.Builder> searchGroupProfilesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return searchGroupProfiles(SearchGroupProfilesRequest.builder().applyMutation(searchGroupProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchGroupProfiles(software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchGroupProfilesIterable responses = client.searchGroupProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.SearchGroupProfilesIterable responses = client
     *             .searchGroupProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.SearchGroupProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchGroupProfilesIterable responses = client.searchGroupProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchGroupProfiles(software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchGroupProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchGroupProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchGroupProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchGroupProfilesIterable searchGroupProfilesPaginator(SearchGroupProfilesRequest searchGroupProfilesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new SearchGroupProfilesIterable(this, searchGroupProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchGroupProfiles(software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchGroupProfilesIterable responses = client.searchGroupProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.SearchGroupProfilesIterable responses = client
     *             .searchGroupProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.SearchGroupProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchGroupProfilesIterable responses = client.searchGroupProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchGroupProfiles(software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchGroupProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchGroupProfilesRequest#builder()}
     * </p>
     *
     * @param searchGroupProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchGroupProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchGroupProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchGroupProfilesIterable searchGroupProfilesPaginator(
            Consumer<SearchGroupProfilesRequest.Builder> searchGroupProfilesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return searchGroupProfilesPaginator(SearchGroupProfilesRequest.builder().applyMutation(searchGroupProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Searches listings (records of an asset at a given time) in Amazon DataZone.
     * </p>
     *
     * @param searchListingsRequest
     * @return Result of the SearchListings operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchListings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchListings" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchListingsResponse searchListings(SearchListingsRequest searchListingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches listings (records of an asset at a given time) in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchListingsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchListingsRequest#builder()}
     * </p>
     *
     * @param searchListingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchListingsRequest.Builder} to create a request.
     * @return Result of the SearchListings operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchListings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchListings" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchListingsResponse searchListings(Consumer<SearchListingsRequest.Builder> searchListingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return searchListings(SearchListingsRequest.builder().applyMutation(searchListingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchListings(software.amazon.awssdk.services.datazone.model.SearchListingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchListingsIterable responses = client.searchListingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.SearchListingsIterable responses = client
     *             .searchListingsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.SearchListingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchListingsIterable responses = client.searchListingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchListings(software.amazon.awssdk.services.datazone.model.SearchListingsRequest)} operation.</b>
     * </p>
     *
     * @param searchListingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchListings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchListings" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchListingsIterable searchListingsPaginator(SearchListingsRequest searchListingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new SearchListingsIterable(this, searchListingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchListings(software.amazon.awssdk.services.datazone.model.SearchListingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchListingsIterable responses = client.searchListingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.SearchListingsIterable responses = client
     *             .searchListingsPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.SearchListingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchListingsIterable responses = client.searchListingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchListings(software.amazon.awssdk.services.datazone.model.SearchListingsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchListingsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchListingsRequest#builder()}
     * </p>
     *
     * @param searchListingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchListingsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchListings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchListings" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchListingsIterable searchListingsPaginator(Consumer<SearchListingsRequest.Builder> searchListingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return searchListingsPaginator(SearchListingsRequest.builder().applyMutation(searchListingsRequest).build());
    }

    /**
     * <p>
     * Searches for types in Amazon DataZone.
     * </p>
     *
     * @param searchTypesRequest
     * @return Result of the SearchTypes operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTypesResponse searchTypes(SearchTypesRequest searchTypesRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for types in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchTypesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchTypesRequest#builder()}
     * </p>
     *
     * @param searchTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchTypesRequest.Builder} to create a request.
     * @return Result of the SearchTypes operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTypesResponse searchTypes(Consumer<SearchTypesRequest.Builder> searchTypesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return searchTypes(SearchTypesRequest.builder().applyMutation(searchTypesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #searchTypes(software.amazon.awssdk.services.datazone.model.SearchTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchTypesIterable responses = client.searchTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.SearchTypesIterable responses = client.searchTypesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.SearchTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchTypesIterable responses = client.searchTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchTypes(software.amazon.awssdk.services.datazone.model.SearchTypesRequest)} operation.</b>
     * </p>
     *
     * @param searchTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTypesIterable searchTypesPaginator(SearchTypesRequest searchTypesRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return new SearchTypesIterable(this, searchTypesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #searchTypes(software.amazon.awssdk.services.datazone.model.SearchTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchTypesIterable responses = client.searchTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.SearchTypesIterable responses = client.searchTypesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.SearchTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchTypesIterable responses = client.searchTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchTypes(software.amazon.awssdk.services.datazone.model.SearchTypesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchTypesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchTypesRequest#builder()}
     * </p>
     *
     * @param searchTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchTypesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTypesIterable searchTypesPaginator(Consumer<SearchTypesRequest.Builder> searchTypesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return searchTypesPaginator(SearchTypesRequest.builder().applyMutation(searchTypesRequest).build());
    }

    /**
     * <p>
     * Searches user profiles in Amazon DataZone.
     * </p>
     *
     * @param searchUserProfilesRequest
     * @return Result of the SearchUserProfiles operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchUserProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchUserProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUserProfilesResponse searchUserProfiles(SearchUserProfilesRequest searchUserProfilesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches user profiles in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchUserProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchUserProfilesRequest#builder()}
     * </p>
     *
     * @param searchUserProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the SearchUserProfiles operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchUserProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchUserProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUserProfilesResponse searchUserProfiles(Consumer<SearchUserProfilesRequest.Builder> searchUserProfilesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return searchUserProfiles(SearchUserProfilesRequest.builder().applyMutation(searchUserProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchUserProfiles(software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchUserProfilesIterable responses = client.searchUserProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.SearchUserProfilesIterable responses = client
     *             .searchUserProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.SearchUserProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchUserProfilesIterable responses = client.searchUserProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUserProfiles(software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchUserProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchUserProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchUserProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUserProfilesIterable searchUserProfilesPaginator(SearchUserProfilesRequest searchUserProfilesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return new SearchUserProfilesIterable(this, searchUserProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchUserProfiles(software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchUserProfilesIterable responses = client.searchUserProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datazone.paginators.SearchUserProfilesIterable responses = client
     *             .searchUserProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.datazone.model.SearchUserProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchUserProfilesIterable responses = client.searchUserProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUserProfiles(software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchUserProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchUserProfilesRequest#builder()}
     * </p>
     *
     * @param searchUserProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.SearchUserProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchUserProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUserProfilesIterable searchUserProfilesPaginator(
            Consumer<SearchUserProfilesRequest.Builder> searchUserProfilesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        return searchUserProfilesPaginator(SearchUserProfilesRequest.builder().applyMutation(searchUserProfilesRequest).build());
    }

    /**
     * <p>
     * Start the run of the specified data source in Amazon DataZone.
     * </p>
     *
     * @param startDataSourceRunRequest
     * @return Result of the StartDataSourceRun operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.StartDataSourceRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/StartDataSourceRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StartDataSourceRunResponse startDataSourceRun(StartDataSourceRunRequest startDataSourceRunRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start the run of the specified data source in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDataSourceRunRequest.Builder} avoiding the
     * need to create one manually via {@link StartDataSourceRunRequest#builder()}
     * </p>
     *
     * @param startDataSourceRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.StartDataSourceRunRequest.Builder} to create a
     *        request.
     * @return Result of the StartDataSourceRun operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.StartDataSourceRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/StartDataSourceRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StartDataSourceRunResponse startDataSourceRun(Consumer<StartDataSourceRunRequest.Builder> startDataSourceRunRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return startDataSourceRun(StartDataSourceRunRequest.builder().applyMutation(startDataSourceRunRequest).build());
    }

    /**
     * <p>
     * Starts the metadata generation run.
     * </p>
     *
     * @param startMetadataGenerationRunRequest
     * @return Result of the StartMetadataGenerationRun operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.StartMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/StartMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMetadataGenerationRunResponse startMetadataGenerationRun(
            StartMetadataGenerationRunRequest startMetadataGenerationRunRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ConflictException, ValidationException, UnauthorizedException, AwsServiceException, SdkClientException,
            DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the metadata generation run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMetadataGenerationRunRequest.Builder} avoiding
     * the need to create one manually via {@link StartMetadataGenerationRunRequest#builder()}
     * </p>
     *
     * @param startMetadataGenerationRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.StartMetadataGenerationRunRequest.Builder} to create
     *        a request.
     * @return Result of the StartMetadataGenerationRun operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The request has exceeded the specified service quota.
     * @throws ConflictException
     *         There is a conflict while performing this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.StartMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/StartMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMetadataGenerationRunResponse startMetadataGenerationRun(
            Consumer<StartMetadataGenerationRunRequest.Builder> startMetadataGenerationRunRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ConflictException, ValidationException, UnauthorizedException, AwsServiceException,
            SdkClientException, DataZoneException {
        return startMetadataGenerationRun(StartMetadataGenerationRunRequest.builder()
                .applyMutation(startMetadataGenerationRunRequest).build());
    }

    /**
     * <p>
     * Tags a resource in Amazon DataZone.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, UnauthorizedException,
            AwsServiceException, SdkClientException, DataZoneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the Amazon Web Services service.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataZoneClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, UnauthorizedException, AwsServiceException, SdkClientException, DataZoneException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untags a resource in Amazon DataZone.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UnauthorizedException
     *         You do not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataZoneException
     *         Base class for all