/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an asset published in an Amazon DataZone catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetListingDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetListingDetails.Builder, AssetListingDetails> {
    private static final SdkField<String> LISTING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listingId").getter(getter(AssetListingDetails::listingId)).setter(setter(Builder::listingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingId").build()).build();

    private static final SdkField<String> LISTING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listingStatus").getter(getter(AssetListingDetails::listingStatusAsString))
            .setter(setter(Builder::listingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTING_ID_FIELD,
            LISTING_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String listingId;

    private final String listingStatus;

    private AssetListingDetails(BuilderImpl builder) {
        this.listingId = builder.listingId;
        this.listingStatus = builder.listingStatus;
    }

    /**
     * <p>
     * The identifier of an asset published in an Amazon DataZone catalog.
     * </p>
     * 
     * @return The identifier of an asset published in an Amazon DataZone catalog.
     */
    public final String listingId() {
        return listingId;
    }

    /**
     * <p>
     * The status of an asset published in an Amazon DataZone catalog.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listingStatus}
     * will return {@link ListingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #listingStatusAsString}.
     * </p>
     * 
     * @return The status of an asset published in an Amazon DataZone catalog.
     * @see ListingStatus
     */
    public final ListingStatus listingStatus() {
        return ListingStatus.fromValue(listingStatus);
    }

    /**
     * <p>
     * The status of an asset published in an Amazon DataZone catalog.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listingStatus}
     * will return {@link ListingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #listingStatusAsString}.
     * </p>
     * 
     * @return The status of an asset published in an Amazon DataZone catalog.
     * @see ListingStatus
     */
    public final String listingStatusAsString() {
        return listingStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listingId());
        hashCode = 31 * hashCode + Objects.hashCode(listingStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetListingDetails)) {
            return false;
        }
        AssetListingDetails other = (AssetListingDetails) obj;
        return Objects.equals(listingId(), other.listingId())
                && Objects.equals(listingStatusAsString(), other.listingStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetListingDetails").add("ListingId", listingId())
                .add("ListingStatus", listingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "listingId":
            return Optional.ofNullable(clazz.cast(listingId()));
        case "listingStatus":
            return Optional.ofNullable(clazz.cast(listingStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("listingId", LISTING_ID_FIELD);
        map.put("listingStatus", LISTING_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetListingDetails, T> g) {
        return obj -> g.apply((AssetListingDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetListingDetails> {
        /**
         * <p>
         * The identifier of an asset published in an Amazon DataZone catalog.
         * </p>
         * 
         * @param listingId
         *        The identifier of an asset published in an Amazon DataZone catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingId(String listingId);

        /**
         * <p>
         * The status of an asset published in an Amazon DataZone catalog.
         * </p>
         * 
         * @param listingStatus
         *        The status of an asset published in an Amazon DataZone catalog.
         * @see ListingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingStatus
         */
        Builder listingStatus(String listingStatus);

        /**
         * <p>
         * The status of an asset published in an Amazon DataZone catalog.
         * </p>
         * 
         * @param listingStatus
         *        The status of an asset published in an Amazon DataZone catalog.
         * @see ListingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingStatus
         */
        Builder listingStatus(ListingStatus listingStatus);
    }

    static final class BuilderImpl implements Builder {
        private String listingId;

        private String listingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetListingDetails model) {
            listingId(model.listingId);
            listingStatus(model.listingStatus);
        }

        public final String getListingId() {
            return listingId;
        }

        public final void setListingId(String listingId) {
            this.listingId = listingId;
        }

        @Override
        public final Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public final String getListingStatus() {
            return listingStatus;
        }

        public final void setListingStatus(String listingStatus) {
            this.listingStatus = listingStatus;
        }

        @Override
        public final Builder listingStatus(String listingStatus) {
            this.listingStatus = listingStatus;
            return this;
        }

        @Override
        public final Builder listingStatus(ListingStatus listingStatus) {
            this.listingStatus(listingStatus == null ? null : listingStatus.toString());
            return this;
        }

        @Override
        public AssetListingDetails build() {
            return new AssetListingDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
