/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The asset scope.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetScope implements SdkPojo, Serializable, ToCopyableBuilder<AssetScope.Builder, AssetScope> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(AssetScope::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(AssetScope::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<List<String>> FILTER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("filterIds")
            .getter(getter(AssetScope::filterIds))
            .setter(setter(Builder::filterIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AssetScope::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            ERROR_MESSAGE_FIELD, FILTER_IDS_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String assetId;

    private final String errorMessage;

    private final List<String> filterIds;

    private final String status;

    private AssetScope(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.errorMessage = builder.errorMessage;
        this.filterIds = builder.filterIds;
        this.status = builder.status;
    }

    /**
     * <p>
     * The asset ID of the asset scope.
     * </p>
     * 
     * @return The asset ID of the asset scope.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The error message of the asset scope.
     * </p>
     * 
     * @return The error message of the asset scope.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilterIds() {
        return filterIds != null && !(filterIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter IDs of the asset scope.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterIds} method.
     * </p>
     * 
     * @return The filter IDs of the asset scope.
     */
    public final List<String> filterIds() {
        return filterIds;
    }

    /**
     * <p>
     * The status of the asset scope.
     * </p>
     * 
     * @return The status of the asset scope.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterIds() ? filterIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetScope)) {
            return false;
        }
        AssetScope other = (AssetScope) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(errorMessage(), other.errorMessage())
                && hasFilterIds() == other.hasFilterIds() && Objects.equals(filterIds(), other.filterIds())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetScope").add("AssetId", assetId()).add("ErrorMessage", errorMessage())
                .add("FilterIds", hasFilterIds() ? filterIds() : null).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "filterIds":
            return Optional.ofNullable(clazz.cast(filterIds()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("filterIds", FILTER_IDS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetScope, T> g) {
        return obj -> g.apply((AssetScope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetScope> {
        /**
         * <p>
         * The asset ID of the asset scope.
         * </p>
         * 
         * @param assetId
         *        The asset ID of the asset scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The error message of the asset scope.
         * </p>
         * 
         * @param errorMessage
         *        The error message of the asset scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The filter IDs of the asset scope.
         * </p>
         * 
         * @param filterIds
         *        The filter IDs of the asset scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterIds(Collection<String> filterIds);

        /**
         * <p>
         * The filter IDs of the asset scope.
         * </p>
         * 
         * @param filterIds
         *        The filter IDs of the asset scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterIds(String... filterIds);

        /**
         * <p>
         * The status of the asset scope.
         * </p>
         * 
         * @param status
         *        The status of the asset scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String assetId;

        private String errorMessage;

        private List<String> filterIds = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetScope model) {
            assetId(model.assetId);
            errorMessage(model.errorMessage);
            filterIds(model.filterIds);
            status(model.status);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Collection<String> getFilterIds() {
            if (filterIds instanceof SdkAutoConstructList) {
                return null;
            }
            return filterIds;
        }

        public final void setFilterIds(Collection<String> filterIds) {
            this.filterIds = FilterIdsCopier.copy(filterIds);
        }

        @Override
        public final Builder filterIds(Collection<String> filterIds) {
            this.filterIds = FilterIdsCopier.copy(filterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterIds(String... filterIds) {
            filterIds(Arrays.asList(filterIds));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public AssetScope build() {
            return new AssetScope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
