/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connection properties patch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionPropertiesPatch implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionPropertiesPatch.Builder, ConnectionPropertiesPatch> {
    private static final SdkField<AthenaPropertiesPatch> ATHENA_PROPERTIES_FIELD = SdkField
            .<AthenaPropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("athenaProperties")
            .getter(getter(ConnectionPropertiesPatch::athenaProperties)).setter(setter(Builder::athenaProperties))
            .constructor(AthenaPropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("athenaProperties").build()).build();

    private static final SdkField<GluePropertiesPatch> GLUE_PROPERTIES_FIELD = SdkField
            .<GluePropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("glueProperties")
            .getter(getter(ConnectionPropertiesPatch::glueProperties)).setter(setter(Builder::glueProperties))
            .constructor(GluePropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueProperties").build()).build();

    private static final SdkField<IamPropertiesPatch> IAM_PROPERTIES_FIELD = SdkField
            .<IamPropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("iamProperties")
            .getter(getter(ConnectionPropertiesPatch::iamProperties)).setter(setter(Builder::iamProperties))
            .constructor(IamPropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamProperties").build()).build();

    private static final SdkField<RedshiftPropertiesPatch> REDSHIFT_PROPERTIES_FIELD = SdkField
            .<RedshiftPropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("redshiftProperties")
            .getter(getter(ConnectionPropertiesPatch::redshiftProperties)).setter(setter(Builder::redshiftProperties))
            .constructor(RedshiftPropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftProperties").build())
            .build();

    private static final SdkField<SparkEmrPropertiesPatch> SPARK_EMR_PROPERTIES_FIELD = SdkField
            .<SparkEmrPropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("sparkEmrProperties")
            .getter(getter(ConnectionPropertiesPatch::sparkEmrProperties)).setter(setter(Builder::sparkEmrProperties))
            .constructor(SparkEmrPropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkEmrProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_PROPERTIES_FIELD,
            GLUE_PROPERTIES_FIELD, IAM_PROPERTIES_FIELD, REDSHIFT_PROPERTIES_FIELD, SPARK_EMR_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AthenaPropertiesPatch athenaProperties;

    private final GluePropertiesPatch glueProperties;

    private final IamPropertiesPatch iamProperties;

    private final RedshiftPropertiesPatch redshiftProperties;

    private final SparkEmrPropertiesPatch sparkEmrProperties;

    private final Type type;

    private ConnectionPropertiesPatch(BuilderImpl builder) {
        this.athenaProperties = builder.athenaProperties;
        this.glueProperties = builder.glueProperties;
        this.iamProperties = builder.iamProperties;
        this.redshiftProperties = builder.redshiftProperties;
        this.sparkEmrProperties = builder.sparkEmrProperties;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Athena properties of a connection properties patch.
     * </p>
     * 
     * @return The Amazon Athena properties of a connection properties patch.
     */
    public final AthenaPropertiesPatch athenaProperties() {
        return athenaProperties;
    }

    /**
     * <p>
     * The Amazon Web Services Glue properties of a connection properties patch.
     * </p>
     * 
     * @return The Amazon Web Services Glue properties of a connection properties patch.
     */
    public final GluePropertiesPatch glueProperties() {
        return glueProperties;
    }

    /**
     * <p>
     * The IAM properties of a connection properties patch.
     * </p>
     * 
     * @return The IAM properties of a connection properties patch.
     */
    public final IamPropertiesPatch iamProperties() {
        return iamProperties;
    }

    /**
     * <p>
     * The Amazon Redshift properties of a connection properties patch.
     * </p>
     * 
     * @return The Amazon Redshift properties of a connection properties patch.
     */
    public final RedshiftPropertiesPatch redshiftProperties() {
        return redshiftProperties;
    }

    /**
     * <p>
     * The Spark EMR properties of a connection properties patch.
     * </p>
     * 
     * @return The Spark EMR properties of a connection properties patch.
     */
    public final SparkEmrPropertiesPatch sparkEmrProperties() {
        return sparkEmrProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(athenaProperties());
        hashCode = 31 * hashCode + Objects.hashCode(glueProperties());
        hashCode = 31 * hashCode + Objects.hashCode(iamProperties());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sparkEmrProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionPropertiesPatch)) {
            return false;
        }
        ConnectionPropertiesPatch other = (ConnectionPropertiesPatch) obj;
        return Objects.equals(athenaProperties(), other.athenaProperties())
                && Objects.equals(glueProperties(), other.glueProperties())
                && Objects.equals(iamProperties(), other.iamProperties())
                && Objects.equals(redshiftProperties(), other.redshiftProperties())
                && Objects.equals(sparkEmrProperties(), other.sparkEmrProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionPropertiesPatch").add("AthenaProperties", athenaProperties())
                .add("GlueProperties", glueProperties()).add("IamProperties", iamProperties())
                .add("RedshiftProperties", redshiftProperties()).add("SparkEmrProperties", sparkEmrProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "athenaProperties":
            return Optional.ofNullable(clazz.cast(athenaProperties()));
        case "glueProperties":
            return Optional.ofNullable(clazz.cast(glueProperties()));
        case "iamProperties":
            return Optional.ofNullable(clazz.cast(iamProperties()));
        case "redshiftProperties":
            return Optional.ofNullable(clazz.cast(redshiftProperties()));
        case "sparkEmrProperties":
            return Optional.ofNullable(clazz.cast(sparkEmrProperties()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #athenaProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Athena properties of a connection properties patch.
     * </p>
     * 
     * @param athenaProperties
     *        The Amazon Athena properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromAthenaProperties(AthenaPropertiesPatch athenaProperties) {
        return builder().athenaProperties(athenaProperties).build();
    }

    /**
     * Create an instance of this class with {@link #athenaProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Athena properties of a connection properties patch.
     * </p>
     * 
     * @param athenaProperties
     *        The Amazon Athena properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromAthenaProperties(Consumer<AthenaPropertiesPatch.Builder> athenaProperties) {
        AthenaPropertiesPatch.Builder builder = AthenaPropertiesPatch.builder();
        athenaProperties.accept(builder);
        return fromAthenaProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #glueProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Web Services Glue properties of a connection properties patch.
     * </p>
     * 
     * @param glueProperties
     *        The Amazon Web Services Glue properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromGlueProperties(GluePropertiesPatch glueProperties) {
        return builder().glueProperties(glueProperties).build();
    }

    /**
     * Create an instance of this class with {@link #glueProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Web Services Glue properties of a connection properties patch.
     * </p>
     * 
     * @param glueProperties
     *        The Amazon Web Services Glue properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromGlueProperties(Consumer<GluePropertiesPatch.Builder> glueProperties) {
        GluePropertiesPatch.Builder builder = GluePropertiesPatch.builder();
        glueProperties.accept(builder);
        return fromGlueProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #iamProperties()} initialized to the given value.
     *
     * <p>
     * The IAM properties of a connection properties patch.
     * </p>
     * 
     * @param iamProperties
     *        The IAM properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromIamProperties(IamPropertiesPatch iamProperties) {
        return builder().iamProperties(iamProperties).build();
    }

    /**
     * Create an instance of this class with {@link #iamProperties()} initialized to the given value.
     *
     * <p>
     * The IAM properties of a connection properties patch.
     * </p>
     * 
     * @param iamProperties
     *        The IAM properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromIamProperties(Consumer<IamPropertiesPatch.Builder> iamProperties) {
        IamPropertiesPatch.Builder builder = IamPropertiesPatch.builder();
        iamProperties.accept(builder);
        return fromIamProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #redshiftProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Redshift properties of a connection properties patch.
     * </p>
     * 
     * @param redshiftProperties
     *        The Amazon Redshift properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromRedshiftProperties(RedshiftPropertiesPatch redshiftProperties) {
        return builder().redshiftProperties(redshiftProperties).build();
    }

    /**
     * Create an instance of this class with {@link #redshiftProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Redshift properties of a connection properties patch.
     * </p>
     * 
     * @param redshiftProperties
     *        The Amazon Redshift properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromRedshiftProperties(Consumer<RedshiftPropertiesPatch.Builder> redshiftProperties) {
        RedshiftPropertiesPatch.Builder builder = RedshiftPropertiesPatch.builder();
        redshiftProperties.accept(builder);
        return fromRedshiftProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sparkEmrProperties()} initialized to the given value.
     *
     * <p>
     * The Spark EMR properties of a connection properties patch.
     * </p>
     * 
     * @param sparkEmrProperties
     *        The Spark EMR properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromSparkEmrProperties(SparkEmrPropertiesPatch sparkEmrProperties) {
        return builder().sparkEmrProperties(sparkEmrProperties).build();
    }

    /**
     * Create an instance of this class with {@link #sparkEmrProperties()} initialized to the given value.
     *
     * <p>
     * The Spark EMR properties of a connection properties patch.
     * </p>
     * 
     * @param sparkEmrProperties
     *        The Spark EMR properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromSparkEmrProperties(Consumer<SparkEmrPropertiesPatch.Builder> sparkEmrProperties) {
        SparkEmrPropertiesPatch.Builder builder = SparkEmrPropertiesPatch.builder();
        sparkEmrProperties.accept(builder);
        return fromSparkEmrProperties(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("athenaProperties", ATHENA_PROPERTIES_FIELD);
        map.put("glueProperties", GLUE_PROPERTIES_FIELD);
        map.put("iamProperties", IAM_PROPERTIES_FIELD);
        map.put("redshiftProperties", REDSHIFT_PROPERTIES_FIELD);
        map.put("sparkEmrProperties", SPARK_EMR_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionPropertiesPatch, T> g) {
        return obj -> g.apply((ConnectionPropertiesPatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionPropertiesPatch> {
        /**
         * <p>
         * The Amazon Athena properties of a connection properties patch.
         * </p>
         * 
         * @param athenaProperties
         *        The Amazon Athena properties of a connection properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaProperties(AthenaPropertiesPatch athenaProperties);

        /**
         * <p>
         * The Amazon Athena properties of a connection properties patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link AthenaPropertiesPatch.Builder} avoiding
         * the need to create one manually via {@link AthenaPropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AthenaPropertiesPatch.Builder#build()} is called immediately and
         * its result is passed to {@link #athenaProperties(AthenaPropertiesPatch)}.
         * 
         * @param athenaProperties
         *        a consumer that will call methods on {@link AthenaPropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #athenaProperties(AthenaPropertiesPatch)
         */
        default Builder athenaProperties(Consumer<AthenaPropertiesPatch.Builder> athenaProperties) {
            return athenaProperties(AthenaPropertiesPatch.builder().applyMutation(athenaProperties).build());
        }

        /**
         * <p>
         * The Amazon Web Services Glue properties of a connection properties patch.
         * </p>
         * 
         * @param glueProperties
         *        The Amazon Web Services Glue properties of a connection properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueProperties(GluePropertiesPatch glueProperties);

        /**
         * <p>
         * The Amazon Web Services Glue properties of a connection properties patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link GluePropertiesPatch.Builder} avoiding the
         * need to create one manually via {@link GluePropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GluePropertiesPatch.Builder#build()} is called immediately and
         * its result is passed to {@link #glueProperties(GluePropertiesPatch)}.
         * 
         * @param glueProperties
         *        a consumer that will call methods on {@link GluePropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glueProperties(GluePropertiesPatch)
         */
        default Builder glueProperties(Consumer<GluePropertiesPatch.Builder> glueProperties) {
            return glueProperties(GluePropertiesPatch.builder().applyMutation(glueProperties).build());
        }

        /**
         * <p>
         * The IAM properties of a connection properties patch.
         * </p>
         * 
         * @param iamProperties
         *        The IAM properties of a connection properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamProperties(IamPropertiesPatch iamProperties);

        /**
         * <p>
         * The IAM properties of a connection properties patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamPropertiesPatch.Builder} avoiding the
         * need to create one manually via {@link IamPropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamPropertiesPatch.Builder#build()} is called immediately and its
         * result is passed to {@link #iamProperties(IamPropertiesPatch)}.
         * 
         * @param iamProperties
         *        a consumer that will call methods on {@link IamPropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamProperties(IamPropertiesPatch)
         */
        default Builder iamProperties(Consumer<IamPropertiesPatch.Builder> iamProperties) {
            return iamProperties(IamPropertiesPatch.builder().applyMutation(iamProperties).build());
        }

        /**
         * <p>
         * The Amazon Redshift properties of a connection properties patch.
         * </p>
         * 
         * @param redshiftProperties
         *        The Amazon Redshift properties of a connection properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftProperties(RedshiftPropertiesPatch redshiftProperties);

        /**
         * <p>
         * The Amazon Redshift properties of a connection properties patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftPropertiesPatch.Builder} avoiding
         * the need to create one manually via {@link RedshiftPropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftPropertiesPatch.Builder#build()} is called immediately
         * and its result is passed to {@link #redshiftProperties(RedshiftPropertiesPatch)}.
         * 
         * @param redshiftProperties
         *        a consumer that will call methods on {@link RedshiftPropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftProperties(RedshiftPropertiesPatch)
         */
        default Builder redshiftProperties(Consumer<RedshiftPropertiesPatch.Builder> redshiftProperties) {
            return redshiftProperties(RedshiftPropertiesPatch.builder().applyMutation(redshiftProperties).build());
        }

        /**
         * <p>
         * The Spark EMR properties of a connection properties patch.
         * </p>
         * 
         * @param sparkEmrProperties
         *        The Spark EMR properties of a connection properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkEmrProperties(SparkEmrPropertiesPatch sparkEmrProperties);

        /**
         * <p>
         * The Spark EMR properties of a connection properties patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkEmrPropertiesPatch.Builder} avoiding
         * the need to create one manually via {@link SparkEmrPropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkEmrPropertiesPatch.Builder#build()} is called immediately
         * and its result is passed to {@link #sparkEmrProperties(SparkEmrPropertiesPatch)}.
         * 
         * @param sparkEmrProperties
         *        a consumer that will call methods on {@link SparkEmrPropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkEmrProperties(SparkEmrPropertiesPatch)
         */
        default Builder sparkEmrProperties(Consumer<SparkEmrPropertiesPatch.Builder> sparkEmrProperties) {
            return sparkEmrProperties(SparkEmrPropertiesPatch.builder().applyMutation(sparkEmrProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AthenaPropertiesPatch athenaProperties;

        private GluePropertiesPatch glueProperties;

        private IamPropertiesPatch iamProperties;

        private RedshiftPropertiesPatch redshiftProperties;

        private SparkEmrPropertiesPatch sparkEmrProperties;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionPropertiesPatch model) {
            athenaProperties(model.athenaProperties);
            glueProperties(model.glueProperties);
            iamProperties(model.iamProperties);
            redshiftProperties(model.redshiftProperties);
            sparkEmrProperties(model.sparkEmrProperties);
        }

        public final AthenaPropertiesPatch.Builder getAthenaProperties() {
            return athenaProperties != null ? athenaProperties.toBuilder() : null;
        }

        public final void setAthenaProperties(AthenaPropertiesPatch.BuilderImpl athenaProperties) {
            Object oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties != null ? athenaProperties.build() : null;
            handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
        }

        @Override
        public final Builder athenaProperties(AthenaPropertiesPatch athenaProperties) {
            Object oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties;
            handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
            return this;
        }

        public final GluePropertiesPatch.Builder getGlueProperties() {
            return glueProperties != null ? glueProperties.toBuilder() : null;
        }

        public final void setGlueProperties(GluePropertiesPatch.BuilderImpl glueProperties) {
            Object oldValue = this.glueProperties;
            this.glueProperties = glueProperties != null ? glueProperties.build() : null;
            handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
        }

        @Override
        public final Builder glueProperties(GluePropertiesPatch glueProperties) {
            Object oldValue = this.glueProperties;
            this.glueProperties = glueProperties;
            handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
            return this;
        }

        public final IamPropertiesPatch.Builder getIamProperties() {
            return iamProperties != null ? iamProperties.toBuilder() : null;
        }

        public final void setIamProperties(IamPropertiesPatch.BuilderImpl iamProperties) {
            Object oldValue = this.iamProperties;
            this.iamProperties = iamProperties != null ? iamProperties.build() : null;
            handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
        }

        @Override
        public final Builder iamProperties(IamPropertiesPatch iamProperties) {
            Object oldValue = this.iamProperties;
            this.iamProperties = iamProperties;
            handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
            return this;
        }

        public final RedshiftPropertiesPatch.Builder getRedshiftProperties() {
            return redshiftProperties != null ? redshiftProperties.toBuilder() : null;
        }

        public final void setRedshiftProperties(RedshiftPropertiesPatch.BuilderImpl redshiftProperties) {
            Object oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties != null ? redshiftProperties.build() : null;
            handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
        }

        @Override
        public final Builder redshiftProperties(RedshiftPropertiesPatch redshiftProperties) {
            Object oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties;
            handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
            return this;
        }

        public final SparkEmrPropertiesPatch.Builder getSparkEmrProperties() {
            return sparkEmrProperties != null ? sparkEmrProperties.toBuilder() : null;
        }

        public final void setSparkEmrProperties(SparkEmrPropertiesPatch.BuilderImpl sparkEmrProperties) {
            Object oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties != null ? sparkEmrProperties.build() : null;
            handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
        }

        @Override
        public final Builder sparkEmrProperties(SparkEmrPropertiesPatch sparkEmrProperties) {
            Object oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties;
            handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
            return this;
        }

        @Override
        public ConnectionPropertiesPatch build() {
            return new ConnectionPropertiesPatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ConnectionPropertiesPatch#type()
     */
    public enum Type {
        ATHENA_PROPERTIES,

        GLUE_PROPERTIES,

        IAM_PROPERTIES,

        REDSHIFT_PROPERTIES,

        SPARK_EMR_PROPERTIES,

        UNKNOWN_TO_SDK_VERSION
    }
}
