/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleResponse extends DataZoneResponse implements
        ToCopyableBuilder<CreateRuleResponse.Builder, CreateRuleResponse> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(CreateRuleResponse::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CreateRuleResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(CreateRuleResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateRuleResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<RuleDetail> DETAIL_FIELD = SdkField.<RuleDetail> builder(MarshallingType.SDK_POJO)
            .memberName("detail").getter(getter(CreateRuleResponse::detail)).setter(setter(Builder::detail))
            .constructor(RuleDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detail").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(CreateRuleResponse::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRuleResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleType").getter(getter(CreateRuleResponse::ruleTypeAsString)).setter(setter(Builder::ruleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleType").build()).build();

    private static final SdkField<RuleScope> SCOPE_FIELD = SdkField.<RuleScope> builder(MarshallingType.SDK_POJO)
            .memberName("scope").getter(getter(CreateRuleResponse::scope)).setter(setter(Builder::scope))
            .constructor(RuleScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<RuleTarget> TARGET_FIELD = SdkField.<RuleTarget> builder(MarshallingType.SDK_POJO)
            .memberName("target").getter(getter(CreateRuleResponse::target)).setter(setter(Builder::target))
            .constructor(RuleTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetType").getter(getter(CreateRuleResponse::targetTypeAsString)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DETAIL_FIELD, IDENTIFIER_FIELD, NAME_FIELD, RULE_TYPE_FIELD,
            SCOPE_FIELD, TARGET_FIELD, TARGET_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String action;

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final RuleDetail detail;

    private final String identifier;

    private final String name;

    private final String ruleType;

    private final RuleScope scope;

    private final RuleTarget target;

    private final String targetType;

    private CreateRuleResponse(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.detail = builder.detail;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.ruleType = builder.ruleType;
        this.scope = builder.scope;
        this.target = builder.target;
        this.targetType = builder.targetType;
    }

    /**
     * <p>
     * The action of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action of the rule.
     * @see RuleAction
     */
    public final RuleAction action() {
        return RuleAction.fromValue(action);
    }

    /**
     * <p>
     * The action of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action of the rule.
     * @see RuleAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The timestamp at which the rule is created.
     * </p>
     * 
     * @return The timestamp at which the rule is created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who creates the rule.
     * </p>
     * 
     * @return The user who creates the rule.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of the rule.
     * </p>
     * 
     * @return The description of the rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The detail of the rule.
     * </p>
     * 
     * @return The detail of the rule.
     */
    public final RuleDetail detail() {
        return detail;
    }

    /**
     * <p>
     * The ID of the rule.
     * </p>
     * 
     * @return The ID of the rule.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleType} will
     * return {@link RuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleTypeAsString}.
     * </p>
     * 
     * @return The type of the rule.
     * @see RuleType
     */
    public final RuleType ruleType() {
        return RuleType.fromValue(ruleType);
    }

    /**
     * <p>
     * The type of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleType} will
     * return {@link RuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleTypeAsString}.
     * </p>
     * 
     * @return The type of the rule.
     * @see RuleType
     */
    public final String ruleTypeAsString() {
        return ruleType;
    }

    /**
     * <p>
     * The scope of the rule.
     * </p>
     * 
     * @return The scope of the rule.
     */
    public final RuleScope scope() {
        return scope;
    }

    /**
     * <p>
     * The target of the rule.
     * </p>
     * 
     * @return The target of the rule.
     */
    public final RuleTarget target() {
        return target;
    }

    /**
     * <p>
     * The target type of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link RuleTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The target type of the rule.
     * @see RuleTargetType
     */
    public final RuleTargetType targetType() {
        return RuleTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The target type of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link RuleTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The target type of the rule.
     * @see RuleTargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(detail());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ruleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleResponse)) {
            return false;
        }
        CreateRuleResponse other = (CreateRuleResponse) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(description(), other.description())
                && Objects.equals(detail(), other.detail()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(name(), other.name()) && Objects.equals(ruleTypeAsString(), other.ruleTypeAsString())
                && Objects.equals(scope(), other.scope()) && Objects.equals(target(), other.target())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRuleResponse").add("Action", actionAsString()).add("CreatedAt", createdAt())
                .add("CreatedBy", createdBy())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Detail", detail())
                .add("Identifier", identifier()).add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RuleType", ruleTypeAsString()).add("Scope", scope()).add("Target", target())
                .add("TargetType", targetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "detail":
            return Optional.ofNullable(clazz.cast(detail()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ruleType":
            return Optional.ofNullable(clazz.cast(ruleTypeAsString()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("detail", DETAIL_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("ruleType", RULE_TYPE_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("targetType", TARGET_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleResponse, T> g) {
        return obj -> g.apply((CreateRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleResponse> {
        /**
         * <p>
         * The action of the rule.
         * </p>
         * 
         * @param action
         *        The action of the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action of the rule.
         * </p>
         * 
         * @param action
         *        The action of the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder action(RuleAction action);

        /**
         * <p>
         * The timestamp at which the rule is created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp at which the rule is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who creates the rule.
         * </p>
         * 
         * @param createdBy
         *        The user who creates the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of the rule.
         * </p>
         * 
         * @param description
         *        The description of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The detail of the rule.
         * </p>
         * 
         * @param detail
         *        The detail of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detail(RuleDetail detail);

        /**
         * <p>
         * The detail of the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleDetail.Builder} avoiding the need to
         * create one manually via {@link RuleDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #detail(RuleDetail)}.
         * 
         * @param detail
         *        a consumer that will call methods on {@link RuleDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detail(RuleDetail)
         */
        default Builder detail(Consumer<RuleDetail.Builder> detail) {
            return detail(RuleDetail.builder().applyMutation(detail).build());
        }

        /**
         * <p>
         * The ID of the rule.
         * </p>
         * 
         * @param identifier
         *        The ID of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param name
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the rule.
         * </p>
         * 
         * @param ruleType
         *        The type of the rule.
         * @see RuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleType
         */
        Builder ruleType(String ruleType);

        /**
         * <p>
         * The type of the rule.
         * </p>
         * 
         * @param ruleType
         *        The type of the rule.
         * @see RuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleType
         */
        Builder ruleType(RuleType ruleType);

        /**
         * <p>
         * The scope of the rule.
         * </p>
         * 
         * @param scope
         *        The scope of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(RuleScope scope);

        /**
         * <p>
         * The scope of the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleScope.Builder} avoiding the need to
         * create one manually via {@link RuleScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleScope.Builder#build()} is called immediately and its result
         * is passed to {@link #scope(RuleScope)}.
         * 
         * @param scope
         *        a consumer that will call methods on {@link RuleScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scope(RuleScope)
         */
        default Builder scope(Consumer<RuleScope.Builder> scope) {
            return scope(RuleScope.builder().applyMutation(scope).build());
        }

        /**
         * <p>
         * The target of the rule.
         * </p>
         * 
         * @param target
         *        The target of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(RuleTarget target);

        /**
         * <p>
         * The target of the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleTarget.Builder} avoiding the need to
         * create one manually via {@link RuleTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleTarget.Builder#build()} is called immediately and its result
         * is passed to {@link #target(RuleTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link RuleTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(RuleTarget)
         */
        default Builder target(Consumer<RuleTarget.Builder> target) {
            return target(RuleTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * The target type of the rule.
         * </p>
         * 
         * @param targetType
         *        The target type of the rule.
         * @see RuleTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The target type of the rule.
         * </p>
         * 
         * @param targetType
         *        The target type of the rule.
         * @see RuleTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleTargetType
         */
        Builder targetType(RuleTargetType targetType);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String action;

        private Instant createdAt;

        private String createdBy;

        private String description;

        private RuleDetail detail;

        private String identifier;

        private String name;

        private String ruleType;

        private RuleScope scope;

        private RuleTarget target;

        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleResponse model) {
            super(model);
            action(model.action);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            detail(model.detail);
            identifier(model.identifier);
            name(model.name);
            ruleType(model.ruleType);
            scope(model.scope);
            target(model.target);
            targetType(model.targetType);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(RuleAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RuleDetail.Builder getDetail() {
            return detail != null ? detail.toBuilder() : null;
        }

        public final void setDetail(RuleDetail.BuilderImpl detail) {
            this.detail = detail != null ? detail.build() : null;
        }

        @Override
        public final Builder detail(RuleDetail detail) {
            this.detail = detail;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuleType() {
            return ruleType;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(RuleType ruleType) {
            this.ruleType(ruleType == null ? null : ruleType.toString());
            return this;
        }

        public final RuleScope.Builder getScope() {
            return scope != null ? scope.toBuilder() : null;
        }

        public final void setScope(RuleScope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(RuleScope scope) {
            this.scope = scope;
            return this;
        }

        public final RuleTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(RuleTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(RuleTarget target) {
            this.target = target;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(RuleTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        @Override
        public CreateRuleResponse build() {
            return new CreateRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
