/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceConfigurationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceConfigurationOutput.Builder, DataSourceConfigurationOutput> {
    private static final SdkField<GlueRunConfigurationOutput> GLUE_RUN_CONFIGURATION_FIELD = SdkField
            .<GlueRunConfigurationOutput> builder(MarshallingType.SDK_POJO).memberName("glueRunConfiguration")
            .getter(getter(DataSourceConfigurationOutput::glueRunConfiguration)).setter(setter(Builder::glueRunConfiguration))
            .constructor(GlueRunConfigurationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueRunConfiguration").build())
            .build();

    private static final SdkField<RedshiftRunConfigurationOutput> REDSHIFT_RUN_CONFIGURATION_FIELD = SdkField
            .<RedshiftRunConfigurationOutput> builder(MarshallingType.SDK_POJO).memberName("redshiftRunConfiguration")
            .getter(getter(DataSourceConfigurationOutput::redshiftRunConfiguration))
            .setter(setter(Builder::redshiftRunConfiguration)).constructor(RedshiftRunConfigurationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftRunConfiguration").build())
            .build();

    private static final SdkField<SageMakerRunConfigurationOutput> SAGE_MAKER_RUN_CONFIGURATION_FIELD = SdkField
            .<SageMakerRunConfigurationOutput> builder(MarshallingType.SDK_POJO).memberName("sageMakerRunConfiguration")
            .getter(getter(DataSourceConfigurationOutput::sageMakerRunConfiguration))
            .setter(setter(Builder::sageMakerRunConfiguration)).constructor(SageMakerRunConfigurationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sageMakerRunConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_RUN_CONFIGURATION_FIELD,
            REDSHIFT_RUN_CONFIGURATION_FIELD, SAGE_MAKER_RUN_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GlueRunConfigurationOutput glueRunConfiguration;

    private final RedshiftRunConfigurationOutput redshiftRunConfiguration;

    private final SageMakerRunConfigurationOutput sageMakerRunConfiguration;

    private final Type type;

    private DataSourceConfigurationOutput(BuilderImpl builder) {
        this.glueRunConfiguration = builder.glueRunConfiguration;
        this.redshiftRunConfiguration = builder.redshiftRunConfiguration;
        this.sageMakerRunConfiguration = builder.sageMakerRunConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The configuration of the Amazon Web Services Glue data source.
     * </p>
     * 
     * @return The configuration of the Amazon Web Services Glue data source.
     */
    public final GlueRunConfigurationOutput glueRunConfiguration() {
        return glueRunConfiguration;
    }

    /**
     * <p>
     * The configuration of the Amazon Redshift data source.
     * </p>
     * 
     * @return The configuration of the Amazon Redshift data source.
     */
    public final RedshiftRunConfigurationOutput redshiftRunConfiguration() {
        return redshiftRunConfiguration;
    }

    /**
     * <p>
     * The Amazon SageMaker run configuration.
     * </p>
     * 
     * @return The Amazon SageMaker run configuration.
     */
    public final SageMakerRunConfigurationOutput sageMakerRunConfiguration() {
        return sageMakerRunConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(glueRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sageMakerRunConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfigurationOutput)) {
            return false;
        }
        DataSourceConfigurationOutput other = (DataSourceConfigurationOutput) obj;
        return Objects.equals(glueRunConfiguration(), other.glueRunConfiguration())
                && Objects.equals(redshiftRunConfiguration(), other.redshiftRunConfiguration())
                && Objects.equals(sageMakerRunConfiguration(), other.sageMakerRunConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceConfigurationOutput").add("GlueRunConfiguration", glueRunConfiguration())
                .add("RedshiftRunConfiguration", redshiftRunConfiguration())
                .add("SageMakerRunConfiguration", sageMakerRunConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "glueRunConfiguration":
            return Optional.ofNullable(clazz.cast(glueRunConfiguration()));
        case "redshiftRunConfiguration":
            return Optional.ofNullable(clazz.cast(redshiftRunConfiguration()));
        case "sageMakerRunConfiguration":
            return Optional.ofNullable(clazz.cast(sageMakerRunConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #glueRunConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration of the Amazon Web Services Glue data source.
     * </p>
     * 
     * @param glueRunConfiguration
     *        The configuration of the Amazon Web Services Glue data source.
     */
    public static DataSourceConfigurationOutput fromGlueRunConfiguration(GlueRunConfigurationOutput glueRunConfiguration) {
        return builder().glueRunConfiguration(glueRunConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #glueRunConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration of the Amazon Web Services Glue data source.
     * </p>
     * 
     * @param glueRunConfiguration
     *        The configuration of the Amazon Web Services Glue data source.
     */
    public static DataSourceConfigurationOutput fromGlueRunConfiguration(
            Consumer<GlueRunConfigurationOutput.Builder> glueRunConfiguration) {
        GlueRunConfigurationOutput.Builder builder = GlueRunConfigurationOutput.builder();
        glueRunConfiguration.accept(builder);
        return fromGlueRunConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #redshiftRunConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration of the Amazon Redshift data source.
     * </p>
     * 
     * @param redshiftRunConfiguration
     *        The configuration of the Amazon Redshift data source.
     */
    public static DataSourceConfigurationOutput fromRedshiftRunConfiguration(
            RedshiftRunConfigurationOutput redshiftRunConfiguration) {
        return builder().redshiftRunConfiguration(redshiftRunConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #redshiftRunConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration of the Amazon Redshift data source.
     * </p>
     * 
     * @param redshiftRunConfiguration
     *        The configuration of the Amazon Redshift data source.
     */
    public static DataSourceConfigurationOutput fromRedshiftRunConfiguration(
            Consumer<RedshiftRunConfigurationOutput.Builder> redshiftRunConfiguration) {
        RedshiftRunConfigurationOutput.Builder builder = RedshiftRunConfigurationOutput.builder();
        redshiftRunConfiguration.accept(builder);
        return fromRedshiftRunConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sageMakerRunConfiguration()} initialized to the given value.
     *
     * <p>
     * The Amazon SageMaker run configuration.
     * </p>
     * 
     * @param sageMakerRunConfiguration
     *        The Amazon SageMaker run configuration.
     */
    public static DataSourceConfigurationOutput fromSageMakerRunConfiguration(
            SageMakerRunConfigurationOutput sageMakerRunConfiguration) {
        return builder().sageMakerRunConfiguration(sageMakerRunConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #sageMakerRunConfiguration()} initialized to the given value.
     *
     * <p>
     * The Amazon SageMaker run configuration.
     * </p>
     * 
     * @param sageMakerRunConfiguration
     *        The Amazon SageMaker run configuration.
     */
    public static DataSourceConfigurationOutput fromSageMakerRunConfiguration(
            Consumer<SageMakerRunConfigurationOutput.Builder> sageMakerRunConfiguration) {
        SageMakerRunConfigurationOutput.Builder builder = SageMakerRunConfigurationOutput.builder();
        sageMakerRunConfiguration.accept(builder);
        return fromSageMakerRunConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("glueRunConfiguration", GLUE_RUN_CONFIGURATION_FIELD);
        map.put("redshiftRunConfiguration", REDSHIFT_RUN_CONFIGURATION_FIELD);
        map.put("sageMakerRunConfiguration", SAGE_MAKER_RUN_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfigurationOutput, T> g) {
        return obj -> g.apply((DataSourceConfigurationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceConfigurationOutput> {
        /**
         * <p>
         * The configuration of the Amazon Web Services Glue data source.
         * </p>
         * 
         * @param glueRunConfiguration
         *        The configuration of the Amazon Web Services Glue data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueRunConfiguration(GlueRunConfigurationOutput glueRunConfiguration);

        /**
         * <p>
         * The configuration of the Amazon Web Services Glue data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlueRunConfigurationOutput.Builder}
         * avoiding the need to create one manually via {@link GlueRunConfigurationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlueRunConfigurationOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #glueRunConfiguration(GlueRunConfigurationOutput)}.
         * 
         * @param glueRunConfiguration
         *        a consumer that will call methods on {@link GlueRunConfigurationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glueRunConfiguration(GlueRunConfigurationOutput)
         */
        default Builder glueRunConfiguration(Consumer<GlueRunConfigurationOutput.Builder> glueRunConfiguration) {
            return glueRunConfiguration(GlueRunConfigurationOutput.builder().applyMutation(glueRunConfiguration).build());
        }

        /**
         * <p>
         * The configuration of the Amazon Redshift data source.
         * </p>
         * 
         * @param redshiftRunConfiguration
         *        The configuration of the Amazon Redshift data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftRunConfiguration(RedshiftRunConfigurationOutput redshiftRunConfiguration);

        /**
         * <p>
         * The configuration of the Amazon Redshift data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftRunConfigurationOutput.Builder}
         * avoiding the need to create one manually via {@link RedshiftRunConfigurationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftRunConfigurationOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #redshiftRunConfiguration(RedshiftRunConfigurationOutput)}.
         * 
         * @param redshiftRunConfiguration
         *        a consumer that will call methods on {@link RedshiftRunConfigurationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftRunConfiguration(RedshiftRunConfigurationOutput)
         */
        default Builder redshiftRunConfiguration(Consumer<RedshiftRunConfigurationOutput.Builder> redshiftRunConfiguration) {
            return redshiftRunConfiguration(RedshiftRunConfigurationOutput.builder().applyMutation(redshiftRunConfiguration)
                    .build());
        }

        /**
         * <p>
         * The Amazon SageMaker run configuration.
         * </p>
         * 
         * @param sageMakerRunConfiguration
         *        The Amazon SageMaker run configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerRunConfiguration(SageMakerRunConfigurationOutput sageMakerRunConfiguration);

        /**
         * <p>
         * The Amazon SageMaker run configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SageMakerRunConfigurationOutput.Builder}
         * avoiding the need to create one manually via {@link SageMakerRunConfigurationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SageMakerRunConfigurationOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #sageMakerRunConfiguration(SageMakerRunConfigurationOutput)}.
         * 
         * @param sageMakerRunConfiguration
         *        a consumer that will call methods on {@link SageMakerRunConfigurationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sageMakerRunConfiguration(SageMakerRunConfigurationOutput)
         */
        default Builder sageMakerRunConfiguration(Consumer<SageMakerRunConfigurationOutput.Builder> sageMakerRunConfiguration) {
            return sageMakerRunConfiguration(SageMakerRunConfigurationOutput.builder().applyMutation(sageMakerRunConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GlueRunConfigurationOutput glueRunConfiguration;

        private RedshiftRunConfigurationOutput redshiftRunConfiguration;

        private SageMakerRunConfigurationOutput sageMakerRunConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfigurationOutput model) {
            glueRunConfiguration(model.glueRunConfiguration);
            redshiftRunConfiguration(model.redshiftRunConfiguration);
            sageMakerRunConfiguration(model.sageMakerRunConfiguration);
        }

        public final GlueRunConfigurationOutput.Builder getGlueRunConfiguration() {
            return glueRunConfiguration != null ? glueRunConfiguration.toBuilder() : null;
        }

        public final void setGlueRunConfiguration(GlueRunConfigurationOutput.BuilderImpl glueRunConfiguration) {
            Object oldValue = this.glueRunConfiguration;
            this.glueRunConfiguration = glueRunConfiguration != null ? glueRunConfiguration.build() : null;
            handleUnionValueChange(Type.GLUE_RUN_CONFIGURATION, oldValue, this.glueRunConfiguration);
        }

        @Override
        public final Builder glueRunConfiguration(GlueRunConfigurationOutput glueRunConfiguration) {
            Object oldValue = this.glueRunConfiguration;
            this.glueRunConfiguration = glueRunConfiguration;
            handleUnionValueChange(Type.GLUE_RUN_CONFIGURATION, oldValue, this.glueRunConfiguration);
            return this;
        }

        public final RedshiftRunConfigurationOutput.Builder getRedshiftRunConfiguration() {
            return redshiftRunConfiguration != null ? redshiftRunConfiguration.toBuilder() : null;
        }

        public final void setRedshiftRunConfiguration(RedshiftRunConfigurationOutput.BuilderImpl redshiftRunConfiguration) {
            Object oldValue = this.redshiftRunConfiguration;
            this.redshiftRunConfiguration = redshiftRunConfiguration != null ? redshiftRunConfiguration.build() : null;
            handleUnionValueChange(Type.REDSHIFT_RUN_CONFIGURATION, oldValue, this.redshiftRunConfiguration);
        }

        @Override
        public final Builder redshiftRunConfiguration(RedshiftRunConfigurationOutput redshiftRunConfiguration) {
            Object oldValue = this.redshiftRunConfiguration;
            this.redshiftRunConfiguration = redshiftRunConfiguration;
            handleUnionValueChange(Type.REDSHIFT_RUN_CONFIGURATION, oldValue, this.redshiftRunConfiguration);
            return this;
        }

        public final SageMakerRunConfigurationOutput.Builder getSageMakerRunConfiguration() {
            return sageMakerRunConfiguration != null ? sageMakerRunConfiguration.toBuilder() : null;
        }

        public final void setSageMakerRunConfiguration(SageMakerRunConfigurationOutput.BuilderImpl sageMakerRunConfiguration) {
            Object oldValue = this.sageMakerRunConfiguration;
            this.sageMakerRunConfiguration = sageMakerRunConfiguration != null ? sageMakerRunConfiguration.build() : null;
            handleUnionValueChange(Type.SAGE_MAKER_RUN_CONFIGURATION, oldValue, this.sageMakerRunConfiguration);
        }

        @Override
        public final Builder sageMakerRunConfiguration(SageMakerRunConfigurationOutput sageMakerRunConfiguration) {
            Object oldValue = this.sageMakerRunConfiguration;
            this.sageMakerRunConfiguration = sageMakerRunConfiguration;
            handleUnionValueChange(Type.SAGE_MAKER_RUN_CONFIGURATION, oldValue, this.sageMakerRunConfiguration);
            return this;
        }

        @Override
        public DataSourceConfigurationOutput build() {
            return new DataSourceConfigurationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DataSourceConfigurationOutput#type()
     */
    public enum Type {
        GLUE_RUN_CONFIGURATION,

        REDSHIFT_RUN_CONFIGURATION,

        SAGE_MAKER_RUN_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
