/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The run lineage summary of a data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceRunLineageSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceRunLineageSummary.Builder, DataSourceRunLineageSummary> {
    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importStatus").getter(getter(DataSourceRunLineageSummary::importStatusAsString))
            .setter(setter(Builder::importStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String importStatus;

    private DataSourceRunLineageSummary(BuilderImpl builder) {
        this.importStatus = builder.importStatus;
    }

    /**
     * <p>
     * The import status that's part of the run lineage summary of a data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link LineageImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #importStatusAsString}.
     * </p>
     * 
     * @return The import status that's part of the run lineage summary of a data source.
     * @see LineageImportStatus
     */
    public final LineageImportStatus importStatus() {
        return LineageImportStatus.fromValue(importStatus);
    }

    /**
     * <p>
     * The import status that's part of the run lineage summary of a data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link LineageImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #importStatusAsString}.
     * </p>
     * 
     * @return The import status that's part of the run lineage summary of a data source.
     * @see LineageImportStatus
     */
    public final String importStatusAsString() {
        return importStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceRunLineageSummary)) {
            return false;
        }
        DataSourceRunLineageSummary other = (DataSourceRunLineageSummary) obj;
        return Objects.equals(importStatusAsString(), other.importStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceRunLineageSummary").add("ImportStatus", importStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importStatus":
            return Optional.ofNullable(clazz.cast(importStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("importStatus", IMPORT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceRunLineageSummary, T> g) {
        return obj -> g.apply((DataSourceRunLineageSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceRunLineageSummary> {
        /**
         * <p>
         * The import status that's part of the run lineage summary of a data source.
         * </p>
         * 
         * @param importStatus
         *        The import status that's part of the run lineage summary of a data source.
         * @see LineageImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineageImportStatus
         */
        Builder importStatus(String importStatus);

        /**
         * <p>
         * The import status that's part of the run lineage summary of a data source.
         * </p>
         * 
         * @param importStatus
         *        The import status that's part of the run lineage summary of a data source.
         * @see LineageImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineageImportStatus
         */
        Builder importStatus(LineageImportStatus importStatus);
    }

    static final class BuilderImpl implements Builder {
        private String importStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceRunLineageSummary model) {
            importStatus(model.importStatus);
        }

        public final String getImportStatus() {
            return importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(LineageImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        @Override
        public DataSourceRunLineageSummary build() {
            return new DataSourceRunLineageSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
