/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The deployment properties of the Amazon DataZone blueprint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentProperties.Builder, DeploymentProperties> {
    private static final SdkField<Integer> END_TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("endTimeoutMinutes").getter(getter(DeploymentProperties::endTimeoutMinutes))
            .setter(setter(Builder::endTimeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeoutMinutes").build()).build();

    private static final SdkField<Integer> START_TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("startTimeoutMinutes").getter(getter(DeploymentProperties::startTimeoutMinutes))
            .setter(setter(Builder::startTimeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeoutMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIMEOUT_MINUTES_FIELD,
            START_TIMEOUT_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer endTimeoutMinutes;

    private final Integer startTimeoutMinutes;

    private DeploymentProperties(BuilderImpl builder) {
        this.endTimeoutMinutes = builder.endTimeoutMinutes;
        this.startTimeoutMinutes = builder.startTimeoutMinutes;
    }

    /**
     * <p>
     * The end timeout of the environment blueprint deployment.
     * </p>
     * 
     * @return The end timeout of the environment blueprint deployment.
     */
    public final Integer endTimeoutMinutes() {
        return endTimeoutMinutes;
    }

    /**
     * <p>
     * The start timeout of the environment blueprint deployment.
     * </p>
     * 
     * @return The start timeout of the environment blueprint deployment.
     */
    public final Integer startTimeoutMinutes() {
        return startTimeoutMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeoutMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentProperties)) {
            return false;
        }
        DeploymentProperties other = (DeploymentProperties) obj;
        return Objects.equals(endTimeoutMinutes(), other.endTimeoutMinutes())
                && Objects.equals(startTimeoutMinutes(), other.startTimeoutMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentProperties").add("EndTimeoutMinutes", endTimeoutMinutes())
                .add("StartTimeoutMinutes", startTimeoutMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTimeoutMinutes":
            return Optional.ofNullable(clazz.cast(endTimeoutMinutes()));
        case "startTimeoutMinutes":
            return Optional.ofNullable(clazz.cast(startTimeoutMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endTimeoutMinutes", END_TIMEOUT_MINUTES_FIELD);
        map.put("startTimeoutMinutes", START_TIMEOUT_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentProperties, T> g) {
        return obj -> g.apply((DeploymentProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentProperties> {
        /**
         * <p>
         * The end timeout of the environment blueprint deployment.
         * </p>
         * 
         * @param endTimeoutMinutes
         *        The end timeout of the environment blueprint deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeoutMinutes(Integer endTimeoutMinutes);

        /**
         * <p>
         * The start timeout of the environment blueprint deployment.
         * </p>
         * 
         * @param startTimeoutMinutes
         *        The start timeout of the environment blueprint deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeoutMinutes(Integer startTimeoutMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Integer endTimeoutMinutes;

        private Integer startTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentProperties model) {
            endTimeoutMinutes(model.endTimeoutMinutes);
            startTimeoutMinutes(model.startTimeoutMinutes);
        }

        public final Integer getEndTimeoutMinutes() {
            return endTimeoutMinutes;
        }

        public final void setEndTimeoutMinutes(Integer endTimeoutMinutes) {
            this.endTimeoutMinutes = endTimeoutMinutes;
        }

        @Override
        public final Builder endTimeoutMinutes(Integer endTimeoutMinutes) {
            this.endTimeoutMinutes = endTimeoutMinutes;
            return this;
        }

        public final Integer getStartTimeoutMinutes() {
            return startTimeoutMinutes;
        }

        public final void setStartTimeoutMinutes(Integer startTimeoutMinutes) {
            this.startTimeoutMinutes = startTimeoutMinutes;
        }

        @Override
        public final Builder startTimeoutMinutes(Integer startTimeoutMinutes) {
            this.startTimeoutMinutes = startTimeoutMinutes;
            return this;
        }

        @Override
        public DeploymentProperties build() {
            return new DeploymentProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
