/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateEnvironmentRoleRequest extends DataZoneRequest implements
        ToCopyableBuilder<DisassociateEnvironmentRoleRequest.Builder, DisassociateEnvironmentRoleRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(DisassociateEnvironmentRoleRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentIdentifier").getter(getter(DisassociateEnvironmentRoleRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentIdentifier").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentRoleArn").getter(getter(DisassociateEnvironmentRoleRequest::environmentRoleArn))
            .setter(setter(Builder::environmentRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            ENVIRONMENT_IDENTIFIER_FIELD, ENVIRONMENT_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainIdentifier;

    private final String environmentIdentifier;

    private final String environmentRoleArn;

    private DisassociateEnvironmentRoleRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.environmentRoleArn = builder.environmentRoleArn;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which an environment role is disassociated.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which an environment role is disassociated.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the environment.
     * </p>
     * 
     * @return The ID of the environment.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * The ARN of the environment role.
     * </p>
     * 
     * @return The ARN of the environment role.
     */
    public final String environmentRoleArn() {
        return environmentRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateEnvironmentRoleRequest)) {
            return false;
        }
        DisassociateEnvironmentRoleRequest other = (DisassociateEnvironmentRoleRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier())
                && Objects.equals(environmentRoleArn(), other.environmentRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateEnvironmentRoleRequest").add("DomainIdentifier", domainIdentifier())
                .add("EnvironmentIdentifier", environmentIdentifier()).add("EnvironmentRoleArn", environmentRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "environmentRoleArn":
            return Optional.ofNullable(clazz.cast(environmentRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("environmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
        map.put("environmentRoleArn", ENVIRONMENT_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateEnvironmentRoleRequest, T> g) {
        return obj -> g.apply((DisassociateEnvironmentRoleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateEnvironmentRoleRequest> {
        /**
         * <p>
         * The ID of the Amazon DataZone domain in which an environment role is disassociated.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain in which an environment role is disassociated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the environment.
         * </p>
         * 
         * @param environmentIdentifier
         *        The ID of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * The ARN of the environment role.
         * </p>
         * 
         * @param environmentRoleArn
         *        The ARN of the environment role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentRoleArn(String environmentRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private String environmentIdentifier;

        private String environmentRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateEnvironmentRoleRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            environmentIdentifier(model.environmentIdentifier);
            environmentRoleArn(model.environmentRoleArn);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getEnvironmentRoleArn() {
            return environmentRoleArn;
        }

        public final void setEnvironmentRoleArn(String environmentRoleArn) {
            this.environmentRoleArn = environmentRoleArn;
        }

        @Override
        public final Builder environmentRoleArn(String environmentRoleArn) {
            this.environmentRoleArn = environmentRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateEnvironmentRoleRequest build() {
            return new DisassociateEnvironmentRoleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
