/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentSummary.Builder, EnvironmentSummary> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(EnvironmentSummary::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountRegion").getter(getter(EnvironmentSummary::awsAccountRegion))
            .setter(setter(Builder::awsAccountRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountRegion").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(EnvironmentSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(EnvironmentSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(EnvironmentSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(EnvironmentSummary::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ENVIRONMENT_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentProfileId").getter(getter(EnvironmentSummary::environmentProfileId))
            .setter(setter(Builder::environmentProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentProfileId").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(EnvironmentSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EnvironmentSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(EnvironmentSummary::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(EnvironmentSummary::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(EnvironmentSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(EnvironmentSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, AWS_ACCOUNT_REGION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD,
                    DESCRIPTION_FIELD, DOMAIN_ID_FIELD, ENVIRONMENT_PROFILE_ID_FIELD, ID_FIELD, NAME_FIELD, PROJECT_ID_FIELD,
                    PROVIDER_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final String awsAccountRegion;

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final String domainId;

    private final String environmentProfileId;

    private final String id;

    private final String name;

    private final String projectId;

    private final String provider;

    private final String status;

    private final Instant updatedAt;

    private EnvironmentSummary(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountRegion = builder.awsAccountRegion;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.environmentProfileId = builder.environmentProfileId;
        this.id = builder.id;
        this.name = builder.name;
        this.projectId = builder.projectId;
        this.provider = builder.provider;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account in which an environment exists.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account in which an environment exists.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services Region in which an environment exists.
     * </p>
     * 
     * @return The Amazon Web Services Region in which an environment exists.
     */
    public final String awsAccountRegion() {
        return awsAccountRegion;
    }

    /**
     * <p>
     * The timestamp of when the environment was created.
     * </p>
     * 
     * @return The timestamp of when the environment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who created the environment.
     * </p>
     * 
     * @return The Amazon DataZone user who created the environment.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of the environment.
     * </p>
     * 
     * @return The description of the environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which the environment exists.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which the environment exists.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The identifier of the environment profile with which the environment was created.
     * </p>
     * 
     * @return The identifier of the environment profile with which the environment was created.
     */
    public final String environmentProfileId() {
        return environmentProfileId;
    }

    /**
     * <p>
     * The identifier of the environment.
     * </p>
     * 
     * @return The identifier of the environment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the project in which the environment exists.
     * </p>
     * 
     * @return The identifier of the project in which the environment exists.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * The provider of the environment.
     * </p>
     * 
     * @return The provider of the environment.
     */
    public final String provider() {
        return provider;
    }

    /**
     * <p>
     * The status of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the environment.
     * @see EnvironmentStatus
     */
    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the environment.
     * @see EnvironmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp of when the environment was updated.
     * </p>
     * 
     * @return The timestamp of when the environment was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountRegion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentSummary)) {
            return false;
        }
        EnvironmentSummary other = (EnvironmentSummary) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(awsAccountRegion(), other.awsAccountRegion()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(description(), other.description())
                && Objects.equals(domainId(), other.domainId())
                && Objects.equals(environmentProfileId(), other.environmentProfileId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(projectId(), other.projectId())
                && Objects.equals(provider(), other.provider()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentSummary").add("AwsAccountId", awsAccountId())
                .add("AwsAccountRegion", awsAccountRegion()).add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("EnvironmentProfileId", environmentProfileId()).add("Id", id())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("ProjectId", projectId())
                .add("Provider", provider()).add("Status", statusAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "awsAccountRegion":
            return Optional.ofNullable(clazz.cast(awsAccountRegion()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "environmentProfileId":
            return Optional.ofNullable(clazz.cast(environmentProfileId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsAccountRegion", AWS_ACCOUNT_REGION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("environmentProfileId", ENVIRONMENT_PROFILE_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("provider", PROVIDER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentSummary, T> g) {
        return obj -> g.apply((EnvironmentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentSummary> {
        /**
         * <p>
         * The identifier of the Amazon Web Services account in which an environment exists.
         * </p>
         * 
         * @param awsAccountId
         *        The identifier of the Amazon Web Services account in which an environment exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Web Services Region in which an environment exists.
         * </p>
         * 
         * @param awsAccountRegion
         *        The Amazon Web Services Region in which an environment exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountRegion(String awsAccountRegion);

        /**
         * <p>
         * The timestamp of when the environment was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the environment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon DataZone user who created the environment.
         * </p>
         * 
         * @param createdBy
         *        The Amazon DataZone user who created the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of the environment.
         * </p>
         * 
         * @param description
         *        The description of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which the environment exists.
         * </p>
         * 
         * @param domainId
         *        The identifier of the Amazon DataZone domain in which the environment exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The identifier of the environment profile with which the environment was created.
         * </p>
         * 
         * @param environmentProfileId
         *        The identifier of the environment profile with which the environment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentProfileId(String environmentProfileId);

        /**
         * <p>
         * The identifier of the environment.
         * </p>
         * 
         * @param id
         *        The identifier of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param name
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the project in which the environment exists.
         * </p>
         * 
         * @param projectId
         *        The identifier of the project in which the environment exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The provider of the environment.
         * </p>
         * 
         * @param provider
         *        The provider of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The status of the environment.
         * </p>
         * 
         * @param status
         *        The status of the environment.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the environment.
         * </p>
         * 
         * @param status
         *        The status of the environment.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(EnvironmentStatus status);

        /**
         * <p>
         * The timestamp of when the environment was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the environment was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private String awsAccountRegion;

        private Instant createdAt;

        private String createdBy;

        private String description;

        private String domainId;

        private String environmentProfileId;

        private String id;

        private String name;

        private String projectId;

        private String provider;

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentSummary model) {
            awsAccountId(model.awsAccountId);
            awsAccountRegion(model.awsAccountRegion);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            domainId(model.domainId);
            environmentProfileId(model.environmentProfileId);
            id(model.id);
            name(model.name);
            projectId(model.projectId);
            provider(model.provider);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsAccountRegion() {
            return awsAccountRegion;
        }

        public final void setAwsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
        }

        @Override
        public final Builder awsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEnvironmentProfileId() {
            return environmentProfileId;
        }

        public final void setEnvironmentProfileId(String environmentProfileId) {
            this.environmentProfileId = environmentProfileId;
        }

        @Override
        public final Builder environmentProfileId(String environmentProfileId) {
            this.environmentProfileId = environmentProfileId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public EnvironmentSummary build() {
            return new EnvironmentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
