/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataProductResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetDataProductResponse.Builder, GetDataProductResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetDataProductResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetDataProductResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetDataProductResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetDataProductResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<Instant> FIRST_REVISION_CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstRevisionCreatedAt").getter(getter(GetDataProductResponse::firstRevisionCreatedAt))
            .setter(setter(Builder::firstRevisionCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedAt").build())
            .build();

    private static final SdkField<String> FIRST_REVISION_CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firstRevisionCreatedBy").getter(getter(GetDataProductResponse::firstRevisionCreatedBy))
            .setter(setter(Builder::firstRevisionCreatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedBy").build())
            .build();

    private static final SdkField<List<FormOutput>> FORMS_OUTPUT_FIELD = SdkField
            .<List<FormOutput>> builder(MarshallingType.LIST)
            .memberName("formsOutput")
            .getter(getter(GetDataProductResponse::formsOutput))
            .setter(setter(Builder::formsOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsOutput").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FormOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(GetDataProductResponse::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetDataProductResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<DataProductItem>> ITEMS_FIELD = SdkField
            .<List<DataProductItem>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(GetDataProductResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataProductItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataProductItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetDataProductResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectId").getter(getter(GetDataProductResponse::owningProjectId))
            .setter(setter(Builder::owningProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(GetDataProductResponse::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetDataProductResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, FIRST_REVISION_CREATED_AT_FIELD,
            FIRST_REVISION_CREATED_BY_FIELD, FORMS_OUTPUT_FIELD, GLOSSARY_TERMS_FIELD, ID_FIELD, ITEMS_FIELD, NAME_FIELD,
            OWNING_PROJECT_ID_FIELD, REVISION_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final String domainId;

    private final Instant firstRevisionCreatedAt;

    private final String firstRevisionCreatedBy;

    private final List<FormOutput> formsOutput;

    private final List<String> glossaryTerms;

    private final String id;

    private final List<DataProductItem> items;

    private final String name;

    private final String owningProjectId;

    private final String revision;

    private final String status;

    private GetDataProductResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.firstRevisionCreatedAt = builder.firstRevisionCreatedAt;
        this.firstRevisionCreatedBy = builder.firstRevisionCreatedBy;
        this.formsOutput = builder.formsOutput;
        this.glossaryTerms = builder.glossaryTerms;
        this.id = builder.id;
        this.items = builder.items;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
        this.revision = builder.revision;
        this.status = builder.status;
    }

    /**
     * <p>
     * The timestamp at which the data product is created.
     * </p>
     * 
     * @return The timestamp at which the data product is created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the data product.
     * </p>
     * 
     * @return The user who created the data product.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of the data product.
     * </p>
     * 
     * @return The description of the data product.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the domain where the data product lives.
     * </p>
     * 
     * @return The ID of the domain where the data product lives.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The timestamp at which the first revision of the data product is created.
     * </p>
     * 
     * @return The timestamp at which the first revision of the data product is created.
     */
    public final Instant firstRevisionCreatedAt() {
        return firstRevisionCreatedAt;
    }

    /**
     * <p>
     * The user who created the first revision of the data product.
     * </p>
     * 
     * @return The user who created the first revision of the data product.
     */
    public final String firstRevisionCreatedBy() {
        return firstRevisionCreatedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the FormsOutput property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFormsOutput() {
        return formsOutput != null && !(formsOutput instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata forms of the data product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormsOutput} method.
     * </p>
     * 
     * @return The metadata forms of the data product.
     */
    public final List<FormOutput> formsOutput() {
        return formsOutput;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The glossary terms of the data product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The glossary terms of the data product.
     */
    public final List<String> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * The ID of the data product.
     * </p>
     * 
     * @return The ID of the data product.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data assets of the data product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The data assets of the data product.
     */
    public final List<DataProductItem> items() {
        return items;
    }

    /**
     * <p>
     * The name of the data product.
     * </p>
     * 
     * @return The name of the data product.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the owning project of the data product.
     * </p>
     * 
     * @return The ID of the owning project of the data product.
     */
    public final String owningProjectId() {
        return owningProjectId;
    }

    /**
     * <p>
     * The revision of the data product.
     * </p>
     * 
     * @return The revision of the data product.
     */
    public final String revision() {
        return revision;
    }

    /**
     * <p>
     * The status of the data product.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataProductStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data product.
     * @see DataProductStatus
     */
    public final DataProductStatus status() {
        return DataProductStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the data product.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataProductStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data product.
     * @see DataProductStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(firstRevisionCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(firstRevisionCreatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasFormsOutput() ? formsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataProductResponse)) {
            return false;
        }
        GetDataProductResponse other = (GetDataProductResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(firstRevisionCreatedAt(), other.firstRevisionCreatedAt())
                && Objects.equals(firstRevisionCreatedBy(), other.firstRevisionCreatedBy())
                && hasFormsOutput() == other.hasFormsOutput() && Objects.equals(formsOutput(), other.formsOutput())
                && hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(glossaryTerms(), other.glossaryTerms())
                && Objects.equals(id(), other.id()) && hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(name(), other.name()) && Objects.equals(owningProjectId(), other.owningProjectId())
                && Objects.equals(revision(), other.revision()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataProductResponse").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("FirstRevisionCreatedAt", firstRevisionCreatedAt()).add("FirstRevisionCreatedBy", firstRevisionCreatedBy())
                .add("FormsOutput", hasFormsOutput() ? formsOutput() : null)
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).add("Id", id())
                .add("Items", hasItems() ? items() : null).add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OwningProjectId", owningProjectId()).add("Revision", revision()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "firstRevisionCreatedAt":
            return Optional.ofNullable(clazz.cast(firstRevisionCreatedAt()));
        case "firstRevisionCreatedBy":
            return Optional.ofNullable(clazz.cast(firstRevisionCreatedBy()));
        case "formsOutput":
            return Optional.ofNullable(clazz.cast(formsOutput()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owningProjectId":
            return Optional.ofNullable(clazz.cast(owningProjectId()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("firstRevisionCreatedAt", FIRST_REVISION_CREATED_AT_FIELD);
        map.put("firstRevisionCreatedBy", FIRST_REVISION_CREATED_BY_FIELD);
        map.put("formsOutput", FORMS_OUTPUT_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("id", ID_FIELD);
        map.put("items", ITEMS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        map.put("revision", REVISION_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataProductResponse, T> g) {
        return obj -> g.apply((GetDataProductResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataProductResponse> {
        /**
         * <p>
         * The timestamp at which the data product is created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp at which the data product is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the data product.
         * </p>
         * 
         * @param createdBy
         *        The user who created the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of the data product.
         * </p>
         * 
         * @param description
         *        The description of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the domain where the data product lives.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain where the data product lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The timestamp at which the first revision of the data product is created.
         * </p>
         * 
         * @param firstRevisionCreatedAt
         *        The timestamp at which the first revision of the data product is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstRevisionCreatedAt(Instant firstRevisionCreatedAt);

        /**
         * <p>
         * The user who created the first revision of the data product.
         * </p>
         * 
         * @param firstRevisionCreatedBy
         *        The user who created the first revision of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstRevisionCreatedBy(String firstRevisionCreatedBy);

        /**
         * <p>
         * The metadata forms of the data product.
         * </p>
         * 
         * @param formsOutput
         *        The metadata forms of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formsOutput(Collection<FormOutput> formsOutput);

        /**
         * <p>
         * The metadata forms of the data product.
         * </p>
         * 
         * @param formsOutput
         *        The metadata forms of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formsOutput(FormOutput... formsOutput);

        /**
         * <p>
         * The metadata forms of the data product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.FormOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #formsOutput(List<FormOutput>)}.
         * 
         * @param formsOutput
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formsOutput(java.util.Collection<FormOutput>)
         */
        Builder formsOutput(Consumer<FormOutput.Builder>... formsOutput);

        /**
         * <p>
         * The glossary terms of the data product.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<String> glossaryTerms);

        /**
         * <p>
         * The glossary terms of the data product.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(String... glossaryTerms);

        /**
         * <p>
         * The ID of the data product.
         * </p>
         * 
         * @param id
         *        The ID of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The data assets of the data product.
         * </p>
         * 
         * @param items
         *        The data assets of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<DataProductItem> items);

        /**
         * <p>
         * The data assets of the data product.
         * </p>
         * 
         * @param items
         *        The data assets of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(DataProductItem... items);

        /**
         * <p>
         * The data assets of the data product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.DataProductItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.DataProductItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.DataProductItem.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<DataProductItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.DataProductItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<DataProductItem>)
         */
        Builder items(Consumer<DataProductItem.Builder>... items);

        /**
         * <p>
         * The name of the data product.
         * </p>
         * 
         * @param name
         *        The name of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the owning project of the data product.
         * </p>
         * 
         * @param owningProjectId
         *        The ID of the owning project of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectId(String owningProjectId);

        /**
         * <p>
         * The revision of the data product.
         * </p>
         * 
         * @param revision
         *        The revision of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        /**
         * <p>
         * The status of the data product.
         * </p>
         * 
         * @param status
         *        The status of the data product.
         * @see DataProductStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataProductStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the data product.
         * </p>
         * 
         * @param status
         *        The status of the data product.
         * @see DataProductStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataProductStatus
         */
        Builder status(DataProductStatus status);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String description;

        private String domainId;

        private Instant firstRevisionCreatedAt;

        private String firstRevisionCreatedBy;

        private List<FormOutput> formsOutput = DefaultSdkAutoConstructList.getInstance();

        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private List<DataProductItem> items = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String owningProjectId;

        private String revision;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataProductResponse model) {
            super(model);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            domainId(model.domainId);
            firstRevisionCreatedAt(model.firstRevisionCreatedAt);
            firstRevisionCreatedBy(model.firstRevisionCreatedBy);
            formsOutput(model.formsOutput);
            glossaryTerms(model.glossaryTerms);
            id(model.id);
            items(model.items);
            name(model.name);
            owningProjectId(model.owningProjectId);
            revision(model.revision);
            status(model.status);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Instant getFirstRevisionCreatedAt() {
            return firstRevisionCreatedAt;
        }

        public final void setFirstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
        }

        @Override
        public final Builder firstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
            return this;
        }

        public final String getFirstRevisionCreatedBy() {
            return firstRevisionCreatedBy;
        }

        public final void setFirstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
        }

        @Override
        public final Builder firstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
            return this;
        }

        public final List<FormOutput.Builder> getFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.formsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFormsOutput(Collection<FormOutput.BuilderImpl> formsOutput) {
            this.formsOutput = FormOutputListCopier.copyFromBuilder(formsOutput);
        }

        @Override
        public final Builder formsOutput(Collection<FormOutput> formsOutput) {
            this.formsOutput = FormOutputListCopier.copy(formsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(FormOutput... formsOutput) {
            formsOutput(Arrays.asList(formsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(Consumer<FormOutput.Builder>... formsOutput) {
            formsOutput(Stream.of(formsOutput).map(c -> FormOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<DataProductItem.Builder> getItems() {
            List<DataProductItem.Builder> result = DataProductItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<DataProductItem.BuilderImpl> items) {
            this.items = DataProductItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<DataProductItem> items) {
            this.items = DataProductItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(DataProductItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<DataProductItem.Builder>... items) {
            items(Stream.of(items).map(c -> DataProductItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataProductStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetDataProductResponse build() {
            return new GetDataProductResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
