/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobRunResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetJobRunResponse.Builder, GetJobRunResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetJobRunResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetJobRunResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<JobRunDetails> DETAILS_FIELD = SdkField.<JobRunDetails> builder(MarshallingType.SDK_POJO)
            .memberName("details").getter(getter(GetJobRunResponse::details)).setter(setter(Builder::details))
            .constructor(JobRunDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetJobRunResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(GetJobRunResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<JobRunError> ERROR_FIELD = SdkField.<JobRunError> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(GetJobRunResponse::error)).setter(setter(Builder::error))
            .constructor(JobRunError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetJobRunResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(GetJobRunResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobType").getter(getter(GetJobRunResponse::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()).build();

    private static final SdkField<String> RUN_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runMode").getter(getter(GetJobRunResponse::runModeAsString)).setter(setter(Builder::runMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runMode").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(GetJobRunResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetJobRunResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DETAILS_FIELD, DOMAIN_ID_FIELD, END_TIME_FIELD, ERROR_FIELD, ID_FIELD, JOB_ID_FIELD,
            JOB_TYPE_FIELD, RUN_MODE_FIELD, START_TIME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createdAt;

    private final String createdBy;

    private final JobRunDetails details;

    private final String domainId;

    private final Instant endTime;

    private final JobRunError error;

    private final String id;

    private final String jobId;

    private final String jobType;

    private final String runMode;

    private final Instant startTime;

    private final String status;

    private GetJobRunResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.details = builder.details;
        this.domainId = builder.domainId;
        this.endTime = builder.endTime;
        this.error = builder.error;
        this.id = builder.id;
        this.jobId = builder.jobId;
        this.jobType = builder.jobType;
        this.runMode = builder.runMode;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * The timestamp of when the job run was created.
     * </p>
     * 
     * @return The timestamp of when the job run was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the job run.
     * </p>
     * 
     * @return The user who created the job run.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The details of the job run.
     * </p>
     * 
     * @return The details of the job run.
     */
    public final JobRunDetails details() {
        return details;
    }

    /**
     * <p>
     * The ID of the domain.
     * </p>
     * 
     * @return The ID of the domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The timestamp of when the job run ended.
     * </p>
     * 
     * @return The timestamp of when the job run ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The error generated if the action is not completed successfully.
     * </p>
     * 
     * @return The error generated if the action is not completed successfully.
     */
    public final JobRunError error() {
        return error;
    }

    /**
     * <p>
     * The ID of the job run.
     * </p>
     * 
     * @return The ID of the job run.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the job run.
     * </p>
     * 
     * @return The ID of the job run.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The type of the job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type of the job run.
     * @see JobType
     */
    public final JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * The type of the job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type of the job run.
     * @see JobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * The mode of the job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runMode} will
     * return {@link JobRunMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runModeAsString}.
     * </p>
     * 
     * @return The mode of the job run.
     * @see JobRunMode
     */
    public final JobRunMode runMode() {
        return JobRunMode.fromValue(runMode);
    }

    /**
     * <p>
     * The mode of the job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runMode} will
     * return {@link JobRunMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runModeAsString}.
     * </p>
     * 
     * @return The mode of the job run.
     * @see JobRunMode
     */
    public final String runModeAsString() {
        return runMode;
    }

    /**
     * <p>
     * The timestamp of when the job run started.
     * </p>
     * 
     * @return The timestamp of when the job run started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The status of the job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job run.
     * @see JobRunStatus
     */
    public final JobRunStatus status() {
        return JobRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job run.
     * @see JobRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobRunResponse)) {
            return false;
        }
        GetJobRunResponse other = (GetJobRunResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(details(), other.details()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(error(), other.error())
                && Objects.equals(id(), other.id()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && Objects.equals(runModeAsString(), other.runModeAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJobRunResponse").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Details", details()).add("DomainId", domainId()).add("EndTime", endTime()).add("Error", error())
                .add("Id", id()).add("JobId", jobId()).add("JobType", jobTypeAsString()).add("RunMode", runModeAsString())
                .add("StartTime", startTime()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "runMode":
            return Optional.ofNullable(clazz.cast(runModeAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("details", DETAILS_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("id", ID_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("jobType", JOB_TYPE_FIELD);
        map.put("runMode", RUN_MODE_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetJobRunResponse, T> g) {
        return obj -> g.apply((GetJobRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetJobRunResponse> {
        /**
         * <p>
         * The timestamp of when the job run was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the job run was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the job run.
         * </p>
         * 
         * @param createdBy
         *        The user who created the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The details of the job run.
         * </p>
         * 
         * @param details
         *        The details of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(JobRunDetails details);

        /**
         * <p>
         * The details of the job run.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobRunDetails.Builder} avoiding the need
         * to create one manually via {@link JobRunDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobRunDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #details(JobRunDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link JobRunDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(JobRunDetails)
         */
        default Builder details(Consumer<JobRunDetails.Builder> details) {
            return details(JobRunDetails.builder().applyMutation(details).build());
        }

        /**
         * <p>
         * The ID of the domain.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The timestamp of when the job run ended.
         * </p>
         * 
         * @param endTime
         *        The timestamp of when the job run ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The error generated if the action is not completed successfully.
         * </p>
         * 
         * @param error
         *        The error generated if the action is not completed successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(JobRunError error);

        /**
         * <p>
         * The error generated if the action is not completed successfully.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobRunError.Builder} avoiding the need to
         * create one manually via {@link JobRunError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobRunError.Builder#build()} is called immediately and its result
         * is passed to {@link #error(JobRunError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link JobRunError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(JobRunError)
         */
        default Builder error(Consumer<JobRunError.Builder> error) {
            return error(JobRunError.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The ID of the job run.
         * </p>
         * 
         * @param id
         *        The ID of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the job run.
         * </p>
         * 
         * @param jobId
         *        The ID of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The type of the job run.
         * </p>
         * 
         * @param jobType
         *        The type of the job run.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The type of the job run.
         * </p>
         * 
         * @param jobType
         *        The type of the job run.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * The mode of the job run.
         * </p>
         * 
         * @param runMode
         *        The mode of the job run.
         * @see JobRunMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunMode
         */
        Builder runMode(String runMode);

        /**
         * <p>
         * The mode of the job run.
         * </p>
         * 
         * @param runMode
         *        The mode of the job run.
         * @see JobRunMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunMode
         */
        Builder runMode(JobRunMode runMode);

        /**
         * <p>
         * The timestamp of when the job run started.
         * </p>
         * 
         * @param startTime
         *        The timestamp of when the job run started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The status of the job run.
         * </p>
         * 
         * @param status
         *        The status of the job run.
         * @see JobRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the job run.
         * </p>
         * 
         * @param status
         *        The status of the job run.
         * @see JobRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunStatus
         */
        Builder status(JobRunStatus status);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private JobRunDetails details;

        private String domainId;

        private Instant endTime;

        private JobRunError error;

        private String id;

        private String jobId;

        private String jobType;

        private String runMode;

        private Instant startTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobRunResponse model) {
            super(model);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            details(model.details);
            domainId(model.domainId);
            endTime(model.endTime);
            error(model.error);
            id(model.id);
            jobId(model.jobId);
            jobType(model.jobType);
            runMode(model.runMode);
            startTime(model.startTime);
            status(model.status);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final JobRunDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(JobRunDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(JobRunDetails details) {
            this.details = details;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final JobRunError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(JobRunError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(JobRunError error) {
            this.error = error;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getRunMode() {
            return runMode;
        }

        public final void setRunMode(String runMode) {
            this.runMode = runMode;
        }

        @Override
        public final Builder runMode(String runMode) {
            this.runMode = runMode;
            return this;
        }

        @Override
        public final Builder runMode(JobRunMode runMode) {
            this.runMode(runMode == null ? null : runMode.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetJobRunResponse build() {
            return new GetJobRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
