/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLineageEventResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetLineageEventResponse.Builder, GetLineageEventResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetLineageEventResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Created-At").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetLineageEventResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Created-By").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetLineageEventResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Domain-Id").build()).build();

    private static final SdkField<SdkBytes> EVENT_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("event")
            .getter(getter(GetLineageEventResponse::event))
            .setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventTime").getter(getter(GetLineageEventResponse::eventTime)).setter(setter(Builder::eventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Event-Time").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetLineageEventResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Id").build()).build();

    private static final SdkField<String> PROCESSING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("processingStatus").getter(getter(GetLineageEventResponse::processingStatusAsString))
            .setter(setter(Builder::processingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Processing-Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DOMAIN_ID_FIELD, EVENT_FIELD, EVENT_TIME_FIELD, ID_FIELD, PROCESSING_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createdAt;

    private final String createdBy;

    private final String domainId;

    private final SdkBytes event;

    private final Instant eventTime;

    private final String id;

    private final String processingStatus;

    private GetLineageEventResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.event = builder.event;
        this.eventTime = builder.eventTime;
        this.id = builder.id;
        this.processingStatus = builder.processingStatus;
    }

    /**
     * <p>
     * The timestamp of when the lineage event was created.
     * </p>
     * 
     * @return The timestamp of when the lineage event was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the lineage event.
     * </p>
     * 
     * @return The user who created the lineage event.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The ID of the domain.
     * </p>
     * 
     * @return The ID of the domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The lineage event details.
     * </p>
     * 
     * @return The lineage event details.
     */
    public final SdkBytes event() {
        return event;
    }

    /**
     * <p>
     * The time of the lineage event.
     * </p>
     * 
     * @return The time of the lineage event.
     */
    public final Instant eventTime() {
        return eventTime;
    }

    /**
     * <p>
     * The ID of the lineage event.
     * </p>
     * 
     * @return The ID of the lineage event.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The progressing status of the lineage event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processingStatus}
     * will return {@link LineageEventProcessingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #processingStatusAsString}.
     * </p>
     * 
     * @return The progressing status of the lineage event.
     * @see LineageEventProcessingStatus
     */
    public final LineageEventProcessingStatus processingStatus() {
        return LineageEventProcessingStatus.fromValue(processingStatus);
    }

    /**
     * <p>
     * The progressing status of the lineage event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processingStatus}
     * will return {@link LineageEventProcessingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #processingStatusAsString}.
     * </p>
     * 
     * @return The progressing status of the lineage event.
     * @see LineageEventProcessingStatus
     */
    public final String processingStatusAsString() {
        return processingStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(event());
        hashCode = 31 * hashCode + Objects.hashCode(eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(processingStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLineageEventResponse)) {
            return false;
        }
        GetLineageEventResponse other = (GetLineageEventResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(domainId(), other.domainId()) && Objects.equals(event(), other.event())
                && Objects.equals(eventTime(), other.eventTime()) && Objects.equals(id(), other.id())
                && Objects.equals(processingStatusAsString(), other.processingStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLineageEventResponse").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("DomainId", domainId()).add("Event", event() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EventTime", eventTime()).add("Id", id()).add("ProcessingStatus", processingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "event":
            return Optional.ofNullable(clazz.cast(event()));
        case "eventTime":
            return Optional.ofNullable(clazz.cast(eventTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "processingStatus":
            return Optional.ofNullable(clazz.cast(processingStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Created-At", CREATED_AT_FIELD);
        map.put("Created-By", CREATED_BY_FIELD);
        map.put("Domain-Id", DOMAIN_ID_FIELD);
        map.put("event", EVENT_FIELD);
        map.put("Event-Time", EVENT_TIME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Processing-Status", PROCESSING_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLineageEventResponse, T> g) {
        return obj -> g.apply((GetLineageEventResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLineageEventResponse> {
        /**
         * <p>
         * The timestamp of when the lineage event was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the lineage event was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the lineage event.
         * </p>
         * 
         * @param createdBy
         *        The user who created the lineage event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The ID of the domain.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The lineage event details.
         * </p>
         * 
         * @param event
         *        The lineage event details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder event(SdkBytes event);

        /**
         * <p>
         * The time of the lineage event.
         * </p>
         * 
         * @param eventTime
         *        The time of the lineage event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTime(Instant eventTime);

        /**
         * <p>
         * The ID of the lineage event.
         * </p>
         * 
         * @param id
         *        The ID of the lineage event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The progressing status of the lineage event.
         * </p>
         * 
         * @param processingStatus
         *        The progressing status of the lineage event.
         * @see LineageEventProcessingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineageEventProcessingStatus
         */
        Builder processingStatus(String processingStatus);

        /**
         * <p>
         * The progressing status of the lineage event.
         * </p>
         * 
         * @param processingStatus
         *        The progressing status of the lineage event.
         * @see LineageEventProcessingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineageEventProcessingStatus
         */
        Builder processingStatus(LineageEventProcessingStatus processingStatus);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String domainId;

        private SdkBytes event;

        private Instant eventTime;

        private String id;

        private String processingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLineageEventResponse model) {
            super(model);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            domainId(model.domainId);
            event(model.event);
            eventTime(model.eventTime);
            id(model.id);
            processingStatus(model.processingStatus);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final ByteBuffer getEvent() {
            return event == null ? null : event.asByteBuffer();
        }

        public final void setEvent(ByteBuffer event) {
            event(event == null ? null : SdkBytes.fromByteBuffer(event));
        }

        @Override
        public final Builder event(SdkBytes event) {
            this.event = event;
            return this;
        }

        public final Instant getEventTime() {
            return eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getProcessingStatus() {
            return processingStatus;
        }

        public final void setProcessingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
        }

        @Override
        public final Builder processingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
            return this;
        }

        @Override
        public final Builder processingStatus(LineageEventProcessingStatus processingStatus) {
            this.processingStatus(processingStatus == null ? null : processingStatus.toString());
            return this;
        }

        @Override
        public GetLineageEventResponse build() {
            return new GetLineageEventResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
