/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProjectResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetProjectResponse.Builder, GetProjectResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetProjectResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetProjectResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetProjectResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetProjectResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> DOMAIN_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainUnitId").getter(getter(GetProjectResponse::domainUnitId)).setter(setter(Builder::domainUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitId").build()).build();

    private static final SdkField<EnvironmentDeploymentDetails> ENVIRONMENT_DEPLOYMENT_DETAILS_FIELD = SdkField
            .<EnvironmentDeploymentDetails> builder(MarshallingType.SDK_POJO)
            .memberName("environmentDeploymentDetails")
            .getter(getter(GetProjectResponse::environmentDeploymentDetails))
            .setter(setter(Builder::environmentDeploymentDetails))
            .constructor(EnvironmentDeploymentDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentDeploymentDetails")
                    .build()).build();

    private static final SdkField<List<ProjectDeletionError>> FAILURE_REASONS_FIELD = SdkField
            .<List<ProjectDeletionError>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(GetProjectResponse::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectDeletionError> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectDeletionError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(GetProjectResponse::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetProjectResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(GetProjectResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetProjectResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROJECT_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectProfileId").getter(getter(GetProjectResponse::projectProfileId))
            .setter(setter(Builder::projectProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectProfileId").build()).build();

    private static final SdkField<String> PROJECT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectStatus").getter(getter(GetProjectResponse::projectStatusAsString))
            .setter(setter(Builder::projectStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectStatus").build()).build();

    private static final SdkField<List<EnvironmentConfigurationUserParameter>> USER_PARAMETERS_FIELD = SdkField
            .<List<EnvironmentConfigurationUserParameter>> builder(MarshallingType.LIST)
            .memberName("userParameters")
            .getter(getter(GetProjectResponse::userParameters))
            .setter(setter(Builder::userParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentConfigurationUserParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentConfigurationUserParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, DOMAIN_UNIT_ID_FIELD, ENVIRONMENT_DEPLOYMENT_DETAILS_FIELD,
            FAILURE_REASONS_FIELD, GLOSSARY_TERMS_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, PROJECT_PROFILE_ID_FIELD,
            PROJECT_STATUS_FIELD, USER_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final String domainId;

    private final String domainUnitId;

    private final EnvironmentDeploymentDetails environmentDeploymentDetails;

    private final List<ProjectDeletionError> failureReasons;

    private final List<String> glossaryTerms;

    private final String id;

    private final Instant lastUpdatedAt;

    private final String name;

    private final String projectProfileId;

    private final String projectStatus;

    private final List<EnvironmentConfigurationUserParameter> userParameters;

    private GetProjectResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.domainUnitId = builder.domainUnitId;
        this.environmentDeploymentDetails = builder.environmentDeploymentDetails;
        this.failureReasons = builder.failureReasons;
        this.glossaryTerms = builder.glossaryTerms;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.projectProfileId = builder.projectProfileId;
        this.projectStatus = builder.projectStatus;
        this.userParameters = builder.userParameters;
    }

    /**
     * <p>
     * The timestamp of when the project was created.
     * </p>
     * 
     * @return The timestamp of when the project was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who created the project.
     * </p>
     * 
     * @return The Amazon DataZone user who created the project.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of the project.
     * </p>
     * 
     * @return The description of the project.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which the project exists.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which the project exists.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The ID of the domain unit.
     * </p>
     * 
     * @return The ID of the domain unit.
     */
    public final String domainUnitId() {
        return domainUnitId;
    }

    /**
     * <p>
     * The environment deployment status of a project.
     * </p>
     * 
     * @return The environment deployment status of a project.
     */
    public final EnvironmentDeploymentDetails environmentDeploymentDetails() {
        return environmentDeploymentDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the error message that is returned if the operation cannot be successfully completed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return Specifies the error message that is returned if the operation cannot be successfully completed.
     */
    public final List<ProjectDeletionError> failureReasons() {
        return failureReasons;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The business glossary terms that can be used in the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The business glossary terms that can be used in the project.
     */
    public final List<String> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * &gt;The ID of the project.
     * </p>
     * 
     * @return &gt;The ID of the project.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The timestamp of when the project was last updated.
     * </p>
     * 
     * @return The timestamp of when the project was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The name of the project.
     * </p>
     * 
     * @return The name of the project.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the project profile of a project.
     * </p>
     * 
     * @return The ID of the project profile of a project.
     */
    public final String projectProfileId() {
        return projectProfileId;
    }

    /**
     * <p>
     * The status of the project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStatus}
     * will return {@link ProjectStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #projectStatusAsString}.
     * </p>
     * 
     * @return The status of the project.
     * @see ProjectStatus
     */
    public final ProjectStatus projectStatus() {
        return ProjectStatus.fromValue(projectStatus);
    }

    /**
     * <p>
     * The status of the project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStatus}
     * will return {@link ProjectStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #projectStatusAsString}.
     * </p>
     * 
     * @return The status of the project.
     * @see ProjectStatus
     */
    public final String projectStatusAsString() {
        return projectStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserParameters() {
        return userParameters != null && !(userParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user parameters of a project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserParameters} method.
     * </p>
     * 
     * @return The user parameters of a project.
     */
    public final List<EnvironmentConfigurationUserParameter> userParameters() {
        return userParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(domainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentDeploymentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(projectProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(projectStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserParameters() ? userParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProjectResponse)) {
            return false;
        }
        GetProjectResponse other = (GetProjectResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(domainUnitId(), other.domainUnitId())
                && Objects.equals(environmentDeploymentDetails(), other.environmentDeploymentDetails())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons())
                && hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(glossaryTerms(), other.glossaryTerms())
                && Objects.equals(id(), other.id()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(name(), other.name()) && Objects.equals(projectProfileId(), other.projectProfileId())
                && Objects.equals(projectStatusAsString(), other.projectStatusAsString())
                && hasUserParameters() == other.hasUserParameters() && Objects.equals(userParameters(), other.userParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProjectResponse").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("DomainUnitId", domainUnitId()).add("EnvironmentDeploymentDetails", environmentDeploymentDetails())
                .add("FailureReasons", hasFailureReasons() ? failureReasons() : null)
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).add("Id", id())
                .add("LastUpdatedAt", lastUpdatedAt()).add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProjectProfileId", projectProfileId()).add("ProjectStatus", projectStatusAsString())
                .add("UserParameters", hasUserParameters() ? userParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "domainUnitId":
            return Optional.ofNullable(clazz.cast(domainUnitId()));
        case "environmentDeploymentDetails":
            return Optional.ofNullable(clazz.cast(environmentDeploymentDetails()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "projectProfileId":
            return Optional.ofNullable(clazz.cast(projectProfileId()));
        case "projectStatus":
            return Optional.ofNullable(clazz.cast(projectStatusAsString()));
        case "userParameters":
            return Optional.ofNullable(clazz.cast(userParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("domainUnitId", DOMAIN_UNIT_ID_FIELD);
        map.put("environmentDeploymentDetails", ENVIRONMENT_DEPLOYMENT_DETAILS_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("projectProfileId", PROJECT_PROFILE_ID_FIELD);
        map.put("projectStatus", PROJECT_STATUS_FIELD);
        map.put("userParameters", USER_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProjectResponse, T> g) {
        return obj -> g.apply((GetProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetProjectResponse> {
        /**
         * <p>
         * The timestamp of when the project was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the project was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon DataZone user who created the project.
         * </p>
         * 
         * @param createdBy
         *        The Amazon DataZone user who created the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of the project.
         * </p>
         * 
         * @param description
         *        The description of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which the project exists.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain in which the project exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The ID of the domain unit.
         * </p>
         * 
         * @param domainUnitId
         *        The ID of the domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainUnitId(String domainUnitId);

        /**
         * <p>
         * The environment deployment status of a project.
         * </p>
         * 
         * @param environmentDeploymentDetails
         *        The environment deployment status of a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentDeploymentDetails(EnvironmentDeploymentDetails environmentDeploymentDetails);

        /**
         * <p>
         * The environment deployment status of a project.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentDeploymentDetails.Builder}
         * avoiding the need to create one manually via {@link EnvironmentDeploymentDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentDeploymentDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #environmentDeploymentDetails(EnvironmentDeploymentDetails)}.
         * 
         * @param environmentDeploymentDetails
         *        a consumer that will call methods on {@link EnvironmentDeploymentDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentDeploymentDetails(EnvironmentDeploymentDetails)
         */
        default Builder environmentDeploymentDetails(Consumer<EnvironmentDeploymentDetails.Builder> environmentDeploymentDetails) {
            return environmentDeploymentDetails(EnvironmentDeploymentDetails.builder()
                    .applyMutation(environmentDeploymentDetails).build());
        }

        /**
         * <p>
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * 
         * @param failureReasons
         *        Specifies the error message that is returned if the operation cannot be successfully completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<ProjectDeletionError> failureReasons);

        /**
         * <p>
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * 
         * @param failureReasons
         *        Specifies the error message that is returned if the operation cannot be successfully completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(ProjectDeletionError... failureReasons);

        /**
         * <p>
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.ProjectDeletionError.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.ProjectDeletionError#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.ProjectDeletionError.Builder#build()} is called
         * immediately and its result is passed to {@link #failureReasons(List<ProjectDeletionError>)}.
         * 
         * @param failureReasons
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.ProjectDeletionError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureReasons(java.util.Collection<ProjectDeletionError>)
         */
        Builder failureReasons(Consumer<ProjectDeletionError.Builder>... failureReasons);

        /**
         * <p>
         * The business glossary terms that can be used in the project.
         * </p>
         * 
         * @param glossaryTerms
         *        The business glossary terms that can be used in the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<String> glossaryTerms);

        /**
         * <p>
         * The business glossary terms that can be used in the project.
         * </p>
         * 
         * @param glossaryTerms
         *        The business glossary terms that can be used in the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(String... glossaryTerms);

        /**
         * <p>
         * &gt;The ID of the project.
         * </p>
         * 
         * @param id
         *        &gt;The ID of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The timestamp of when the project was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp of when the project was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The name of the project.
         * </p>
         * 
         * @param name
         *        The name of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the project profile of a project.
         * </p>
         * 
         * @param projectProfileId
         *        The ID of the project profile of a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectProfileId(String projectProfileId);

        /**
         * <p>
         * The status of the project.
         * </p>
         * 
         * @param projectStatus
         *        The status of the project.
         * @see ProjectStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectStatus
         */
        Builder projectStatus(String projectStatus);

        /**
         * <p>
         * The status of the project.
         * </p>
         * 
         * @param projectStatus
         *        The status of the project.
         * @see ProjectStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectStatus
         */
        Builder projectStatus(ProjectStatus projectStatus);

        /**
         * <p>
         * The user parameters of a project.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(Collection<EnvironmentConfigurationUserParameter> userParameters);

        /**
         * <p>
         * The user parameters of a project.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(EnvironmentConfigurationUserParameter... userParameters);

        /**
         * <p>
         * The user parameters of a project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationUserParameter.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationUserParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationUserParameter.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #userParameters(List<EnvironmentConfigurationUserParameter>)}.
         * 
         * @param userParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationUserParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userParameters(java.util.Collection<EnvironmentConfigurationUserParameter>)
         */
        Builder userParameters(Consumer<EnvironmentConfigurationUserParameter.Builder>... userParameters);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String description;

        private String domainId;

        private String domainUnitId;

        private EnvironmentDeploymentDetails environmentDeploymentDetails;

        private List<ProjectDeletionError> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private Instant lastUpdatedAt;

        private String name;

        private String projectProfileId;

        private String projectStatus;

        private List<EnvironmentConfigurationUserParameter> userParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetProjectResponse model) {
            super(model);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            domainId(model.domainId);
            domainUnitId(model.domainUnitId);
            environmentDeploymentDetails(model.environmentDeploymentDetails);
            failureReasons(model.failureReasons);
            glossaryTerms(model.glossaryTerms);
            id(model.id);
            lastUpdatedAt(model.lastUpdatedAt);
            name(model.name);
            projectProfileId(model.projectProfileId);
            projectStatus(model.projectStatus);
            userParameters(model.userParameters);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainUnitId() {
            return domainUnitId;
        }

        public final void setDomainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
        }

        @Override
        public final Builder domainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
            return this;
        }

        public final EnvironmentDeploymentDetails.Builder getEnvironmentDeploymentDetails() {
            return environmentDeploymentDetails != null ? environmentDeploymentDetails.toBuilder() : null;
        }

        public final void setEnvironmentDeploymentDetails(EnvironmentDeploymentDetails.BuilderImpl environmentDeploymentDetails) {
            this.environmentDeploymentDetails = environmentDeploymentDetails != null ? environmentDeploymentDetails.build()
                    : null;
        }

        @Override
        public final Builder environmentDeploymentDetails(EnvironmentDeploymentDetails environmentDeploymentDetails) {
            this.environmentDeploymentDetails = environmentDeploymentDetails;
            return this;
        }

        public final List<ProjectDeletionError.Builder> getFailureReasons() {
            List<ProjectDeletionError.Builder> result = FailureReasonsCopier.copyToBuilder(this.failureReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailureReasons(Collection<ProjectDeletionError.BuilderImpl> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copyFromBuilder(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<ProjectDeletionError> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(ProjectDeletionError... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(Consumer<ProjectDeletionError.Builder>... failureReasons) {
            failureReasons(Stream.of(failureReasons).map(c -> ProjectDeletionError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectProfileId() {
            return projectProfileId;
        }

        public final void setProjectProfileId(String projectProfileId) {
            this.projectProfileId = projectProfileId;
        }

        @Override
        public final Builder projectProfileId(String projectProfileId) {
            this.projectProfileId = projectProfileId;
            return this;
        }

        public final String getProjectStatus() {
            return projectStatus;
        }

        public final void setProjectStatus(String projectStatus) {
            this.projectStatus = projectStatus;
        }

        @Override
        public final Builder projectStatus(String projectStatus) {
            this.projectStatus = projectStatus;
            return this;
        }

        @Override
        public final Builder projectStatus(ProjectStatus projectStatus) {
            this.projectStatus(projectStatus == null ? null : projectStatus.toString());
            return this;
        }

        public final List<EnvironmentConfigurationUserParameter.Builder> getUserParameters() {
            List<EnvironmentConfigurationUserParameter.Builder> result = EnvironmentConfigurationUserParametersListCopier
                    .copyToBuilder(this.userParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserParameters(Collection<EnvironmentConfigurationUserParameter.BuilderImpl> userParameters) {
            this.userParameters = EnvironmentConfigurationUserParametersListCopier.copyFromBuilder(userParameters);
        }

        @Override
        public final Builder userParameters(Collection<EnvironmentConfigurationUserParameter> userParameters) {
            this.userParameters = EnvironmentConfigurationUserParametersListCopier.copy(userParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(EnvironmentConfigurationUserParameter... userParameters) {
            userParameters(Arrays.asList(userParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(Consumer<EnvironmentConfigurationUserParameter.Builder>... userParameters) {
            userParameters(Stream.of(userParameters)
                    .map(c -> EnvironmentConfigurationUserParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetProjectResponse build() {
            return new GetProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
