/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTimeSeriesDataPointRequest extends DataZoneRequest implements
        ToCopyableBuilder<GetTimeSeriesDataPointRequest.Builder, GetTimeSeriesDataPointRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(GetTimeSeriesDataPointRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityIdentifier").getter(getter(GetTimeSeriesDataPointRequest::entityIdentifier))
            .setter(setter(Builder::entityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(GetTimeSeriesDataPointRequest::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()).build();

    private static final SdkField<String> FORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("formName").getter(getter(GetTimeSeriesDataPointRequest::formName)).setter(setter(Builder::formName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("formName").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(GetTimeSeriesDataPointRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            ENTITY_IDENTIFIER_FIELD, ENTITY_TYPE_FIELD, FORM_NAME_FIELD, IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainIdentifier;

    private final String entityIdentifier;

    private final String entityType;

    private final String formName;

    private final String identifier;

    private GetTimeSeriesDataPointRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityType = builder.entityType;
        this.formName = builder.formName;
        this.identifier = builder.identifier;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain that houses the asset for which you want to get the data point.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain that houses the asset for which you want to get the data point.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the asset for which you want to get the data point.
     * </p>
     * 
     * @return The ID of the asset for which you want to get the data point.
     */
    public final String entityIdentifier() {
        return entityIdentifier;
    }

    /**
     * <p>
     * The type of the asset for which you want to get the data point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TimeSeriesEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the asset for which you want to get the data point.
     * @see TimeSeriesEntityType
     */
    public final TimeSeriesEntityType entityType() {
        return TimeSeriesEntityType.fromValue(entityType);
    }

    /**
     * <p>
     * The type of the asset for which you want to get the data point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TimeSeriesEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the asset for which you want to get the data point.
     * @see TimeSeriesEntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    /**
     * <p>
     * The name of the time series form that houses the data point that you want to get.
     * </p>
     * 
     * @return The name of the time series form that houses the data point that you want to get.
     */
    public final String formName() {
        return formName;
    }

    /**
     * <p>
     * The ID of the data point that you want to get.
     * </p>
     * 
     * @return The ID of the data point that you want to get.
     */
    public final String identifier() {
        return identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formName());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTimeSeriesDataPointRequest)) {
            return false;
        }
        GetTimeSeriesDataPointRequest other = (GetTimeSeriesDataPointRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(entityIdentifier(), other.entityIdentifier())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString())
                && Objects.equals(formName(), other.formName()) && Objects.equals(identifier(), other.identifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTimeSeriesDataPointRequest").add("DomainIdentifier", domainIdentifier())
                .add("EntityIdentifier", entityIdentifier()).add("EntityType", entityTypeAsString()).add("FormName", formName())
                .add("Identifier", identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "entityIdentifier":
            return Optional.ofNullable(clazz.cast(entityIdentifier()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        case "formName":
            return Optional.ofNullable(clazz.cast(formName()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        map.put("formName", FORM_NAME_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTimeSeriesDataPointRequest, T> g) {
        return obj -> g.apply((GetTimeSeriesDataPointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTimeSeriesDataPointRequest> {
        /**
         * <p>
         * The ID of the Amazon DataZone domain that houses the asset for which you want to get the data point.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain that houses the asset for which you want to get the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the asset for which you want to get the data point.
         * </p>
         * 
         * @param entityIdentifier
         *        The ID of the asset for which you want to get the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdentifier(String entityIdentifier);

        /**
         * <p>
         * The type of the asset for which you want to get the data point.
         * </p>
         * 
         * @param entityType
         *        The type of the asset for which you want to get the data point.
         * @see TimeSeriesEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeSeriesEntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The type of the asset for which you want to get the data point.
         * </p>
         * 
         * @param entityType
         *        The type of the asset for which you want to get the data point.
         * @see TimeSeriesEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeSeriesEntityType
         */
        Builder entityType(TimeSeriesEntityType entityType);

        /**
         * <p>
         * The name of the time series form that houses the data point that you want to get.
         * </p>
         * 
         * @param formName
         *        The name of the time series form that houses the data point that you want to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formName(String formName);

        /**
         * <p>
         * The ID of the data point that you want to get.
         * </p>
         * 
         * @param identifier
         *        The ID of the data point that you want to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private String entityIdentifier;

        private String entityType;

        private String formName;

        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTimeSeriesDataPointRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            entityIdentifier(model.entityIdentifier);
            entityType(model.entityType);
            formName(model.formName);
            identifier(model.identifier);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(TimeSeriesEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final String getFormName() {
            return formName;
        }

        public final void setFormName(String formName) {
            this.formName = formName;
        }

        @Override
        public final Builder formName(String formName) {
            this.formName = formName;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTimeSeriesDataPointRequest build() {
            return new GetTimeSeriesDataPointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
