/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Web Services Glue properties patch of a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GluePropertiesPatch implements SdkPojo, Serializable,
        ToCopyableBuilder<GluePropertiesPatch.Builder, GluePropertiesPatch> {
    private static final SdkField<GlueConnectionPatch> GLUE_CONNECTION_INPUT_FIELD = SdkField
            .<GlueConnectionPatch> builder(MarshallingType.SDK_POJO).memberName("glueConnectionInput")
            .getter(getter(GluePropertiesPatch::glueConnectionInput)).setter(setter(Builder::glueConnectionInput))
            .constructor(GlueConnectionPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueConnectionInput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_CONNECTION_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GlueConnectionPatch glueConnectionInput;

    private GluePropertiesPatch(BuilderImpl builder) {
        this.glueConnectionInput = builder.glueConnectionInput;
    }

    /**
     * <p>
     * The Amazon Web Services Glue properties patch of a connection.
     * </p>
     * 
     * @return The Amazon Web Services Glue properties patch of a connection.
     */
    public final GlueConnectionPatch glueConnectionInput() {
        return glueConnectionInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(glueConnectionInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GluePropertiesPatch)) {
            return false;
        }
        GluePropertiesPatch other = (GluePropertiesPatch) obj;
        return Objects.equals(glueConnectionInput(), other.glueConnectionInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GluePropertiesPatch").add("GlueConnectionInput", glueConnectionInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "glueConnectionInput":
            return Optional.ofNullable(clazz.cast(glueConnectionInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("glueConnectionInput", GLUE_CONNECTION_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GluePropertiesPatch, T> g) {
        return obj -> g.apply((GluePropertiesPatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GluePropertiesPatch> {
        /**
         * <p>
         * The Amazon Web Services Glue properties patch of a connection.
         * </p>
         * 
         * @param glueConnectionInput
         *        The Amazon Web Services Glue properties patch of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueConnectionInput(GlueConnectionPatch glueConnectionInput);

        /**
         * <p>
         * The Amazon Web Services Glue properties patch of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlueConnectionPatch.Builder} avoiding the
         * need to create one manually via {@link GlueConnectionPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlueConnectionPatch.Builder#build()} is called immediately and
         * its result is passed to {@link #glueConnectionInput(GlueConnectionPatch)}.
         * 
         * @param glueConnectionInput
         *        a consumer that will call methods on {@link GlueConnectionPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glueConnectionInput(GlueConnectionPatch)
         */
        default Builder glueConnectionInput(Consumer<GlueConnectionPatch.Builder> glueConnectionInput) {
            return glueConnectionInput(GlueConnectionPatch.builder().applyMutation(glueConnectionInput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GlueConnectionPatch glueConnectionInput;

        private BuilderImpl() {
        }

        private BuilderImpl(GluePropertiesPatch model) {
            glueConnectionInput(model.glueConnectionInput);
        }

        public final GlueConnectionPatch.Builder getGlueConnectionInput() {
            return glueConnectionInput != null ? glueConnectionInput.toBuilder() : null;
        }

        public final void setGlueConnectionInput(GlueConnectionPatch.BuilderImpl glueConnectionInput) {
            this.glueConnectionInput = glueConnectionInput != null ? glueConnectionInput.build() : null;
        }

        @Override
        public final Builder glueConnectionInput(GlueConnectionPatch glueConnectionInput) {
            this.glueConnectionInput = glueConnectionInput;
            return this;
        }

        @Override
        public GluePropertiesPatch build() {
            return new GluePropertiesPatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
