/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the self granting status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlueSelfGrantStatusOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<GlueSelfGrantStatusOutput.Builder, GlueSelfGrantStatusOutput> {
    private static final SdkField<List<SelfGrantStatusDetail>> SELF_GRANT_STATUS_DETAILS_FIELD = SdkField
            .<List<SelfGrantStatusDetail>> builder(MarshallingType.LIST)
            .memberName("selfGrantStatusDetails")
            .getter(getter(GlueSelfGrantStatusOutput::selfGrantStatusDetails))
            .setter(setter(Builder::selfGrantStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selfGrantStatusDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SelfGrantStatusDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(SelfGrantStatusDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SELF_GRANT_STATUS_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SelfGrantStatusDetail> selfGrantStatusDetails;

    private GlueSelfGrantStatusOutput(BuilderImpl builder) {
        this.selfGrantStatusDetails = builder.selfGrantStatusDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelfGrantStatusDetails property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSelfGrantStatusDetails() {
        return selfGrantStatusDetails != null && !(selfGrantStatusDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details for the self granting status for a Glue data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelfGrantStatusDetails} method.
     * </p>
     * 
     * @return The details for the self granting status for a Glue data source.
     */
    public final List<SelfGrantStatusDetail> selfGrantStatusDetails() {
        return selfGrantStatusDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSelfGrantStatusDetails() ? selfGrantStatusDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueSelfGrantStatusOutput)) {
            return false;
        }
        GlueSelfGrantStatusOutput other = (GlueSelfGrantStatusOutput) obj;
        return hasSelfGrantStatusDetails() == other.hasSelfGrantStatusDetails()
                && Objects.equals(selfGrantStatusDetails(), other.selfGrantStatusDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlueSelfGrantStatusOutput")
                .add("SelfGrantStatusDetails", hasSelfGrantStatusDetails() ? selfGrantStatusDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "selfGrantStatusDetails":
            return Optional.ofNullable(clazz.cast(selfGrantStatusDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("selfGrantStatusDetails", SELF_GRANT_STATUS_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlueSelfGrantStatusOutput, T> g) {
        return obj -> g.apply((GlueSelfGrantStatusOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlueSelfGrantStatusOutput> {
        /**
         * <p>
         * The details for the self granting status for a Glue data source.
         * </p>
         * 
         * @param selfGrantStatusDetails
         *        The details for the self granting status for a Glue data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfGrantStatusDetails(Collection<SelfGrantStatusDetail> selfGrantStatusDetails);

        /**
         * <p>
         * The details for the self granting status for a Glue data source.
         * </p>
         * 
         * @param selfGrantStatusDetails
         *        The details for the self granting status for a Glue data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfGrantStatusDetails(SelfGrantStatusDetail... selfGrantStatusDetails);

        /**
         * <p>
         * The details for the self granting status for a Glue data source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.SelfGrantStatusDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.SelfGrantStatusDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.SelfGrantStatusDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #selfGrantStatusDetails(List<SelfGrantStatusDetail>)}.
         * 
         * @param selfGrantStatusDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.SelfGrantStatusDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfGrantStatusDetails(java.util.Collection<SelfGrantStatusDetail>)
         */
        Builder selfGrantStatusDetails(Consumer<SelfGrantStatusDetail.Builder>... selfGrantStatusDetails);
    }

    static final class BuilderImpl implements Builder {
        private List<SelfGrantStatusDetail> selfGrantStatusDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GlueSelfGrantStatusOutput model) {
            selfGrantStatusDetails(model.selfGrantStatusDetails);
        }

        public final List<SelfGrantStatusDetail.Builder> getSelfGrantStatusDetails() {
            List<SelfGrantStatusDetail.Builder> result = SelfGrantStatusDetailsCopier.copyToBuilder(this.selfGrantStatusDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelfGrantStatusDetails(Collection<SelfGrantStatusDetail.BuilderImpl> selfGrantStatusDetails) {
            this.selfGrantStatusDetails = SelfGrantStatusDetailsCopier.copyFromBuilder(selfGrantStatusDetails);
        }

        @Override
        public final Builder selfGrantStatusDetails(Collection<SelfGrantStatusDetail> selfGrantStatusDetails) {
            this.selfGrantStatusDetails = SelfGrantStatusDetailsCopier.copy(selfGrantStatusDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selfGrantStatusDetails(SelfGrantStatusDetail... selfGrantStatusDetails) {
            selfGrantStatusDetails(Arrays.asList(selfGrantStatusDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selfGrantStatusDetails(Consumer<SelfGrantStatusDetail.Builder>... selfGrantStatusDetails) {
            selfGrantStatusDetails(Stream.of(selfGrantStatusDetails)
                    .map(c -> SelfGrantStatusDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GlueSelfGrantStatusOutput build() {
            return new GlueSelfGrantStatusOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
