/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The IAM properties patch of a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IamPropertiesPatch implements SdkPojo, Serializable,
        ToCopyableBuilder<IamPropertiesPatch.Builder, IamPropertiesPatch> {
    private static final SdkField<Boolean> GLUE_LINEAGE_SYNC_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("glueLineageSyncEnabled").getter(getter(IamPropertiesPatch::glueLineageSyncEnabled))
            .setter(setter(Builder::glueLineageSyncEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueLineageSyncEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GLUE_LINEAGE_SYNC_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean glueLineageSyncEnabled;

    private IamPropertiesPatch(BuilderImpl builder) {
        this.glueLineageSyncEnabled = builder.glueLineageSyncEnabled;
    }

    /**
     * <p>
     * Specifies whether Amazon Web Services Glue lineage sync is enabled for a connection.
     * </p>
     * 
     * @return Specifies whether Amazon Web Services Glue lineage sync is enabled for a connection.
     */
    public final Boolean glueLineageSyncEnabled() {
        return glueLineageSyncEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(glueLineageSyncEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamPropertiesPatch)) {
            return false;
        }
        IamPropertiesPatch other = (IamPropertiesPatch) obj;
        return Objects.equals(glueLineageSyncEnabled(), other.glueLineageSyncEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IamPropertiesPatch").add("GlueLineageSyncEnabled", glueLineageSyncEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "glueLineageSyncEnabled":
            return Optional.ofNullable(clazz.cast(glueLineageSyncEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("glueLineageSyncEnabled", GLUE_LINEAGE_SYNC_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IamPropertiesPatch, T> g) {
        return obj -> g.apply((IamPropertiesPatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IamPropertiesPatch> {
        /**
         * <p>
         * Specifies whether Amazon Web Services Glue lineage sync is enabled for a connection.
         * </p>
         * 
         * @param glueLineageSyncEnabled
         *        Specifies whether Amazon Web Services Glue lineage sync is enabled for a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueLineageSyncEnabled(Boolean glueLineageSyncEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean glueLineageSyncEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(IamPropertiesPatch model) {
            glueLineageSyncEnabled(model.glueLineageSyncEnabled);
        }

        public final Boolean getGlueLineageSyncEnabled() {
            return glueLineageSyncEnabled;
        }

        public final void setGlueLineageSyncEnabled(Boolean glueLineageSyncEnabled) {
            this.glueLineageSyncEnabled = glueLineageSyncEnabled;
        }

        @Override
        public final Builder glueLineageSyncEnabled(Boolean glueLineageSyncEnabled) {
            this.glueLineageSyncEnabled = glueLineageSyncEnabled;
            return this;
        }

        @Override
        public IamPropertiesPatch build() {
            return new IamPropertiesPatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
