/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a job run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobRunDetails implements SdkPojo, Serializable, ToCopyableBuilder<JobRunDetails.Builder, JobRunDetails> {
    private static final SdkField<LineageRunDetails> LINEAGE_RUN_DETAILS_FIELD = SdkField
            .<LineageRunDetails> builder(MarshallingType.SDK_POJO).memberName("lineageRunDetails")
            .getter(getter(JobRunDetails::lineageRunDetails)).setter(setter(Builder::lineageRunDetails))
            .constructor(LineageRunDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineageRunDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINEAGE_RUN_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LineageRunDetails lineageRunDetails;

    private final Type type;

    private JobRunDetails(BuilderImpl builder) {
        this.lineageRunDetails = builder.lineageRunDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * The data lineage details of a job run.
     * </p>
     * 
     * @return The data lineage details of a job run.
     */
    public final LineageRunDetails lineageRunDetails() {
        return lineageRunDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lineageRunDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRunDetails)) {
            return false;
        }
        JobRunDetails other = (JobRunDetails) obj;
        return Objects.equals(lineageRunDetails(), other.lineageRunDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobRunDetails").add("LineageRunDetails", lineageRunDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lineageRunDetails":
            return Optional.ofNullable(clazz.cast(lineageRunDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #lineageRunDetails()} initialized to the given value.
     *
     * <p>
     * The data lineage details of a job run.
     * </p>
     * 
     * @param lineageRunDetails
     *        The data lineage details of a job run.
     */
    public static JobRunDetails fromLineageRunDetails(LineageRunDetails lineageRunDetails) {
        return builder().lineageRunDetails(lineageRunDetails).build();
    }

    /**
     * Create an instance of this class with {@link #lineageRunDetails()} initialized to the given value.
     *
     * <p>
     * The data lineage details of a job run.
     * </p>
     * 
     * @param lineageRunDetails
     *        The data lineage details of a job run.
     */
    public static JobRunDetails fromLineageRunDetails(Consumer<LineageRunDetails.Builder> lineageRunDetails) {
        LineageRunDetails.Builder builder = LineageRunDetails.builder();
        lineageRunDetails.accept(builder);
        return fromLineageRunDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lineageRunDetails", LINEAGE_RUN_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobRunDetails, T> g) {
        return obj -> g.apply((JobRunDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobRunDetails> {
        /**
         * <p>
         * The data lineage details of a job run.
         * </p>
         * 
         * @param lineageRunDetails
         *        The data lineage details of a job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageRunDetails(LineageRunDetails lineageRunDetails);

        /**
         * <p>
         * The data lineage details of a job run.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineageRunDetails.Builder} avoiding the
         * need to create one manually via {@link LineageRunDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineageRunDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #lineageRunDetails(LineageRunDetails)}.
         * 
         * @param lineageRunDetails
         *        a consumer that will call methods on {@link LineageRunDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineageRunDetails(LineageRunDetails)
         */
        default Builder lineageRunDetails(Consumer<LineageRunDetails.Builder> lineageRunDetails) {
            return lineageRunDetails(LineageRunDetails.builder().applyMutation(lineageRunDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LineageRunDetails lineageRunDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(JobRunDetails model) {
            lineageRunDetails(model.lineageRunDetails);
        }

        public final LineageRunDetails.Builder getLineageRunDetails() {
            return lineageRunDetails != null ? lineageRunDetails.toBuilder() : null;
        }

        public final void setLineageRunDetails(LineageRunDetails.BuilderImpl lineageRunDetails) {
            Object oldValue = this.lineageRunDetails;
            this.lineageRunDetails = lineageRunDetails != null ? lineageRunDetails.build() : null;
            handleUnionValueChange(Type.LINEAGE_RUN_DETAILS, oldValue, this.lineageRunDetails);
        }

        @Override
        public final Builder lineageRunDetails(LineageRunDetails lineageRunDetails) {
            Object oldValue = this.lineageRunDetails;
            this.lineageRunDetails = lineageRunDetails;
            handleUnionValueChange(Type.LINEAGE_RUN_DETAILS, oldValue, this.lineageRunDetails);
            return this;
        }

        @Override
        public JobRunDetails build() {
            return new JobRunDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see JobRunDetails#type()
     */
    public enum Type {
        LINEAGE_RUN_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
