/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data lineage run details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineageRunDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<LineageRunDetails.Builder, LineageRunDetails> {
    private static final SdkField<LineageSqlQueryRunDetails> SQL_QUERY_RUN_DETAILS_FIELD = SdkField
            .<LineageSqlQueryRunDetails> builder(MarshallingType.SDK_POJO).memberName("sqlQueryRunDetails")
            .getter(getter(LineageRunDetails::sqlQueryRunDetails)).setter(setter(Builder::sqlQueryRunDetails))
            .constructor(LineageSqlQueryRunDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlQueryRunDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_QUERY_RUN_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LineageSqlQueryRunDetails sqlQueryRunDetails;

    private LineageRunDetails(BuilderImpl builder) {
        this.sqlQueryRunDetails = builder.sqlQueryRunDetails;
    }

    /**
     * <p>
     * The SQL query run details of a data lineage run.
     * </p>
     * 
     * @return The SQL query run details of a data lineage run.
     */
    public final LineageSqlQueryRunDetails sqlQueryRunDetails() {
        return sqlQueryRunDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sqlQueryRunDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageRunDetails)) {
            return false;
        }
        LineageRunDetails other = (LineageRunDetails) obj;
        return Objects.equals(sqlQueryRunDetails(), other.sqlQueryRunDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineageRunDetails").add("SqlQueryRunDetails", sqlQueryRunDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sqlQueryRunDetails":
            return Optional.ofNullable(clazz.cast(sqlQueryRunDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sqlQueryRunDetails", SQL_QUERY_RUN_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineageRunDetails, T> g) {
        return obj -> g.apply((LineageRunDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineageRunDetails> {
        /**
         * <p>
         * The SQL query run details of a data lineage run.
         * </p>
         * 
         * @param sqlQueryRunDetails
         *        The SQL query run details of a data lineage run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlQueryRunDetails(LineageSqlQueryRunDetails sqlQueryRunDetails);

        /**
         * <p>
         * The SQL query run details of a data lineage run.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineageSqlQueryRunDetails.Builder}
         * avoiding the need to create one manually via {@link LineageSqlQueryRunDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineageSqlQueryRunDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #sqlQueryRunDetails(LineageSqlQueryRunDetails)}.
         * 
         * @param sqlQueryRunDetails
         *        a consumer that will call methods on {@link LineageSqlQueryRunDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlQueryRunDetails(LineageSqlQueryRunDetails)
         */
        default Builder sqlQueryRunDetails(Consumer<LineageSqlQueryRunDetails.Builder> sqlQueryRunDetails) {
            return sqlQueryRunDetails(LineageSqlQueryRunDetails.builder().applyMutation(sqlQueryRunDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LineageSqlQueryRunDetails sqlQueryRunDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(LineageRunDetails model) {
            sqlQueryRunDetails(model.sqlQueryRunDetails);
        }

        public final LineageSqlQueryRunDetails.Builder getSqlQueryRunDetails() {
            return sqlQueryRunDetails != null ? sqlQueryRunDetails.toBuilder() : null;
        }

        public final void setSqlQueryRunDetails(LineageSqlQueryRunDetails.BuilderImpl sqlQueryRunDetails) {
            this.sqlQueryRunDetails = sqlQueryRunDetails != null ? sqlQueryRunDetails.build() : null;
        }

        @Override
        public final Builder sqlQueryRunDetails(LineageSqlQueryRunDetails sqlQueryRunDetails) {
            this.sqlQueryRunDetails = sqlQueryRunDetails;
            return this;
        }

        @Override
        public LineageRunDetails build() {
            return new LineageRunDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
