/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SQL query run details of a data lineage run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineageSqlQueryRunDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<LineageSqlQueryRunDetails.Builder, LineageSqlQueryRunDetails> {
    private static final SdkField<List<String>> ERROR_MESSAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("errorMessages")
            .getter(getter(LineageSqlQueryRunDetails::errorMessages))
            .setter(setter(Builder::errorMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> NUM_QUERIES_FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numQueriesFailed").getter(getter(LineageSqlQueryRunDetails::numQueriesFailed))
            .setter(setter(Builder::numQueriesFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numQueriesFailed").build()).build();

    private static final SdkField<Instant> QUERY_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("queryEndTime").getter(getter(LineageSqlQueryRunDetails::queryEndTime))
            .setter(setter(Builder::queryEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryEndTime").build()).build();

    private static final SdkField<Instant> QUERY_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("queryStartTime").getter(getter(LineageSqlQueryRunDetails::queryStartTime))
            .setter(setter(Builder::queryStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryStartTime").build()).build();

    private static final SdkField<Integer> TOTAL_QUERIES_PROCESSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalQueriesProcessed").getter(getter(LineageSqlQueryRunDetails::totalQueriesProcessed))
            .setter(setter(Builder::totalQueriesProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalQueriesProcessed").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGES_FIELD,
            NUM_QUERIES_FAILED_FIELD, QUERY_END_TIME_FIELD, QUERY_START_TIME_FIELD, TOTAL_QUERIES_PROCESSED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> errorMessages;

    private final Integer numQueriesFailed;

    private final Instant queryEndTime;

    private final Instant queryStartTime;

    private final Integer totalQueriesProcessed;

    private LineageSqlQueryRunDetails(BuilderImpl builder) {
        this.errorMessages = builder.errorMessages;
        this.numQueriesFailed = builder.numQueriesFailed;
        this.queryEndTime = builder.queryEndTime;
        this.queryStartTime = builder.queryStartTime;
        this.totalQueriesProcessed = builder.totalQueriesProcessed;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorMessages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasErrorMessages() {
        return errorMessages != null && !(errorMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The error message of the SQL query run details of a data lineage run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorMessages} method.
     * </p>
     * 
     * @return The error message of the SQL query run details of a data lineage run.
     */
    public final List<String> errorMessages() {
        return errorMessages;
    }

    /**
     * <p>
     * The number of queries that failed in the SQL query run details of a data lineage run.
     * </p>
     * 
     * @return The number of queries that failed in the SQL query run details of a data lineage run.
     */
    public final Integer numQueriesFailed() {
        return numQueriesFailed;
    }

    /**
     * <p>
     * The query end time in the SQL query run details of a data lineage run.
     * </p>
     * 
     * @return The query end time in the SQL query run details of a data lineage run.
     */
    public final Instant queryEndTime() {
        return queryEndTime;
    }

    /**
     * <p>
     * The query start time in the SQL query run details of a data lineage run.
     * </p>
     * 
     * @return The query start time in the SQL query run details of a data lineage run.
     */
    public final Instant queryStartTime() {
        return queryStartTime;
    }

    /**
     * <p>
     * The total queries processed in the SQL query run details of a data lineage run.
     * </p>
     * 
     * @return The total queries processed in the SQL query run details of a data lineage run.
     */
    public final Integer totalQueriesProcessed() {
        return totalQueriesProcessed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorMessages() ? errorMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numQueriesFailed());
        hashCode = 31 * hashCode + Objects.hashCode(queryEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(queryStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(totalQueriesProcessed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageSqlQueryRunDetails)) {
            return false;
        }
        LineageSqlQueryRunDetails other = (LineageSqlQueryRunDetails) obj;
        return hasErrorMessages() == other.hasErrorMessages() && Objects.equals(errorMessages(), other.errorMessages())
                && Objects.equals(numQueriesFailed(), other.numQueriesFailed())
                && Objects.equals(queryEndTime(), other.queryEndTime())
                && Objects.equals(queryStartTime(), other.queryStartTime())
                && Objects.equals(totalQueriesProcessed(), other.totalQueriesProcessed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineageSqlQueryRunDetails").add("ErrorMessages", hasErrorMessages() ? errorMessages() : null)
                .add("NumQueriesFailed", numQueriesFailed()).add("QueryEndTime", queryEndTime())
                .add("QueryStartTime", queryStartTime()).add("TotalQueriesProcessed", totalQueriesProcessed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorMessages":
            return Optional.ofNullable(clazz.cast(errorMessages()));
        case "numQueriesFailed":
            return Optional.ofNullable(clazz.cast(numQueriesFailed()));
        case "queryEndTime":
            return Optional.ofNullable(clazz.cast(queryEndTime()));
        case "queryStartTime":
            return Optional.ofNullable(clazz.cast(queryStartTime()));
        case "totalQueriesProcessed":
            return Optional.ofNullable(clazz.cast(totalQueriesProcessed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorMessages", ERROR_MESSAGES_FIELD);
        map.put("numQueriesFailed", NUM_QUERIES_FAILED_FIELD);
        map.put("queryEndTime", QUERY_END_TIME_FIELD);
        map.put("queryStartTime", QUERY_START_TIME_FIELD);
        map.put("totalQueriesProcessed", TOTAL_QUERIES_PROCESSED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineageSqlQueryRunDetails, T> g) {
        return obj -> g.apply((LineageSqlQueryRunDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineageSqlQueryRunDetails> {
        /**
         * <p>
         * The error message of the SQL query run details of a data lineage run.
         * </p>
         * 
         * @param errorMessages
         *        The error message of the SQL query run details of a data lineage run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessages(Collection<String> errorMessages);

        /**
         * <p>
         * The error message of the SQL query run details of a data lineage run.
         * </p>
         * 
         * @param errorMessages
         *        The error message of the SQL query run details of a data lineage run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessages(String... errorMessages);

        /**
         * <p>
         * The number of queries that failed in the SQL query run details of a data lineage run.
         * </p>
         * 
         * @param numQueriesFailed
         *        The number of queries that failed in the SQL query run details of a data lineage run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numQueriesFailed(Integer numQueriesFailed);

        /**
         * <p>
         * The query end time in the SQL query run details of a data lineage run.
         * </p>
         * 
         * @param queryEndTime
         *        The query end time in the SQL query run details of a data lineage run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryEndTime(Instant queryEndTime);

        /**
         * <p>
         * The query start time in the SQL query run details of a data lineage run.
         * </p>
         * 
         * @param queryStartTime
         *        The query start time in the SQL query run details of a data lineage run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStartTime(Instant queryStartTime);

        /**
         * <p>
         * The total queries processed in the SQL query run details of a data lineage run.
         * </p>
         * 
         * @param totalQueriesProcessed
         *        The total queries processed in the SQL query run details of a data lineage run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalQueriesProcessed(Integer totalQueriesProcessed);
    }

    static final class BuilderImpl implements Builder {
        private List<String> errorMessages = DefaultSdkAutoConstructList.getInstance();

        private Integer numQueriesFailed;

        private Instant queryEndTime;

        private Instant queryStartTime;

        private Integer totalQueriesProcessed;

        private BuilderImpl() {
        }

        private BuilderImpl(LineageSqlQueryRunDetails model) {
            errorMessages(model.errorMessages);
            numQueriesFailed(model.numQueriesFailed);
            queryEndTime(model.queryEndTime);
            queryStartTime(model.queryStartTime);
            totalQueriesProcessed(model.totalQueriesProcessed);
        }

        public final Collection<String> getErrorMessages() {
            if (errorMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return errorMessages;
        }

        public final void setErrorMessages(Collection<String> errorMessages) {
            this.errorMessages = FailedQueryProcessingErrorMessagesCopier.copy(errorMessages);
        }

        @Override
        public final Builder errorMessages(Collection<String> errorMessages) {
            this.errorMessages = FailedQueryProcessingErrorMessagesCopier.copy(errorMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorMessages(String... errorMessages) {
            errorMessages(Arrays.asList(errorMessages));
            return this;
        }

        public final Integer getNumQueriesFailed() {
            return numQueriesFailed;
        }

        public final void setNumQueriesFailed(Integer numQueriesFailed) {
            this.numQueriesFailed = numQueriesFailed;
        }

        @Override
        public final Builder numQueriesFailed(Integer numQueriesFailed) {
            this.numQueriesFailed = numQueriesFailed;
            return this;
        }

        public final Instant getQueryEndTime() {
            return queryEndTime;
        }

        public final void setQueryEndTime(Instant queryEndTime) {
            this.queryEndTime = queryEndTime;
        }

        @Override
        public final Builder queryEndTime(Instant queryEndTime) {
            this.queryEndTime = queryEndTime;
            return this;
        }

        public final Instant getQueryStartTime() {
            return queryStartTime;
        }

        public final void setQueryStartTime(Instant queryStartTime) {
            this.queryStartTime = queryStartTime;
        }

        @Override
        public final Builder queryStartTime(Instant queryStartTime) {
            this.queryStartTime = queryStartTime;
            return this;
        }

        public final Integer getTotalQueriesProcessed() {
            return totalQueriesProcessed;
        }

        public final void setTotalQueriesProcessed(Integer totalQueriesProcessed) {
            this.totalQueriesProcessed = totalQueriesProcessed;
        }

        @Override
        public final Builder totalQueriesProcessed(Integer totalQueriesProcessed) {
            this.totalQueriesProcessed = totalQueriesProcessed;
            return this;
        }

        @Override
        public LineageSqlQueryRunDetails build() {
            return new LineageSqlQueryRunDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
