/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTimeSeriesDataPointsRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListTimeSeriesDataPointsRequest.Builder, ListTimeSeriesDataPointsRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListTimeSeriesDataPointsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt").getter(getter(ListTimeSeriesDataPointsRequest::endedAt)).setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endedAt").build()).build();

    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityIdentifier").getter(getter(ListTimeSeriesDataPointsRequest::entityIdentifier))
            .setter(setter(Builder::entityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(ListTimeSeriesDataPointsRequest::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()).build();

    private static final SdkField<String> FORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("formName").getter(getter(ListTimeSeriesDataPointsRequest::formName)).setter(setter(Builder::formName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("formName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListTimeSeriesDataPointsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTimeSeriesDataPointsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt").getter(getter(ListTimeSeriesDataPointsRequest::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            ENDED_AT_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_TYPE_FIELD, FORM_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD,
            STARTED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainIdentifier;

    private final Instant endedAt;

    private final String entityIdentifier;

    private final String entityType;

    private final String formName;

    private final Integer maxResults;

    private final String nextToken;

    private final Instant startedAt;

    private ListTimeSeriesDataPointsRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.endedAt = builder.endedAt;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityType = builder.entityType;
        this.formName = builder.formName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.startedAt = builder.startedAt;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain that houses the assets for which you want to list time series data points.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain that houses the assets for which you want to list time series data
     *         points.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The timestamp at which the data points that you wanted to list ended.
     * </p>
     * 
     * @return The timestamp at which the data points that you wanted to list ended.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The ID of the asset for which you want to list data points.
     * </p>
     * 
     * @return The ID of the asset for which you want to list data points.
     */
    public final String entityIdentifier() {
        return entityIdentifier;
    }

    /**
     * <p>
     * The type of the asset for which you want to list data points.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TimeSeriesEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the asset for which you want to list data points.
     * @see TimeSeriesEntityType
     */
    public final TimeSeriesEntityType entityType() {
        return TimeSeriesEntityType.fromValue(entityType);
    }

    /**
     * <p>
     * The type of the asset for which you want to list data points.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TimeSeriesEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the asset for which you want to list data points.
     * @see TimeSeriesEntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    /**
     * <p>
     * The name of the time series data points form.
     * </p>
     * 
     * @return The name of the time series data points form.
     */
    public final String formName() {
        return formName;
    }

    /**
     * <p>
     * The maximum number of data points to return in a single call to ListTimeSeriesDataPoints. When the number of data
     * points to be listed is greater than the value of MaxResults, the response contains a NextToken value that you can
     * use in a subsequent call to ListTimeSeriesDataPoints to list the next set of data points.
     * </p>
     * 
     * @return The maximum number of data points to return in a single call to ListTimeSeriesDataPoints. When the number
     *         of data points to be listed is greater than the value of MaxResults, the response contains a NextToken
     *         value that you can use in a subsequent call to ListTimeSeriesDataPoints to list the next set of data
     *         points.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of data points is greater than the default value for the MaxResults parameter, or if you
     * explicitly specify a value for MaxResults that is less than the number of data points, the response includes a
     * pagination token named NextToken. You can specify this NextToken value in a subsequent call to
     * ListTimeSeriesDataPoints to list the next set of data points.
     * </p>
     * 
     * @return When the number of data points is greater than the default value for the MaxResults parameter, or if you
     *         explicitly specify a value for MaxResults that is less than the number of data points, the response
     *         includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to
     *         ListTimeSeriesDataPoints to list the next set of data points.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The timestamp at which the data points that you want to list started.
     * </p>
     * 
     * @return The timestamp at which the data points that you want to list started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTimeSeriesDataPointsRequest)) {
            return false;
        }
        ListTimeSeriesDataPointsRequest other = (ListTimeSeriesDataPointsRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier()) && Objects.equals(endedAt(), other.endedAt())
                && Objects.equals(entityIdentifier(), other.entityIdentifier())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString())
                && Objects.equals(formName(), other.formName()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(startedAt(), other.startedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTimeSeriesDataPointsRequest").add("DomainIdentifier", domainIdentifier())
                .add("EndedAt", endedAt()).add("EntityIdentifier", entityIdentifier()).add("EntityType", entityTypeAsString())
                .add("FormName", formName()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("StartedAt", startedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "entityIdentifier":
            return Optional.ofNullable(clazz.cast(entityIdentifier()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        case "formName":
            return Optional.ofNullable(clazz.cast(formName()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        map.put("formName", FORM_NAME_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTimeSeriesDataPointsRequest, T> g) {
        return obj -> g.apply((ListTimeSeriesDataPointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTimeSeriesDataPointsRequest> {
        /**
         * <p>
         * The ID of the Amazon DataZone domain that houses the assets for which you want to list time series data
         * points.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain that houses the assets for which you want to list time series
         *        data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The timestamp at which the data points that you wanted to list ended.
         * </p>
         * 
         * @param endedAt
         *        The timestamp at which the data points that you wanted to list ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The ID of the asset for which you want to list data points.
         * </p>
         * 
         * @param entityIdentifier
         *        The ID of the asset for which you want to list data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdentifier(String entityIdentifier);

        /**
         * <p>
         * The type of the asset for which you want to list data points.
         * </p>
         * 
         * @param entityType
         *        The type of the asset for which you want to list data points.
         * @see TimeSeriesEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeSeriesEntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The type of the asset for which you want to list data points.
         * </p>
         * 
         * @param entityType
         *        The type of the asset for which you want to list data points.
         * @see TimeSeriesEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeSeriesEntityType
         */
        Builder entityType(TimeSeriesEntityType entityType);

        /**
         * <p>
         * The name of the time series data points form.
         * </p>
         * 
         * @param formName
         *        The name of the time series data points form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formName(String formName);

        /**
         * <p>
         * The maximum number of data points to return in a single call to ListTimeSeriesDataPoints. When the number of
         * data points to be listed is greater than the value of MaxResults, the response contains a NextToken value
         * that you can use in a subsequent call to ListTimeSeriesDataPoints to list the next set of data points.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of data points to return in a single call to ListTimeSeriesDataPoints. When the
         *        number of data points to be listed is greater than the value of MaxResults, the response contains a
         *        NextToken value that you can use in a subsequent call to ListTimeSeriesDataPoints to list the next set
         *        of data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of data points is greater than the default value for the MaxResults parameter, or if you
         * explicitly specify a value for MaxResults that is less than the number of data points, the response includes
         * a pagination token named NextToken. You can specify this NextToken value in a subsequent call to
         * ListTimeSeriesDataPoints to list the next set of data points.
         * </p>
         * 
         * @param nextToken
         *        When the number of data points is greater than the default value for the MaxResults parameter, or if
         *        you explicitly specify a value for MaxResults that is less than the number of data points, the
         *        response includes a pagination token named NextToken. You can specify this NextToken value in a
         *        subsequent call to ListTimeSeriesDataPoints to list the next set of data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The timestamp at which the data points that you want to list started.
         * </p>
         * 
         * @param startedAt
         *        The timestamp at which the data points that you want to list started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private Instant endedAt;

        private String entityIdentifier;

        private String entityType;

        private String formName;

        private Integer maxResults;

        private String nextToken;

        private Instant startedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTimeSeriesDataPointsRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            endedAt(model.endedAt);
            entityIdentifier(model.entityIdentifier);
            entityType(model.entityType);
            formName(model.formName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            startedAt(model.startedAt);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final String getEntityIdentifier() {
            return entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(TimeSeriesEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final String getFormName() {
            return formName;
        }

        public final void setFormName(String formName) {
            this.formName = formName;
        }

        @Override
        public final Builder formName(String formName) {
            this.formName = formName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTimeSeriesDataPointsRequest build() {
            return new ListTimeSeriesDataPointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
