/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A member of the policy grant list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyGrantMember implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyGrantMember.Builder, PolicyGrantMember> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(PolicyGrantMember::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(PolicyGrantMember::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<PolicyGrantDetail> DETAIL_FIELD = SdkField
            .<PolicyGrantDetail> builder(MarshallingType.SDK_POJO).memberName("detail").getter(getter(PolicyGrantMember::detail))
            .setter(setter(Builder::detail)).constructor(PolicyGrantDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detail").build()).build();

    private static final SdkField<PolicyGrantPrincipal> PRINCIPAL_FIELD = SdkField
            .<PolicyGrantPrincipal> builder(MarshallingType.SDK_POJO).memberName("principal")
            .getter(getter(PolicyGrantMember::principal)).setter(setter(Builder::principal))
            .constructor(PolicyGrantPrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DETAIL_FIELD, PRINCIPAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String createdBy;

    private final PolicyGrantDetail detail;

    private final PolicyGrantPrincipal principal;

    private PolicyGrantMember(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.detail = builder.detail;
        this.principal = builder.principal;
    }

    /**
     * <p>
     * Specifies the timestamp at which policy grant member was created.
     * </p>
     * 
     * @return Specifies the timestamp at which policy grant member was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies the user who created the policy grant member.
     * </p>
     * 
     * @return Specifies the user who created the policy grant member.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The details of the policy grant member.
     * </p>
     * 
     * @return The details of the policy grant member.
     */
    public final PolicyGrantDetail detail() {
        return detail;
    }

    /**
     * <p>
     * The principal of the policy grant member.
     * </p>
     * 
     * @return The principal of the policy grant member.
     */
    public final PolicyGrantPrincipal principal() {
        return principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(detail());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyGrantMember)) {
            return false;
        }
        PolicyGrantMember other = (PolicyGrantMember) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(detail(), other.detail()) && Objects.equals(principal(), other.principal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyGrantMember").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Detail", detail()).add("Principal", principal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "detail":
            return Optional.ofNullable(clazz.cast(detail()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("detail", DETAIL_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyGrantMember, T> g) {
        return obj -> g.apply((PolicyGrantMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyGrantMember> {
        /**
         * <p>
         * Specifies the timestamp at which policy grant member was created.
         * </p>
         * 
         * @param createdAt
         *        Specifies the timestamp at which policy grant member was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies the user who created the policy grant member.
         * </p>
         * 
         * @param createdBy
         *        Specifies the user who created the policy grant member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The details of the policy grant member.
         * </p>
         * 
         * @param detail
         *        The details of the policy grant member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detail(PolicyGrantDetail detail);

        /**
         * <p>
         * The details of the policy grant member.
         * </p>
         * This is a convenience method that creates an instance of the {@link PolicyGrantDetail.Builder} avoiding the
         * need to create one manually via {@link PolicyGrantDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PolicyGrantDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #detail(PolicyGrantDetail)}.
         * 
         * @param detail
         *        a consumer that will call methods on {@link PolicyGrantDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detail(PolicyGrantDetail)
         */
        default Builder detail(Consumer<PolicyGrantDetail.Builder> detail) {
            return detail(PolicyGrantDetail.builder().applyMutation(detail).build());
        }

        /**
         * <p>
         * The principal of the policy grant member.
         * </p>
         * 
         * @param principal
         *        The principal of the policy grant member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(PolicyGrantPrincipal principal);

        /**
         * <p>
         * The principal of the policy grant member.
         * </p>
         * This is a convenience method that creates an instance of the {@link PolicyGrantPrincipal.Builder} avoiding
         * the need to create one manually via {@link PolicyGrantPrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PolicyGrantPrincipal.Builder#build()} is called immediately and
         * its result is passed to {@link #principal(PolicyGrantPrincipal)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link PolicyGrantPrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(PolicyGrantPrincipal)
         */
        default Builder principal(Consumer<PolicyGrantPrincipal.Builder> principal) {
            return principal(PolicyGrantPrincipal.builder().applyMutation(principal).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private PolicyGrantDetail detail;

        private PolicyGrantPrincipal principal;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyGrantMember model) {
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            detail(model.detail);
            principal(model.principal);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final PolicyGrantDetail.Builder getDetail() {
            return detail != null ? detail.toBuilder() : null;
        }

        public final void setDetail(PolicyGrantDetail.BuilderImpl detail) {
            this.detail = detail != null ? detail.build() : null;
        }

        @Override
        public final Builder detail(PolicyGrantDetail detail) {
            this.detail = detail;
            return this;
        }

        public final PolicyGrantPrincipal.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        public final void setPrincipal(PolicyGrantPrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(PolicyGrantPrincipal principal) {
            this.principal = principal;
            return this;
        }

        @Override
        public PolicyGrantMember build() {
            return new PolicyGrantMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
