/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The policy grant principal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyGrantPrincipal implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyGrantPrincipal.Builder, PolicyGrantPrincipal> {
    private static final SdkField<DomainUnitPolicyGrantPrincipal> DOMAIN_UNIT_FIELD = SdkField
            .<DomainUnitPolicyGrantPrincipal> builder(MarshallingType.SDK_POJO).memberName("domainUnit")
            .getter(getter(PolicyGrantPrincipal::domainUnit)).setter(setter(Builder::domainUnit))
            .constructor(DomainUnitPolicyGrantPrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnit").build()).build();

    private static final SdkField<GroupPolicyGrantPrincipal> GROUP_FIELD = SdkField
            .<GroupPolicyGrantPrincipal> builder(MarshallingType.SDK_POJO).memberName("group")
            .getter(getter(PolicyGrantPrincipal::group)).setter(setter(Builder::group))
            .constructor(GroupPolicyGrantPrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<ProjectPolicyGrantPrincipal> PROJECT_FIELD = SdkField
            .<ProjectPolicyGrantPrincipal> builder(MarshallingType.SDK_POJO).memberName("project")
            .getter(getter(PolicyGrantPrincipal::project)).setter(setter(Builder::project))
            .constructor(ProjectPolicyGrantPrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()).build();

    private static final SdkField<UserPolicyGrantPrincipal> USER_FIELD = SdkField
            .<UserPolicyGrantPrincipal> builder(MarshallingType.SDK_POJO).memberName("user")
            .getter(getter(PolicyGrantPrincipal::user)).setter(setter(Builder::user))
            .constructor(UserPolicyGrantPrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_UNIT_FIELD,
            GROUP_FIELD, PROJECT_FIELD, USER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DomainUnitPolicyGrantPrincipal domainUnit;

    private final GroupPolicyGrantPrincipal group;

    private final ProjectPolicyGrantPrincipal project;

    private final UserPolicyGrantPrincipal user;

    private final Type type;

    private PolicyGrantPrincipal(BuilderImpl builder) {
        this.domainUnit = builder.domainUnit;
        this.group = builder.group;
        this.project = builder.project;
        this.user = builder.user;
        this.type = builder.type;
    }

    /**
     * <p>
     * The domain unit of the policy grant principal.
     * </p>
     * 
     * @return The domain unit of the policy grant principal.
     */
    public final DomainUnitPolicyGrantPrincipal domainUnit() {
        return domainUnit;
    }

    /**
     * <p>
     * The group of the policy grant principal.
     * </p>
     * 
     * @return The group of the policy grant principal.
     */
    public final GroupPolicyGrantPrincipal group() {
        return group;
    }

    /**
     * <p>
     * The project of the policy grant principal.
     * </p>
     * 
     * @return The project of the policy grant principal.
     */
    public final ProjectPolicyGrantPrincipal project() {
        return project;
    }

    /**
     * <p>
     * The user of the policy grant principal.
     * </p>
     * 
     * @return The user of the policy grant principal.
     */
    public final UserPolicyGrantPrincipal user() {
        return user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainUnit());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyGrantPrincipal)) {
            return false;
        }
        PolicyGrantPrincipal other = (PolicyGrantPrincipal) obj;
        return Objects.equals(domainUnit(), other.domainUnit()) && Objects.equals(group(), other.group())
                && Objects.equals(project(), other.project()) && Objects.equals(user(), other.user());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyGrantPrincipal").add("DomainUnit", domainUnit()).add("Group", group())
                .add("Project", project()).add("User", user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainUnit":
            return Optional.ofNullable(clazz.cast(domainUnit()));
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        case "user":
            return Optional.ofNullable(clazz.cast(user()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #domainUnit()} initialized to the given value.
     *
     * <p>
     * The domain unit of the policy grant principal.
     * </p>
     * 
     * @param domainUnit
     *        The domain unit of the policy grant principal.
     */
    public static PolicyGrantPrincipal fromDomainUnit(DomainUnitPolicyGrantPrincipal domainUnit) {
        return builder().domainUnit(domainUnit).build();
    }

    /**
     * Create an instance of this class with {@link #domainUnit()} initialized to the given value.
     *
     * <p>
     * The domain unit of the policy grant principal.
     * </p>
     * 
     * @param domainUnit
     *        The domain unit of the policy grant principal.
     */
    public static PolicyGrantPrincipal fromDomainUnit(Consumer<DomainUnitPolicyGrantPrincipal.Builder> domainUnit) {
        DomainUnitPolicyGrantPrincipal.Builder builder = DomainUnitPolicyGrantPrincipal.builder();
        domainUnit.accept(builder);
        return fromDomainUnit(builder.build());
    }

    /**
     * Create an instance of this class with {@link #group()} initialized to the given value.
     *
     * <p>
     * The group of the policy grant principal.
     * </p>
     * 
     * @param group
     *        The group of the policy grant principal.
     */
    public static PolicyGrantPrincipal fromGroup(GroupPolicyGrantPrincipal group) {
        return builder().group(group).build();
    }

    /**
     * Create an instance of this class with {@link #group()} initialized to the given value.
     *
     * <p>
     * The group of the policy grant principal.
     * </p>
     * 
     * @param group
     *        The group of the policy grant principal.
     */
    public static PolicyGrantPrincipal fromGroup(Consumer<GroupPolicyGrantPrincipal.Builder> group) {
        GroupPolicyGrantPrincipal.Builder builder = GroupPolicyGrantPrincipal.builder();
        group.accept(builder);
        return fromGroup(builder.build());
    }

    /**
     * Create an instance of this class with {@link #project()} initialized to the given value.
     *
     * <p>
     * The project of the policy grant principal.
     * </p>
     * 
     * @param project
     *        The project of the policy grant principal.
     */
    public static PolicyGrantPrincipal fromProject(ProjectPolicyGrantPrincipal project) {
        return builder().project(project).build();
    }

    /**
     * Create an instance of this class with {@link #project()} initialized to the given value.
     *
     * <p>
     * The project of the policy grant principal.
     * </p>
     * 
     * @param project
     *        The project of the policy grant principal.
     */
    public static PolicyGrantPrincipal fromProject(Consumer<ProjectPolicyGrantPrincipal.Builder> project) {
        ProjectPolicyGrantPrincipal.Builder builder = ProjectPolicyGrantPrincipal.builder();
        project.accept(builder);
        return fromProject(builder.build());
    }

    /**
     * Create an instance of this class with {@link #user()} initialized to the given value.
     *
     * <p>
     * The user of the policy grant principal.
     * </p>
     * 
     * @param user
     *        The user of the policy grant principal.
     */
    public static PolicyGrantPrincipal fromUser(UserPolicyGrantPrincipal user) {
        return builder().user(user).build();
    }

    /**
     * Create an instance of this class with {@link #user()} initialized to the given value.
     *
     * <p>
     * The user of the policy grant principal.
     * </p>
     * 
     * @param user
     *        The user of the policy grant principal.
     */
    public static PolicyGrantPrincipal fromUser(Consumer<UserPolicyGrantPrincipal.Builder> user) {
        UserPolicyGrantPrincipal.Builder builder = UserPolicyGrantPrincipal.builder();
        user.accept(builder);
        return fromUser(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainUnit", DOMAIN_UNIT_FIELD);
        map.put("group", GROUP_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("user", USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyGrantPrincipal, T> g) {
        return obj -> g.apply((PolicyGrantPrincipal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyGrantPrincipal> {
        /**
         * <p>
         * The domain unit of the policy grant principal.
         * </p>
         * 
         * @param domainUnit
         *        The domain unit of the policy grant principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainUnit(DomainUnitPolicyGrantPrincipal domainUnit);

        /**
         * <p>
         * The domain unit of the policy grant principal.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainUnitPolicyGrantPrincipal.Builder}
         * avoiding the need to create one manually via {@link DomainUnitPolicyGrantPrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainUnitPolicyGrantPrincipal.Builder#build()} is called
         * immediately and its result is passed to {@link #domainUnit(DomainUnitPolicyGrantPrincipal)}.
         * 
         * @param domainUnit
         *        a consumer that will call methods on {@link DomainUnitPolicyGrantPrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainUnit(DomainUnitPolicyGrantPrincipal)
         */
        default Builder domainUnit(Consumer<DomainUnitPolicyGrantPrincipal.Builder> domainUnit) {
            return domainUnit(DomainUnitPolicyGrantPrincipal.builder().applyMutation(domainUnit).build());
        }

        /**
         * <p>
         * The group of the policy grant principal.
         * </p>
         * 
         * @param group
         *        The group of the policy grant principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(GroupPolicyGrantPrincipal group);

        /**
         * <p>
         * The group of the policy grant principal.
         * </p>
         * This is a convenience method that creates an instance of the {@link GroupPolicyGrantPrincipal.Builder}
         * avoiding the need to create one manually via {@link GroupPolicyGrantPrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GroupPolicyGrantPrincipal.Builder#build()} is called immediately
         * and its result is passed to {@link #group(GroupPolicyGrantPrincipal)}.
         * 
         * @param group
         *        a consumer that will call methods on {@link GroupPolicyGrantPrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #group(GroupPolicyGrantPrincipal)
         */
        default Builder group(Consumer<GroupPolicyGrantPrincipal.Builder> group) {
            return group(GroupPolicyGrantPrincipal.builder().applyMutation(group).build());
        }

        /**
         * <p>
         * The project of the policy grant principal.
         * </p>
         * 
         * @param project
         *        The project of the policy grant principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(ProjectPolicyGrantPrincipal project);

        /**
         * <p>
         * The project of the policy grant principal.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProjectPolicyGrantPrincipal.Builder}
         * avoiding the need to create one manually via {@link ProjectPolicyGrantPrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectPolicyGrantPrincipal.Builder#build()} is called
         * immediately and its result is passed to {@link #project(ProjectPolicyGrantPrincipal)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link ProjectPolicyGrantPrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(ProjectPolicyGrantPrincipal)
         */
        default Builder project(Consumer<ProjectPolicyGrantPrincipal.Builder> project) {
            return project(ProjectPolicyGrantPrincipal.builder().applyMutation(project).build());
        }

        /**
         * <p>
         * The user of the policy grant principal.
         * </p>
         * 
         * @param user
         *        The user of the policy grant principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(UserPolicyGrantPrincipal user);

        /**
         * <p>
         * The user of the policy grant principal.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserPolicyGrantPrincipal.Builder}
         * avoiding the need to create one manually via {@link UserPolicyGrantPrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserPolicyGrantPrincipal.Builder#build()} is called immediately
         * and its result is passed to {@link #user(UserPolicyGrantPrincipal)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link UserPolicyGrantPrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(UserPolicyGrantPrincipal)
         */
        default Builder user(Consumer<UserPolicyGrantPrincipal.Builder> user) {
            return user(UserPolicyGrantPrincipal.builder().applyMutation(user).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DomainUnitPolicyGrantPrincipal domainUnit;

        private GroupPolicyGrantPrincipal group;

        private ProjectPolicyGrantPrincipal project;

        private UserPolicyGrantPrincipal user;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyGrantPrincipal model) {
            domainUnit(model.domainUnit);
            group(model.group);
            project(model.project);
            user(model.user);
        }

        public final DomainUnitPolicyGrantPrincipal.Builder getDomainUnit() {
            return domainUnit != null ? domainUnit.toBuilder() : null;
        }

        public final void setDomainUnit(DomainUnitPolicyGrantPrincipal.BuilderImpl domainUnit) {
            Object oldValue = this.domainUnit;
            this.domainUnit = domainUnit != null ? domainUnit.build() : null;
            handleUnionValueChange(Type.DOMAIN_UNIT, oldValue, this.domainUnit);
        }

        @Override
        public final Builder domainUnit(DomainUnitPolicyGrantPrincipal domainUnit) {
            Object oldValue = this.domainUnit;
            this.domainUnit = domainUnit;
            handleUnionValueChange(Type.DOMAIN_UNIT, oldValue, this.domainUnit);
            return this;
        }

        public final GroupPolicyGrantPrincipal.Builder getGroup() {
            return group != null ? group.toBuilder() : null;
        }

        public final void setGroup(GroupPolicyGrantPrincipal.BuilderImpl group) {
            Object oldValue = this.group;
            this.group = group != null ? group.build() : null;
            handleUnionValueChange(Type.GROUP, oldValue, this.group);
        }

        @Override
        public final Builder group(GroupPolicyGrantPrincipal group) {
            Object oldValue = this.group;
            this.group = group;
            handleUnionValueChange(Type.GROUP, oldValue, this.group);
            return this;
        }

        public final ProjectPolicyGrantPrincipal.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        public final void setProject(ProjectPolicyGrantPrincipal.BuilderImpl project) {
            Object oldValue = this.project;
            this.project = project != null ? project.build() : null;
            handleUnionValueChange(Type.PROJECT, oldValue, this.project);
        }

        @Override
        public final Builder project(ProjectPolicyGrantPrincipal project) {
            Object oldValue = this.project;
            this.project = project;
            handleUnionValueChange(Type.PROJECT, oldValue, this.project);
            return this;
        }

        public final UserPolicyGrantPrincipal.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(UserPolicyGrantPrincipal.BuilderImpl user) {
            Object oldValue = this.user;
            this.user = user != null ? user.build() : null;
            handleUnionValueChange(Type.USER, oldValue, this.user);
        }

        @Override
        public final Builder user(UserPolicyGrantPrincipal user) {
            Object oldValue = this.user;
            this.user = user;
            handleUnionValueChange(Type.USER, oldValue, this.user);
            return this;
        }

        @Override
        public PolicyGrantPrincipal build() {
            return new PolicyGrantPrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PolicyGrantPrincipal#type()
     */
    public enum Type {
        DOMAIN_UNIT,

        GROUP,

        PROJECT,

        USER,

        UNKNOWN_TO_SDK_VERSION
    }
}
