/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The provisioning properties of an environment blueprint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisioningProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisioningProperties.Builder, ProvisioningProperties> {
    private static final SdkField<CloudFormationProperties> CLOUD_FORMATION_FIELD = SdkField
            .<CloudFormationProperties> builder(MarshallingType.SDK_POJO).memberName("cloudFormation")
            .getter(getter(ProvisioningProperties::cloudFormation)).setter(setter(Builder::cloudFormation))
            .constructor(CloudFormationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudFormation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CloudFormationProperties cloudFormation;

    private final Type type;

    private ProvisioningProperties(BuilderImpl builder) {
        this.cloudFormation = builder.cloudFormation;
        this.type = builder.type;
    }

    /**
     * <p>
     * The cloud formation properties included as part of the provisioning properties of an environment blueprint.
     * </p>
     * 
     * @return The cloud formation properties included as part of the provisioning properties of an environment
     *         blueprint.
     */
    public final CloudFormationProperties cloudFormation() {
        return cloudFormation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningProperties)) {
            return false;
        }
        ProvisioningProperties other = (ProvisioningProperties) obj;
        return Objects.equals(cloudFormation(), other.cloudFormation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisioningProperties").add("CloudFormation", cloudFormation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudFormation":
            return Optional.ofNullable(clazz.cast(cloudFormation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #cloudFormation()} initialized to the given value.
     *
     * <p>
     * The cloud formation properties included as part of the provisioning properties of an environment blueprint.
     * </p>
     * 
     * @param cloudFormation
     *        The cloud formation properties included as part of the provisioning properties of an environment
     *        blueprint.
     */
    public static ProvisioningProperties fromCloudFormation(CloudFormationProperties cloudFormation) {
        return builder().cloudFormation(cloudFormation).build();
    }

    /**
     * Create an instance of this class with {@link #cloudFormation()} initialized to the given value.
     *
     * <p>
     * The cloud formation properties included as part of the provisioning properties of an environment blueprint.
     * </p>
     * 
     * @param cloudFormation
     *        The cloud formation properties included as part of the provisioning properties of an environment
     *        blueprint.
     */
    public static ProvisioningProperties fromCloudFormation(Consumer<CloudFormationProperties.Builder> cloudFormation) {
        CloudFormationProperties.Builder builder = CloudFormationProperties.builder();
        cloudFormation.accept(builder);
        return fromCloudFormation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudFormation", CLOUD_FORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningProperties, T> g) {
        return obj -> g.apply((ProvisioningProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisioningProperties> {
        /**
         * <p>
         * The cloud formation properties included as part of the provisioning properties of an environment blueprint.
         * </p>
         * 
         * @param cloudFormation
         *        The cloud formation properties included as part of the provisioning properties of an environment
         *        blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormation(CloudFormationProperties cloudFormation);

        /**
         * <p>
         * The cloud formation properties included as part of the provisioning properties of an environment blueprint.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudFormationProperties.Builder}
         * avoiding the need to create one manually via {@link CloudFormationProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudFormationProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudFormation(CloudFormationProperties)}.
         * 
         * @param cloudFormation
         *        a consumer that will call methods on {@link CloudFormationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormation(CloudFormationProperties)
         */
        default Builder cloudFormation(Consumer<CloudFormationProperties.Builder> cloudFormation) {
            return cloudFormation(CloudFormationProperties.builder().applyMutation(cloudFormation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudFormationProperties cloudFormation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningProperties model) {
            cloudFormation(model.cloudFormation);
        }

        public final CloudFormationProperties.Builder getCloudFormation() {
            return cloudFormation != null ? cloudFormation.toBuilder() : null;
        }

        public final void setCloudFormation(CloudFormationProperties.BuilderImpl cloudFormation) {
            Object oldValue = this.cloudFormation;
            this.cloudFormation = cloudFormation != null ? cloudFormation.build() : null;
            handleUnionValueChange(Type.CLOUD_FORMATION, oldValue, this.cloudFormation);
        }

        @Override
        public final Builder cloudFormation(CloudFormationProperties cloudFormation) {
            Object oldValue = this.cloudFormation;
            this.cloudFormation = cloudFormation;
            handleUnionValueChange(Type.CLOUD_FORMATION, oldValue, this.cloudFormation);
            return this;
        }

        @Override
        public ProvisioningProperties build() {
            return new ProvisioningProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ProvisioningProperties#type()
     */
    public enum Type {
        CLOUD_FORMATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
